/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.algorithm;

import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.math.Vector3D;

public class CGAlgorithms3D {
    private CGAlgorithms3D() {
    }

    public static double distance(Coordinate p0, Coordinate p1) {
        if (Double.isNaN(p0.getZ()) || Double.isNaN(p1.getZ())) {
            return p0.distance(p1);
        }
        double dx = p0.x - p1.x;
        double dy = p0.y - p1.y;
        double dz = p0.getZ() - p1.getZ();
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static double distancePointSegment(Coordinate p2, Coordinate A, Coordinate B) {
        if (A.equals3D(B)) {
            return CGAlgorithms3D.distance(p2, A);
        }
        double len2 = (B.x - A.x) * (B.x - A.x) + (B.y - A.y) * (B.y - A.y) + (B.getZ() - A.getZ()) * (B.getZ() - A.getZ());
        if (Double.isNaN(len2)) {
            throw new IllegalArgumentException("Ordinates must not be NaN");
        }
        double r = ((p2.x - A.x) * (B.x - A.x) + (p2.y - A.y) * (B.y - A.y) + (p2.getZ() - A.getZ()) * (B.getZ() - A.getZ())) / len2;
        if (r <= 0.0) {
            return CGAlgorithms3D.distance(p2, A);
        }
        if (r >= 1.0) {
            return CGAlgorithms3D.distance(p2, B);
        }
        double qx = A.x + r * (B.x - A.x);
        double qy = A.y + r * (B.y - A.y);
        double qz = A.getZ() + r * (B.getZ() - A.getZ());
        double dx = p2.x - qx;
        double dy = p2.y - qy;
        double dz = p2.getZ() - qz;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public static double distanceSegmentSegment(Coordinate A, Coordinate B, Coordinate C, Coordinate D) {
        double t;
        double s;
        if (A.equals3D(B)) {
            return CGAlgorithms3D.distancePointSegment(A, C, D);
        }
        if (C.equals3D(B)) {
            return CGAlgorithms3D.distancePointSegment(C, A, B);
        }
        double a = Vector3D.dot(A, B, A, B);
        double b = Vector3D.dot(A, B, C, D);
        double c2 = Vector3D.dot(C, D, C, D);
        double d = Vector3D.dot(A, B, C, A);
        double e = Vector3D.dot(C, D, C, A);
        double denom = a * c2 - b * b;
        if (Double.isNaN(denom)) {
            throw new IllegalArgumentException("Ordinates must not be NaN");
        }
        if (denom <= 0.0) {
            s = 0.0;
            t = b > c2 ? d / b : e / c2;
        } else {
            s = (b * e - c2 * d) / denom;
            t = (a * e - b * d) / denom;
        }
        if (s < 0.0) {
            return CGAlgorithms3D.distancePointSegment(A, C, D);
        }
        if (s > 1.0) {
            return CGAlgorithms3D.distancePointSegment(B, C, D);
        }
        if (t < 0.0) {
            return CGAlgorithms3D.distancePointSegment(C, A, B);
        }
        if (t > 1.0) {
            return CGAlgorithms3D.distancePointSegment(D, A, B);
        }
        double x1 = A.x + s * (B.x - A.x);
        double y1 = A.y + s * (B.y - A.y);
        double z1 = A.getZ() + s * (B.getZ() - A.getZ());
        double x2 = C.x + t * (D.x - C.x);
        double y2 = C.y + t * (D.y - C.y);
        double z2 = C.getZ() + t * (D.getZ() - C.getZ());
        return CGAlgorithms3D.distance(new Coordinate(x1, y1, z1), new Coordinate(x2, y2, z2));
    }
}

