/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.project.DumbAware;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.SqlIntentionUtil;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlQualificationIntentionBase
extends BaseIntentionAction
implements DumbAware {
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            SqlQualificationIntentionBase.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    protected static JBIterable<SqlIdentifier> getTopmostIdentifiers(@NotNull PsiFile file, @NotNull Caret caret) {
        if (file == null) {
            SqlQualificationIntentionBase.$$$reportNull$$$0(1);
        }
        if (caret == null) {
            SqlQualificationIntentionBase.$$$reportNull$$$0(2);
        }
        int start2 = caret.getSelectionStart();
        int end = caret.getSelectionEnd();
        PsiElement element = file.findElementAt(start2);
        if (start2 == end) {
            SqlReferenceExpression ref = SqlIntentionUtil.getReferenceExpression(element);
            if (ref == null && start2 > 0) {
                element = file.findElementAt(start2 - 1);
                ref = SqlIntentionUtil.getReferenceExpression(element);
            }
            JBIterable jBIterable = JBIterable.of((Object)SqlQualificationIntentionBase.getTopmostIdentifier(ref));
            if (jBIterable == null) {
                SqlQualificationIntentionBase.$$$reportNull$$$0(3);
            }
            return jBIterable;
        }
        SqlReferenceExpression ref = SqlQualificationIntentionBase.nextReferenceExpression(element, end);
        JBIterable jBIterable = JBIterable.generate((Object)ref, e -> SqlQualificationIntentionBase.nextReferenceExpression(SqlQualificationIntentionBase.exitReferenceExpression(e), end)).filterMap(e -> SqlQualificationIntentionBase.getTopmostIdentifier(e));
        if (jBIterable == null) {
            SqlQualificationIntentionBase.$$$reportNull$$$0(4);
        }
        return jBIterable;
    }

    @Nullable
    private static PsiElement exitReferenceExpression(@NotNull SqlReferenceExpression e) {
        if (e == null) {
            SqlQualificationIntentionBase.$$$reportNull$$$0(5);
        }
        SqlReferenceExpression p2;
        while ((p2 = (SqlReferenceExpression)ObjectUtils.tryCast((Object)e.getParent(), SqlReferenceExpression.class)) != null) {
            e = p2;
        }
        return PsiTreeUtil.nextLeaf((PsiElement)e);
    }

    @Nullable
    private static SqlReferenceExpression nextReferenceExpression(@Nullable PsiElement element, int limit) {
        while (element != null) {
            if (element.getTextRange().getStartOffset() > limit) {
                return null;
            }
            SqlReferenceExpression expression = SqlIntentionUtil.getReferenceExpression(element);
            if (expression != null) {
                return expression;
            }
            element = PsiTreeUtil.nextLeaf((PsiElement)element);
        }
        return null;
    }

    @Nullable
    private static SqlIdentifier getTopmostIdentifier(@Nullable SqlReferenceExpression e) {
        while (e != null) {
            SqlExpression q = e.getQualifierExpression();
            if (q == null) {
                return e.getIdentifier();
            }
            e = (SqlReferenceExpression)ObjectUtils.tryCast((Object)q, SqlReferenceExpression.class);
        }
        return null;
    }

    @Nullable
    public static ObjectName getName(@Nullable Object object) {
        DasObject obj2 = (DasObject)ObjectUtils.tryCast((Object)object, DasObject.class);
        if (obj2 != null && obj2.getKind() != ObjectKind.NONE) {
            return TreePatternUtils.nameOf(obj2, true);
        }
        if (object instanceof SqlReferenceExpression) {
            return ObjectName.create(((SqlReferenceExpression)object).getName(), DbSqlUtilCore.isQuoted((SqlReferenceExpression)object));
        }
        BuiltinFunction f = (BuiltinFunction)ObjectUtils.tryCast((Object)obj2, BuiltinFunction.class);
        if (f == null && object instanceof PsiElement) {
            f = (BuiltinFunction)ObjectUtils.tryCast((Object)SqlImplUtil.unwrapPsiToObject((PsiElement)object), BuiltinFunction.class);
        }
        if (f != null) {
            return ObjectName.create(f.getName(), false);
        }
        return null;
    }

    protected static ObjectKind getKind(@Nullable Object object) {
        DasObject obj2 = (DasObject)ObjectUtils.tryCast((Object)object, DasObject.class);
        if (obj2 instanceof SqlAsExpression) {
            return ObjectKind.TABLE;
        }
        if (obj2 instanceof DasSynonym) {
            obj2 = (DasObject)ObjectUtils.chooseNotNull((Object)((DasSynonym)obj2).resolveTarget(), (Object)obj2);
        }
        if (obj2 != null) {
            return obj2.getKind();
        }
        if (object instanceof SqlReferenceExpression) {
            return ((SqlReferenceExpression)object).getReferenceElementType().getTargetKind();
        }
        if (object instanceof PsiElement && SqlImplUtil.unwrapPsiToObject((PsiElement)object) instanceof BuiltinFunction) {
            return ObjectKind.ROUTINE;
        }
        return ObjectKind.ROOT;
    }

    protected static int getDepth(@NotNull SqlLanguageDialectEx dialect, @NotNull ObjectKind kind) {
        if (dialect == null) {
            SqlQualificationIntentionBase.$$$reportNull$$$0(6);
        }
        if (kind == null) {
            SqlQualificationIntentionBase.$$$reportNull$$$0(7);
        }
        int d = 0;
        for (List kinds : DbImplUtilCore.getMetaModel(dialect.getDbms()).getPathsToRoot(dialect.unaliased(kind))) {
            d = Math.max(d, kinds.size());
        }
        return d;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/intentions/SqlQualificationIntentionBase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/intentions/SqlQualificationIntentionBase";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopmostIdentifiers";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTopmostIdentifiers";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "exitReferenceExpression";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDepth";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

