/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mssql;

import com.intellij.database.script.generator.NamingServices;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.base.SqlParser;
import com.intellij.sql.dialects.mssql.MsExpressionParsing;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;

public class MsGeneratedParserUtil
extends SqlGeneratedParserUtil {
    public static boolean parseExecArgument(PsiBuilder builder, int level) {
        SqlParser parser = MsGeneratedParserUtil.getParser(builder);
        PsiBuilder.Marker mark2 = builder.mark();
        boolean parsed = parser.parseNamedFunctionArgumentPrefixImpl(builder, SqlCommonTokens.SQL_OP_EQ);
        boolean parsedVal = MsGeneratedParserUtil.parseExecArgumentValue(parser, builder, level, !parsed);
        if (parsed) {
            mark2.done((IElementType)SqlCompositeElementTypes.SQL_NAMED_PARAMETER_VALUE);
        } else {
            mark2.drop();
        }
        return parsed || parsedVal;
    }

    private static boolean parseExecArgumentValue(SqlParser parser, PsiBuilder builder, int level, boolean optional) {
        boolean res;
        if (builder.getTokenType() == SqlCommonTokens.SQL_OP_MINUS) {
            PsiBuilder.Marker mark2 = builder.mark();
            builder.advanceLexer();
            res = MsExpressionParsing.numeric_literal(builder, level);
            if (res) {
                mark2.done((IElementType)SqlCompositeElementTypes.SQL_UNARY_EXPRESSION);
            } else {
                mark2.rollbackTo();
            }
        } else {
            res = MsExpressionParsing.literal_expr(builder, level);
        }
        res = res || parser.parseReferenceExpressionOrVariable(builder, SqlCompositeElementTypes.SQL_SHORT_REFERENCE);
        boolean bl = res = res || MsGeneratedParserUtil.parseNoArgCall(parser, builder);
        if (!optional && !res) {
            GeneratedParserUtilBase.report_error_((PsiBuilder)builder, (boolean)false);
        }
        return res;
    }

    private static boolean parseNoArgCall(SqlParser parser, PsiBuilder builder) {
        BuiltinFunction foo;
        String text2 = builder.getTokenText();
        BuiltinFunction builtinFunction = foo = text2 == null ? null : parser.getLanguage().getSupportedFunctions().get(StringUtil.toUpperCase((String)text2));
        if (foo == null) {
            return false;
        }
        boolean noArg = false;
        for (BuiltinFunction.Prototype prototype : foo.getPrototypes()) {
            if (!parser.getLanguage().canBeCalledWithoutParens(prototype)) continue;
            noArg = true;
            break;
        }
        if (noArg) {
            PsiBuilder.Marker ref = builder.mark();
            builder.advanceLexer();
            ref.done((IElementType)SqlCompositeElementTypes.SQL_IDENTIFIER);
            ref = ref.precede();
            ref.done((IElementType)SqlCompositeElementTypes.SQL_ANY_CALLABLE_REFERENCE);
            builder.mark().done((IElementType)SqlCompositeElementTypes.SQL_PARAMETER_LIST);
            ref.precede().done((IElementType)SqlCompositeElementTypes.SQL_FUNCTION_CALL);
        }
        return noArg;
    }

    public static boolean isTimestampColumn(PsiBuilder builder, int level) {
        LighterASTNode marker = builder.getLatestDoneMarker();
        if (marker == null || marker.getTokenType() != SqlCompositeElementTypes.SQL_IDENTIFIER) {
            return false;
        }
        int s = marker.getStartOffset();
        int e = marker.getEndOffset();
        CharSequence text2 = builder.getOriginalText();
        text2 = text2.subSequence(s, e);
        SqlLanguageDialectEx language = MsGeneratedParserUtil.getParser(builder).getLanguage();
        String identifier = NamingServices.getNamingService(language.getDbms()).unquoteIdentifier(text2.toString());
        return StringUtil.equalsIgnoreCase((CharSequence)identifier, (CharSequence)"timestamp");
    }
}

