/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.layoutedQueries;

import com.intellij.database.layoutedQueries.BaseSession;
import com.intellij.database.layoutedQueries.DBFacade;
import com.intellij.database.layoutedQueries.DBLeasedSession;
import com.intellij.database.layoutedQueries.InSession;
import com.intellij.database.layoutedQueries.InSessionNoResult;
import com.intellij.database.layoutedQueries.impl.DBLeasedSessionWrapper;
import com.intellij.database.layoutedQueries.impl.IntegralIntermediateFacade;
import com.intellij.database.layoutedQueries.impl.IntegralIntermediateSession;
import com.intellij.database.remote.jdba.core.ConnectionInfo;
import com.intellij.database.remote.jdba.exceptions.DBIsNotConnected;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseFacade
implements DBFacade {
    @NotNull
    private final IntegralIntermediateFacade myInterFacade;
    @Nullable
    private ConnectionInfo myConnectionInfo;

    public BaseFacade(@NotNull IntegralIntermediateFacade interFacade) {
        if (interFacade == null) {
            BaseFacade.$$$reportNull$$$0(0);
        }
        this.myInterFacade = interFacade;
    }

    @Override
    public synchronized void connect() {
        this.myInterFacade.connect();
        this.myConnectionInfo = null;
    }

    @Override
    public synchronized void reconnect() {
        this.myInterFacade.reconnect();
        this.myConnectionInfo = null;
    }

    @Override
    public synchronized void detachFromDB() {
        this.myInterFacade.detachFromDB();
        this.myConnectionInfo = null;
    }

    @Override
    public synchronized void disconnect() {
        this.myInterFacade.disconnect();
        this.myConnectionInfo = null;
    }

    @Override
    public boolean isConnected() {
        return this.myInterFacade.isConnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectionInfo getConnectionInfo() {
        ConnectionInfo ci = this.myConnectionInfo;
        if (ci == null) {
            BaseFacade baseFacade = this;
            synchronized (baseFacade) {
                ci = this.myConnectionInfo;
                if (ci == null) {
                    this.myConnectionInfo = ci = this.myInterFacade.getConnectionInfo();
                }
            }
        }
        return ci;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <R> R inSession(InSession<R> operation) {
        R result2;
        if (operation == null) {
            throw new IllegalArgumentException("The operation is null");
        }
        if (!this.isConnected()) {
            throw new DBIsNotConnected("Facade is not connected.");
        }
        try (IntegralIntermediateSession interSession = this.instantiateIntermediateSession();){
            BaseSession session = new BaseSession(interSession);
            result2 = operation.run(session);
            session.closeRunners();
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inSession(InSessionNoResult operation) {
        if (operation == null) {
            return;
        }
        if (!this.isConnected()) {
            throw new DBIsNotConnected("Facade is not connected.");
        }
        try (IntegralIntermediateSession interSession = this.instantiateIntermediateSession();){
            BaseSession session = new BaseSession(interSession);
            operation.run(session);
            session.closeRunners();
        }
    }

    @Override
    public synchronized DBLeasedSession leaseSession() {
        IntegralIntermediateSession interSession = this.instantiateIntermediateSession();
        BaseSession baseSession = new BaseSession(interSession);
        return new DBLeasedSessionWrapper(baseSession);
    }

    @NotNull
    protected synchronized IntegralIntermediateSession instantiateIntermediateSession() {
        IntegralIntermediateSession integralIntermediateSession = this.myInterFacade.openSession();
        if (integralIntermediateSession == null) {
            BaseFacade.$$$reportNull$$$0(1);
        }
        return integralIntermediateSession;
    }

    @Nullable
    public <I> I getSpecificService(@NotNull Class<I> serviceClass, @NotNull String serviceName) throws ClassCastException {
        if (serviceClass == null) {
            BaseFacade.$$$reportNull$$$0(2);
        }
        if (serviceName == null) {
            BaseFacade.$$$reportNull$$$0(3);
        }
        return (I)this.myInterFacade.getSpecificService(serviceClass, serviceName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interFacade";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/layoutedQueries/BaseFacade";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/layoutedQueries/BaseFacade";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "instantiateIntermediateSession";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSpecificService";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

