/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.oracle;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.sql.psi.SqlBlockStatement;
import com.intellij.sql.psi.SqlRoutineDefinition;
import com.intellij.sql.psi.impl.SqlImplUtil;
import org.jetbrains.annotations.NotNull;

public final class OraDbSqlUtils {
    private OraDbSqlUtils() {
    }

    public static boolean isBodyRoutine(@NotNull DasObject def, boolean enforceNonEmptyBody) {
        if (def == null) {
            OraDbSqlUtils.$$$reportNull$$$0(0);
        }
        if (def.getKind() != ObjectKind.ROUTINE) {
            return false;
        }
        DasObject parent = def.getDasParent();
        if (enforceNonEmptyBody && def instanceof SqlRoutineDefinition && ((SqlRoutineDefinition)def).getBody().isEmpty()) {
            return false;
        }
        return parent != null && parent.getKind() == ObjectKind.BODY || def instanceof SqlRoutineDefinition && SqlImplUtil.sqlParent((SqlRoutineDefinition)def) instanceof SqlBlockStatement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "def", "com/intellij/database/dialects/oracle/OraDbSqlUtils", "isBodyRoutine"));
    }
}

