/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types.domain;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.SizeProvider;
import com.intellij.database.data.types.domain.Cardinality;
import com.intellij.database.data.types.domain.Compatibility;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.SimpleDomain;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FractionDomain
extends Domain {
    private final Cardinality.FractionCardinality myCardinality;
    private final int myDefaultValue;
    private final boolean myNarrowable;
    private final int myMax;

    public FractionDomain(@NotNull String name2, @NotNull ConversionPoint descriptor, int max) {
        if (name2 == null) {
            FractionDomain.$$$reportNull$$$0(0);
        }
        if (descriptor == null) {
            FractionDomain.$$$reportNull$$$0(1);
        }
        this(name2, descriptor, max, -1, false);
    }

    public FractionDomain(@NotNull String name2, @NotNull ConversionPoint descriptor, int myMax, int defaultValue, boolean narrowable) {
        if (name2 == null) {
            FractionDomain.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            FractionDomain.$$$reportNull$$$0(3);
        }
        super(descriptor, name2);
        this.myMax = myMax;
        this.myCardinality = new Cardinality.FractionCardinality(myMax);
        this.myDefaultValue = defaultValue;
        this.myNarrowable = narrowable;
    }

    @Override
    @NotNull
    public Compatibility getCompatibility(@NotNull Domain domain) {
        if (domain == null) {
            FractionDomain.$$$reportNull$$$0(4);
        }
        int suitability = this.getLogicType().getSuitability(domain.getLogicType());
        Compatibility compatibility = domain instanceof SimpleDomain && suitability >= 100 ? Compatibility.full(this.cardinality(), domain.getLogicType(), this.getLogicType()) : (domain instanceof SimpleDomain && suitability > 1 ? Compatibility.compatibleLossy(this.cardinality(), domain.getLogicType(), this.getLogicType()) : (domain instanceof FractionDomain && suitability > 0 ? this.compareWithFraction((FractionDomain)domain) : Compatibility.incompatible()));
        if (compatibility == null) {
            FractionDomain.$$$reportNull$$$0(5);
        }
        return compatibility;
    }

    @Override
    @Nullable
    public Object trim(@NotNull Object o) {
        if (o == null) {
            FractionDomain.$$$reportNull$$$0(6);
        }
        return o;
    }

    @Override
    @NotNull
    public Cardinality cardinality() {
        Cardinality.FractionCardinality fractionCardinality = this.myCardinality;
        if (fractionCardinality == null) {
            FractionDomain.$$$reportNull$$$0(7);
        }
        return fractionCardinality;
    }

    @Override
    @NotNull
    public Domain narrow(@NotNull Domain domain) {
        if (domain == null) {
            FractionDomain.$$$reportNull$$$0(8);
        }
        FractionDomain fractionDomain = this.myNarrowable && domain instanceof FractionDomain ? new FractionDomain(this.simpleName(), this.getPoint(), Math.min(((FractionDomain)domain).getMax(), this.getMax()), this.myDefaultValue, true) : (this.myNarrowable && domain instanceof SimpleDomain && domain.getLogicType() == this.getLogicType() ? new FractionDomain(this.simpleName(), this.getPoint(), this.myDefaultValue, this.myDefaultValue, true) : this);
        if (fractionDomain == null) {
            FractionDomain.$$$reportNull$$$0(9);
        }
        return fractionDomain;
    }

    @Override
    @NotNull
    public Domain narrow(@NotNull SizeProvider provider) {
        if (provider == null) {
            FractionDomain.$$$reportNull$$$0(10);
        }
        FractionDomain fractionDomain = this.myNarrowable ? new FractionDomain(this.simpleName(), this.getPoint(), Math.min(provider.getScale(), this.getMax()), this.myDefaultValue, true) : this;
        if (fractionDomain == null) {
            FractionDomain.$$$reportNull$$$0(11);
        }
        return fractionDomain;
    }

    @Override
    @NotNull
    public String name() {
        Object object = this.shouldParametrize() ? this.simpleName() + "(" + this.getMax() + ")" : super.name();
        if (object == null) {
            FractionDomain.$$$reportNull$$$0(12);
        }
        return object;
    }

    public int getMax() {
        return this.myMax;
    }

    public int getDefaultValue() {
        return this.myDefaultValue;
    }

    public boolean isNarrowable() {
        return this.myNarrowable;
    }

    protected boolean shouldParametrize() {
        return this.getMax() != this.myDefaultValue && this.myNarrowable && this.getMax() > 0;
    }

    @NotNull
    private Compatibility compareWithFraction(@NotNull FractionDomain domain) {
        if (domain == null) {
            FractionDomain.$$$reportNull$$$0(13);
        }
        Compatibility compatibility = this.getLogicType().getSuitability(domain.getLogicType()) >= 100 && this.getMax() >= domain.getMax() ? Compatibility.full(this.cardinality(), domain.getLogicType(), this.getLogicType()) : Compatibility.compatibleLossy(this.cardinality(), domain.getLogicType(), this.getLogicType());
        if (compatibility == null) {
            FractionDomain.$$$reportNull$$$0(14);
        }
        return compatibility;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7, 9, 11, 12, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domain";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/data/types/domain/FractionDomain";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/data/types/domain/FractionDomain";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompatibility";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "cardinality";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "narrow";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "name";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "compareWithFraction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getCompatibility";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 14: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "trim";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "narrow";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "compareWithFraction";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7, 9, 11, 12, 14 -> new IllegalStateException(string);
        };
    }
}

