/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.sourcemap.visualizer;

import com.intellij.icons.AllIcons;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.sourcemap.visualizer.SourceMapInspector;
import com.intellij.javascript.debugger.sourcemap.visualizer.actions.BaseSourceMapAction;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.TextEditorState;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.io.LocalFileFinder;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ*\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0006H\u0002J\b\u0010\u001a\u001a\u00020\fH\u0016J\b\u0010\u001b\u001a\u00020\fH\u0016J\u0012\u0010\u001c\u001a\f0\u0012\u00a2\u0006\u0002\b\u001d\u00a2\u0006\u0002\b\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020 H\u0016J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020&H\u0016J\b\u0010(\u001a\u00020\u0018H\u0016J\b\u0010)\u001a\u00020\u0018H\u0016J\u0010\u0010*\u001a\u00020\u00182\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020\u00182\u0006\u0010+\u001a\u00020,H\u0016J\n\u0010.\u001a\u0004\u0018\u00010/H\u0016J\b\u00100\u001a\u00020\u0006H\u0016J\b\u00101\u001a\u00020\u0018H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/intellij/javascript/debugger/sourcemap/visualizer/SourcemapFileViewer;", "Lcom/intellij/openapi/util/UserDataHolderBase;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;)V", "map", "Lorg/jetbrains/debugger/sourcemap/SourceMap;", "mainPanel", "Ljavax/swing/JPanel;", "generatedTextEditor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "addEditorNotification", "Lcom/intellij/ui/EditorNotificationPanel;", "message", "", "icon", "Ljavax/swing/Icon;", "status", "Lcom/intellij/ui/EditorNotificationPanel$Status;", "visualize", "", "generatedFile", "getComponent", "getPreferredFocusedComponent", "getName", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getState", "Lcom/intellij/openapi/fileEditor/FileEditorState;", "level", "Lcom/intellij/openapi/fileEditor/FileEditorStateLevel;", "setState", "state", "isModified", "", "isValid", "selectNotify", "deselectNotify", "addPropertyChangeListener", "listener", "Ljava/beans/PropertyChangeListener;", "removePropertyChangeListener", "getCurrentLocation", "Lcom/intellij/openapi/fileEditor/FileEditorLocation;", "getFile", "dispose", "intellij.javascript.debugger"})
public final class SourcemapFileViewer
extends UserDataHolderBase
implements FileEditor {
    @NotNull
    private final VirtualFile file;
    @Nullable
    private final SourceMap map;
    @NotNull
    private final JPanel mainPanel;
    @Nullable
    private TextEditor generatedTextEditor;

    public SourcemapFileViewer(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
        this.mainPanel = new JPanel(new BorderLayout());
        Pair<SourceMap, Exception> result = BaseSourceMapAction.Companion.compute(this.file);
        this.map = (SourceMap)result.first;
        if (this.map == null) {
            ApplicationManager.getApplication().invokeLater(() -> SourcemapFileViewer._init_$lambda$0(this, project, result), project.getDisposed());
        } else {
            VirtualFile generatedFile = null;
            if (this.map.getOutFile() != null) {
                VirtualFile virtualFile = this.file.getParent();
                String string = this.map.getOutFile();
                Intrinsics.checkNotNull((Object)string);
                VirtualFile virtualFile2 = virtualFile.findFileByRelativePath(string);
                if (virtualFile2 == null) {
                    String string2 = this.map.getOutFile();
                    Intrinsics.checkNotNull((Object)string2);
                    virtualFile2 = generatedFile = LocalFileFinder.findFile((String)string2);
                }
            }
            if (generatedFile == null) {
                String string = this.file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String fileName = string;
                if (StringsKt.endsWith$default((String)fileName, (String)".map", (boolean)false, (int)2, null)) {
                    VirtualFile virtualFile = this.file.getParent();
                    String string3 = fileName.substring(0, fileName.length() - 4);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    generatedFile = virtualFile.findChild(string3);
                }
            }
            if (generatedFile == null) {
                ApplicationManager.getApplication().invokeLater(() -> SourcemapFileViewer._init_$lambda$3(this, project));
            } else {
                this.visualize(this.map, project, generatedFile);
            }
        }
    }

    private final EditorNotificationPanel addEditorNotification(Project project, @NlsContexts.Label String message, Icon icon, EditorNotificationPanel.Status status) {
        EditorNotificationPanel notificationPanel = new EditorNotificationPanel((FileEditor)this.generatedTextEditor, status).text(message).icon(icon);
        FileEditorManager.getInstance((Project)project).addTopComponent((FileEditor)this, (JComponent)notificationPanel);
        Intrinsics.checkNotNull((Object)notificationPanel);
        return notificationPanel;
    }

    private final void visualize(SourceMap map, Project project, VirtualFile generatedFile) {
        SourceMapInspector mapInspector = new SourceMapInspector(map, generatedFile, project, (Disposable)this, null);
        this.mainPanel.add((Component)mapInspector.createMainComponent(null), "Center");
        this.generatedTextEditor = mapInspector.getGeneratedTextEditor$intellij_javascript_debugger();
    }

    @NotNull
    public JPanel getComponent() {
        return this.mainPanel;
    }

    @NotNull
    public JPanel getPreferredFocusedComponent() {
        return this.mainPanel;
    }

    @NotNull
    public String getName() {
        String string = JSDebuggerBundle.message("js.scripts.visualize.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel level) {
        FileEditorState fileEditorState;
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        if (this.generatedTextEditor == null) {
            fileEditorState = (FileEditorState)new TextEditorState();
        } else {
            TextEditor textEditor = this.generatedTextEditor;
            Intrinsics.checkNotNull((Object)textEditor);
            FileEditorState fileEditorState2 = textEditor.getState(level);
            fileEditorState = fileEditorState2;
            Intrinsics.checkNotNullExpressionValue((Object)fileEditorState2, (String)"getState(...)");
        }
        return fileEditorState;
    }

    public void setState(@NotNull FileEditorState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (this.generatedTextEditor != null && state instanceof TextEditorState) {
            TextEditor textEditor = this.generatedTextEditor;
            Intrinsics.checkNotNull((Object)textEditor);
            textEditor.setState(state);
        }
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
        UIUtil.invokeLaterIfNeeded(() -> SourcemapFileViewer.selectNotify$lambda$4(this));
    }

    public void deselectNotify() {
        UIUtil.invokeLaterIfNeeded(() -> SourcemapFileViewer.deselectNotify$lambda$5(this));
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        FileEditorLocation fileEditorLocation;
        if (this.generatedTextEditor == null) {
            fileEditorLocation = null;
        } else {
            TextEditor textEditor = this.generatedTextEditor;
            Intrinsics.checkNotNull((Object)textEditor);
            fileEditorLocation = textEditor.getCurrentLocation();
        }
        return fileEditorLocation;
    }

    @NotNull
    public VirtualFile getFile() {
        return this.file;
    }

    public void dispose() {
    }

    private static final void _init_$lambda$0(SourcemapFileViewer this$0, Project $project, Pair $result) {
        String string = JSDebuggerBundle.message($result.second == null ? "js.scripts.visualize.notification.empty" : "js.scripts.visualize.notification.decode", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Icon icon = $result.second == null ? AllIcons.General.Information : AllIcons.General.ExclMark;
        Intrinsics.checkNotNull((Object)icon);
        this$0.addEditorNotification($project, string, icon, $result.second == null ? EditorNotificationPanel.Status.Info : EditorNotificationPanel.Status.Error);
    }

    private static final void lambda$3$lambda$2$lambda$1(Project $project, SourcemapFileViewer this$0, EditorNotificationPanel $notificationPanel, VirtualFile file) {
        FileEditorManager.getInstance((Project)$project).removeTopComponent((FileEditor)this$0, (JComponent)$notificationPanel);
        SourceMap sourceMap = this$0.map;
        Intrinsics.checkNotNull((Object)file);
        this$0.visualize(sourceMap, $project, file);
    }

    private static final void lambda$3$lambda$2(Project $project, SourcemapFileViewer this$0, EditorNotificationPanel $notificationPanel) {
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileDescriptor((FileType)((FileType)JavaScriptFileType.INSTANCE));
        descriptor.setTitle(JSDebuggerBundle.message("js.scripts.visualize.select.generated", new Object[0]));
        FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)$project, (VirtualFile)this$0.file.getParent(), arg_0 -> SourcemapFileViewer.lambda$3$lambda$2$lambda$1($project, this$0, $notificationPanel, arg_0));
    }

    private static final void _init_$lambda$3(SourcemapFileViewer this$0, Project $project) {
        String string = JSDebuggerBundle.message("js.scripts.visualize.notification.cant", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Icon icon = AllIcons.General.ExclMark;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ExclMark");
        EditorNotificationPanel notificationPanel = this$0.addEditorNotification($project, string, icon, EditorNotificationPanel.Status.Error);
        notificationPanel.createActionLabel(JSDebuggerBundle.message("js.scripts.visualize.action.browse", new Object[0]), () -> SourcemapFileViewer.lambda$3$lambda$2($project, this$0, notificationPanel));
    }

    private static final void selectNotify$lambda$4(SourcemapFileViewer this$0) {
        if (this$0.generatedTextEditor != null) {
            TextEditor textEditor = this$0.generatedTextEditor;
            Intrinsics.checkNotNull((Object)textEditor);
            textEditor.selectNotify();
        }
    }

    private static final void deselectNotify$lambda$5(SourcemapFileViewer this$0) {
        if (this$0.generatedTextEditor != null) {
            TextEditor textEditor = this$0.generatedTextEditor;
            Intrinsics.checkNotNull((Object)textEditor);
            textEditor.deselectNotify();
        }
    }
}

