/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.locationResolving;

import com.intellij.javascript.debugger.locationResolving.FileUrlMapping;
import com.intellij.javascript.debugger.locationResolving.FileUrlMappingsStorage;
import com.intellij.javascript.debugger.locationResolving.SearchAccuracy;
import com.intellij.javascript.debugger.locationResolving.SearchResult;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.Script;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J(\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u00142\u0006\u0010\u0015\u001a\u00020\u00072\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00140\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/javascript/debugger/locationResolving/JSFileUrlMappings;", "", "<init>", "()V", "storage", "Lcom/intellij/javascript/debugger/locationResolving/FileUrlMappingsStorage;", "findFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "url", "Lcom/intellij/util/Url;", "sourceContent", "", "findByName", "", "script", "Lorg/jetbrains/debugger/Script;", "finder", "Lkotlin/Function0;", "Lcom/intellij/javascript/debugger/locationResolving/SearchResult;", "findUrls", "", "file", "intellij.javascript.debugger"})
public final class JSFileUrlMappings {
    @NotNull
    private final FileUrlMappingsStorage storage = new FileUrlMappingsStorage();

    @Nullable
    public final VirtualFile findFile(@NotNull Url url, @Nullable String sourceContent, boolean findByName, @Nullable Script script, @NotNull Function0<SearchResult> finder) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(finder, (String)"finder");
        this.storage.removeOutdatedResults(url, sourceContent);
        if (script != null) {
            this.storage.scriptFound(url, script);
        }
        SearchAccuracy accuracy = sourceContent != null ? SearchAccuracy.BY_CONTENT : (findByName ? SearchAccuracy.BY_NAME : SearchAccuracy.BY_URL);
        FileUrlMapping cachedMapping = this.storage.findSuitableMapping(url, accuracy);
        if (cachedMapping != null) {
            return cachedMapping.getFile();
        }
        SearchResult searchResult = (SearchResult)finder.invoke();
        this.storage.addMapping(new FileUrlMapping(url, searchResult.getFile(), searchResult.getAccuracy(), sourceContent));
        return searchResult.getFile();
    }

    @NotNull
    public final List<Url> findUrls(@NotNull VirtualFile file, @NotNull Function0<? extends List<? extends Url>> finder) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(finder, (String)"finder");
        Collection collection = this.storage.findUrls(file);
        return (List)(collection.isEmpty() ? finder.invoke() : collection);
    }
}

