/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.execution;

import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.ide.browsers.JavaScriptDebuggerStarter;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.JavaScriptDebuggerStarterImpl;
import com.intellij.javascript.debugger.execution.JavaScriptDebugConfiguration;
import com.intellij.javascript.debugger.execution.JavaScriptDebugSessionsUtil;
import com.intellij.javascript.debugger.execution.JavascriptDebugConfigurationType;
import com.intellij.javascript.debugger.execution.RemoteUrlMappingBean;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseJavaScriptDebuggerStarter<RC extends RunConfiguration, U>
implements JavaScriptDebuggerStarter<RC, U> {
    private static RunnerAndConfigurationSettings create(@NotNull String url, @NotNull Project project, @NotNull RunProfile namePrefix, @Nullable WebBrowser browser, @Nullable List<RemoteUrlMappingBean> mappings) {
        if (url == null) {
            BaseJavaScriptDebuggerStarter.$$$reportNull$$$0(0);
        }
        if (project == null) {
            BaseJavaScriptDebuggerStarter.$$$reportNull$$$0(1);
        }
        if (namePrefix == null) {
            BaseJavaScriptDebuggerStarter.$$$reportNull$$$0(2);
        }
        RunnerAndConfigurationSettings runSettings = RunManager.getInstance((Project)project).createConfiguration(namePrefix.getName() + " JavaScript", (ConfigurationFactory)JavascriptDebugConfigurationType.getTypeInstance());
        JavaScriptDebugConfiguration configuration = (JavaScriptDebugConfiguration)runSettings.getConfiguration();
        configuration.setUri(url);
        if (browser != null) {
            configuration.setEngineId(browser.getId().toString());
        }
        if (mappings != null && !mappings.isEmpty()) {
            configuration.setMappings(mappings);
        }
        return runSettings;
    }

    public final void start(@NotNull String url, @NotNull RC runConfiguration, @NotNull U userData, @Nullable WebBrowser browser) {
        if (url == null) {
            BaseJavaScriptDebuggerStarter.$$$reportNull$$$0(3);
        }
        if (runConfiguration == null) {
            BaseJavaScriptDebuggerStarter.$$$reportNull$$$0(4);
        }
        if (userData == null) {
            BaseJavaScriptDebuggerStarter.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            Project project = runConfiguration.getProject();
            String browserId = browser == null ? null : browser.getId().toString();
            for (XDebugProcess process2 : XDebuggerManager.getInstance((Project)project).getDebugProcesses(JavaScriptDebugProcess.class)) {
                JavaScriptDebugConfiguration cfg;
                XDebugSession session2 = process2.getSession();
                RunProfile profile = session2.getRunProfile();
                if (session2.isStopped() || !(profile instanceof JavaScriptDebugConfiguration) || !Objects.equals((cfg = (JavaScriptDebugConfiguration)profile).getUri(), url) || !Objects.equals(cfg.getEngineId(), browserId)) continue;
                return;
            }
            RunnerAndConfigurationSettings runSettings = JavaScriptDebugSessionsUtil.findExistingConfiguration(url, browser, project);
            if (runSettings == null) {
                runSettings = BaseJavaScriptDebuggerStarter.create(url, project, (RunProfile)runConfiguration, browser, this.createMappings(url, runConfiguration, userData, project));
                if (this instanceof JavaScriptDebuggerStarterImpl) {
                    RunManager.getInstance((Project)project).addConfiguration(runSettings);
                }
            }
            ProgramRunnerUtil.executeConfiguration((RunnerAndConfigurationSettings)runSettings, (Executor)DefaultDebugExecutor.getDebugExecutorInstance());
        }, runConfiguration.getProject().getDisposed());
    }

    @Nullable
    protected abstract List<RemoteUrlMappingBean> createMappings(@NotNull String var1, @NotNull RC var2, @NotNull U var3, @NotNull Project var4);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namePrefix";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "userData";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/debugger/execution/BaseJavaScriptDebuggerStarter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "start";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

