/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.environment.HttpExecutionBlockWithSubstitutor;
import com.intellij.httpClient.http.request.environment.HttpRequestEnvironment;
import com.intellij.httpClient.http.request.psi.HttpClientExecutionBlock;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.psi.HttpRequestBlock;
import com.intellij.httpClient.http.request.run.HttpClientRequestProcessHandler;
import com.intellij.httpClient.http.request.run.HttpRequestRunExecutor;
import com.intellij.httpClient.http.request.run.config.HttpRequestExecutionConfig;
import com.intellij.httpClient.http.request.run.config.HttpRequestRunConfiguration;
import com.intellij.httpClient.http.request.run.console.HttpResponseConsole;
import com.intellij.httpClient.http.request.run.console.HttpResponsePresentation;
import com.intellij.httpClient.http.request.run.console.single.HttpSingleResponseConsole;
import com.intellij.httpClient.http.request.run.test.HttpMultiResponseConsole;
import com.intellij.httpClient.http.request.substitution.HttpRequestVariableRootSubstitutor;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class RunHttpRequestProfileState
implements RunProfileState {
    private final Project myProject;
    private final HttpRequestExecutionConfig myConfig;
    private final SMTRunnerConsoleProperties myProperties;
    private final HttpRequestVariableRootSubstitutor mySubstitutor;
    @NotNull
    protected final HttpRequestRunConfiguration.Settings mySettings;

    public RunHttpRequestProfileState(@NotNull Project project, @NotNull HttpRequestRunConfiguration.Settings settings, @NotNull HttpRequestExecutionConfig config, @NotNull SMTRunnerConsoleProperties properties2, @NotNull HttpRequestVariableRootSubstitutor substitutor2) {
        if (project == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(1);
        }
        if (config == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(2);
        }
        if (properties2 == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(3);
        }
        if (substitutor2 == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(4);
        }
        this.myProject = project;
        this.myConfig = config;
        this.myProperties = properties2;
        this.mySubstitutor = substitutor2;
        this.mySettings = settings;
    }

    @Nullable
    public ExecutionResult execute(Executor executor, @NotNull ProgramRunner<?> runner) throws ExecutionException {
        if (runner == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(5);
        }
        return this.execute();
    }

    @ApiStatus.Internal
    @Nullable
    public ExecutionResult execute() throws ExecutionException {
        HttpRequestEnvironment.clearForcingToUseStored(this.myProject);
        List executionBlocks = this.myConfig.getExecutionBlocks().stream().toList();
        HttpRequest firstRequest = executionBlocks.stream().filter(it -> it instanceof HttpRequestBlock).findFirst().map(requestBlock -> ((HttpRequestBlock)requestBlock).getRequest()).orElse(null);
        boolean isSingleResponseConsole = executionBlocks.size() == 1 && firstRequest != null;
        HttpClientRequestProcessHandler processHandler = new HttpClientRequestProcessHandler(isSingleResponseConsole && firstRequest.getResponseHandler() != null);
        final HttpResponseConsole console2 = isSingleResponseConsole ? new HttpSingleResponseConsole(this.myProject, this.myProperties, processHandler, true, firstRequest, this.mySubstitutor) : new HttpMultiResponseConsole(this.myProject, this.myProperties, processHandler, null);
        processHandler.addProcessListener(new ProcessListener(){

            public void processTerminated(@NotNull ProcessEvent event) {
                int exitCode;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((exitCode = event.getExitCode()) != 0) {
                    String message = exitCode == 1 ? RestClientBundle.message("rest.client.request.execute.cancel", new Object[0]) : RestClientBundle.message("rest.client.request.execute.cancel.post.process", new Object[0]);
                    console2.setErrorResponse(null, HttpResponsePresentation.createErrorResponse(message));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/httpClient/http/request/run/RunHttpRequestProfileState$1", "processTerminated"));
            }
        });
        List blocksWithSubstitutor = ContainerUtil.map(executionBlocks, it -> new HttpExecutionBlockWithSubstitutor((HttpClientExecutionBlock)it, this.mySubstitutor));
        this.createRequestExecutor(this.myProject, blocksWithSubstitutor, processHandler, console2).startExecution();
        return new DefaultExecutionResult((ExecutionConsole)console2.getConsole(), (ProcessHandler)processHandler);
    }

    protected HttpRequestRunExecutor createRequestExecutor(@NotNull Project project, @NotNull List<HttpExecutionBlockWithSubstitutor> requests2, @NotNull HttpClientRequestProcessHandler processHandler, @NotNull HttpResponseConsole console2) {
        if (project == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(6);
        }
        if (requests2 == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(7);
        }
        if (processHandler == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(8);
        }
        if (console2 == null) {
            RunHttpRequestProfileState.$$$reportNull$$$0(9);
        }
        return new HttpRequestRunExecutor(project, requests2, processHandler, false, console2, this.mySettings);
    }

    @TestOnly
    public HttpRequestVariableRootSubstitutor getSubstitutor() {
        return this.mySubstitutor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runner";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requests";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
        }
        objectArray2[1] = "com/intellij/httpClient/http/request/run/RunHttpRequestProfileState";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "createRequestExecutor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

