import React from 'react';
import { sanitize } from 'isomorphic-dompurify';
import { renderMarkdown } from '../helpers';
export var Markdown = function (_a) {
    var children = _a.children;
    if (!children) {
        return null;
    }
    if (typeof children !== 'string') {
        return React.createElement(React.Fragment, null, children);
    }
    return (React.createElement("div", { className: "prose max-w-none text-sm", dangerouslySetInnerHTML: { __html: sanitize(renderMarkdown(children)) } }));
};
//# sourceMappingURL=Markdown.js.map