/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.el;

import com.intellij.javaee.el.ELElementProcessor;
import com.intellij.javaee.el.ELExpressionHolder;
import com.intellij.javaee.el.providers.ElVariablesProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.utils.light.SpringImplicitVariable;
import com.intellij.spring.mvc.el.SpringMvcElServletShortcutVariableKt;
import com.intellij.spring.mvc.services.SpringMvcUtils;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public class SpringMvcElVariablesProvider
extends ElVariablesProvider {
    public boolean processImplicitVariables(@NotNull PsiElement element, @NotNull ELExpressionHolder holder, @NotNull ELElementProcessor processor) {
        Module module;
        if (element == null) {
            SpringMvcElVariablesProvider.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            SpringMvcElVariablesProvider.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            SpringMvcElVariablesProvider.$$$reportNull$$$0(2);
        }
        if (!SpringCommonUtils.isSpringConfigured((Module)(module = ModuleUtilCore.findModuleForPsiElement((PsiElement)holder)))) {
            return true;
        }
        if (!SpringMvcElServletShortcutVariableKt.processShortcuts(element, processor)) {
            return false;
        }
        if (!SpringMvcUtils.processVariables((PsiElement)holder, (Processor<? super PsiVariable>)((Processor)arg_0 -> ((ELElementProcessor)processor).processVariable(arg_0)), processor.getNameHint())) {
            return false;
        }
        return SpringMvcElVariablesProvider.processConfigurationVariables(holder, processor, module);
    }

    private static boolean processConfigurationVariables(ELExpressionHolder holder, ELElementProcessor elElementProcessor, Module module) {
        PsiClass internalViewResolver = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.web.servlet.view.InternalResourceViewResolver");
        if (internalViewResolver == null) {
            return true;
        }
        Processor processor = pointer -> {
            CommonSpringBean bean = pointer.getSpringBean();
            String contextAttributeName = SpringPropertyUtils.getPropertyStringValue((CommonSpringBean)bean, (String)"requestContextAttribute");
            if (StringUtil.isEmpty((String)contextAttributeName)) {
                return true;
            }
            PsiClassType type = JavaPsiFacade.getElementFactory((Project)holder.getProject()).createTypeByFQClassName("org.springframework.web.servlet.support.RequestContext");
            SpringImplicitVariable variable = new SpringImplicitVariable(contextAttributeName, (PsiType)type, bean.getIdentifyingPsiElement());
            return elElementProcessor.processVariable((PsiVariable)variable);
        };
        SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)internalViewResolver).withInheritors();
        for (SpringModel springModel : SpringManager.getInstance((Project)module.getProject()).getAllModels(module)) {
            if (springModel.processByClass(searchParameters, processor)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "processor";
                break;
            }
        }
        objectArray[1] = "com/intellij/spring/mvc/el/SpringMvcElVariablesProvider";
        objectArray[2] = "processImplicitVariables";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

