/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.dependencies;

import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.starters.JavaStartersBundle;
import com.intellij.ide.starters.remote.WebStarterContext;
import com.intellij.ide.starters.remote.WebStarterContextProvider;
import com.intellij.ide.starters.remote.WebStarterDependencyCategory;
import com.intellij.ide.starters.remote.WebStarterModuleBuilder;
import com.intellij.ide.starters.remote.WebStarterServerOptions;
import com.intellij.ide.starters.remote.wizard.WebStarterInitialStep;
import com.intellij.ide.starters.remote.wizard.WebStarterLibrariesStep;
import com.intellij.ide.starters.shared.LibraryInfo;
import com.intellij.ide.starters.shared.StarterWizardSettings;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.microservices.jvm.dependencies.FrameworkDependency;
import com.intellij.microservices.jvm.dependencies.FrameworkModuleBuilder;
import com.intellij.microservices.jvm.dependencies.FrameworkVersion;
import com.intellij.microservices.jvm.dependencies.FrameworkWebStarterLibrariesStep;
import com.intellij.microservices.jvm.dependencies.Version;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.Future;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00bc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010B\u001a\u00020\u000f2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007H$J\r\u0010C\u001a\u00070\u0005\u00a2\u0006\u0002\bDH$J\r\u0010E\u001a\u00070\u0005\u00a2\u0006\u0002\bFH$J\b\u0010G\u001a\u00020HH\u0014J\n\u0010I\u001a\u0004\u0018\u00010HH\u0016J\b\u0010J\u001a\u00020KH\u0002J\b\u0010L\u001a\u00020$H\u0002J\u0015\u0010M\u001a\u00070\u0005\u00a2\u0006\u0002\bN2\u0006\u0010O\u001a\u00020\u0005H\u0002J\b\u0010P\u001a\u00020)H\u0002J\b\u0010Q\u001a\u00020RH\u0002J\u000e\u0010S\u001a\b\u0012\u0004\u0012\u00020U0TH\u0002J\u0012\u0010V\u001a\u00020R2\b\u0010@\u001a\u0004\u0018\u00010AH\u0002J\b\u0010W\u001a\u00020RH\u0002J\b\u0010X\u001a\u00020YH\u0002J\b\u0010Z\u001a\u00020RH\u0002J\u0012\u0010[\u001a\u00020R2\b\b\u0001\u0010\\\u001a\u00020\u0005H\u0002J\b\u0010]\u001a\u00020\u0005H\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001b\u0010\u000e\u001a\u00020\u000f8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0014\u001a\u00020\u0015X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u001bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001b\u0010\u001e\u001a\u00020\u001f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\"\u0010\u0013\u001a\u0004\b \u0010!R\u001b\u0010#\u001a\u00020$8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010\u0013\u001a\u0004\b%\u0010&R\u001b\u0010(\u001a\u00020)8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010\u0013\u001a\u0004\b*\u0010+R\u000e\u0010-\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u00100\u001a\u0004\u0018\u000101X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u000e\u00106\u001a\u000207X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u00108\u001a\b\u0012\u0002\b\u0003\u0018\u000109X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\u000e\u0010>\u001a\u00020?X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010@\u001a\u0004\u0018\u00010AX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006^"}, d2={"Lcom/intellij/microservices/jvm/dependencies/FrameworkEditDependenciesDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "module", "Lcom/intellij/openapi/module/Module;", "frameworkVersion", "", "relatedModules", "", "<init>", "(Lcom/intellij/openapi/module/Module;Ljava/lang/String;Ljava/util/List;)V", "getModule", "()Lcom/intellij/openapi/module/Module;", "getFrameworkVersion", "()Ljava/lang/String;", "moduleBuilder", "Lcom/intellij/ide/starters/remote/WebStarterModuleBuilder;", "getModuleBuilder", "()Lcom/intellij/ide/starters/remote/WebStarterModuleBuilder;", "moduleBuilder$delegate", "Lkotlin/Lazy;", "starterContext", "Lcom/intellij/ide/starters/remote/WebStarterContext;", "getStarterContext", "()Lcom/intellij/ide/starters/remote/WebStarterContext;", "moduleBuilderSettings", "Lcom/intellij/ide/starters/shared/StarterWizardSettings;", "mainPanel", "Ljavax/swing/JPanel;", "getMainPanel", "()Ljavax/swing/JPanel;", "progressIcon", "Lcom/intellij/util/ui/AsyncProcessIcon;", "getProgressIcon", "()Lcom/intellij/util/ui/AsyncProcessIcon;", "progressIcon$delegate", "serverUrlLink", "Lcom/intellij/ui/components/ActionLink;", "getServerUrlLink", "()Lcom/intellij/ui/components/ActionLink;", "serverUrlLink$delegate", "retryButton", "Lcom/intellij/ui/InplaceButton;", "getRetryButton", "()Lcom/intellij/ui/InplaceButton;", "retryButton$delegate", "serverSettingsButton", "loadingPanel", "Lcom/intellij/ui/components/JBLoadingPanel;", "librariesStep", "Lcom/intellij/ide/starters/remote/wizard/WebStarterLibrariesStep;", "getLibrariesStep", "()Lcom/intellij/ide/starters/remote/wizard/WebStarterLibrariesStep;", "setLibrariesStep", "(Lcom/intellij/ide/starters/remote/wizard/WebStarterLibrariesStep;)V", "serverOptionsLoadingSemaphore", "Lcom/intellij/util/concurrency/Semaphore;", "currentRequest", "Ljava/util/concurrent/Future;", "getCurrentRequest", "()Ljava/util/concurrent/Future;", "setCurrentRequest", "(Ljava/util/concurrent/Future;)V", "isDisposed", "", "serverOptions", "Lcom/intellij/ide/starters/remote/WebStarterServerOptions;", "createModuleBuilder", "getDialogTitle", "Lcom/intellij/openapi/util/NlsContexts$DialogTitle;", "getDependenciesLoadingText", "Lorg/jetbrains/annotations/Nls;", "createCenterPanel", "Ljavax/swing/JComponent;", "getPreferredFocusedComponent", "getLoadingPanelMinimumSize", "Ljava/awt/Dimension;", "createServerUrlLink", "urlPreview", "Lcom/intellij/openapi/util/NlsSafe;", "serverUrl", "createRetryButton", "requestServerOptions", "", "getDisposed", "Lcom/intellij/openapi/util/Condition;", "", "setServerOptions", "updateContent", "getModalityState", "Lcom/intellij/openapi/application/ModalityState;", "configureServer", "setServerUrl", "url", "getServerUrlPropertyName", "intellij.microservices.jvm"})
@SourceDebugExtension(value={"SMAP\nFrameworkEditDependenciesDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrameworkEditDependenciesDialog.kt\ncom/intellij/microservices/jvm/dependencies/FrameworkEditDependenciesDialog\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,313:1\n19#2:314\n13#3:315\n13#3:316\n*S KotlinDebug\n*F\n+ 1 FrameworkEditDependenciesDialog.kt\ncom/intellij/microservices/jvm/dependencies/FrameworkEditDependenciesDialog\n*L\n248#1:314\n190#1:315\n193#1:316\n*E\n"})
public abstract class FrameworkEditDependenciesDialog
extends DialogWrapper {
    @NotNull
    private final Module module;
    @NotNull
    private final String frameworkVersion;
    @NotNull
    private final Lazy moduleBuilder$delegate;
    @NotNull
    private final WebStarterContext starterContext;
    @NotNull
    private final StarterWizardSettings moduleBuilderSettings;
    @NotNull
    private final JPanel mainPanel;
    @NotNull
    private final Lazy progressIcon$delegate;
    @NotNull
    private final Lazy serverUrlLink$delegate;
    @NotNull
    private final Lazy retryButton$delegate;
    @NotNull
    private final InplaceButton serverSettingsButton;
    @NotNull
    private final JBLoadingPanel loadingPanel;
    @Nullable
    private WebStarterLibrariesStep librariesStep;
    @NotNull
    private final Semaphore serverOptionsLoadingSemaphore;
    @Nullable
    private volatile Future<?> currentRequest;
    private volatile boolean isDisposed;
    @Nullable
    private volatile WebStarterServerOptions serverOptions;

    public FrameworkEditDependenciesDialog(@NotNull Module module, @NotNull String frameworkVersion, @NotNull List<? extends Module> relatedModules) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)frameworkVersion, (String)"frameworkVersion");
        Intrinsics.checkNotNullParameter(relatedModules, (String)"relatedModules");
        super(module.getProject());
        this.module = module;
        this.frameworkVersion = frameworkVersion;
        this.moduleBuilder$delegate = LazyKt.lazy(() -> FrameworkEditDependenciesDialog.moduleBuilder_delegate$lambda$0(this, relatedModules));
        WebStarterModuleBuilder webStarterModuleBuilder = this.getModuleBuilder();
        Intrinsics.checkNotNull((Object)webStarterModuleBuilder, (String)"null cannot be cast to non-null type com.intellij.microservices.jvm.dependencies.FrameworkModuleBuilder");
        this.starterContext = ((FrameworkModuleBuilder)webStarterModuleBuilder).getContext();
        WebStarterModuleBuilder webStarterModuleBuilder2 = this.getModuleBuilder();
        Intrinsics.checkNotNull((Object)webStarterModuleBuilder2, (String)"null cannot be cast to non-null type com.intellij.microservices.jvm.dependencies.FrameworkModuleBuilder");
        this.moduleBuilderSettings = ((FrameworkModuleBuilder)webStarterModuleBuilder2).getSettings();
        this.mainPanel = new JPanel(new BorderLayout());
        this.progressIcon$delegate = LazyKt.lazy(() -> FrameworkEditDependenciesDialog.progressIcon_delegate$lambda$0(this));
        this.serverUrlLink$delegate = LazyKt.lazy(() -> FrameworkEditDependenciesDialog.serverUrlLink_delegate$lambda$0(this));
        this.retryButton$delegate = LazyKt.lazy(() -> FrameworkEditDependenciesDialog.retryButton_delegate$lambda$0(this));
        this.serverSettingsButton = new InplaceButton(new IconButton(JavaStartersBundle.message((String)"button.tooltip.configure", (Object[])new Object[0]), AllIcons.General.Gear, AllIcons.General.GearHover), arg_0 -> FrameworkEditDependenciesDialog.serverSettingsButton$lambda$0(this, arg_0));
        LayoutManager layoutManager = new BorderLayout();
        Disposable disposable = this.myDisposable;
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"myDisposable");
        this.loadingPanel = new JBLoadingPanel(layoutManager, disposable, 0, 4, null);
        this.serverOptionsLoadingSemaphore = new Semaphore();
        this.setTitle(this.getDialogTitle());
        this.starterContext.setServerUrl(this.getModuleBuilder().getDefaultServerUrl());
        this.setOKActionEnabled(false);
        Disposer.register((Disposable)this.myDisposable, () -> FrameworkEditDependenciesDialog._init_$lambda$0(this));
        this.init();
    }

    @NotNull
    protected final Module getModule() {
        return this.module;
    }

    @NotNull
    protected final String getFrameworkVersion() {
        return this.frameworkVersion;
    }

    @NotNull
    protected final WebStarterModuleBuilder getModuleBuilder() {
        Lazy lazy = this.moduleBuilder$delegate;
        return (WebStarterModuleBuilder)lazy.getValue();
    }

    @NotNull
    protected final WebStarterContext getStarterContext() {
        return this.starterContext;
    }

    @NotNull
    protected final JPanel getMainPanel() {
        return this.mainPanel;
    }

    private final AsyncProcessIcon getProgressIcon() {
        Lazy lazy = this.progressIcon$delegate;
        return (AsyncProcessIcon)lazy.getValue();
    }

    private final ActionLink getServerUrlLink() {
        Lazy lazy = this.serverUrlLink$delegate;
        return (ActionLink)lazy.getValue();
    }

    private final InplaceButton getRetryButton() {
        Lazy lazy = this.retryButton$delegate;
        return (InplaceButton)lazy.getValue();
    }

    @Nullable
    protected final WebStarterLibrariesStep getLibrariesStep() {
        return this.librariesStep;
    }

    protected final void setLibrariesStep(@Nullable WebStarterLibrariesStep webStarterLibrariesStep) {
        this.librariesStep = webStarterLibrariesStep;
    }

    @Nullable
    protected final Future<?> getCurrentRequest() {
        return this.currentRequest;
    }

    protected final void setCurrentRequest(@Nullable Future<?> future) {
        this.currentRequest = future;
    }

    @NotNull
    protected abstract WebStarterModuleBuilder createModuleBuilder(@NotNull List<? extends Module> var1);

    @NotNull
    protected abstract String getDialogTitle();

    @NotNull
    protected abstract String getDependenciesLoadingText();

    @NotNull
    protected JComponent createCenterPanel() {
        this.getProgressIcon().setToolTipText(JavaStartersBundle.message((String)"message.state.connecting.and.retrieving.options", (Object[])new Object[0]));
        DialogPanel serverUrlPanel = BuilderKt.panel(arg_0 -> FrameworkEditDependenciesDialog.createCenterPanel$lambda$0(this, arg_0));
        this.mainPanel.add((Component)serverUrlPanel, "North");
        this.mainPanel.add((Component)this.loadingPanel, "Center");
        this.loadingPanel.setLoadingText(this.getDependenciesLoadingText());
        this.loadingPanel.setMinimumSize(this.getLoadingPanelMinimumSize());
        this.requestServerOptions();
        return this.mainPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        Object object = this.librariesStep;
        if (object == null || (object = object.getPreferredFocusedComponent()) == null) {
            object = super.getPreferredFocusedComponent();
        }
        return object;
    }

    private final Dimension getLoadingPanelMinimumSize() {
        Version version = Version.parse("2.0.0");
        Intrinsics.checkNotNullExpressionValue((Object)version, (String)"parse(...)");
        this.starterContext.setServerOptions(new WebStarterServerOptions(CollectionsKt.listOf((Object)((Object)new FrameworkVersion("id", "title", version, true))), CollectionsKt.listOf((Object)new WebStarterDependencyCategory("category", CollectionsKt.listOf((Object)((Object)new FrameworkDependency("id", "title", null, null, false, null, 60, null)))))));
        WebStarterModuleBuilder webStarterModuleBuilder = this.getModuleBuilder();
        WizardContext wizardContext = new WizardContext(this.module.getProject(), this.myDisposable);
        Disposable disposable = this.myDisposable;
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"myDisposable");
        WebStarterContextProvider contextProvider = new WebStarterContextProvider(webStarterModuleBuilder, wizardContext, this.starterContext, this.moduleBuilderSettings, disposable);
        FrameworkWebStarterLibrariesStep librariesStep = new FrameworkWebStarterLibrariesStep(contextProvider);
        librariesStep.setLibraryRemovablePredicate((Function1<? super LibraryInfo, Boolean>)((Function1)FrameworkEditDependenciesDialog::getLoadingPanelMinimumSize$lambda$0));
        librariesStep._init();
        Dimension size = librariesStep.getComponent().getMinimumSize();
        return new Dimension(size.width * 3, size.height * 4);
    }

    private final ActionLink createServerUrlLink() {
        ActionLink result = new ActionLink(this.urlPreview(this.starterContext.getServerUrl()), arg_0 -> FrameworkEditDependenciesDialog.createServerUrlLink$lambda$0(this, arg_0));
        UIUtil.applyStyle((UIUtil.ComponentStyle)UIUtil.ComponentStyle.REGULAR, (Component)((Component)result));
        return result;
    }

    private final String urlPreview(String serverUrl) {
        String url = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)serverUrl, (CharSequence)"https://"), (CharSequence)"/");
        if (url.length() > 35) {
            return StringsKt.take((String)url, (int)30) + "...";
        }
        return url;
    }

    private final InplaceButton createRetryButton() {
        InplaceButton inplaceButton;
        InplaceButton $this$createRetryButton_u24lambda_u241 = inplaceButton = new InplaceButton(new IconButton(JavaStartersBundle.message((String)"button.tooltip.retry", (Object[])new Object[0]), AllIcons.Nodes.ErrorIntroduction, AllIcons.Actions.ForceRefresh), arg_0 -> FrameworkEditDependenciesDialog.createRetryButton$lambda$0(this, arg_0));
        boolean bl = false;
        $this$createRetryButton_u24lambda_u241.setVisible(false);
        return inplaceButton;
    }

    private final void requestServerOptions() {
        this.getProgressIcon().setVisible(true);
        this.getRetryButton().setVisible(false);
        this.loadingPanel.startLoading();
        this.setOKActionEnabled(false);
        this.getProgressIcon().resume();
        this.serverOptionsLoadingSemaphore.down();
        this.currentRequest = ApplicationManager.getApplication().executeOnPooledThread(() -> FrameworkEditDependenciesDialog.requestServerOptions$lambda$0(this));
    }

    private final Condition<Object> getDisposed() {
        return arg_0 -> FrameworkEditDependenciesDialog.getDisposed$lambda$0(this, arg_0);
    }

    private final void setServerOptions(WebStarterServerOptions serverOptions) {
        if (serverOptions != null) {
            this.starterContext.setServerOptions(serverOptions);
        }
        this.serverOptions = serverOptions;
        this.currentRequest = null;
        this.serverOptionsLoadingSemaphore.up();
        ApplicationManager.getApplication().invokeLater(() -> FrameworkEditDependenciesDialog.setServerOptions$lambda$0(this, serverOptions), this.getModalityState(), this.getDisposed());
    }

    private final void updateContent() {
        block2: {
            this.loadingPanel.stopLoading();
            this.setOKActionEnabled(true);
            WebStarterModuleBuilder webStarterModuleBuilder = this.getModuleBuilder();
            WizardContext wizardContext = new WizardContext(this.module.getProject(), this.myDisposable);
            Disposable disposable = this.myDisposable;
            Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"myDisposable");
            WebStarterContextProvider contextProvider = new WebStarterContextProvider(webStarterModuleBuilder, wizardContext, this.starterContext, this.moduleBuilderSettings, disposable);
            WebStarterLibrariesStep $this$asSafely$iv = this.librariesStep = (WebStarterLibrariesStep)new FrameworkWebStarterLibrariesStep(contextProvider, this){
                final /* synthetic */ FrameworkEditDependenciesDialog this$0;
                {
                    this.this$0 = $receiver;
                    super($contextProvider);
                }

                protected ModalityState getModalityState() {
                    return FrameworkEditDependenciesDialog.access$getModalityState(this.this$0);
                }
            };
            boolean $i$f$asSafely = false;
            WebStarterLibrariesStep webStarterLibrariesStep = $this$asSafely$iv;
            if (!(webStarterLibrariesStep instanceof FrameworkWebStarterLibrariesStep)) {
                webStarterLibrariesStep = null;
            }
            FrameworkWebStarterLibrariesStep frameworkWebStarterLibrariesStep = (FrameworkWebStarterLibrariesStep)webStarterLibrariesStep;
            if (frameworkWebStarterLibrariesStep != null) {
                frameworkWebStarterLibrariesStep.setLibraryRemovablePredicate((Function1<? super LibraryInfo, Boolean>)((Function1)FrameworkEditDependenciesDialog::updateContent$lambda$0));
            }
            WebStarterLibrariesStep webStarterLibrariesStep2 = this.librariesStep;
            Intrinsics.checkNotNull((Object)webStarterLibrariesStep2);
            webStarterLibrariesStep2._init();
            WebStarterLibrariesStep webStarterLibrariesStep3 = this.librariesStep;
            Intrinsics.checkNotNull((Object)webStarterLibrariesStep3);
            this.loadingPanel.add((Component)webStarterLibrariesStep3.getComponent(), (Object)"Center");
            this.mainPanel.revalidate();
            this.mainPanel.repaint();
            WebStarterLibrariesStep webStarterLibrariesStep4 = this.librariesStep;
            Intrinsics.checkNotNull((Object)webStarterLibrariesStep4);
            JComponent jComponent = webStarterLibrariesStep4.getPreferredFocusedComponent();
            if (jComponent == null) break block2;
            jComponent.requestFocus();
        }
    }

    private final ModalityState getModalityState() {
        ModalityState modalityState = ModalityState.stateForComponent((Component)this.mainPanel);
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"stateForComponent(...)");
        return modalityState;
    }

    private final void configureServer() {
        Object serverUrlTitle;
        String newUrl2;
        String currentServerUrl = this.starterContext.getServerUrl();
        Object object = this.moduleBuilderSettings.getCustomizedMessages();
        if (object == null || (object = object.getServerUrlDialogTitle()) == null) {
            String string = JavaStartersBundle.message((String)"title.server.url.dialog", (Object[])new Object[0]);
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        }
        if ((newUrl2 = Messages.showInputDialog((Component)this.mainPanel, null, (String)(serverUrlTitle = object), null, (String)currentServerUrl, (InputValidator)new InputValidator(){

            public boolean canClose(String inputString) {
                return this.checkInput(inputString);
            }

            public boolean checkInput(String inputString) {
                try {
                    new URL(inputString);
                }
                catch (MalformedURLException malformedURLException) {
                    return false;
                }
                return true;
            }
        })) != null && !Intrinsics.areEqual((Object)this.starterContext.getServerUrl(), (Object)newUrl2)) {
            this.setServerUrl(newUrl2);
            PropertiesComponent.getInstance().setValue(this.getServerUrlPropertyName(), newUrl2);
            this.requestServerOptions();
        }
    }

    private final void setServerUrl(@NlsSafe String url) {
        this.starterContext.setServerUrl(url);
        this.getServerUrlLink().setText(this.urlPreview(url));
        this.getServerUrlLink().setToolTipText(url);
    }

    private final String getServerUrlPropertyName() {
        return this.getModuleBuilder().getBuilderId() + ".service.url.last";
    }

    private static final WebStarterModuleBuilder moduleBuilder_delegate$lambda$0(FrameworkEditDependenciesDialog this$0, List $relatedModules) {
        return this$0.createModuleBuilder($relatedModules);
    }

    private static final AsyncProcessIcon progressIcon_delegate$lambda$0(FrameworkEditDependenciesDialog this$0) {
        return new AsyncProcessIcon(this$0.getModuleBuilder().getBuilderId() + "ServerOptions");
    }

    private static final ActionLink serverUrlLink_delegate$lambda$0(FrameworkEditDependenciesDialog this$0) {
        return this$0.createServerUrlLink();
    }

    private static final InplaceButton retryButton_delegate$lambda$0(FrameworkEditDependenciesDialog this$0) {
        return this$0.createRetryButton();
    }

    private static final void serverSettingsButton$lambda$0(FrameworkEditDependenciesDialog this$0, ActionEvent it) {
        this$0.configureServer();
    }

    private static final void _init_$lambda$0(FrameworkEditDependenciesDialog this$0) {
        block0: {
            this$0.isDisposed = true;
            Future<?> future = this$0.currentRequest;
            if (future == null) break block0;
            future.cancel(true);
        }
    }

    private static final Unit createCenterPanel$lambda$0(FrameworkEditDependenciesDialog this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> FrameworkEditDependenciesDialog.createCenterPanel$lambda$0$0(this$0, arg_0), (int)1, null).bottomGap(BottomGap.SMALL);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$0(FrameworkEditDependenciesDialog this$0, Row $this$row) {
        Cell cell;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = JavaStartersBundle.message((String)"title.project.server.url.label", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell $this$createCenterPanel_u24lambda_u240_u240_u240 = cell = $this$row.label(string);
        boolean bl = false;
        ((JLabel)$this$createCenterPanel_u24lambda_u240_u240_u240.getComponent()).setBorder((Border)JBUI.Borders.emptyLeft((int)20));
        $this$row.cell((JComponent)this$0.getServerUrlLink());
        $this$row.cell((JComponent)this$0.serverSettingsButton);
        $this$row.cell((JComponent)this$0.getRetryButton());
        $this$row.cell((JComponent)this$0.getProgressIcon());
        return Unit.INSTANCE;
    }

    private static final boolean getLoadingPanelMinimumSize$lambda$0(LibraryInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !it.isDefault();
    }

    private static final Unit createServerUrlLink$lambda$0(FrameworkEditDependenciesDialog this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BrowserUtil.browse((String)this$0.starterContext.getServerUrl());
        return Unit.INSTANCE;
    }

    private static final void createRetryButton$lambda$0(FrameworkEditDependenciesDialog this$0, ActionEvent it) {
        this$0.requestServerOptions();
    }

    private static final void requestServerOptions$lambda$0(FrameworkEditDependenciesDialog this$0) {
        WebStarterServerOptions webStarterServerOptions;
        try {
            webStarterServerOptions = this$0.getModuleBuilder().getServerOptions(this$0.starterContext.getServerUrl());
        }
        catch (Exception e) {
            if (e instanceof IOException || e instanceof IllegalStateException) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(WebStarterInitialStep.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.info("Unable to get server options for " + this$0.getModuleBuilder().getBuilderId(), (Throwable)e);
            } else {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(WebStarterInitialStep.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Unable to get server options for " + this$0.getModuleBuilder().getBuilderId(), (Throwable)e);
            }
            ApplicationManager.getApplication().invokeLater(() -> FrameworkEditDependenciesDialog.requestServerOptions$lambda$0$0(this$0, e), this$0.getModalityState());
            webStarterServerOptions = null;
        }
        WebStarterServerOptions readyServerOptions = webStarterServerOptions;
        this$0.setServerOptions(readyServerOptions);
    }

    private static final void requestServerOptions$lambda$0$0(FrameworkEditDependenciesDialog this$0, Exception $e) {
        if (this$0.mainPanel.isShowing()) {
            Object[] objectArray = new Object[]{this$0.starterContext.getServerUrl(), $e.getMessage()};
            Messages.showErrorDialog((String)JavaStartersBundle.message((String)"message.no.connection.with.error.content", (Object[])objectArray), (String)JavaStartersBundle.message((String)"message.title.error", (Object[])new Object[0]));
            this$0.loadingPanel.stopLoading();
        }
    }

    private static final boolean getDisposed$lambda$0(FrameworkEditDependenciesDialog this$0, Object it) {
        return this$0.isDisposed;
    }

    private static final void setServerOptions$lambda$0(FrameworkEditDependenciesDialog this$0, WebStarterServerOptions $serverOptions) {
        this$0.getProgressIcon().suspend();
        this$0.getProgressIcon().setVisible(false);
        this$0.getRetryButton().setVisible($serverOptions == null);
        if ($serverOptions != null) {
            this$0.updateContent();
        }
    }

    private static final boolean updateContent$lambda$0(LibraryInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !it.isDefault();
    }

    public static final /* synthetic */ ModalityState access$getModalityState(FrameworkEditDependenciesDialog $this) {
        return $this.getModalityState();
    }
}

