/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.local.generation;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.completion.full.line.language.TrimPolicy;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00042\u00020\u0001:\u0001\u0004B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/completion/full/line/local/generation/ChunkTrimmer;", "", "<init>", "()V", "Companion", "intellij.fullLine.local"})
public final class ChunkTrimmer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Map<Character, Character> CLOSING_TO_OPENING_BRACKETS;
    @NotNull
    private static final Set<Character> OPENING_BRACKETS;
    @NotNull
    private static final Set<Character> QUOTES;

    static {
        Object[] objectArray = new Pair[]{TuplesKt.to((Object)Character.valueOf(')'), (Object)Character.valueOf('(')), TuplesKt.to((Object)Character.valueOf(']'), (Object)Character.valueOf('[')), TuplesKt.to((Object)Character.valueOf('}'), (Object)Character.valueOf('{'))};
        CLOSING_TO_OPENING_BRACKETS = MapsKt.mapOf((Pair[])objectArray);
        OPENING_BRACKETS = CollectionsKt.toSet((Iterable)CLOSING_TO_OPENING_BRACKETS.values());
        objectArray = new Character[]{Character.valueOf('\"'), Character.valueOf('\''), Character.valueOf('`')};
        QUOTES = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u001fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u0017J\u001a\u0010\u0018\u001a\u00020\u0010*\u00020\u00102\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u0017H\u0007J\"\u0010\u0019\u001a\u00020\u0010*\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u0017H\u0007J\u0014\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u0017*\u00020\u0010H\u0007J\u0014\u0010\u001c\u001a\u00020\u0015*\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u0015H\u0002J\u001a\u0010\u001e\u001a\u00020\u0015*\u00020\u00102\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00100\u0017H\u0002R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\f\u00a8\u0006 "}, d2={"Lorg/jetbrains/completion/full/line/local/generation/ChunkTrimmer$Companion;", "", "<init>", "()V", "CLOSING_TO_OPENING_BRACKETS", "", "", "getCLOSING_TO_OPENING_BRACKETS", "()Ljava/util/Map;", "OPENING_BRACKETS", "", "getOPENING_BRACKETS", "()Ljava/util/Set;", "QUOTES", "getQUOTES", "trim", "", "chunk", "policy", "Lorg/jetbrains/completion/full/line/language/TrimPolicy;", "chunkOffset", "", "endOfLineMarkers", "", "trimLines", "trimByBrackets", "findRedundantBrackets", "Lorg/jetbrains/completion/full/line/local/generation/ChunkTrimmer$Companion$Bracket;", "numberOfPrecedingSlashes", "offset", "numberOfLines", "Bracket", "intellij.fullLine.local"})
    @SourceDebugExtension(value={"SMAP\nChunkTrimmer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChunkTrimmer.kt\norg/jetbrains/completion/full/line/local/generation/ChunkTrimmer$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Strings.kt\nkotlin/text/StringsKt__StringsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,86:1\n388#2,7:87\n106#3:94\n78#3,22:95\n37#4,2:117\n*S KotlinDebug\n*F\n+ 1 ChunkTrimmer.kt\norg/jetbrains/completion/full/line/local/generation/ChunkTrimmer$Companion\n*L\n38#1:87,7\n41#1:94\n41#1:95,22\n81#1:117,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<Character, Character> getCLOSING_TO_OPENING_BRACKETS() {
            return CLOSING_TO_OPENING_BRACKETS;
        }

        @NotNull
        public final Set<Character> getOPENING_BRACKETS() {
            return OPENING_BRACKETS;
        }

        @NotNull
        public final Set<Character> getQUOTES() {
            return QUOTES;
        }

        @NotNull
        public final String trim(@NotNull String chunk, @NotNull TrimPolicy policy, int chunkOffset, @NotNull List<String> endOfLineMarkers) {
            Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
            Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
            Intrinsics.checkNotNullParameter(endOfLineMarkers, (String)"endOfLineMarkers");
            return switch (WhenMappings.$EnumSwitchMapping$0[policy.ordinal()]) {
                case 1 -> {
                    String trimmedByBrackets = this.trimByBrackets(chunk, chunkOffset, endOfLineMarkers);
                    if (this.numberOfLines(trimmedByBrackets, endOfLineMarkers) == 1) {
                        yield this.trimLines(chunk, endOfLineMarkers);
                    }
                    yield trimmedByBrackets;
                }
                case 2 -> this.trimLines(chunk, endOfLineMarkers);
                default -> chunk;
            };
        }

        @VisibleForTesting
        @NotNull
        public final String trimLines(@NotNull String $this$trimLines, @NotNull List<String> endOfLineMarkers) {
            Intrinsics.checkNotNullParameter((Object)$this$trimLines, (String)"<this>");
            Intrinsics.checkNotNullParameter(endOfLineMarkers, (String)"endOfLineMarkers");
            String joinedMarkers = CollectionsKt.joinToString$default((Iterable)endOfLineMarkers, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
            Regex valuableLineRegex = new Regex("[^" + joinedMarkers + "]*\\w[^" + joinedMarkers + "]*");
            Sequence valuableLines = Regex.findAll$default((Regex)valuableLineRegex, (CharSequence)$this$trimLines, (int)0, (int)2, null);
            int start = ((MatchResult)SequencesKt.first((Sequence)valuableLines)).getRange().getStart();
            int end = ((MatchResult)SequencesKt.last((Sequence)valuableLines)).getRange().getEndInclusive() + 1;
            String string = $this$trimLines.substring(start, end);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            return string;
        }

        /*
         * WARNING - void declaration
         */
        @VisibleForTesting
        @NotNull
        public final String trimByBrackets(@NotNull String $this$trimByBrackets, int chunkOffset, @NotNull List<String> endOfLineMarkers) {
            void $this$trim$iv;
            int n;
            Object iterator$iv;
            List<Bracket> redundantBrackets;
            block6: {
                Intrinsics.checkNotNullParameter((Object)$this$trimByBrackets, (String)"<this>");
                Intrinsics.checkNotNullParameter(endOfLineMarkers, (String)"endOfLineMarkers");
                List<Bracket> list = this.findRedundantBrackets($this$trimByBrackets);
                if (list == null) {
                    return "";
                }
                redundantBrackets = list;
                if (redundantBrackets.isEmpty()) {
                    return $this$trimByBrackets;
                }
                List<Bracket> $this$indexOfLast$iv = redundantBrackets;
                boolean $i$f$indexOfLast = false;
                iterator$iv = $this$indexOfLast$iv.listIterator($this$indexOfLast$iv.size());
                while (iterator$iv.hasPrevious()) {
                    Bracket it = iterator$iv.previous();
                    boolean bl = false;
                    if (!(it.getOffset() <= chunkOffset)) continue;
                    n = iterator$iv.nextIndex();
                    break block6;
                }
                n = -1;
            }
            int startBracketIndex = n;
            int startOffset = startBracketIndex == -1 ? 0 : redundantBrackets.get(startBracketIndex).getOffset() + 1;
            int endOffset = startBracketIndex + 1 >= redundantBrackets.size() ? $this$trimByBrackets.length() : redundantBrackets.get(startBracketIndex + 1).getOffset();
            String string = $this$trimByBrackets.substring(startOffset, endOffset);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            iterator$iv = string;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean match$iv$iv = endOfLineMarkers.contains(String.valueOf(it));
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            return ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        }

        @VisibleForTesting
        @Nullable
        public final List<Bracket> findRedundantBrackets(@NotNull String $this$findRedundantBrackets) {
            Intrinsics.checkNotNullParameter((Object)$this$findRedundantBrackets, (String)"<this>");
            ArrayDeque stack = new ArrayDeque();
            Character quote = null;
            int n = $this$findRedundantBrackets.length();
            for (int i = 0; i < n; ++i) {
                int offset = i;
                char c = $this$findRedundantBrackets.charAt(i);
                Character c2 = quote;
                char c3 = c;
                boolean isMatchingQuote = c2 != null && c2.charValue() == c3 && this.numberOfPrecedingSlashes($this$findRedundantBrackets, offset) % 2 == 0;
                boolean isNewQuote = quote == null && this.getQUOTES().contains(Character.valueOf(c));
                if (isMatchingQuote) {
                    quote = null;
                } else if (isNewQuote) {
                    quote = Character.valueOf(c);
                }
                if (quote != null) continue;
                char c4 = c;
                if (this.getOPENING_BRACKETS().contains(Character.valueOf(c4))) {
                    stack.addLast((Object)new Bracket(c, offset));
                    continue;
                }
                if (!this.getCLOSING_TO_OPENING_BRACKETS().keySet().contains(Character.valueOf(c4))) continue;
                if (stack.isEmpty() || this.getCLOSING_TO_OPENING_BRACKETS().keySet().contains(Character.valueOf(((Bracket)stack.last()).getChar()))) {
                    stack.addLast((Object)new Bracket(c, offset));
                    continue;
                }
                Character c5 = this.getCLOSING_TO_OPENING_BRACKETS().get(Character.valueOf(c));
                if (c5 != null && ((Bracket)stack.last()).getChar() == c5.charValue()) {
                    stack.removeLast();
                    continue;
                }
                return null;
            }
            return (List)stack;
        }

        private final int numberOfPrecedingSlashes(String $this$numberOfPrecedingSlashes, int offset) {
            int i;
            for (i = offset - 1; i >= 0 && $this$numberOfPrecedingSlashes.charAt(i) == '\\'; --i) {
            }
            return offset - i - 1;
        }

        private final int numberOfLines(String $this$numberOfLines, List<String> endOfLineMarkers) {
            Collection $this$toTypedArray$iv = endOfLineMarkers;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            return StringsKt.split$default((CharSequence)$this$numberOfLines, (String[])Arrays.copyOf(stringArray, stringArray.length), (boolean)false, (int)0, (int)6, null).size();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/completion/full/line/local/generation/ChunkTrimmer$Companion$Bracket;", "", "char", "", "offset", "", "<init>", "(CI)V", "getChar", "()C", "getOffset", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.fullLine.local"})
        public static final class Bracket {
            private final char char;
            private final int offset;

            public Bracket(char c, int offset) {
                this.char = c;
                this.offset = offset;
            }

            public final char getChar() {
                return this.char;
            }

            public final int getOffset() {
                return this.offset;
            }

            public final char component1() {
                return this.char;
            }

            public final int component2() {
                return this.offset;
            }

            @NotNull
            public final Bracket copy(char c, int offset) {
                return new Bracket(c, offset);
            }

            public static /* synthetic */ Bracket copy$default(Bracket bracket, char c, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    c = bracket.char;
                }
                if ((n2 & 2) != 0) {
                    n = bracket.offset;
                }
                return bracket.copy(c, n);
            }

            @NotNull
            public String toString() {
                return "Bracket(char=" + this.char + ", offset=" + this.offset + ")";
            }

            public int hashCode() {
                int result = Character.hashCode(this.char);
                result = result * 31 + Integer.hashCode(this.offset);
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Bracket)) {
                    return false;
                }
                Bracket bracket = (Bracket)other;
                if (this.char != bracket.char) {
                    return false;
                }
                return this.offset == bracket.offset;
            }
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[TrimPolicy.values().length];
                try {
                    nArray[TrimPolicy.BRACKETS.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[TrimPolicy.NON_VALUABLE_LINES.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

