/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.javaee.web.tld;

import com.intellij.javaee.ExternalResourceManager;
import com.intellij.javaee.ExternalResourceManagerEx;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.jsp.javaee.web.tld.TaglibIndex;
import com.intellij.jsp.javaee.web.tld.WebTldProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.index.IndexedRelevantResource;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface TldProvider {
    @NonNls
    public static final String TAGS_DIR = "/WEB-INF/tags";
    public static final TldProvider DEFAULT = new TldProvider(){

        @Override
        public XmlFile getTldFileByUri(String uri, @NotNull Module module, @Nullable JspFile context) {
            List<IndexedRelevantResource<String, TaglibIndex.TaglibInfo>> resources;
            if (module == null) {
                1.$$$reportNull$$$0(0);
            }
            if ((resources = TaglibIndex.getTldFiles(uri, module, context)).isEmpty()) {
                return null;
            }
            IndexedRelevantResource<String, TaglibIndex.TaglibInfo> max = Collections.max(resources);
            PsiManager psiManager = PsiManager.getInstance((Project)module.getProject());
            PsiFile file = psiManager.findFile(max.getFile());
            return file instanceof XmlFile ? (XmlFile)file : null;
        }

        @Override
        public void collectUris(@NotNull Module module, Map<String, XmlFile> map, JspFile context) {
            if (module == null) {
                1.$$$reportNull$$$0(1);
            }
            List<IndexedRelevantResource<String, TaglibIndex.TaglibInfo>> resources = TaglibIndex.getTldFiles(module, context);
            for (IndexedRelevantResource<String, TaglibIndex.TaglibInfo> resource : resources) {
                String key;
                PsiManager psiManager = PsiManager.getInstance((Project)module.getProject());
                PsiFile psiFile = psiManager.findFile(resource.getFile());
                if (!(psiFile instanceof XmlFile) || map.containsKey(key = (String)resource.getKey())) continue;
                map.put(key, (XmlFile)psiFile);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "module";
            objectArray2[1] = "com/intellij/jsp/javaee/web/tld/TldProvider$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getTldFileByUri";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "collectUris";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    public static final TldProvider LOCAL = new TldProvider(){

        @Override
        public XmlFile getTldFileByUri(String uri, @NotNull Module module, @Nullable JspFile context) {
            if (module == null) {
                2.$$$reportNull$$$0(0);
            }
            if (context == null) {
                return null;
            }
            WebFacet webFacet = WebUtil.getWebFacet((PsiElement)context);
            if (webFacet == null) {
                return null;
            }
            return WebTldProvider.resolveResource(uri, webFacet);
        }

        @Override
        public void collectUris(@NotNull Module module, Map<String, XmlFile> map, JspFile context) {
            if (module == null) {
                2.$$$reportNull$$$0(1);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "module";
            objectArray2[1] = "com/intellij/jsp/javaee/web/tld/TldProvider$2";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getTldFileByUri";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "collectUris";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    public static final TldProvider WEB = new WebTldProvider();
    public static final TldProvider MAPPED = new TldProvider(){

        @Override
        public XmlFile getTldFileByUri(String uri, @NotNull Module module, @Nullable JspFile context) {
            String location;
            if (module == null) {
                3.$$$reportNull$$$0(0);
            }
            if ((location = ExternalResourceManagerEx.getInstanceEx().getUserResource(module.getProject(), uri, null)) != null) {
                return 3.findXmlFile(module, location);
            }
            return null;
        }

        @Override
        public void collectUris(@NotNull Module module, Map<String, XmlFile> map, JspFile context) {
            if (module == null) {
                3.$$$reportNull$$$0(1);
            }
            ExternalResourceManager resourceManager = ExternalResourceManager.getInstance();
            for (String url : resourceManager.getResourceUrls(null, false)) {
                XmlFile xmlFile;
                String location = resourceManager.getResourceLocation(url, module.getProject());
                if (location == null || (xmlFile = 3.findXmlFile(module, location)) == null || map.containsKey(url)) continue;
                map.put(url, xmlFile);
            }
        }

        @Nullable
        private static XmlFile findXmlFile(Module module, String location) {
            XmlDocument document;
            PsiFile psiFile;
            if (!location.endsWith(".tld") && !location.endsWith(".xml")) {
                return null;
            }
            VirtualFile virtualFile = VfsUtilCore.findRelativeFile((String)location, null);
            if (virtualFile != null && (psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(virtualFile)) instanceof XmlFile && (document = ((XmlFile)psiFile).getDocument()) != null && document.getMetaData() instanceof XmlNSDescriptor) {
                return (XmlFile)psiFile;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "module";
            objectArray2[1] = "com/intellij/jsp/javaee/web/tld/TldProvider$3";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getTldFileByUri";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "collectUris";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };
    public static final TldProvider[] ALL = new TldProvider[]{MAPPED, DEFAULT, LOCAL, WEB};

    @Nullable
    public XmlFile getTldFileByUri(String var1, @NotNull Module var2, @Nullable JspFile var3);

    public void collectUris(@NotNull Module var1, Map<String, XmlFile> var2, @Nullable JspFile var3);
}

