/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics;

import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.ColorKt;
import androidx.compose.ui.graphics.InlineClassHelperKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0017\n\u0002\b\u0006\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0005\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0005\u00a2\u0006\u0004\b\f\u0010\rJ\u0016\u0010\u001b\u001a\u00020\u00152\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0005H\u0002J\u0016\u0010\u001c\u001a\u00020\u00112\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002R\u0013\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\b\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\n\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001e"}, d2={"Landroidx/compose/ui/graphics/Vertices;", "", "vertexMode", "Landroidx/compose/ui/graphics/VertexMode;", "positions", "", "Landroidx/compose/ui/geometry/Offset;", "textureCoordinates", "colors", "Landroidx/compose/ui/graphics/Color;", "indices", "", "<init>", "(ILjava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "getVertexMode-c2xauaI", "()I", "I", "", "getPositions", "()[F", "getTextureCoordinates", "", "getColors", "()[I", "", "getIndices", "()[S", "encodeColorList", "encodePointList", "points", "ui-graphics"})
@SourceDebugExtension(value={"SMAP\nVertices.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Vertices.kt\nandroidx/compose/ui/graphics/Vertices\n+ 2 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n+ 3 Offset.kt\nandroidx/compose/ui/geometry/Offset\n+ 4 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 5 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n*L\n1#1,68:1\n103#2:69\n35#2,5:70\n104#2:75\n65#3:76\n69#3:79\n60#4:77\n70#4:80\n22#5:78\n22#5:81\n*S KotlinDebug\n*F\n+ 1 Vertices.kt\nandroidx/compose/ui/graphics/Vertices\n*L\n41#1:69\n41#1:70,5\n41#1:75\n61#1:76\n63#1:79\n61#1:77\n63#1:80\n61#1:78\n63#1:81\n*E\n"})
public final class Vertices {
    private final int vertexMode;
    @NotNull
    private final float[] positions;
    @NotNull
    private final float[] textureCoordinates;
    @NotNull
    private final int[] colors;
    @NotNull
    private final short[] indices;

    private Vertices(int vertexMode, List<Offset> positions, List<Offset> textureCoordinates, List<Color> colors, List<Integer> indices) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter(positions, (String)"positions");
            Intrinsics.checkNotNullParameter(textureCoordinates, (String)"textureCoordinates");
            Intrinsics.checkNotNullParameter(colors, (String)"colors");
            Intrinsics.checkNotNullParameter(indices, (String)"indices");
            this.vertexMode = vertexMode;
            if (textureCoordinates.size() != positions.size()) {
                InlineClassHelperKt.throwIllegalArgumentException("positions and textureCoordinates lengths must match.");
            }
            if (colors.size() != positions.size()) {
                InlineClassHelperKt.throwIllegalArgumentException("positions and colors lengths must match.");
            }
            List<Integer> $this$fastAny$iv = indices;
            boolean $i$f$fastAny = false;
            List<Integer> $this$fastForEach$iv$iv = $this$fastAny$iv;
            boolean $i$f$fastForEach = false;
            int n = ((Collection)$this$fastForEach$iv$iv).size();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                Integer item$iv$iv;
                Integer it$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                boolean bl2 = false;
                int it = ((Number)it$iv).intValue();
                boolean bl3 = false;
                if (!(it < 0 || it >= positions.size())) continue;
                bl = true;
                break block5;
            }
            bl = false;
        }
        if (bl) {
            InlineClassHelperKt.throwIllegalArgumentException("indices values must be valid indices in the positions list.");
        }
        this.positions = this.encodePointList(positions);
        this.textureCoordinates = this.encodePointList(textureCoordinates);
        this.colors = this.encodeColorList(colors);
        int n = 0;
        int n2 = indices.size();
        short[] sArray = new short[n2];
        Vertices vertices = this;
        while (n < n2) {
            int n3 = n++;
            sArray[n3] = (short)((Number)indices.get(n3)).intValue();
        }
        vertices.indices = sArray;
    }

    public final int getVertexMode-c2xauaI() {
        return this.vertexMode;
    }

    @NotNull
    public final float[] getPositions() {
        return this.positions;
    }

    @NotNull
    public final float[] getTextureCoordinates() {
        return this.textureCoordinates;
    }

    @NotNull
    public final int[] getColors() {
        return this.colors;
    }

    @NotNull
    public final short[] getIndices() {
        return this.indices;
    }

    private final int[] encodeColorList(List<Color> colors) {
        int n = 0;
        int n2 = colors.size();
        int[] nArray = new int[n2];
        while (n < n2) {
            int n3 = n++;
            nArray[n3] = ColorKt.toArgb-8_81llA(colors.get(n3).unbox-impl());
        }
        return nArray;
    }

    private final float[] encodePointList(List<Offset> points) {
        int n = points.size() * 2;
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            float f;
            boolean $i$f$floatFromBits;
            int bits$iv$iv$iv;
            long value$iv$iv;
            long arg0$iv;
            int n2 = i;
            int pointIndex = n2 / 2;
            long point = points.get(pointIndex).unbox-impl();
            if (n2 % 2 == 0) {
                arg0$iv = point;
                boolean bl = false;
                value$iv$iv = arg0$iv;
                boolean $i$f$unpackFloat1 = false;
                bits$iv$iv$iv = (int)(value$iv$iv >> 32);
                $i$f$floatFromBits = false;
                f = Float.intBitsToFloat(bits$iv$iv$iv);
            } else {
                arg0$iv = point;
                boolean bl = false;
                value$iv$iv = arg0$iv;
                boolean $i$f$unpackFloat2 = false;
                bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
                $i$f$floatFromBits = false;
                f = Float.intBitsToFloat(bits$iv$iv$iv);
            }
            fArray[n2] = f;
        }
        return fArray;
    }

    public /* synthetic */ Vertices(int vertexMode, List positions, List textureCoordinates, List colors, List indices, DefaultConstructorMarker $constructor_marker) {
        this(vertexMode, positions, textureCoordinates, colors, indices);
    }
}

