/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.process;

import com.intellij.javaee.process.JavaeeProcessResponse;
import com.intellij.javaee.process.common.Base64EncodingUtil;
import com.intellij.javaee.process.common.DocumentReader;
import com.intellij.javaee.process.common.JavaeeProcessUtilException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.socketConnection.ResponseToRequest;

public class JavaeeProcessResponseToRequest
extends JavaeeProcessResponse
implements ResponseToRequest {
    private final String myResult;
    private final boolean myResultIsNull;
    private final String myException;
    private final int myRequestId;

    public JavaeeProcessResponseToRequest(DocumentReader documentReader) throws JavaeeProcessUtilException {
        this.myRequestId = Integer.parseInt(documentReader.getTopElement("requestId"));
        this.myResult = documentReader.getTopElement("result");
        this.myResultIsNull = Boolean.parseBoolean(documentReader.getTopElement("resultIsNull"));
        this.myException = Base64EncodingUtil.decodeBase64((String)documentReader.getTopElement("exception"));
    }

    public String getResult() {
        return this.myResult;
    }

    public boolean isResultNull() {
        return this.myResultIsNull;
    }

    public void rethrowException() {
        if (!StringUtil.isEmpty((String)this.myException)) {
            throw new RuntimeException(this.myException);
        }
    }

    public int getRequestId() {
        return this.myRequestId;
    }
}

