/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.types;

import com.intellij.database.model.DataType;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.types.DasBuiltinTypeWithPrecision;
import com.intellij.database.types.DasSimpleBuiltinTypeClass;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeInternerKt;
import com.intellij.database.types.DasTypeUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0019B!\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\u0002H\u0016J\b\u0010\n\u001a\u00020\u0005H\u0016J\b\u0010\u000b\u001a\u00020\u0005H\u0016J\u0018\u0010\f\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\r\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013H\u0016J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0005H\u0016R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/database/types/DasBuiltinTypeWithPrecisionImpl;", "Lcom/intellij/database/types/DasBuiltinTypeWithPrecision;", "Lcom/intellij/database/types/DasSimpleBuiltinTypeClass;", "typeClass", "precision", "", "scale", "<init>", "(Lcom/intellij/database/types/DasSimpleBuiltinTypeClass;II)V", "getTypeClass", "getPrecision", "getScale", "copy", "withTypeClass", "newTypeClass", "getDescription", "", "toDataType", "Lcom/intellij/database/model/DataType;", "Lorg/jetbrains/annotations/NotNull;", "equals", "", "other", "", "hashCode", "Companion", "intellij.database.core.impl"})
public final class DasBuiltinTypeWithPrecisionImpl
implements DasBuiltinTypeWithPrecision<DasSimpleBuiltinTypeClass> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DasSimpleBuiltinTypeClass typeClass;
    private final int precision;
    private final int scale;

    private DasBuiltinTypeWithPrecisionImpl(DasSimpleBuiltinTypeClass typeClass, int precision, int scale) {
        this.typeClass = typeClass;
        this.precision = precision;
        this.scale = scale;
    }

    @NotNull
    public DasSimpleBuiltinTypeClass getTypeClass() {
        return this.typeClass;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    @NotNull
    public DasBuiltinTypeWithPrecisionImpl copy(int precision, int scale) {
        return Companion.of(this.typeClass, precision, scale);
    }

    @NotNull
    public DasBuiltinTypeWithPrecisionImpl withTypeClass(@NotNull DasSimpleBuiltinTypeClass newTypeClass) {
        Intrinsics.checkNotNullParameter((Object)newTypeClass, (String)"newTypeClass");
        return Companion.of(newTypeClass, this.precision, this.scale);
    }

    @NotNull
    public String getDescription() {
        StringBuilder stringBuilder;
        String string = DasTypeUtilsKt.renderSize(this.precision);
        if (string == null) {
            return DasTypeUtilsKt.getDebugName(this.typeClass);
        }
        String precisionStr = string;
        String scaleStr = DasTypeUtilsKt.renderScale(this.scale);
        StringBuilder $this$getDescription_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$getDescription_u24lambda_u240.append(DasTypeUtilsKt.getDebugName(this.typeClass));
        $this$getDescription_u24lambda_u240.append("(");
        $this$getDescription_u24lambda_u240.append(precisionStr);
        if (scaleStr != null) {
            $this$getDescription_u24lambda_u240.append(", ").append(scaleStr);
        }
        $this$getDescription_u24lambda_u240.append(")");
        return stringBuilder.toString();
    }

    @NotNull
    public DataType toDataType() {
        DataType dataType = DataTypeFactory.of(null, this.typeClass.getName(), this.precision, this.scale, null, null, false, false);
        Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
        return dataType;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Object object2 = other;
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.database.types.DasBuiltinTypeWithPrecisionImpl");
        DasBuiltinTypeWithPrecisionImpl cfr_ignored_0 = (DasBuiltinTypeWithPrecisionImpl)object2;
        if (!Intrinsics.areEqual((Object)this.typeClass, (Object)((DasBuiltinTypeWithPrecisionImpl)other).typeClass)) {
            return false;
        }
        if (this.precision != ((DasBuiltinTypeWithPrecisionImpl)other).precision) {
            return false;
        }
        return this.scale == ((DasBuiltinTypeWithPrecisionImpl)other).scale;
    }

    public int hashCode() {
        int result = this.typeClass.hashCode();
        result = 31 * result + this.precision;
        result = 31 * result + this.scale;
        return result;
    }

    public /* synthetic */ DasBuiltinTypeWithPrecisionImpl(DasSimpleBuiltinTypeClass typeClass, int precision, int scale, DefaultConstructorMarker $constructor_marker) {
        this(typeClass, precision, scale);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t\u00a8\u0006\u000b"}, d2={"Lcom/intellij/database/types/DasBuiltinTypeWithPrecisionImpl$Companion;", "", "<init>", "()V", "of", "Lcom/intellij/database/types/DasBuiltinTypeWithPrecisionImpl;", "typeClass", "Lcom/intellij/database/types/DasSimpleBuiltinTypeClass;", "precision", "", "scale", "intellij.database.core.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DasBuiltinTypeWithPrecisionImpl of(@NotNull DasSimpleBuiltinTypeClass typeClass, int precision, int scale) {
            Intrinsics.checkNotNullParameter((Object)typeClass, (String)"typeClass");
            return (DasBuiltinTypeWithPrecisionImpl)DasTypeInternerKt.intern((DasType)new DasBuiltinTypeWithPrecisionImpl(typeClass, precision, scale, null));
        }

        public static /* synthetic */ DasBuiltinTypeWithPrecisionImpl of$default(Companion companion, DasSimpleBuiltinTypeClass dasSimpleBuiltinTypeClass, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n = -1;
            }
            if ((n3 & 4) != 0) {
                n2 = 0;
            }
            return companion.of(dasSimpleBuiltinTypeClass, n, n2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

