/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.model.BaseModel;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.psi.ModelNameIndex;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.TreePattern;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public final class ModelNameIndexImpl
implements ModelNameIndex {
    public static final ModelNameIndex EMPTY_INDEX = new ModelNameIndexImpl(DasUtil.emptyModel());
    private final DasModel model;
    private final AtomicReference<NameIndex> myNameIndex = new AtomicReference();

    public ModelNameIndexImpl(DasModel model) {
        this.model = model;
    }

    public void clear() {
        this.myNameIndex.set(null);
    }

    @NotNull
    public Collection<String> getAllNames() {
        Set<String> set = this.getNameIndex().objects.keySet();
        if (set == null) {
            ModelNameIndexImpl.$$$reportNull$$$0(0);
        }
        return set;
    }

    @NotNull
    public Collection<DasObject> getObjectsByName(@NotNull String name) {
        if (name == null) {
            ModelNameIndexImpl.$$$reportNull$$$0(1);
        }
        Collection<DasObject> collection = this.getNameIndex().getObjects(name);
        if (collection == null) {
            ModelNameIndexImpl.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @NotNull
    public JBIterable<DasObject> getObjectsByNameInsensitive(@NotNull String name) {
        if (name == null) {
            ModelNameIndexImpl.$$$reportNull$$$0(3);
        }
        NameIndex index = this.getNameIndex();
        Set<String> names = index.insensitive.get(name);
        JBIterable jBIterable = names == null ? JBIterable.empty() : JBIterable.from(names).flatten(index::getObjects);
        if (jBIterable == null) {
            ModelNameIndexImpl.$$$reportNull$$$0(4);
        }
        return jBIterable;
    }

    @NotNull
    private NameIndex getNameIndex() {
        NameIndex res;
        BasicRoot root;
        BasicRoot basicRoot = root = this.model instanceof BaseModel ? ((BaseModel)this.model).getRoot() : null;
        do {
            NameIndex result;
            if ((result = this.myNameIndex.get()) != null) {
                NameIndex nameIndex = result;
                if (nameIndex == null) {
                    ModelNameIndexImpl.$$$reportNull$$$0(5);
                }
                return nameIndex;
            }
            res = new NameIndex();
            if (root != null) {
                res.put(root.getName(), root);
            }
            int i2 = 0;
            TreePattern scope = DbImplUtilCore.getIntrospectionScope((DasDataSource)ObjectUtils.tryCast((Object)root, DasDataSource.class));
            JBTreeTraverser traverser = (JBTreeTraverser)((JBTreeTraverser)this.model.traverser().expand(o -> o.getKind() != ObjectKind.ROUTINE && DbImplUtilCore.isExpandable(o, scope))).filter(o -> o.getKind() != ObjectKind.ROOT);
            for (DasObject o2 : traverser.bfsTraversal()) {
                if (++i2 % 1000 == 0) {
                    ProgressManager.checkCanceled();
                    result = this.myNameIndex.get();
                    if (result != null) {
                        NameIndex nameIndex = result;
                        if (nameIndex == null) {
                            ModelNameIndexImpl.$$$reportNull$$$0(6);
                        }
                        return nameIndex;
                    }
                }
                String name = o2.getName();
                res.put(name, o2);
            }
            res.compact();
        } while (!this.myNameIndex.compareAndSet(null, res));
        NameIndex nameIndex = res;
        if (nameIndex == null) {
            ModelNameIndexImpl.$$$reportNull$$$0(7);
        }
        return nameIndex;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/psi/ModelNameIndexImpl";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllNames";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/psi/ModelNameIndexImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectsByName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectsByNameInsensitive";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameIndex";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getObjectsByName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getObjectsByNameInsensitive";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3 -> new IllegalArgumentException(string);
        };
    }

    private static final class NameIndex {
        final Map<String, List<DasObject>> objects = CollectionFactory.createSmallMemoryFootprintMap();
        private final Map<String, Set<String>> insensitive = CollectionFactory.createCaseInsensitiveStringMap();

        private NameIndex() {
        }

        void put(@NotNull String name, @NotNull DasObject object) {
            SmartList objectsBucket;
            if (name == null) {
                NameIndex.$$$reportNull$$$0(0);
            }
            if (object == null) {
                NameIndex.$$$reportNull$$$0(1);
            }
            if ((objectsBucket = this.objects.get(name)) == null) {
                objectsBucket = new SmartList();
                this.objects.put(name, (List<DasObject>)objectsBucket);
            }
            objectsBucket.add((DasObject)object);
            ObjectOpenHashSet namesBucket = this.insensitive.get(name);
            if (namesBucket == null) {
                namesBucket = new ObjectOpenHashSet();
                this.insensitive.put(name, (Set<String>)namesBucket);
            }
            namesBucket.add((String)name);
        }

        void compact() {
            CollectionFactory.trimMap(this.objects);
            for (Set<String> value : this.insensitive.values()) {
                CollectionFactory.trimSet(value);
            }
            CollectionFactory.trimMap(this.insensitive);
        }

        @NotNull
        Collection<DasObject> getObjects(@NotNull String name) {
            if (name == null) {
                NameIndex.$$$reportNull$$$0(2);
            }
            Collection collection = (Collection)ObjectUtils.chooseNotNull(this.objects.get(name), Collections.emptyList());
            if (collection == null) {
                NameIndex.$$$reportNull$$$0(3);
            }
            return collection;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "object";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/psi/ModelNameIndexImpl$NameIndex";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/psi/ModelNameIndexImpl$NameIndex";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getObjects";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "put";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getObjects";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

