/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.backend.enumd;

import com.intellij.jpa.jpb.model.backend.enumd.EnumParser;
import com.intellij.jpa.jpb.model.model.EnumType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class JavaEnumParser
implements EnumParser {
    public static EnumParser getInstance(Project project) {
        return (EnumParser)project.getComponent(JavaEnumParser.class);
    }

    @Override
    public List<Pair<PsiField, PsiLiteralExpression>> getValueFields(PsiClass enumClass) {
        ArrayList<Pair<PsiField, PsiLiteralExpression>> fields = new ArrayList<Pair<PsiField, PsiLiteralExpression>>();
        for (PsiField field : enumClass.getFields()) {
            PsiExpression[] expressions;
            PsiExpressionList argumentList;
            if (!(field instanceof PsiEnumConstant) || (argumentList = ((PsiEnumConstant)field).getArgumentList()) == null || (expressions = argumentList.getExpressions()).length != 1 || !(expressions[0] instanceof PsiLiteralExpression)) continue;
            fields.add((Pair<PsiField, PsiLiteralExpression>)new Pair((Object)field, (Object)((PsiLiteralExpression)expressions[0])));
        }
        return fields;
    }

    @Override
    public List<EnumType.Value> getValues(PsiClass enumClass) {
        ArrayList<EnumType.Value> result = new ArrayList<EnumType.Value>();
        for (Pair<PsiField, PsiLiteralExpression> field : this.getValueFields(enumClass)) {
            EnumType.Value value = new EnumType.Value();
            value.setName(((PsiField)field.first).getName());
            value.setValue(String.valueOf(((PsiLiteralExpression)field.second).getValue()));
            result.add(value);
        }
        return Collections.unmodifiableList(result);
    }
}

