/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.backend.ed.annotation.attr;

import com.google.common.base.Strings;
import com.intellij.jpa.jpb.model.backend.ed.annotation.AnnotationHelper;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.AbstractDynamicConstraintAnnotation;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.ConstraintAnnotation;
import com.intellij.jpa.jpb.model.core.backend.ed.annotation.AnnotationModel;
import com.intellij.jpa.jpb.model.core.backend.ed.annotation.AnnotationModelBuilder;
import com.intellij.jpa.jpb.model.core.backend.ed.annotation.StringParameter;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.jpa.jpb.model.model.constraint.Constraint;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractConstraintAnnotation
extends AbstractDynamicConstraintAnnotation {
    public static final String MESSAGE = "message";

    public AbstractConstraintAnnotation(@NotNull ConstraintAnnotation descriptor) {
        if (descriptor == null) {
            AbstractConstraintAnnotation.$$$reportNull$$$0(0);
        }
        super(descriptor);
    }

    @Override
    public boolean isInsert(@NotNull EntityAttribute attribute, @NotNull Entity entity) {
        if (attribute == null) {
            AbstractConstraintAnnotation.$$$reportNull$$$0(1);
        }
        if (entity == null) {
            AbstractConstraintAnnotation.$$$reportNull$$$0(2);
        }
        return this.getConstraint(attribute) != null;
    }

    @Override
    public LinkedHashMap<String, String> getParams(@NotNull EntityAttribute attribute, Module module) {
        if (attribute == null) {
            AbstractConstraintAnnotation.$$$reportNull$$$0(3);
        }
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        String message = this.annotationMessage(attribute);
        if (!Strings.isNullOrEmpty((String)message)) {
            params.put(MESSAGE, AnnotationHelper.wrap(message));
        }
        return params;
    }

    public AnnotationModelBuilder getBuilderWithMessage(EntityAttribute attribute, Project project, Module module) {
        AnnotationModelBuilder builder = AnnotationModel.builder(this.getFqn(project, module));
        String annotationMessage = this.annotationMessage(attribute);
        if (!Strings.isNullOrEmpty((String)annotationMessage)) {
            builder.add(MESSAGE, new StringParameter(annotationMessage));
        }
        return builder;
    }

    protected String annotationMessage(EntityAttribute attribute) {
        Constraint c = this.getConstraint(attribute);
        if (c != null) {
            return c.getMessage();
        }
        return null;
    }

    @Nullable
    protected Constraint getConstraint(EntityAttribute attribute) {
        return attribute.getConstraints().stream().filter(c -> this.getName().equals(c.getName())).filter(Constraint::isEnabled).findFirst().orElse(null);
    }

    @Override
    public List<String> knownAttributes(EntityAttribute attribute) {
        ArrayList<String> knownAttributes = new ArrayList<String>();
        knownAttributes.add(MESSAGE);
        return knownAttributes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entity";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jpa/jpb/model/backend/ed/annotation/attr/AbstractConstraintAnnotation";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isInsert";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getParams";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

