/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi.directives;

import com.intellij.freemarker.psi.FtlElementTypes;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.directives.FtlAssignmentType;
import com.intellij.freemarker.psi.directives.FtlFileReferenceDirective;
import com.intellij.freemarker.psi.files.FtlFile;
import com.intellij.freemarker.psi.variables.FtlTemplateType;
import com.intellij.freemarker.psi.variables.FtlVariable;
import com.intellij.freemarker.psi.variables.GlobalVariablesProcessor;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FtlImportDirective
extends FtlFileReferenceDirective
implements FtlVariable,
PsiNamedElement {
    public FtlImportDirective(ASTNode node) {
        super(node);
    }

    @Nullable
    public PsiElement getNameElement() {
        return this.findChildByType((IElementType)FtlElementTypes.IDENTIFIER);
    }

    @NotNull
    public SearchScope getUseScope() {
        return new LocalSearchScope((PsiElement)this.getContainingFile());
    }

    public int getTextOffset() {
        PsiElement nameElement = this.getNameElement();
        return nameElement != null ? nameElement.getTextRange().getStartOffset() : super.getTextOffset();
    }

    public String getName() {
        PsiElement nameElement = this.getNameElement();
        return nameElement != null ? nameElement.getText() : null;
    }

    @Override
    public FtlType getType() {
        PsiFile file = this.resolveFile();
        return file instanceof FtlFile ? new FtlTemplateType((FtlFile)file) : null;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            FtlImportDirective.$$$reportNull$$$0(0);
        }
        PsiElement element = FtlPsiUtil.parseFtlExpression(name, this.getProject());
        this.getNode().replaceChild(this.getNameElement().getNode(), element.getNode().getFirstChildNode());
        return this;
    }

    @Override
    public boolean processDeclarationsInFile(PsiScopeProcessor processor, ResolveState state) {
        ResolveState newState = state.get(FtlAssignmentType.TYPE_KEY) == null ? FtlAssignmentType.allowAssignments(state, FtlAssignmentType.GLOBAL) : state;
        return super.processDeclarationsInFile(new GlobalVariablesProcessor(processor), newState);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/freemarker/psi/directives/FtlImportDirective", "setName"));
    }
}

