/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.jupyter.ws;

import java.io.Closeable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MagicApiIntrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KType;
import kotlin.text.Charsets;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.modules.SerializersModule;
import org.java_websocket.WebSocket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.jupyter.protocol.CallbackHandler;
import org.jetbrains.kotlinx.jupyter.protocol.JupyterCallbackBasedSocket;
import org.jetbrains.kotlinx.jupyter.protocol.RawMessageCallback;
import org.jetbrains.kotlinx.jupyter.protocol.RawMessageImplKt;
import org.jetbrains.kotlinx.jupyter.protocol.api.JupyterSocketType;
import org.jetbrains.kotlinx.jupyter.protocol.api.JupyterSocketTypeKt;
import org.jetbrains.kotlinx.jupyter.protocol.api.KernelLoggerFactory;
import org.jetbrains.kotlinx.jupyter.protocol.api.KernelLoggerFactoryKt;
import org.jetbrains.kotlinx.jupyter.protocol.api.RawMessage;
import org.slf4j.Logger;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u00002\u00020\u00012\u00020\u0002B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H&J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J \u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0002J\u0010\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u0016H\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlinx/jupyter/ws/WsCallbackBasedSocket;", "Lorg/jetbrains/kotlinx/jupyter/protocol/JupyterCallbackBasedSocket;", "Ljava/io/Closeable;", "loggerFactory", "Lorg/jetbrains/kotlinx/jupyter/protocol/api/KernelLoggerFactory;", "getWebSockets", "Lkotlin/Function0;", "", "Lorg/java_websocket/WebSocket;", "channel", "Lorg/jetbrains/kotlinx/jupyter/protocol/api/JupyterSocketType;", "<init>", "(Lorg/jetbrains/kotlinx/jupyter/protocol/api/KernelLoggerFactory;Lkotlin/jvm/functions/Function0;Lorg/jetbrains/kotlinx/jupyter/protocol/api/JupyterSocketType;)V", "getChannel", "()Lorg/jetbrains/kotlinx/jupyter/protocol/api/JupyterSocketType;", "logger", "Lorg/slf4j/Logger;", "callbacks", "Lorg/jetbrains/kotlinx/jupyter/protocol/CallbackHandler;", "getCallbacks", "()Lorg/jetbrains/kotlinx/jupyter/protocol/CallbackHandler;", "messageReceived", "", "msg", "Lorg/jetbrains/kotlinx/jupyter/protocol/api/RawMessage;", "sendRawMessage", "messageWithBuffersToBytes", "Ljava/nio/ByteBuffer;", "msgDataJsonString", "", "buffers", "", "", "onRawMessage", "callback", "Lorg/jetbrains/kotlinx/jupyter/protocol/RawMessageCallback;", "close", "ws-server"})
@SourceDebugExtension(value={"SMAP\nWsCallbackBasedSocket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WsCallbackBasedSocket.kt\norg/jetbrains/kotlinx/jupyter/ws/WsCallbackBasedSocket\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n205#2:98\n1#3:99\n*S KotlinDebug\n*F\n+ 1 WsCallbackBasedSocket.kt\norg/jetbrains/kotlinx/jupyter/ws/WsCallbackBasedSocket\n*L\n39#1:98\n*E\n"})
public abstract class WsCallbackBasedSocket
implements JupyterCallbackBasedSocket,
Closeable {
    @NotNull
    private final Function0<Iterable<WebSocket>> getWebSockets;
    @NotNull
    private final JupyterSocketType channel;
    @NotNull
    private final Logger logger;
    @NotNull
    private final CallbackHandler callbacks;

    public WsCallbackBasedSocket(@NotNull KernelLoggerFactory loggerFactory, @NotNull Function0<? extends Iterable<? extends WebSocket>> getWebSockets, @NotNull JupyterSocketType channel) {
        Intrinsics.checkNotNullParameter((Object)loggerFactory, (String)"loggerFactory");
        Intrinsics.checkNotNullParameter(getWebSockets, (String)"getWebSockets");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        this.getWebSockets = getWebSockets;
        this.channel = channel;
        this.logger = KernelLoggerFactoryKt.getLogger((KernelLoggerFactory)loggerFactory, (KClass)Reflection.getOrCreateKotlinClass(this.getClass()));
        this.callbacks = new CallbackHandler(this.logger);
    }

    @NotNull
    protected final JupyterSocketType getChannel() {
        return this.channel;
    }

    @NotNull
    protected final CallbackHandler getCallbacks() {
        return this.callbacks;
    }

    public abstract void messageReceived(@NotNull RawMessage var1);

    /*
     * WARNING - void declaration
     */
    public void sendRawMessage(@NotNull RawMessage msg) {
        void value$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        Json json = (Json)Json.Default;
        JsonObject jsonObject = new JsonObject(MapsKt.plus((Map)((Map)RawMessageImplKt.getData((RawMessage)msg)), (Pair)TuplesKt.to((Object)"channel", (Object)JsonElementKt.JsonPrimitive((String)JupyterSocketTypeKt.getJupyterName((JupyterSocketType)this.channel)))));
        boolean $i$f$encodeToString = false;
        SerializersModule serializersModule = this_$iv.getSerializersModule();
        KType kType = Reflection.typeOf(JsonObject.class);
        MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
        String msgDataJsonString = this_$iv.encodeToString((SerializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, (KType)kType), (Object)value$iv);
        for (WebSocket webSocket : (Iterable)this.getWebSockets.invoke()) {
            if (msg.getId().isEmpty()) {
                webSocket.send(msgDataJsonString);
                continue;
            }
            webSocket.send(this.messageWithBuffersToBytes(msgDataJsonString, msg.getId()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ByteBuffer messageWithBuffersToBytes(String msgDataJsonString, List<byte[]> buffers) {
        int n;
        Object object;
        int msgDataStartIndex = 4 * (2 + buffers.size());
        byte[] byArray = msgDataJsonString.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] msgDataJsonBytes = byArray;
        Iterable iterable = buffers;
        int n2 = msgDataStartIndex + msgDataJsonBytes.length;
        int n3 = 0;
        Iterator iterator = iterable.iterator();
        while (iterator.hasNext()) {
            void it;
            Object t = iterator.next();
            object = (byte[])t;
            n = n3;
            boolean bl = false;
            int n4 = ((void)it).length;
            n3 = n + n4;
        }
        n = n3;
        ByteBuffer resultBuffer = ByteBuffer.allocate(n2 + n);
        resultBuffer.order(ByteOrder.BIG_ENDIAN);
        resultBuffer.putInt(buffers.size() + 1);
        WsCallbackBasedSocket $this$messageWithBuffersToBytes_u24lambda_u241 = this;
        boolean bl = false;
        int offset = msgDataStartIndex;
        resultBuffer.putInt(offset);
        offset += msgDataJsonBytes.length;
        object = buffers.iterator();
        while (object.hasNext()) {
            byte[] buffer = (byte[])object.next();
            resultBuffer.putInt(offset);
            offset += buffer.length;
        }
        resultBuffer.put(msgDataJsonBytes);
        for (byte[] buffer : buffers) {
            resultBuffer.put(buffer);
        }
        resultBuffer.rewind();
        return resultBuffer;
    }

    public void onRawMessage(@NotNull RawMessageCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.callbacks.addCallback(callback);
    }

    @Override
    public void close() {
        this.callbacks.close();
    }
}

