/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run.editor.additionalParams.columns;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.boot.run.SpringBootAdditionalParameter;
import com.intellij.spring.boot.run.SpringBootRunSharedBundle;
import com.intellij.spring.boot.run.editor.additionalParams.SimpleSpringBootAdditionalParamsTableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class SimplePropertyNameColumn
extends ColumnInfo<SpringBootAdditionalParameter, String> {
    protected final Project myProject;
    private final TableCellRenderer myRenderer = new DefaultTableCellRenderer(){

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel component = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value == null || "".equals(value)) {
                component.setBorder(BorderFactory.createLineBorder(JBUI.CurrentTheme.Focus.errorColor((boolean)false), 3));
            }
            return component;
        }
    };

    public SimplePropertyNameColumn(Project project) {
        super(SpringBootRunSharedBundle.message("additional.params.table.name", new Object[0]));
        this.myProject = project;
    }

    public TableCellEditor getEditor(SpringBootAdditionalParameter parameter) {
        return SimpleSpringBootAdditionalParamsTableView.createDefaultParameterEditor(this.myProject, parameter.getName());
    }

    public String valueOf(SpringBootAdditionalParameter parameter) {
        return parameter.getName();
    }

    public void setValue(SpringBootAdditionalParameter parameter, String value) {
        parameter.setName(StringUtil.trim((String)value));
    }

    public boolean isCellEditable(SpringBootAdditionalParameter parameter) {
        return parameter.getEnabled();
    }

    public TableCellRenderer getRenderer(SpringBootAdditionalParameter parameter) {
        return this.myRenderer;
    }

    public String getPreferredStringValue() {
        return "012345678901234";
    }
}

