/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.protobuf.lang.completion;

import com.intellij.codeInsight.completion.AddSpaceInsertHandler;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.protobuf.lang.psi.PbElement;
import com.intellij.protobuf.lang.psi.PbExtendDefinition;
import com.intellij.protobuf.lang.psi.PbField;
import com.intellij.protobuf.lang.psi.PbFieldLabel;
import com.intellij.protobuf.lang.psi.PbFile;
import com.intellij.protobuf.lang.psi.PbIdentifierValue;
import com.intellij.protobuf.lang.psi.PbImportName;
import com.intellij.protobuf.lang.psi.PbMessageType;
import com.intellij.protobuf.lang.psi.PbOptionExpression;
import com.intellij.protobuf.lang.psi.PbServiceMethodType;
import com.intellij.protobuf.lang.psi.PbSimpleField;
import com.intellij.protobuf.lang.psi.PbStatementOwner;
import com.intellij.protobuf.lang.psi.PbStringPart;
import com.intellij.protobuf.lang.psi.PbTypeName;
import com.intellij.protobuf.lang.psi.ProtoSymbolPath;
import com.intellij.protobuf.lang.psi.SyntaxLevel;
import com.intellij.protobuf.lang.psi.SyntaxLevelKt;
import com.intellij.protobuf.lang.psi.util.PbPsiUtil;
import com.intellij.protobuf.lang.util.BuiltInType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class PbCompletionContributor
extends CompletionContributor {
    public PbCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiElement(ProtoSymbolPath.class).withParent((ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement(PbTypeName.class).andNot((ElementPattern)PlatformPatterns.psiElement().withParent(PbExtendDefinition.class))).andNot((ElementPattern)PlatformPatterns.psiElement().withParent(PbServiceMethodType.class))))).andNot((ElementPattern)PlatformPatterns.psiElement().afterLeaf(new String[]{"."})), new BuiltinTypesProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent(PsiErrorElement.class)).withSuperParent(2, PbFile.class), new TopLevelStartKeywords());
        this.extend(CompletionType.BASIC, (ElementPattern)((PsiElementPattern.Capture)PlatformPatterns.psiElement().inside((ElementPattern)PlatformPatterns.psiElement(PbSimpleField.class))).andNot((ElementPattern)PlatformPatterns.psiElement().afterLeaf(new String[]{"."})), new NonTopLevelKeywords());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiElement(PbIdentifierValue.class).withParent(PbOptionExpression.class)), new BooleanKeywords());
    }

    public boolean invokeAutoPopup(@NotNull PsiElement position, char typeChar) {
        if (position == null) {
            PbCompletionContributor.$$$reportNull$$$0(0);
        }
        return typeChar == '/' && position.getParent() instanceof PbStringPart && PsiTreeUtil.getParentOfType((PsiElement)position, PbImportName.class) != null;
    }

    private static LookupElement lookupElementWithSpace(String keyword) {
        return LookupElementBuilder.create((String)keyword).withInsertHandler(AddSpaceInsertHandler.INSTANCE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/protobuf/lang/completion/PbCompletionContributor", "invokeAutoPopup"));
    }

    private static class BuiltinTypesProvider
    extends CompletionProvider<CompletionParameters> {
        private BuiltinTypesProvider() {
        }

        private static List<LookupElement> createBuiltinTypeBuildersWithSpace() {
            return BuiltInType.getTypes().stream().map(BuiltInType::getName).map(PbCompletionContributor::lookupElementWithSpace).collect(Collectors.toList());
        }

        private static List<LookupElement> createBuiltinTypeBuilders() {
            return BuiltInType.getTypes().stream().map(BuiltInType::getName).map(LookupElementBuilder::create).collect(Collectors.toList());
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext processingContext, @NotNull CompletionResultSet result) {
            PsiElement element;
            PbField fieldParent;
            if (parameters == null) {
                BuiltinTypesProvider.$$$reportNull$$$0(0);
            }
            if (processingContext == null) {
                BuiltinTypesProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                BuiltinTypesProvider.$$$reportNull$$$0(2);
            }
            if ((fieldParent = (PbField)PsiTreeUtil.getParentOfType((PsiElement)(element = parameters.getPosition()), PbField.class)) instanceof PbSimpleField) {
                result.addAllElements(BuiltinTypesProvider.createBuiltinTypeBuildersWithSpace());
                return;
            }
            result.addAllElements(BuiltinTypesProvider.createBuiltinTypeBuilders());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "processingContext";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/intellij/protobuf/lang/completion/PbCompletionContributor$BuiltinTypesProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class TopLevelStartKeywords
    extends CompletionProvider<CompletionParameters> {
        private TopLevelStartKeywords() {
        }

        private static List<LookupElement> createTopLevelEntryStart() {
            return Stream.of("message", "enum", "service", "extend", "import", "package", "option").map(PbCompletionContributor::lookupElementWithSpace).collect(Collectors.toList());
        }

        protected void addCompletions(@NotNull CompletionParameters completionParameters, @NotNull ProcessingContext processingContext, @NotNull CompletionResultSet result) {
            if (completionParameters == null) {
                TopLevelStartKeywords.$$$reportNull$$$0(0);
            }
            if (processingContext == null) {
                TopLevelStartKeywords.$$$reportNull$$$0(1);
            }
            if (result == null) {
                TopLevelStartKeywords.$$$reportNull$$$0(2);
            }
            result.addAllElements(TopLevelStartKeywords.createTopLevelEntryStart());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "completionParameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "processingContext";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/intellij/protobuf/lang/completion/PbCompletionContributor$TopLevelStartKeywords";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class NonTopLevelKeywords
    extends CompletionProvider<CompletionParameters> {
        private NonTopLevelKeywords() {
        }

        private static List<LookupElement> createMessageEntryStart() {
            return Stream.of("message", "enum", "extensions", "reserved", "extend", "option", "oneof").map(PbCompletionContributor::lookupElementWithSpace).collect(Collectors.toList());
        }

        private static List<LookupElement> createMessageEntryStartNoSpace() {
            return Stream.of("map").map(LookupElementBuilder::create).collect(Collectors.toList());
        }

        private static List<LookupElement> createProto2FieldLabels() {
            return Stream.of("optional", "required", "repeated").map(PbCompletionContributor::lookupElementWithSpace).collect(Collectors.toList());
        }

        private static List<LookupElement> createProto3FieldLabels() {
            return Stream.of("optional", "repeated").map(PbCompletionContributor::lookupElementWithSpace).collect(Collectors.toList());
        }

        private static List<LookupElement> createEditionsFieldLabels() {
            return Stream.of("repeated").map(PbCompletionContributor::lookupElementWithSpace).collect(Collectors.toList());
        }

        private static LookupElement createGroupKeyWord() {
            return PbCompletionContributor.lookupElementWithSpace("group");
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext processingContext, @NotNull CompletionResultSet result) {
            List fieldElements;
            PsiElement element;
            PbSimpleField simpleField;
            if (parameters == null) {
                NonTopLevelKeywords.$$$reportNull$$$0(0);
            }
            if (processingContext == null) {
                NonTopLevelKeywords.$$$reportNull$$$0(1);
            }
            if (result == null) {
                NonTopLevelKeywords.$$$reportNull$$$0(2);
            }
            if ((simpleField = (PbSimpleField)PsiTreeUtil.getParentOfType((PsiElement)(element = parameters.getPosition()), PbSimpleField.class)) == null) {
                return;
            }
            SyntaxLevel syntaxLevel = simpleField.getPbFile().getSyntaxLevel();
            if (PbPsiUtil.isFirstInside(element, simpleField)) {
                PbStatementOwner statementOwner = (PbStatementOwner)PsiTreeUtil.getParentOfType((PsiElement)element, PbStatementOwner.class);
                if (statementOwner instanceof PbMessageType) {
                    result.addAllElements(NonTopLevelKeywords.createMessageEntryStart());
                    result.addAllElements(NonTopLevelKeywords.createMessageEntryStartNoSpace());
                }
                if (SyntaxLevelKt.isDeprecatedProto2Syntax(syntaxLevel)) {
                    result.addAllElements(NonTopLevelKeywords.createProto2FieldLabels());
                } else if (SyntaxLevelKt.isDeprecatedProto3Syntax(syntaxLevel)) {
                    result.addAllElements(NonTopLevelKeywords.createProto3FieldLabels());
                } else if (syntaxLevel instanceof SyntaxLevel.Edition) {
                    result.addAllElements(NonTopLevelKeywords.createEditionsFieldLabels());
                }
            } else if (SyntaxLevelKt.isDeprecatedProto2Syntax(syntaxLevel) && (fieldElements = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)simpleField, PbElement.class)).size() == 2 && fieldElements.get(0) instanceof PbFieldLabel) {
                result.addElement(NonTopLevelKeywords.createGroupKeyWord());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "processingContext";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/intellij/protobuf/lang/completion/PbCompletionContributor$NonTopLevelKeywords";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class BooleanKeywords
    extends CompletionProvider<CompletionParameters> {
        private BooleanKeywords() {
        }

        private static List<LookupElement> createBooleanValues() {
            return Stream.of("true", "false").map(LookupElementBuilder::create).collect(Collectors.toList());
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext processingContext, @NotNull CompletionResultSet result) {
            PsiElement element;
            PbOptionExpression option;
            if (parameters == null) {
                BooleanKeywords.$$$reportNull$$$0(0);
            }
            if (processingContext == null) {
                BooleanKeywords.$$$reportNull$$$0(1);
            }
            if (result == null) {
                BooleanKeywords.$$$reportNull$$$0(2);
            }
            if ((option = (PbOptionExpression)PsiTreeUtil.getParentOfType((PsiElement)(element = parameters.getPosition()), PbOptionExpression.class)) == null) {
                return;
            }
            BuiltInType builtInType = option.getOptionName().getBuiltInType();
            if (builtInType != null && "bool".equals(builtInType.getName())) {
                result.addAllElements(BooleanKeywords.createBooleanValues());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "processingContext";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/intellij/protobuf/lang/completion/PbCompletionContributor$BooleanKeywords";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

