/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ktor.initializr.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.ktor.initializr.json.KtorBuildSystem;
import com.intellij.ktor.initializr.json.KtorConfiguration;
import com.intellij.ktor.initializr.json.KtorEngine;
import com.intellij.ktor.initializr.json.KtorKotlinVersion;
import com.intellij.ktor.initializr.json.KtorSettingOption;
import com.intellij.ktor.initializr.json.KtorVersion;
import com.intellij.ktor.initializr.json.OptionalSetting;
import com.intellij.ktor.initializr.json.ProjectSettingsTemplate;
import com.intellij.ktor.initializr.json.TextSetting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000R\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a4\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\n0\t\"\b\b\u0000\u0010\n*\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u0002H\n0\rH\u0002\u001a\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\n\u0010\u0010\u001a\u00020\u0011*\u00020\u000e\u001a\n\u0010\u0012\u001a\u00020\u0013*\u00020\u000e\u001a\n\u0010\u0014\u001a\u00020\u0015*\u00020\u000e\u001a\n\u0010\u0016\u001a\u00020\u0017*\u00020\u000e\u001a\n\u0010\u0018\u001a\u00020\u0019*\u00020\u000e\u001a\u001f\u0010\u001a\u001a\u0002H\n\"\b\b\u0000\u0010\n*\u00020\u000b*\b\u0012\u0004\u0012\u0002H\n0\t\u00a2\u0006\u0002\u0010\u001b\u00a8\u0006\u001c"}, d2={"parseProjectSettingsTemplate", "Lcom/intellij/ktor/initializr/json/ProjectSettingsTemplate;", "jsonRootElement", "Lcom/google/gson/JsonElement;", "parseTextSetting", "Lcom/intellij/ktor/initializr/json/TextSetting;", "jsonObject", "Lcom/google/gson/JsonObject;", "parseOptionalSetting", "Lcom/intellij/ktor/initializr/json/OptionalSetting;", "T", "Lcom/intellij/ktor/initializr/json/KtorSettingOption;", "parseType", "Lkotlin/Function1;", "Lcom/intellij/ktor/initializr/json/OptionalSetting$Option;", "parseOption", "toKtorVersion", "Lcom/intellij/ktor/initializr/json/KtorVersion;", "toKotlinVersion", "Lcom/intellij/ktor/initializr/json/KtorKotlinVersion;", "toKtorEngine", "Lcom/intellij/ktor/initializr/json/KtorEngine;", "toKtorBuildSystem", "Lcom/intellij/ktor/initializr/json/KtorBuildSystem;", "toKtorConfiguration", "Lcom/intellij/ktor/initializr/json/KtorConfiguration;", "defaultOption", "(Lcom/intellij/ktor/initializr/json/OptionalSetting;)Lcom/intellij/ktor/initializr/json/KtorSettingOption;", "intellij.ktor"})
@SourceDebugExtension(value={"SMAP\nProjectSettingsTemplate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectSettingsTemplate.kt\ncom/intellij/ktor/initializr/json/ProjectSettingsTemplateKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,113:1\n1563#2:114\n1634#2,3:115\n1563#2:118\n1634#2,3:119\n1#3:122\n*S KotlinDebug\n*F\n+ 1 ProjectSettingsTemplate.kt\ncom/intellij/ktor/initializr/json/ProjectSettingsTemplateKt\n*L\n61#1:114\n61#1:115,3\n67#1:118\n67#1:119,3\n*E\n"})
public final class ProjectSettingsTemplateKt {
    @NotNull
    public static final ProjectSettingsTemplate parseProjectSettingsTemplate(@NotNull JsonElement jsonRootElement) {
        Intrinsics.checkNotNullParameter((Object)jsonRootElement, (String)"jsonRootElement");
        JsonObject projectName = jsonRootElement.getAsJsonObject().get("project_name").getAsJsonObject();
        JsonObject companyWebsite = jsonRootElement.getAsJsonObject().get("company_website").getAsJsonObject();
        JsonObject engine = jsonRootElement.getAsJsonObject().get("engine").getAsJsonObject();
        JsonObject ktorVersion = jsonRootElement.getAsJsonObject().get("ktor_version").getAsJsonObject();
        JsonObject kotlinVersion = jsonRootElement.getAsJsonObject().get("kotlin_version").getAsJsonObject();
        JsonObject buildSystem = jsonRootElement.getAsJsonObject().get("build_system").getAsJsonObject();
        JsonObject configuration = jsonRootElement.getAsJsonObject().get("configuration_in").getAsJsonObject();
        Intrinsics.checkNotNull((Object)projectName);
        TextSetting textSetting = ProjectSettingsTemplateKt.parseTextSetting(projectName);
        Intrinsics.checkNotNull((Object)companyWebsite);
        TextSetting textSetting2 = ProjectSettingsTemplateKt.parseTextSetting(companyWebsite);
        Intrinsics.checkNotNull((Object)engine);
        OptionalSetting<KtorEngine> optionalSetting = ProjectSettingsTemplateKt.parseOptionalSetting(engine, ProjectSettingsTemplateKt::parseProjectSettingsTemplate$lambda$0);
        Intrinsics.checkNotNull((Object)ktorVersion);
        OptionalSetting<KtorVersion> optionalSetting2 = ProjectSettingsTemplateKt.parseOptionalSetting(ktorVersion, ProjectSettingsTemplateKt::parseProjectSettingsTemplate$lambda$1);
        Intrinsics.checkNotNull((Object)kotlinVersion);
        OptionalSetting<KtorKotlinVersion> optionalSetting3 = ProjectSettingsTemplateKt.parseOptionalSetting(kotlinVersion, ProjectSettingsTemplateKt::parseProjectSettingsTemplate$lambda$2);
        Intrinsics.checkNotNull((Object)buildSystem);
        OptionalSetting<KtorBuildSystem> optionalSetting4 = ProjectSettingsTemplateKt.parseOptionalSetting(buildSystem, ProjectSettingsTemplateKt::parseProjectSettingsTemplate$lambda$3);
        Intrinsics.checkNotNull((Object)configuration);
        return new ProjectSettingsTemplate(textSetting, textSetting2, optionalSetting, optionalSetting2, optionalSetting3, optionalSetting4, ProjectSettingsTemplateKt.parseOptionalSetting(configuration, ProjectSettingsTemplateKt::parseProjectSettingsTemplate$lambda$4));
    }

    private static final TextSetting parseTextSetting(JsonObject jsonObject) {
        String string = jsonObject.get("default").getAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
        return new TextSetting(string);
    }

    /*
     * WARNING - void declaration
     */
    private static final <T extends KtorSettingOption> OptionalSetting<T> parseOptionalSetting(JsonObject jsonObject, Function1<? super OptionalSetting.Option, ? extends T> parseType) {
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        JsonArray optionsArray = jsonObject.get("options").getAsJsonArray();
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)optionsArray.size());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv2.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            JsonObject jsonObject2 = optionsArray.get((int)it).getAsJsonObject();
            Intrinsics.checkNotNullExpressionValue((Object)jsonObject2, (String)"getAsJsonObject(...)");
            collection.add(ProjectSettingsTemplateKt.parseOption(jsonObject2));
        }
        List options = (List)destination$iv$iv;
        String defaultId = jsonObject.get("default_id").getAsString();
        Iterable $this$map$iv2 = options;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            OptionalSetting.Option bl = (OptionalSetting.Option)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add((KtorSettingOption)parseType.invoke((Object)it));
        }
        List list = (List)destination$iv$iv2;
        Intrinsics.checkNotNull((Object)defaultId);
        String string = defaultId;
        List list2 = list;
        return new OptionalSetting(list2, string);
    }

    private static final OptionalSetting.Option parseOption(JsonObject jsonObject) {
        String string = jsonObject.get("id").getAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
        String string2 = jsonObject.get("name").getAsString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAsString(...)");
        JsonElement jsonElement = jsonObject.get("tooltip");
        return new OptionalSetting.Option(string, string2, jsonElement != null ? jsonElement.getAsString() : null);
    }

    @NotNull
    public static final KtorVersion toKtorVersion(@NotNull OptionalSetting.Option $this$toKtorVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$toKtorVersion, (String)"<this>");
        return new KtorVersion($this$toKtorVersion.getId(), $this$toKtorVersion.getName());
    }

    @NotNull
    public static final KtorKotlinVersion toKotlinVersion(@NotNull OptionalSetting.Option $this$toKotlinVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$toKotlinVersion, (String)"<this>");
        return new KtorKotlinVersion($this$toKotlinVersion.getId(), $this$toKotlinVersion.getName());
    }

    @NotNull
    public static final KtorEngine toKtorEngine(@NotNull OptionalSetting.Option $this$toKtorEngine) {
        Intrinsics.checkNotNullParameter((Object)$this$toKtorEngine, (String)"<this>");
        return new KtorEngine($this$toKtorEngine.getId(), $this$toKtorEngine.getName());
    }

    @NotNull
    public static final KtorBuildSystem toKtorBuildSystem(@NotNull OptionalSetting.Option $this$toKtorBuildSystem) {
        Intrinsics.checkNotNullParameter((Object)$this$toKtorBuildSystem, (String)"<this>");
        return new KtorBuildSystem($this$toKtorBuildSystem.getId(), $this$toKtorBuildSystem.getName());
    }

    @NotNull
    public static final KtorConfiguration toKtorConfiguration(@NotNull OptionalSetting.Option $this$toKtorConfiguration) {
        Intrinsics.checkNotNullParameter((Object)$this$toKtorConfiguration, (String)"<this>");
        return new KtorConfiguration($this$toKtorConfiguration.getId(), $this$toKtorConfiguration.getName());
    }

    @NotNull
    public static final <T extends KtorSettingOption> T defaultOption(@NotNull OptionalSetting<T> $this$defaultOption) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter($this$defaultOption, (String)"<this>");
            Iterable iterable = $this$defaultOption.getOptions();
            for (Object t : iterable) {
                KtorSettingOption it = (KtorSettingOption)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)$this$defaultOption.getDefaultId())) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Intrinsics.checkNotNull(v0);
        return (T)((KtorSettingOption)v0);
    }

    private static final KtorEngine parseProjectSettingsTemplate$lambda$0(OptionalSetting.Option it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ProjectSettingsTemplateKt.toKtorEngine(it);
    }

    private static final KtorVersion parseProjectSettingsTemplate$lambda$1(OptionalSetting.Option it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ProjectSettingsTemplateKt.toKtorVersion(it);
    }

    private static final KtorKotlinVersion parseProjectSettingsTemplate$lambda$2(OptionalSetting.Option it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ProjectSettingsTemplateKt.toKotlinVersion(it);
    }

    private static final KtorBuildSystem parseProjectSettingsTemplate$lambda$3(OptionalSetting.Option it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ProjectSettingsTemplateKt.toKtorBuildSystem(it);
    }

    private static final KtorConfiguration parseProjectSettingsTemplate$lambda$4(OptionalSetting.Option it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ProjectSettingsTemplateKt.toKtorConfiguration(it);
    }
}

