/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.clazz.builder;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import de.plushnikov.intellij.plugin.problem.ProblemSink;
import de.plushnikov.intellij.plugin.processor.clazz.AbstractClassProcessor;
import de.plushnikov.intellij.plugin.processor.handler.SuperBuilderHandler;
import de.plushnikov.intellij.plugin.util.PsiClassUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SuperBuilderClassProcessor
extends AbstractClassProcessor {
    public SuperBuilderClassProcessor() {
        super((Class<? extends PsiElement>)PsiClass.class, "lombok.experimental.SuperBuilder");
    }

    private static SuperBuilderHandler getBuilderHandler() {
        return new SuperBuilderHandler();
    }

    @Override
    protected boolean possibleToGenerateElementNamed(@NotNull String nameHint, @NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation) {
        SuperBuilderHandler builderHandler;
        String builderClassName;
        if (nameHint == null) {
            SuperBuilderClassProcessor.$$$reportNull$$$0(0);
        }
        if (psiClass == null) {
            SuperBuilderClassProcessor.$$$reportNull$$$0(1);
        }
        if (psiAnnotation == null) {
            SuperBuilderClassProcessor.$$$reportNull$$$0(2);
        }
        return nameHint.equals(builderClassName = (builderHandler = SuperBuilderClassProcessor.getBuilderHandler()).getBuilderClassName(psiClass)) || !psiClass.hasModifierProperty("abstract") && nameHint.equals(builderHandler.getBuilderImplClassName(psiClass));
    }

    @Override
    protected Collection<String> getNamesOfPossibleGeneratedElements(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation) {
        if (psiClass == null) {
            SuperBuilderClassProcessor.$$$reportNull$$$0(3);
        }
        if (psiAnnotation == null) {
            SuperBuilderClassProcessor.$$$reportNull$$$0(4);
        }
        SuperBuilderHandler builderHandler = SuperBuilderClassProcessor.getBuilderHandler();
        String builderClassName = builderHandler.getBuilderClassName(psiClass);
        if (!psiClass.hasModifierProperty("abstract")) {
            String builderImplClassName = builderHandler.getBuilderImplClassName(psiClass);
            return List.of(builderClassName, builderImplClassName);
        }
        return Collections.singleton(builderClassName);
    }

    @Override
    protected boolean validate(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass psiClass, @NotNull ProblemSink builder) {
        if (psiAnnotation == null) {
            SuperBuilderClassProcessor.$$$reportNull$$$0(5);
        }
        if (psiClass == null) {
            SuperBuilderClassProcessor.$$$reportNull$$$0(6);
        }
        if (builder == null) {
            SuperBuilderClassProcessor.$$$reportNull$$$0(7);
        }
        return SuperBuilderClassProcessor.getBuilderHandler().validate(psiClass, psiAnnotation, builder);
    }

    @Override
    protected void generatePsiElements(@NotNull PsiClass psiClass, @NotNull PsiAnnotation psiAnnotation, @NotNull List<? super PsiElement> target, @Nullable String nameHint) {
        String builderImplClassName;
        SuperBuilderHandler builderHandler;
        String builderClassName;
        Optional<PsiClass> builderClass;
        if (psiClass == null) {
            SuperBuilderClassProcessor.$$$reportNull$$$0(8);
        }
        if (psiAnnotation == null) {
            SuperBuilderClassProcessor.$$$reportNull$$$0(9);
        }
        if (target == null) {
            SuperBuilderClassProcessor.$$$reportNull$$$0(10);
        }
        if ((builderClass = PsiClassUtil.getInnerClassInternByName(psiClass, builderClassName = (builderHandler = SuperBuilderClassProcessor.getBuilderHandler()).getBuilderClassName(psiClass))).isEmpty()) {
            PsiClass createdBuilderClass = builderHandler.createBuilderBaseClass(psiClass, psiAnnotation);
            target.add((PsiElement)createdBuilderClass);
            builderClass = Optional.of(createdBuilderClass);
        }
        if (!psiClass.hasModifierProperty("abstract") && PsiClassUtil.getInnerClassInternByName(psiClass, builderImplClassName = builderHandler.getBuilderImplClassName(psiClass)).isEmpty()) {
            target.add((PsiElement)builderHandler.createBuilderImplClass(psiClass, builderClass.get(), psiAnnotation));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameHint";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        objectArray2[1] = "de/plushnikov/intellij/plugin/processor/clazz/builder/SuperBuilderClassProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "possibleToGenerateElementNamed";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getNamesOfPossibleGeneratedElements";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "validate";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "generatePsiElements";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

