/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jboss.agent;

import com.intellij.javaee.oss.agent.AgentCallback;
import com.intellij.javaee.oss.agent.ParametersMap;
import com.intellij.javaee.oss.agent.SimpleAgentBase;
import com.intellij.javaee.oss.agent.SimpleAgentException;
import com.intellij.remoteServer.agent.util.ILogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.dmr.ModelNode;

public class JBoss7Agent
extends SimpleAgentBase {
    private static final int MAX_CONNECTION_ATTEMPTS = 3;
    private static final int CONNECTION_DELAY_MS = 1000;
    private boolean myDomain;
    private String myServerGroup;
    private ModelControllerClient myClient;
    private String myHost;
    private String[] myDomainServers;

    public void init(String host, int port, String username, String password, ParametersMap initParameters, AgentCallback callback) {
        super.init(host, port, username, password, initParameters, callback);
        this.myDomain = Boolean.parseBoolean((String)initParameters.get((Object)"is.domain"));
        this.myServerGroup = (String)initParameters.get((Object)"server.group");
        if (this.isLocalDomain()) {
            this.myHost = (String)initParameters.get((Object)"domain.host");
            this.myDomainServers = ((String)initParameters.get((Object)"server.names")).split(";");
        }
    }

    protected int getClientConnectionTimeout() {
        return JBoss7Agent.parseIntegerOrDefault(this.getInitParameters(), "client.timeout", 5000);
    }

    protected ModelControllerClient createClient(boolean https, int clientTimeout, CallbackHandler authHandler) throws IOException, SimpleAgentException {
        SSLContext sslContext = https ? JBoss7Agent.createSSLContextTrustingAllCertificates() : null;
        return ModelControllerClient.Factory.create((String)this.getHost(), (int)this.getPort(), (CallbackHandler)authHandler, (SSLContext)sslContext);
    }

    protected boolean doConnect() throws IOException, SimpleAgentException {
        if (this.myClient == null) {
            AuthHandler authHandler = this.createAuthHandler();
            int clientTimeout = this.getClientConnectionTimeout();
            boolean secured = Boolean.parseBoolean((String)this.getInitParameters().get((Object)"is.secured"));
            this.myClient = this.createClient(secured, clientTimeout, authHandler);
        }
        int connectionAttempts = 0;
        while (true) {
            ++connectionAttempts;
            try {
                return this.createValidateOperation(new RootAddressSetup()).validate() && (!this.isLocalDomain() || this.isDomainServersStarted(this.myHost, this.myDomainServers));
            }
            catch (IOException e) {
                if (this.isLocal() || !e.getMessage().contains("JBAS012144") || connectionAttempts == 3) {
                    throw e;
                }
                this.getLog().debugEx((Exception)e);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e2) {
                    throw new SimpleAgentException((Exception)e2);
                }
            }
        }
    }

    protected AuthHandler createAuthHandler() {
        return new AuthHandler((ILogger)this.getLog(), this.getUsername(), this.getPassword());
    }

    protected void doDeploy(final String deploymentName, final File source, final ParametersMap deployParameters) throws IOException, SimpleAgentException {
        try {
            final boolean nativeDeploymentMethod = Boolean.parseBoolean((String)deployParameters.get((Object)"native.deployment.method"));
            if (!new DeploymentOperation("add", deploymentName){

                @Override
                protected void setup(ModelNode request) {
                    super.setup(request);
                    ModelNode contentItem = request.get("content").get(0);
                    if (nativeDeploymentMethod) {
                        contentItem.get("input-stream-index").set(0);
                    } else {
                        contentItem.get("path").set((String)deployParameters.get((Object)"source.path"));
                        contentItem.get("archive").set(!source.isDirectory());
                    }
                    String extension = (String)deployParameters.get((Object)"runtime.name.extension");
                    if (extension != null && !extension.isEmpty()) {
                        request.get("runtime-name").set(deploymentName + "." + extension);
                    }
                }

                @Override
                protected ModelNode doExecute(ModelNode request) throws IOException {
                    if (nativeDeploymentMethod) {
                        OperationBuilder builder = new OperationBuilder(request);
                        builder.addInputStream((InputStream)new FileInputStream(source));
                        try (org.jboss.as.controller.client.Operation operation = builder.build();){
                            ModelNode modelNode = JBoss7Agent.this.myClient.execute(operation);
                            return modelNode;
                        }
                    }
                    return super.doExecute(request);
                }
            }.executeOrFail()) {
                return;
            }
            if (this.myDomain && !new JointDeploymentOperation("add", deploymentName).executeOrFail()) {
                return;
            }
            new JointDeploymentOperation("deploy", deploymentName).executeOrFail();
        }
        catch (SimpleAgentException e) {
            this.doUndeploy(deploymentName);
            throw e;
        }
    }

    protected void doUndeploy(String deploymentName) throws IOException {
        if (!this.isDeploymentRegistered(deploymentName)) {
            return;
        }
        if (this.isDeploymentEnabled(deploymentName)) {
            new JointDeploymentOperation("undeploy", deploymentName).execute();
        }
        if (this.myDomain) {
            new JointDeploymentOperation("remove", deploymentName).execute();
        }
        new DeploymentOperation("remove", deploymentName).execute();
    }

    protected boolean doIsDeployed(String deploymentName) throws IOException {
        return this.isDeploymentRegistered(deploymentName) && this.isDeploymentEnabled(deploymentName);
    }

    private boolean isLocal() {
        return JBoss7Agent.isLocal(this.getInitParameters());
    }

    private static boolean isLocal(ParametersMap initParams) {
        return initParams != null && Boolean.parseBoolean((String)initParams.get((Object)"is.local"));
    }

    private boolean isLocalDomain() {
        return this.isLocal() && this.myDomain;
    }

    private boolean isDeploymentRegistered(String deploymentName) throws IOException {
        return this.createValidateOperation(new DeploymentAddressSetup(deploymentName)).validate();
    }

    private boolean isDeploymentEnabled(String deploymentName) throws IOException {
        JointDeploymentOperation readEnabledOp = new JointDeploymentOperation("read-attribute", deploymentName){

            @Override
            protected void setup(ModelNode request) {
                super.setup(request);
                request.get("name").set("enabled");
            }
        };
        if (!readEnabledOp.execute()) {
            return false;
        }
        return readEnabledOp.getResult().asBoolean(false);
    }

    private boolean isDomainServersStarted(String hostName, String ... serverNames) throws IOException {
        for (String serverName : serverNames) {
            ReadServerStatusOperation readServerStatus = new ReadServerStatusOperation(new HostServerConfigAddressSetup(hostName, serverName));
            if (!readServerStatus.execute()) {
                return false;
            }
            if ("STARTED".equals(readServerStatus.getResult().get("status").asString())) continue;
            return false;
        }
        return true;
    }

    private void debugText(String text) {
        com.intellij.javaee.util.ILogger log = this.getLog();
        if (log != null) {
            log.debug(text);
        } else {
            System.err.println(text);
        }
    }

    public void destroy() {
        this.debugText((Object)((Object)this) + ":destroy: started, myClient: " + this.myClient);
        if (this.myClient == null) {
            return;
        }
        if (this.isLocal()) {
            AddressSetup addressSetup = this.myDomain ? new HostAddressSetup(this.myHost) : new RootAddressSetup();
            this.debugText((Object)((Object)this) + ":pre-shutdown validate");
            try {
                boolean status = this.createValidateOperation(addressSetup).validate();
                this.debugText((Object)((Object)this) + ":pre-shutdown validate: result=" + status);
                if (!status) {
                    throw new IOException("already shutdown?");
                }
            }
            catch (IOException e) {
                this.debugText((Object)((Object)this) + ":pre-shutdown validate failed: " + e);
                this.getLog().debugEx((Exception)e);
                return;
            }
            try {
                this.debugText((Object)((Object)this) + ":destroy: about to call shutdown");
                new Operation("shutdown", addressSetup).execute();
                this.debugText((Object)((Object)this) + ":destroy: completed");
            }
            catch (IOException e) {
                this.debugText((Object)((Object)this) + ":shutdown failed: " + e);
                this.getLog().debugEx((Exception)e);
            }
            for (int i = 0; i < 3; ++i) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                try {
                    this.debugText((Object)((Object)this) + ":post-shutdown validate: attempt #" + (i + 1));
                    boolean status = this.createValidateOperation(addressSetup).validate();
                    this.debugText((Object)((Object)this) + ":post-shutdown validate: attempt #" + (i + 1) + ": result=" + status);
                    if (status) continue;
                }
                catch (IOException e) {
                    this.debugText((Object)((Object)this) + ":post-shutdown validate: attempt #" + (i + 1) + " failed, assuming completed: " + e);
                }
                break;
            }
        }
        try {
            this.debugText((Object)((Object)this) + ":destroy: about to close client");
            this.myClient.close();
        }
        catch (IOException e) {
            this.debugText((Object)((Object)this) + ":destroy: client closing failed: " + e);
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode((Object)this));
    }

    ValidateOperation createValidateOperation(AddressSetup addressSetup) {
        return new ValidateOperation(addressSetup);
    }

    private static int parseIntegerOrDefault(ParametersMap map, String key, int defaultValue) {
        String text = (String)map.get((Object)key);
        if (text == null) {
            return defaultValue;
        }
        if ((text = text.trim()).isEmpty()) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(text);
        }
        catch (NumberFormatException ignored) {
            return defaultValue;
        }
    }

    protected static class AuthHandler
    implements CallbackHandler {
        private final ILogger myLog;
        private final String myPassword;
        private final String myUsername;

        protected AuthHandler(ILogger log, String username, String password) {
            this.myLog = log;
            this.myUsername = username;
            this.myPassword = password;
        }

        protected ILogger getLog() {
            return this.myLog;
        }

        protected String getPassword() {
            return this.myPassword;
        }

        protected String getUsername() {
            return this.myUsername;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            if (callbacks.length == 1 && callbacks[0] instanceof NameCallback) {
                this.getLog().debug("Auth: anonymous");
                ((NameCallback)callbacks[0]).setName("anonymous CLI user");
                return;
            }
            for (Callback current : callbacks) {
                boolean handled = this.handleAuthCallback(current);
                if (handled) continue;
                this.getLog().debug("Auth: unknown callback: " + current);
            }
        }

        protected boolean handleAuthCallback(Callback authCallback) throws IOException, UnsupportedCallbackException {
            if (authCallback instanceof RealmCallback) {
                this.getLog().debug("Auth: realm");
                RealmCallback rcb = (RealmCallback)authCallback;
                String defaultText = rcb.getDefaultText();
                rcb.setText(defaultText);
                return true;
            }
            if (authCallback instanceof RealmChoiceCallback) {
                this.getLog().debug("Auth: realm choice");
                return true;
            }
            if (authCallback instanceof NameCallback) {
                this.getLog().debug("Auth: username");
                NameCallback ncb = (NameCallback)authCallback;
                ncb.setName(this.getUsername());
                return true;
            }
            if (authCallback instanceof PasswordCallback) {
                this.getLog().debug("Auth: password");
                PasswordCallback pcb = (PasswordCallback)authCallback;
                pcb.setPassword(this.getPassword().toCharArray());
                return true;
            }
            return false;
        }
    }

    private static class RootAddressSetup
    implements AddressSetup {
        private RootAddressSetup() {
        }

        @Override
        public void setupAddress(ModelNode address) {
            address.setEmptyList();
        }
    }

    protected static interface AddressSetup {
        public void setupAddress(ModelNode var1);
    }

    class ValidateOperation
    extends Operation {
        ValidateOperation(AddressSetup addressSetup) {
            super("validate-address", addressSetup);
        }

        public boolean validate() throws IOException {
            return this.execute();
        }
    }

    private class JointDeploymentOperation
    extends Operation {
        JointDeploymentOperation(String name, String deploymentName) {
            super(name, new JointDeploymentAddressSetup(deploymentName));
        }
    }

    private class DeploymentOperation
    extends Operation {
        DeploymentOperation(String name, String deploymentName) {
            super(name, new DeploymentAddressSetup(deploymentName));
        }
    }

    private static class DeploymentAddressSetup
    implements AddressSetup {
        private final String myDeploymentName;

        DeploymentAddressSetup(String deploymentName) {
            this.myDeploymentName = deploymentName;
        }

        @Override
        public void setupAddress(ModelNode address) {
            address.add("deployment", this.myDeploymentName);
        }
    }

    private class ReadServerStatusOperation
    extends Operation {
        ReadServerStatusOperation(HostServerConfigAddressSetup addressSetup) {
            super("read-resource", addressSetup);
        }

        @Override
        protected void setup(ModelNode request) {
            super.setup(request);
            request.get("include-runtime").set("true");
        }
    }

    private static final class HostServerConfigAddressSetup
    extends HostAddressSetup {
        private final String myServerName;

        private HostServerConfigAddressSetup(String hostName, String serverName) {
            super(hostName);
            this.myServerName = serverName;
        }

        @Override
        public void setupAddress(ModelNode address) {
            super.setupAddress(address);
            address.add("server-config", this.myServerName);
        }
    }

    private static class HostAddressSetup
    implements AddressSetup {
        private final String myHostName;

        private HostAddressSetup(String hostName) {
            this.myHostName = hostName;
        }

        @Override
        public void setupAddress(ModelNode address) {
            address.add("host", this.myHostName);
        }
    }

    class Operation {
        private final String myName;
        private final AddressSetup myAddressSetup;
        private ModelNode myResult;

        Operation(String name, AddressSetup addressSetup) {
            this.myName = name;
            this.myAddressSetup = addressSetup;
        }

        public boolean execute() throws IOException {
            try {
                return this.executeOrFail();
            }
            catch (SimpleAgentException e) {
                return false;
            }
        }

        public boolean executeOrFail() throws IOException, SimpleAgentException {
            ModelNode failureDescription;
            boolean success;
            ModelNode request = new ModelNode();
            request.get("operation").set(this.myName);
            this.setup(request);
            ModelNode response = this.doExecute(request);
            if (response == null) {
                return false;
            }
            this.myResult = response.get("result");
            ModelNode outcome = response.get("outcome");
            boolean bl = success = outcome != null && outcome.asString().equals("success");
            if (!success && (failureDescription = response.get("failure-description")) != null) {
                throw new SimpleAgentException(new Exception(failureDescription.asString()));
            }
            return success;
        }

        protected ModelNode doExecute(ModelNode request) throws IOException {
            return JBoss7Agent.this.myClient.execute(request);
        }

        protected void setup(ModelNode request) {
            ModelNode address = request.get("address");
            this.setupAddress(address);
        }

        protected final void setupAddress(ModelNode address) {
            this.myAddressSetup.setupAddress(address);
        }

        public ModelNode getResult() {
            return this.myResult;
        }
    }

    private final class JointDeploymentAddressSetup
    extends DeploymentAddressSetup {
        private JointDeploymentAddressSetup(String deploymentName) {
            super(deploymentName);
        }

        @Override
        public void setupAddress(ModelNode address) {
            if (JBoss7Agent.this.myDomain) {
                address.add("server-group", JBoss7Agent.this.myServerGroup);
            }
            super.setupAddress(address);
        }
    }
}

