/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.logs.ui;

import com.intellij.kubernetes.logs.KubernetesLogFilterModelImpl;
import com.intellij.kubernetes.logs.KubernetesLogStateManager;
import com.intellij.kubernetes.logs.KubernetesLogsPresentableTextBuildersKt;
import com.intellij.kubernetes.logs.KubernetesTextFilterModel;
import com.intellij.kubernetes.logs.KubernetesTextLogFilterSettings;
import com.intellij.kubernetes.logs.actions.KubernetesLogsPatternMatchingAction;
import com.intellij.kubernetes.logs.pattern.matching.LogCluster;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.TextComponentEmptyText;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001e\u0010\n\u001a\n\u0018\u00010\u000bj\u0004\u0018\u0001`\f2\f\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000eH\u0014J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u0019H\u0014J\b\u0010!\u001a\u00020\u0019H\u0014J\b\u0010\"\u001a\u00020\u0019H\u0014J\u0006\u0010#\u001a\u00020\u0019J\r\u0010$\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b%J\b\u0010&\u001a\u00020\u0019H\u0002J\b\u0010'\u001a\u00020\u0019H\u0002J\u0010\u0010(\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020\u0010H\u0002J\u0010\u0010*\u001a\u00020\u00192\u0006\u0010+\u001a\u00020,H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/intellij/kubernetes/logs/ui/TextFilterField;", "Lcom/intellij/ui/SearchTextField;", "Lcom/intellij/openapi/actionSystem/UiDataProvider;", "textFilterModel", "Lcom/intellij/kubernetes/logs/KubernetesTextFilterModel;", "Lcom/intellij/kubernetes/logs/KubernetesTextLogFilterSettings;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/kubernetes/logs/KubernetesTextFilterModel;Lcom/intellij/openapi/Disposable;)V", "createItemChosenCallback", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "list", "Ljavax/swing/JList;", "onEmptyText", "", "Lorg/jetbrains/annotations/Nls;", "getOnEmptyText", "()Ljava/lang/String;", "tooltipText", "getTooltipText", "getMinimumSize", "Ljava/awt/Dimension;", "applyFilter", "", "addToHistory", "", "onFieldCleared", "patternsPopup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "patternsTextAdded", "Ljava/util/concurrent/atomic/AtomicBoolean;", "onFocusGained", "onFocusLost", "clearPatternsText", "updatePatternsSelectedTextToFilterField", "updatePatternsSelectedTextToFilterField$intellij_clouds_kubernetes_backend", "showPatternsPopup", "hideSelectedPatternsPopup", "isSameFilterAs", "otherText", "uiDataSnapshot", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "intellij.clouds.kubernetes.backend"})
public abstract class TextFilterField
extends SearchTextField
implements UiDataProvider {
    @NotNull
    private final KubernetesTextFilterModel<KubernetesTextLogFilterSettings> textFilterModel;
    @Nullable
    private JBPopup patternsPopup;
    @NotNull
    private AtomicBoolean patternsTextAdded;

    public TextFilterField(@NotNull KubernetesTextFilterModel<KubernetesTextLogFilterSettings> textFilterModel, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter(textFilterModel, (String)"textFilterModel");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        super("Kubernetes.Log.Filter.History");
        this.textFilterModel = textFilterModel;
        this.setText(((KubernetesTextLogFilterSettings)this.textFilterModel.getValue()).getRequest());
        this.getTextEditor().getEmptyText().setText(this.getOnEmptyText());
        TextComponentEmptyText.setupPlaceholderVisibility((JTextComponent)((JTextComponent)this.getTextEditor()));
        this.getTextEditor().addActionListener(arg_0 -> TextFilterField._init_$lambda$0(this, arg_0));
        BuildersKt.launch$default((CoroutineScope)this.textFilterModel.getStateManager().getCoroutineScope$intellij_clouds_kubernetes_backend(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ TextFilterField this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FlowKt.collectLatest(this.this$0.textFilterModel.getSettingsFlow(), (Function2)((Function2)new Function2<KubernetesTextLogFilterSettings, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            final /* synthetic */ TextFilterField this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object $result) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        String modelText = ((KubernetesTextLogFilterSettings)this.this$0.textFilterModel.getValue()).getRequest();
                                        if (!this.this$0.isSameFilterAs(modelText)) {
                                            this.this$0.setText(modelText);
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(KubernetesTextLogFilterSettings p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        this.getTextEditor().setToolTipText(XmlStringUtil.wrapInHtml((CharSequence)this.getTooltipText()));
        Disposer.register((Disposable)parentDisposable, () -> TextFilterField._init_$lambda$1(this));
        this.patternsTextAdded = new AtomicBoolean(true);
    }

    @Nullable
    protected Runnable createItemChosenCallback(@Nullable JList<?> list) {
        return () -> TextFilterField.createItemChosenCallback$lambda$0(list, this);
    }

    @NotNull
    public abstract String getOnEmptyText();

    @NotNull
    public abstract String getTooltipText();

    @NotNull
    public Dimension getMinimumSize() {
        Dimension size = super.getMinimumSize();
        size.width = Math.max(size.width, JBUIScale.scale((int)150));
        Intrinsics.checkNotNull((Object)size);
        return size;
    }

    private final void applyFilter(boolean addToHistory) {
        this.textFilterModel.updateSettings(arg_0 -> TextFilterField.applyFilter$lambda$0(this, arg_0));
        if (addToHistory) {
            this.addCurrentTextToHistory();
        }
    }

    protected void onFieldCleared() {
        this.textFilterModel.updateSettings(TextFilterField::onFieldCleared$lambda$0);
    }

    protected void onFocusGained() {
        this.showPatternsPopup();
        this.clearPatternsText();
    }

    protected void onFocusLost() {
        if (this.patternsTextAdded.get()) {
            this.clearPatternsText();
        }
        if (!this.isSameFilterAs(((KubernetesTextLogFilterSettings)this.textFilterModel.getValue()).getRequest())) {
            this.applyFilter(false);
        }
        this.hideSelectedPatternsPopup();
        this.updatePatternsSelectedTextToFilterField$intellij_clouds_kubernetes_backend();
    }

    public final void clearPatternsText() {
        this.setText(((KubernetesTextLogFilterSettings)this.textFilterModel.getValue()).getRequest());
        this.getTextEditor().getHighlighter().removeAllHighlights();
        this.patternsTextAdded.set(false);
    }

    public final void updatePatternsSelectedTextToFilterField$intellij_clouds_kubernetes_backend() {
        String patternsText;
        int patternsCount;
        Object excludedPatterns;
        KubernetesTextFilterModel<KubernetesTextLogFilterSettings> kubernetesTextFilterModel;
        Object object;
        Object selectedPatterns;
        this.clearPatternsText();
        KubernetesTextFilterModel<KubernetesTextLogFilterSettings> kubernetesTextFilterModel2 = this.textFilterModel;
        Object object2 = kubernetesTextFilterModel2 instanceof KubernetesLogFilterModelImpl ? (KubernetesLogFilterModelImpl)kubernetesTextFilterModel2 : null;
        if (object2 == null || (object2 = ((KubernetesLogFilterModelImpl)object2).getSelectedPatterns$intellij_clouds_kubernetes_backend()) == null) {
            object2 = selectedPatterns = CollectionsKt.emptyList();
        }
        if ((object = (kubernetesTextFilterModel = this.textFilterModel) instanceof KubernetesLogFilterModelImpl ? (KubernetesLogFilterModelImpl)kubernetesTextFilterModel : null) == null || (object = ((KubernetesLogFilterModelImpl)object).getExcludedPatterns$intellij_clouds_kubernetes_backend()) == null) {
            object = excludedPatterns = CollectionsKt.emptyList();
        }
        if ((patternsCount = selectedPatterns.size() + excludedPatterns.size()) == 0) {
            return;
        }
        if (!this.patternsTextAdded.compareAndSet(false, true)) {
            return;
        }
        this.getTextEditor().getHighlighter().removeAllHighlights();
        String basicText = ((KubernetesTextLogFilterSettings)this.textFilterModel.getValue()).getRequest();
        String string = patternsText = ((CharSequence)basicText).length() == 0 ? patternsCount + " pattern" + (patternsCount > 1 ? "s" : "") + " selected" : "  [+ " + patternsCount + " more pattern" + (patternsCount > 1 ? "s" : "") + "]";
        if (((CharSequence)basicText).length() == 0) {
            // empty if block
        }
        this.setText(basicText + patternsText);
    }

    private final void showPatternsPopup() {
        block5: {
            Object excludedPatterns;
            KubernetesTextFilterModel<KubernetesTextLogFilterSettings> kubernetesTextFilterModel;
            Object object;
            Object selectedPatterns;
            JBPopup jBPopup = this.patternsPopup;
            if (jBPopup != null) {
                jBPopup.cancel();
            }
            KubernetesTextFilterModel<KubernetesTextLogFilterSettings> kubernetesTextFilterModel2 = this.textFilterModel;
            Object object2 = kubernetesTextFilterModel2 instanceof KubernetesLogFilterModelImpl ? (KubernetesLogFilterModelImpl)kubernetesTextFilterModel2 : null;
            if (object2 == null || (object2 = ((KubernetesLogFilterModelImpl)object2).getSelectedPatterns$intellij_clouds_kubernetes_backend()) == null) {
                object2 = selectedPatterns = CollectionsKt.emptyList();
            }
            if ((object = (kubernetesTextFilterModel = this.textFilterModel) instanceof KubernetesLogFilterModelImpl ? (KubernetesLogFilterModelImpl)kubernetesTextFilterModel : null) == null || (object = ((KubernetesLogFilterModelImpl)object).getExcludedPatterns$intellij_clouds_kubernetes_backend()) == null) {
                object = excludedPatterns = CollectionsKt.emptyList();
            }
            if (selectedPatterns.isEmpty() && excludedPatterns.isEmpty()) {
                return;
            }
            String htmlText = KubernetesLogsPresentableTextBuildersKt.buildPatternsDescriptionHtmlText((List<? extends LogCluster>)selectedPatterns, (List<? extends LogCluster>)excludedPatterns);
            JLabel label = new JLabel(htmlText);
            label.setBorder((Border)JBUI.Borders.empty((int)5, (int)10));
            label.addMouseListener(new MouseAdapter(this){
                final /* synthetic */ TextFilterField this$0;
                {
                    this.this$0 = $receiver;
                }

                public void mouseClicked(MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    KubernetesLogStateManager logsManager = TextFilterField.access$getTextFilterModel$p(this.this$0).getStateManager();
                    KubernetesLogsPatternMatchingAction.Companion.performKubernetesLogsPatternMatchingAction(logsManager);
                }
            });
            JBPopup jBPopup2 = this.patternsPopup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)label, null).setRequestFocus(false).setFocusable(false).setResizable(false).setMovable(false).setCancelOnClickOutside(true).createPopup();
            boolean bl = jBPopup2 != null ? jBPopup2.isVisible() : false;
            if (bl) {
                return;
            }
            JBPopup jBPopup3 = this.patternsPopup;
            if (jBPopup3 == null) break block5;
            jBPopup3.showUnderneathOf((Component)this.getTextEditor());
        }
    }

    private final void hideSelectedPatternsPopup() {
        JBPopup jBPopup = this.patternsPopup;
        if (jBPopup != null) {
            jBPopup.cancel();
        }
        this.patternsPopup = null;
    }

    private final boolean isSameFilterAs(String otherText) {
        String thisText = this.getText();
        CharSequence charSequence = thisText;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return StringsKt.isBlank((CharSequence)otherText);
        }
        return Intrinsics.areEqual((Object)thisText, (Object)otherText);
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        DataKey dataKey = PlatformCoreDataKeys.HELP_ID;
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"HELP_ID");
        sink.set(dataKey, (Object)"kubernetes.logs.filter.text.field");
    }

    private static final void createItemChosenCallback$lambda$0(JList $list, TextFilterField this$0) {
        JList jList = $list;
        Object value = jList != null ? jList.getSelectedValue() : null;
        this$0.textFilterModel.updateSettings(arg_0 -> TextFilterField.createItemChosenCallback$lambda$0$0(value, arg_0));
        super.createItemChosenCallback($list).run();
    }

    private static final KubernetesTextLogFilterSettings createItemChosenCallback$lambda$0$0(Object $value, KubernetesTextLogFilterSettings snapshot) {
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        Object object = $value;
        if (object == null || (object = object.toString()) == null) {
            object = "";
        }
        return KubernetesTextLogFilterSettings.copy$default(snapshot, (String)object, false, false, 6, null);
    }

    private static final void _init_$lambda$0(TextFilterField this$0, ActionEvent it) {
        this$0.applyFilter(true);
    }

    private static final void _init_$lambda$1(TextFilterField this$0) {
        this$0.hidePopup();
    }

    private static final KubernetesTextLogFilterSettings applyFilter$lambda$0(TextFilterField this$0, KubernetesTextLogFilterSettings snapshot) {
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        String string = this$0.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return KubernetesTextLogFilterSettings.copy$default(snapshot, string, false, false, 6, null);
    }

    private static final KubernetesTextLogFilterSettings onFieldCleared$lambda$0(KubernetesTextLogFilterSettings snapshot) {
        Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
        return KubernetesTextLogFilterSettings.copy$default(snapshot, "", false, false, 6, null);
    }
}

