/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.orm.structure;

import com.intellij.database.psi.DbColumn;
import com.intellij.database.psi.DbElement;
import com.intellij.database.view.DbNavigationUtils;
import com.intellij.ide.structureView.logical.impl.mappers.LogicalModelMapperProvider;
import com.intellij.ide.structureView.logical.model.LogicalModelPresentationProvider;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.jpa.jpb.model.JpaIcons;
import com.intellij.jpa.jpb.model.core.msg.JpaModelBundle;
import com.intellij.jpa.jpb.model.orm.ep.OrmMappingProvider;
import com.intellij.jpa.jpb.model.orm.ep.OrmSearcher;
import com.intellij.jpa.jpb.model.orm.jpa.model.AbstractJpaOrmEntity;
import com.intellij.jpa.jpb.model.orm.model.OrmEntity;
import com.intellij.jpa.jpb.model.orm.model.OrmEntityAttribute;
import com.intellij.jpa.jpb.model.orm.structuretw.OrmEntityAttributeLogicalModel;
import com.intellij.jpa.jpb.model.orm.structuretw.OrmEntityAttributeLogicalModelPresentationProvider;
import com.intellij.jpa.util.OrmDbElementsUtilKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.psi.PsiClass;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J,\u0010\u001a\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001c0\u001bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u001c`\u001d2\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/jpa/orm/structure/OrmEntityAttributeLogicalModelNavigatablePresentationProvider;", "Lcom/intellij/ide/structureView/logical/model/LogicalModelPresentationProvider;", "Lcom/intellij/jpa/jpb/model/orm/structuretw/OrmEntityAttributeLogicalModel;", "Lcom/intellij/ide/structureView/logical/impl/mappers/LogicalModelMapperProvider;", "<init>", "()V", "defaultProvider", "Lcom/intellij/jpa/jpb/model/orm/structuretw/OrmEntityAttributeLogicalModelPresentationProvider;", "getName", "", "t", "getIcon", "Ljavax/swing/Icon;", "getTypeName", "getColoredText", "", "Lcom/intellij/ide/util/treeView/PresentableNodeDescriptor$ColoredFragment;", "handleClick", "Ljava/util/concurrent/CompletableFuture;", "", "fragmentIndex", "", "getTargetEntity", "Lcom/intellij/jpa/jpb/model/orm/model/OrmEntity;", "ormEntity", "type", "attributes", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "intellij.javaee.jpa.impl"})
@SourceDebugExtension(value={"SMAP\nOrmEntityAttributeLogicalModelNavigatablePresentationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OrmEntityAttributeLogicalModelNavigatablePresentationProvider.kt\ncom/intellij/jpa/orm/structure/OrmEntityAttributeLogicalModelNavigatablePresentationProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,134:1\n1#2:135\n*E\n"})
public final class OrmEntityAttributeLogicalModelNavigatablePresentationProvider
extends LogicalModelPresentationProvider<OrmEntityAttributeLogicalModel>
implements LogicalModelMapperProvider<OrmEntityAttributeLogicalModel> {
    @NotNull
    private final OrmEntityAttributeLogicalModelPresentationProvider defaultProvider = new OrmEntityAttributeLogicalModelPresentationProvider();

    @NotNull
    public String getName(@NotNull OrmEntityAttributeLogicalModel t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        return this.defaultProvider.getName(t);
    }

    @NotNull
    public Icon getIcon(@NotNull OrmEntityAttributeLogicalModel t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        if (t.getAttribute().isTransient()) {
            Icon icon = JpaIcons.SpringData.TransientEntityAttribute;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"TransientEntityAttribute");
            return icon;
        }
        return this.defaultProvider.getIcon(t);
    }

    @NotNull
    public String getTypeName(@NotNull OrmEntityAttributeLogicalModel t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        return this.defaultProvider.getTypeName(t);
    }

    @NotNull
    public List<PresentableNodeDescriptor.ColoredFragment> getColoredText(@NotNull OrmEntityAttributeLogicalModel t) {
        List result;
        block15: {
            String it;
            Object object;
            OrmMappingProvider ormMappingProvider;
            OrmEntityAttribute ormAttribute;
            block14: {
                block13: {
                    Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                    ormAttribute = t.getAttribute();
                    ormMappingProvider = OrmMappingProvider.Companion.findForFramework(ormAttribute.getOrmFramework());
                    result = new ArrayList();
                    object = t.getSourceEmbeddedName();
                    if (object == null) break block13;
                    it = object;
                    boolean bl = false;
                    String string = it + ".";
                    object = string;
                    if (string != null) break block14;
                }
                object = "";
            }
            String attributeName = (String)object + t.getAttribute().getName();
            result.add(new PresentableNodeDescriptor.ColoredFragment(attributeName, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES));
            if (ormAttribute.getAssociationCardinality() != null) {
                OrmMappingProvider ormMappingProvider2 = ormMappingProvider;
                if (ormMappingProvider2 == null || (ormMappingProvider2 = ormMappingProvider2.getAttributeTargetType(t.getEntity(), ormAttribute)) == null) {
                    ormMappingProvider2 = ormAttribute.getTypeFqn().getInner();
                }
                String type = ormMappingProvider2.getClassName();
                result.add(new PresentableNodeDescriptor.ColoredFragment(" " + type, SimpleTextAttributes.GRAYED_ATTRIBUTES));
                if (t.getFrom() != null) {
                    OrmEntity ormEntity = t.getFrom();
                    Intrinsics.checkNotNull((Object)ormEntity);
                    result.add(new PresentableNodeDescriptor.ColoredFragment(" | " + ormEntity.getName(), SimpleTextAttributes.GRAYED_ATTRIBUTES));
                }
                return result;
            }
            OrmEntity targetEntity = this.getTargetEntity(t.getEntity());
            if (!ormAttribute.isEmbedded()) {
                AbstractJpaOrmEntity abstractJpaOrmEntity = targetEntity instanceof AbstractJpaOrmEntity ? (AbstractJpaOrmEntity)targetEntity : null;
                if (!(abstractJpaOrmEntity != null ? abstractJpaOrmEntity.isMappedSuperclass() : false)) {
                    DbColumn dbColumn = OrmDbElementsUtilKt.getDbColumn(targetEntity, ormAttribute, t.getFrom(), t.getSourceEmbeddedName());
                    String string = JpaModelBundle.message((String)"logical.orm.attribute.maps", (Object[])new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    String mapsText = string;
                    if (dbColumn != null) {
                        result.add(new PresentableNodeDescriptor.ColoredFragment(" " + mapsText + " ", SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES));
                        result.add(new PresentableNodeDescriptor.ColoredFragment(dbColumn.getName(), SimpleTextAttributes.LINK_ATTRIBUTES));
                        String string2 = dbColumn.getDasType().getSpecification();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSpecification(...)");
                        String typeName = string2;
                        result.add(new PresentableNodeDescriptor.ColoredFragment(" " + typeName, SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES));
                    } else {
                        OrmMappingProvider ormMappingProvider3 = ormMappingProvider;
                        if (ormMappingProvider3 != null && (ormMappingProvider3 = ormMappingProvider3.getNavigationTableAndColumnNames(ormAttribute, targetEntity, t.getFrom(), t.getSourceEmbeddedName())) != null) {
                            OrmMappingProvider it2 = ormMappingProvider3;
                            boolean bl = false;
                            String columnName = (String)it2.getSecond();
                            result.add(new PresentableNodeDescriptor.ColoredFragment(" " + mapsText + " ", SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES));
                            result.add(new PresentableNodeDescriptor.ColoredFragment(columnName, new SimpleTextAttributes(16, SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES.getFgColor(), SimpleTextAttributes.SIMPLE_CELL_ATTRIBUTES.getBgColor())));
                        }
                    }
                }
            }
            OrmEntity ormEntity = t.getFrom();
            if (ormEntity == null) break block15;
            it = ormEntity;
            boolean bl = false;
            Object object2 = it.getClassPsiPointer();
            if (object2 == null || (object2 = (PsiClass)object2.getElement()) == null || (object2 = object2.getName()) == null) {
                object2 = it.getName();
            }
            Object parentName = object2;
            result.add(new PresentableNodeDescriptor.ColoredFragment(" | " + (String)parentName, SimpleTextAttributes.GRAYED_ATTRIBUTES));
        }
        return result;
    }

    @NotNull
    public CompletableFuture<Boolean> handleClick(@NotNull OrmEntityAttributeLogicalModel t, int fragmentIndex) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        if (fragmentIndex != 2) {
            CompletableFuture<Boolean> completableFuture = CompletableFuture.completedFuture(false);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        ReadAction.nonBlocking(() -> OrmEntityAttributeLogicalModelNavigatablePresentationProvider.handleClick$lambda$0(this, t)).finishOnUiThread(ModalityState.any(), arg_0 -> OrmEntityAttributeLogicalModelNavigatablePresentationProvider.handleClick$lambda$2(arg_0 -> OrmEntityAttributeLogicalModelNavigatablePresentationProvider.handleClick$lambda$1(future, arg_0), arg_0)).submit((Executor)AppExecutorUtil.getAppExecutorService());
        return future;
    }

    private final OrmEntity getTargetEntity(OrmEntity ormEntity) {
        if (ormEntity instanceof OrmEntityAttributeLogicalModel) {
            return this.getTargetEntity(((OrmEntityAttributeLogicalModel)ormEntity).getEntity());
        }
        Map embeddedEntityOwner = OrmSearcher.Companion.getForFramework(ormEntity.getOrmFramework()).findEmbeddedEntityOwner(ormEntity);
        if (!embeddedEntityOwner.isEmpty()) {
            return this.getTargetEntity((OrmEntity)CollectionsKt.first((Iterable)embeddedEntityOwner.keySet()));
        }
        return ormEntity;
    }

    @NotNull
    public String type(@NotNull OrmEntityAttributeLogicalModel t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        return this.getName(t);
    }

    @NotNull
    public HashMap<String, Object> attributes(@NotNull OrmEntityAttributeLogicalModel t) {
        Object object;
        Object it;
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        ((Map)attrs).put("type", t.getAttribute().getTypeFqn().getName(true));
        Object object2 = t.getAttribute().getAssociationCardinality();
        if (object2 != null && (object2 = object2.name()) != null) {
            it = object2;
            boolean bl = false;
            ((Map)attrs).put("cardinality", it);
        }
        if ((object = t.getFrom()) != null && (object = object.getName()) != null) {
            it = object;
            boolean bl = false;
            ((Map)attrs).put("source-entity", it);
        }
        OrmEntity targetEntity = this.getTargetEntity(t.getEntity());
        if (!t.getAttribute().isEmbedded()) {
            AbstractJpaOrmEntity abstractJpaOrmEntity = targetEntity instanceof AbstractJpaOrmEntity ? (AbstractJpaOrmEntity)targetEntity : null;
            if (!(abstractJpaOrmEntity != null ? abstractJpaOrmEntity.isMappedSuperclass() : false)) {
                Object object3 = OrmDbElementsUtilKt.getDbColumn$default(targetEntity, t.getAttribute(), null, null, 12, null);
                if (object3 != null && (object3 = object3.getName()) != null) {
                    Object it2 = object3;
                    boolean bl = false;
                    ((Map)attrs).put("db-column", it2);
                }
            }
        }
        List features = new ArrayList();
        if (t.getAttribute().isId()) {
            features.add("identifier");
        }
        if (t.getAttribute().isTransient()) {
            features.add("transient");
        }
        if (t.getAttribute().isEmbedded()) {
            features.add("embedded");
        }
        if (!((Collection)features).isEmpty()) {
            ((Map)attrs).put("features", CollectionsKt.joinToString$default((Iterable)features, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
        }
        return attrs;
    }

    private static final DbColumn handleClick$lambda$0(OrmEntityAttributeLogicalModelNavigatablePresentationProvider this$0, OrmEntityAttributeLogicalModel $t) {
        return OrmDbElementsUtilKt.getDbColumn(this$0.getTargetEntity($t.getEntity()), $t.getAttribute(), $t.getFrom(), $t.getSourceEmbeddedName());
    }

    private static final Unit handleClick$lambda$1(CompletableFuture $future, DbColumn dbColumn) {
        if (dbColumn != null) {
            DbNavigationUtils.navigateToDatabaseView((DbElement)((DbElement)dbColumn), (boolean)true);
        }
        $future.complete(dbColumn != null);
        return Unit.INSTANCE;
    }

    private static final void handleClick$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

