/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.engine;

import com.intellij.credentialStore.Credentials;
import com.intellij.database.DataBus;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.connection.throwable.info.SimpleErrorInfo;
import com.intellij.database.console.AbstractEngine;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.datagrid.DataAuditor;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataProducer;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataRequest;
import com.intellij.database.datagrid.RawStatementContext;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.run.ConsoleRunConfiguration;
import com.intellij.execution.ExecutionException;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.engine.JpaConsoleBase;
import com.intellij.jpa.jpb.model.orm.model.OrmUnit;
import com.intellij.jpa.jpb.model.util.OrmUtil;
import com.intellij.jpa.orm.model.JpaOrmUnit;
import com.intellij.jpa.remote.RemoteQuery;
import com.intellij.jpa.remote.RemoteQueryResult;
import com.intellij.jpa.remote.impl.QueryResult;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistencePackagePointer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JpaEngineBase
extends AbstractEngine
implements DataProducer {
    private static final Logger LOG = Logger.getInstance(JpaEngineBase.class);
    protected final PersistencePackagePointer myUnitFile;
    protected final ConsoleRunConfiguration myConfiguration;

    public JpaEngineBase(DataBus.Producing messageBus, PersistencePackagePointer unitFile, ConsoleRunConfiguration configuration) {
        super(configuration.getProject(), messageBus);
        this.myUnitFile = unitFile;
        this.myConfiguration = configuration;
    }

    public PersistencePackagePointer getUnitFile() {
        return this.myUnitFile;
    }

    protected void disconnect() {
        super.disconnect();
        this.releaseConnection();
    }

    protected abstract void releaseConnection();

    protected void setRunConfigurationOptionsForDataSource(@Nullable LocalDataSource dataSource) {
        if (dataSource == null) {
            return;
        }
        if (StringUtil.isNotEmpty((String)this.myConfiguration.VM_PARAMETERS)) {
            return;
        }
        if (this.myConfiguration.VM_PARAMETERS_GROUPS != null && !this.myConfiguration.VM_PARAMETERS_GROUPS.isEmpty()) {
            return;
        }
        if (this.myConfiguration.VM_ENV != null && !this.myConfiguration.VM_ENV.isEmpty()) {
            return;
        }
        this.myConfiguration.setOptionsFromDataSource(dataSource);
    }

    public void visitQuery(DataRequest.QueryRequest r) {
        this.queryData(r);
    }

    public void visitRequest(DataRequest r) {
        if (r instanceof JpaConsoleBase.GenerateSql) {
            JpaConsoleBase.GenerateSql gen = (JpaConsoleBase.GenerateSql)r;
            switch (gen.command) {
                case QUERY: {
                    this.getGeneratedSql(gen);
                    break;
                }
                case DDL: {
                    this.getGeneratedDdl(gen);
                }
            }
        }
    }

    public void queryData(@NotNull DataRequest.QueryRequest request) {
        if (request == null) {
            JpaEngineBase.$$$reportNull$$$0(0);
        }
        this.submitRequest((DataRequest)request, () -> {
            if (request instanceof JpaConsoleBase.LoadRequest) {
                JpaConsoleBase.LoadRequest r = (JpaConsoleBase.LoadRequest)request;
                return this.executeQueryInner(request, (Map)r.params, r.expectedColumns);
            }
            return this.executeQueryInner(request, Collections.emptyMap(), Collections.emptyList());
        });
    }

    public void getGeneratedSql(JpaConsoleBase.GenerateSql request) {
        this.submitRequest(request, () -> {
            this.getDataAuditor().print(this.getRequestContext(), this.getGenerateSqlInner(request.query));
            return true;
        });
    }

    @Nullable
    @NlsSafe
    protected abstract String getGenerateSqlInner(String var1) throws Exception;

    public void getGeneratedDdl(JpaConsoleBase.GenerateSql request) {
        this.submitRequest(request, () -> {
            this.getDataAuditor().print(this.getRequestContext(), this.getGeneratedDdlInner());
            return true;
        });
    }

    @Nullable
    @NlsSafe
    protected abstract String getGeneratedDdlInner() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeQueryInner(DataRequest.QueryRequest request, Map<Object, String> parameters, List<String> expectedColumns) {
        try {
            this.getRequestContext().statementContext.push(new RawStatementContext(request.query));
            this.getDataAuditor().beforeStatement(this.getRequestContext());
            RemoteQuery remoteQuery = this.createQuery(request.query);
            try {
                for (Object o : parameters.keySet()) {
                    if (o instanceof Number) {
                        remoteQuery.setParameter(((Number)o).intValue(), (Object)parameters.get(o));
                        continue;
                    }
                    remoteQuery.setParameter((String)o, (Object)parameters.get(o));
                }
                remoteQuery.execute();
                RemoteQueryResult result = remoteQuery.getQueryResult();
                if (result != null) {
                    int rowCount = 0;
                    try {
                        this.getDataAuditor().fetchStarted(this.getRequestContext(), 1);
                        rowCount = this.printResult(request, result, expectedColumns);
                    }
                    finally {
                        this.getDataAuditor().fetchFinished(this.getRequestContext(), 1, rowCount);
                    }
                } else {
                    this.getDataAuditor().updateCountReceived(this.getRequestContext(), remoteQuery.getUpdateCount());
                }
                boolean bl = true;
                this.closeQuery(remoteQuery);
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    this.closeQuery(remoteQuery);
                    throw throwable;
                }
                catch (Exception e) {
                    this.getDataAuditor().error(this.getRequestContext(), (Throwable)e);
                    boolean bl = false;
                    return bl;
                }
            }
        }
        finally {
            this.getDataAuditor().afterStatement(this.getRequestContext());
            this.getRequestContext().statementContext.pollFirst();
        }
    }

    protected abstract RemoteQuery createQuery(String var1) throws Exception;

    private void closeQuery(RemoteQuery remoteQuery) {
        if (remoteQuery != null) {
            try {
                remoteQuery.close();
            }
            catch (Exception e) {
                this.getDataAuditor().error(this.getRequestContext(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int printResult(DataRequest.QueryRequest request, RemoteQueryResult result, List<String> expectedColumns) throws RemoteException {
        DataRequest.Constraints constraints = request.constraints;
        QueryResult.Column[] columnInfos = result.getColumnInfos(constraints.absolutePosition, constraints.limit, ArrayUtilRt.toStringArray(expectedColumns));
        DataConsumer.Column[] columnsDescr = new DataConsumer.Column[columnInfos.length];
        for (int i = 0; i < columnsDescr.length; ++i) {
            columnsDescr[i] = new DataConsumer.Column(i, columnInfos[i].name, 1111, columnInfos[i].type, columnInfos[i].clazz);
        }
        int total = result.getSize();
        int start = DataRequest.getStartIdx((DataRequest.Constraints)constraints, (int)total);
        int pageSize = constraints.limit;
        ArrayList<Object> values = new ArrayList<Object>();
        int rowCount = 0;
        int rowNum = start - 1;
        DataConsumer consumer = this.getDataConsumer();
        if (request instanceof DataConsumer) {
            consumer = new DataConsumer.Composite(new DataConsumer[]{consumer, (DataConsumer)request});
        }
        consumer.setColumns((GridDataRequest.Context)this.getRequestContext(), 1, 1, (GridColumn[])columnsDescr, start);
        int chunkSize = pageSize > 0 ? Math.max(pageSize / 10, 1) : 100;
        ArrayList<DataConsumer.Row> rows = new ArrayList<DataConsumer.Row>(chunkSize);
        try {
            while ((pageSize <= 0 || rowCount < pageSize) && result.next()) {
                if (++rowNum < start) continue;
                ++rowCount;
                for (int i = 1; i <= columnsDescr.length; ++i) {
                    values.add(result.getObject(i));
                }
                DataConsumer.Row row = DataConsumer.Row.create((int)(rowNum - 1), (Object[])ArrayUtil.toObjectArray(values));
                rows.add(row);
                if (rows.size() == chunkSize) {
                    consumer.addRows((GridDataRequest.Context)this.getRequestContext(), rows);
                    rows = new ArrayList(chunkSize);
                }
                values.clear();
            }
            if (!rows.isEmpty()) {
                consumer.addRows((GridDataRequest.Context)this.getRequestContext(), rows);
            }
        }
        finally {
            consumer.afterLastRowAdded((GridDataRequest.Context)this.getRequestContext(), total);
        }
        return rowCount;
    }

    @NotNull
    protected AbstractEngine.EngineDataAuditor wrapDataAuditor(@NotNull DataAuditor dataAuditor) {
        if (dataAuditor == null) {
            JpaEngineBase.$$$reportNull$$$0(1);
        }
        return new JpaEngineBaseDataAuditor(dataAuditor);
    }

    @NotNull
    public static File getTempDirectory(@NotNull Project project) {
        if (project == null) {
            JpaEngineBase.$$$reportNull$$$0(2);
        }
        return new File(CompilerPaths.getGeneratedDataDirectory((Project)project), "Jpa_Console");
    }

    @Nullable
    protected static LocalDataSource findDataSource(Project project, PersistencePackagePointer unitFile) {
        DumbService service = DumbService.getInstance((Project)project);
        return (LocalDataSource)service.runReadActionInSmartMode(() -> {
            List dataSources;
            PersistenceFacet facet = unitFile.getPersistenceFacet();
            if (facet == null) {
                return null;
            }
            String dataSourceId = Optional.ofNullable(unitFile.findElement()).map(it -> new JpaOrmUnit(facet, (PersistencePackage)it)).map(it -> OrmUtil.INSTANCE.getAssociatedDataStore(project, (OrmUnit)it)).map(it -> it.getId()).orElse(facet.getDataSourceId(unitFile));
            DbDataSource dbElement = DbPsiFacade.getInstance((Project)project).findDataSource(dataSourceId);
            if (dbElement == null && (dataSources = DbPsiFacade.getInstance((Project)project).getDataSources()).size() == 1) {
                dbElement = (DbDataSource)dataSources.getFirst();
            }
            RawDataSource delegate = dbElement != null ? dbElement.getDelegate() : null;
            return delegate instanceof LocalDataSource ? (LocalDataSource)delegate : null;
        });
    }

    protected void onTemporaryConfigGenerated(@NotNull GenerationInfo info, @NotNull File file) {
        DataRequest.Owner owner;
        if (info == null) {
            JpaEngineBase.$$$reportNull$$$0(3);
        }
        if (file == null) {
            JpaEngineBase.$$$reportNull$$$0(4);
        }
        if (!ApplicationManager.getApplication().isHeadlessEnvironment() && ApplicationManager.getApplication().isEAP()) {
            this.getDataAuditor().print(this.getRequestContext(), JpaMessages.message("jpa.console.generated.content.using.file", file.getPath()));
        }
        if ((owner = this.getRequestContext().request.owner) instanceof JpaConsoleBase && info.dataSource != null) {
            ((JpaConsoleBase)owner).initHighlighter(info.dataSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeTemporaryConfigText(@NotNull File file, @NotNull String text, @NotNull GenerationInfo info) {
        if (file == null) {
            JpaEngineBase.$$$reportNull$$$0(5);
        }
        if (text == null) {
            JpaEngineBase.$$$reportNull$$$0(6);
        }
        if (info == null) {
            JpaEngineBase.$$$reportNull$$$0(7);
        }
        try {
            file.getParentFile().mkdirs();
            FileUtil.writeToFile((File)file, (String)text);
        }
        catch (IOException e) {
            this.getDataAuditor().error(this.getRequestContext(), (Throwable)e);
        }
        finally {
            this.onTemporaryConfigGenerated(info, file);
        }
    }

    @NotNull
    protected DataRequest.Context createRequestContext(@NotNull DataRequest request) {
        if (request == null) {
            JpaEngineBase.$$$reportNull$$$0(8);
        }
        return new DataRequest.Context((DataProducer)this, (DataRequest.OutputHandler)this.getDataAuditor(), request, DataRequest.NONE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataAuditor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/intellij/jpa/engine/JpaEngineBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "queryData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "wrapDataAuditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getTempDirectory";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "onTemporaryConfigGenerated";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "writeTemporaryConfigText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "createRequestContext";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static class JpaEngineBaseDataAuditor
    extends AbstractEngine.EngineDataAuditor {
        public JpaEngineBaseDataAuditor(@NotNull DataAuditor delegate) {
            if (delegate == null) {
                JpaEngineBaseDataAuditor.$$$reportNull$$$0(0);
            }
            super(delegate);
        }

        @NotNull
        protected ErrorInfo createErrorInfo(@NotNull Throwable th) {
            if (th == null) {
                JpaEngineBaseDataAuditor.$$$reportNull$$$0(1);
            }
            ErrorInfo errorInfo = this.handleException(th);
            if (errorInfo == null) {
                JpaEngineBaseDataAuditor.$$$reportNull$$$0(2);
            }
            return errorInfo;
        }

        @NotNull
        protected ErrorInfo handleException(@NotNull Throwable e) {
            if (e == null) {
                JpaEngineBaseDataAuditor.$$$reportNull$$$0(3);
            }
            LOG.debug("An exception occurred during JPA query execution", e);
            LinkedHashSet messages = new LinkedHashSet();
            Throwable t = e;
            while (t.getCause() != null) {
                ContainerUtil.addIfNotNull(messages, (Object)StringUtil.nullize((String)t.getLocalizedMessage()));
                t = t.getCause();
            }
            if (t instanceof SQLException) {
                @NlsSafe String state = ((SQLException)t).getSQLState();
                ErrorInfo errorInfo = SimpleErrorInfo.create((String)((String)(state != null ? "[" + state + "] " : "") + t.getLocalizedMessage()));
                if (errorInfo == null) {
                    JpaEngineBaseDataAuditor.$$$reportNull$$$0(4);
                }
                return errorInfo;
            }
            if (t instanceof EOFException && e instanceof RemoteException) {
                ErrorInfo errorInfo = SimpleErrorInfo.create((String)JpaMessages.message("jpa.console.process.exited", new Object[0]));
                if (errorInfo == null) {
                    JpaEngineBaseDataAuditor.$$$reportNull$$$0(5);
                }
                return errorInfo;
            }
            if (t instanceof IOException || t instanceof UnsupportedOperationException) {
                @NlsSafe String simpleName = t.getClass().getSimpleName();
                ErrorInfo errorInfo = SimpleErrorInfo.create((String)(simpleName + ": " + t.getLocalizedMessage()));
                if (errorInfo == null) {
                    JpaEngineBaseDataAuditor.$$$reportNull$$$0(6);
                }
                return errorInfo;
            }
            if (t instanceof ExecutionException) {
                ErrorInfo errorInfo = SimpleErrorInfo.create((String)t.getLocalizedMessage());
                if (errorInfo == null) {
                    JpaEngineBaseDataAuditor.$$$reportNull$$$0(7);
                }
                return errorInfo;
            }
            ContainerUtil.addIfNotNull(messages, (Object)StringUtil.nullize((String)t.getLocalizedMessage()));
            for (String s : messages) {
                if (s.contains("QuerySyntaxException:")) {
                    s = s.substring(s.indexOf("QuerySyntaxException:") + "QuerySyntaxException:".length()).trim();
                    ErrorInfo errorInfo = SimpleErrorInfo.create((String)s);
                    if (errorInfo == null) {
                        JpaEngineBaseDataAuditor.$$$reportNull$$$0(8);
                    }
                    return errorInfo;
                }
                if (!s.contains("Syntax error")) continue;
                s = s.substring(s.indexOf("Syntax error")).trim();
                ErrorInfo errorInfo = SimpleErrorInfo.create((String)s);
                if (errorInfo == null) {
                    JpaEngineBaseDataAuditor.$$$reportNull$$$0(9);
                }
                return errorInfo;
            }
            messages.remove(t.getLocalizedMessage());
            @NlsSafe StringBuilder sb = new StringBuilder();
            for (String s : messages) {
                sb.append(s).append("\n");
            }
            sb.append(t);
            ErrorInfo errorInfo = SimpleErrorInfo.create((String)sb.toString());
            if (errorInfo == null) {
                JpaEngineBaseDataAuditor.$$$reportNull$$$0(10);
            }
            return errorInfo;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 4, 5, 6, 7, 8, 9, 10 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "th";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/jpa/engine/JpaEngineBase$JpaEngineBaseDataAuditor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/jpa/engine/JpaEngineBase$JpaEngineBaseDataAuditor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createErrorInfo";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "handleException";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "createErrorInfo";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "handleException";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 4, 5, 6, 7, 8, 9, 10 -> new IllegalStateException(string);
            };
        }
    }

    protected static class GenerationInfo {
        public final Project project;
        public final PersistenceFacet facet;
        public final PersistencePackage unit;
        public final LocalDataSource dataSource;
        public final Credentials credentials;

        public GenerationInfo(Project project, PersistenceFacet facet, PersistencePackage unit, LocalDataSource dataSource, Credentials credentials) {
            this.project = project;
            this.facet = facet;
            this.unit = unit;
            this.dataSource = dataSource;
            this.credentials = credentials;
        }
    }
}

