/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.encoding;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.encoding.Base64;
import org.jetbrains.letsPlot.commons.encoding.Png;
import org.jetbrains.letsPlot.commons.encoding.Zip_jvmKt;
import org.jetbrains.letsPlot.commons.values.Bitmap;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004()*+B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\u0002J\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u0002J$\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00112\b\b\u0002\u0010\u0013\u001a\u00020\bH\u0002J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0006J\u000e\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019J\u001a\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00152\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001dJ\u000e\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0015J\u0010\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020!H\u0002J\u0014\u0010\"\u001a\u00020\u0004*\u00020#2\u0006\u0010$\u001a\u00020\bH\u0002J\u001c\u0010%\u001a\u00020\u0004*\u00020#2\u0006\u0010&\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u0006H\u0002\u00a8\u0006,"}, d2={"Lorg/jetbrains/letsPlot/commons/encoding/Png;", "", "()V", "arraycopy", "", "src", "", "srcPos", "", "dest", "destPos", "length", "buildIHDR", "width", "height", "buildPHYS", "dpiX", "", "dpiY", "unit", "decode", "Lorg/jetbrains/letsPlot/commons/values/Bitmap;", "input", "decodeDataImage", "dataUrl", "", "encode", "bitmap", "dpi", "", "encodeDataImage", "readInt", "stream", "Lorg/jetbrains/letsPlot/commons/encoding/Png$InputPngStream;", "writeInt", "Lorg/jetbrains/letsPlot/commons/encoding/Png$OutputStream;", "value", "writePngChunk", "type", "data", "ByteBuffer", "Crc32", "InputPngStream", "OutputStream", "commons"})
@SourceDebugExtension(value={"SMAP\nPng.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Png.kt\norg/jetbrains/letsPlot/commons/encoding/Png\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,348:1\n1313#2,2:349\n1#3:351\n*S KotlinDebug\n*F\n+ 1 Png.kt\norg/jetbrains/letsPlot/commons/encoding/Png\n*L\n91#1:349,2\n*E\n"})
public final class Png {
    @NotNull
    public static final Png INSTANCE = new Png();

    private Png() {
    }

    @NotNull
    public final String encodeDataImage(@NotNull Bitmap bitmap2) {
        Intrinsics.checkNotNullParameter((Object)bitmap2, (String)"bitmap");
        byte[] pngData = Png.encode$default(this, bitmap2, null, 2, null);
        String base64 = Base64.INSTANCE.encode(pngData);
        return "data:image/png;base64," + base64;
    }

    @NotNull
    public final Bitmap decodeDataImage(@NotNull String dataUrl) {
        Intrinsics.checkNotNullParameter((Object)dataUrl, (String)"dataUrl");
        String base64 = StringsKt.substringAfter$default((String)dataUrl, (String)"base64,", null, (int)2, null);
        byte[] pngData = Base64.INSTANCE.decode(base64);
        return this.decode(pngData);
    }

    private final byte[] buildPHYS(double dpiX, double dpiY, int unit) {
        long xPpm = RangesKt.coerceIn((long)MathKt.roundToLong((double)(dpiX / 0.0254)), (long)0L, (long)0xFFFFFFFFL);
        long yPpm = RangesKt.coerceIn((long)MathKt.roundToLong((double)(dpiY / 0.0254)), (long)0L, (long)0xFFFFFFFFL);
        ByteBuffer buf = new ByteBuffer(new byte[9]);
        buf.putInt((int)(xPpm & 0xFFFFFFFFL));
        buf.putInt((int)(yPpm & 0xFFFFFFFFL));
        buf.put((byte)unit);
        return buf.array();
    }

    static /* synthetic */ byte[] buildPHYS$default(Png png, double d, double d2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            d2 = d;
        }
        if ((n2 & 4) != 0) {
            n = 1;
        }
        return png.buildPHYS(d, d2, n);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] encode(@NotNull Bitmap bitmap2, @Nullable Number dpi) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)bitmap2, (String)"bitmap");
        OutputStream output = new OutputStream();
        byte[] byArray = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        output.write(byArray);
        this.writePngChunk(output, "IHDR", this.buildIHDR(bitmap2.getWidth(), bitmap2.getHeight()));
        if (dpi != null) {
            this.writePngChunk(output, "pHYs", Png.buildPHYS$default(this, dpi.doubleValue(), 0.0, 0, 6, null));
        }
        Png $this$encode_u24lambda_u241 = this;
        boolean bl = false;
        List rawScanlines = new ArrayList();
        Sequence sequence = SequencesKt.windowed$default((Sequence)ArraysKt.asSequence((byte[])bitmap2.rgbaBytes()), (int)(bitmap2.getWidth() * 4), (int)(bitmap2.getWidth() * 4), (boolean)false, (int)4, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            List it = (List)element$iv;
            boolean bl2 = false;
            ((Collection)rawScanlines).add((byte)0);
            CollectionsKt.addAll((Collection)rawScanlines, (Iterable)it);
        }
        byte[] rawScanlines2 = CollectionsKt.toByteArray((Collection)rawScanlines);
        byte[] deflated = Zip_jvmKt.deflate(rawScanlines2);
        this.writePngChunk(output, "IDAT", deflated);
        this.writePngChunk(output, "IEND", new byte[0]);
        return output.getByteArray();
    }

    public static /* synthetic */ byte[] encode$default(Png png, Bitmap bitmap2, Number number, int n, Object object) {
        if ((n & 2) != 0) {
            number = null;
        }
        return png.encode(bitmap2, number);
    }

    @NotNull
    public final Bitmap decode(@NotNull byte[] input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        InputPngStream stream = new InputPngStream(input);
        byte[] signature = new byte[8];
        stream.read(signature);
        byte[] byArray = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        byte[] expected = byArray;
        if (!Arrays.equals(signature, expected)) {
            boolean $i$a$-require-Png$decode$32 = false;
            String $i$a$-require-Png$decode$32 = "Invalid PNG signature";
            throw new IllegalArgumentException($i$a$-require-Png$decode$32.toString());
        }
        int width2 = 0;
        int height = 0;
        List idatChunks = new ArrayList();
        block5: while (true) {
            byte[] byArray2;
            int length = this.readInt(stream);
            byte[] it = byArray2 = new byte[4];
            boolean $i$a$-also-Png$decode$chunkType$22 = false;
            stream.read(it);
            byte[] chunkType = byArray2;
            String type = StringsKt.decodeToString((byte[])chunkType);
            Object $i$a$-also-Png$decode$chunkType$22 = new byte[length];
            byte[] it2 = $i$a$-also-Png$decode$chunkType$22;
            boolean bl = false;
            stream.read(it2);
            byte[] data = $i$a$-also-Png$decode$chunkType$22;
            stream.skip(4L);
            $i$a$-also-Png$decode$chunkType$22 = type;
            switch (((String)$i$a$-also-Png$decode$chunkType$22).hashCode()) {
                case 2243538: {
                    if (((String)$i$a$-also-Png$decode$chunkType$22).equals("IEND")) break block5;
                    continue block5;
                }
                case 2242190: {
                    if (((String)$i$a$-also-Png$decode$chunkType$22).equals("IDAT")) break;
                    continue block5;
                }
                case 2246125: {
                    if (!((String)$i$a$-also-Png$decode$chunkType$22).equals("IHDR")) continue block5;
                    ByteBuffer buffer = new ByteBuffer(data);
                    width2 = buffer.getInt();
                    height = buffer.getInt();
                    byte bitDepth = buffer.get();
                    byte colorType = buffer.get();
                    if (bitDepth == 8 && colorType == 6) continue block5;
                    boolean bl2 = false;
                    String string = "Only 8-bit RGBA PNG supported. Bit depth: " + bitDepth + ", Color type: " + colorType;
                    throw new IllegalArgumentException(string.toString());
                }
            }
            idatChunks.addAll(ArraysKt.toList((byte[])data));
        }
        byte[] compressed = CollectionsKt.toByteArray((Collection)idatChunks);
        int scanlineLength = width2 * 4 + 1;
        byte[] decompressed = Zip_jvmKt.inflate(compressed, scanlineLength * height);
        int strideLength = scanlineLength - 1;
        byte[] rgba = new byte[height * strideLength];
        int n = height;
        for (int rowIndex = 0; rowIndex < n; ++rowIndex) {
            int filterType = decompressed[rowIndex * scanlineLength] & 0xFF;
            if (filterType != 0) {
                throw new IllegalStateException(("Unsupported filter type: " + filterType).toString());
            }
            this.arraycopy(decompressed, rowIndex * scanlineLength + 1, rgba, rowIndex * strideLength, strideLength);
        }
        return Bitmap.Companion.fromRGBABytes(width2, height, rgba);
    }

    private final byte[] buildIHDR(int width2, int height) {
        ByteBuffer byteBuffer;
        ByteBuffer $this$buildIHDR_u24lambda_u246 = byteBuffer = new ByteBuffer(new byte[13]);
        boolean bl = false;
        $this$buildIHDR_u24lambda_u246.putInt(width2);
        $this$buildIHDR_u24lambda_u246.putInt(height);
        $this$buildIHDR_u24lambda_u246.put((byte)8);
        $this$buildIHDR_u24lambda_u246.put((byte)6);
        $this$buildIHDR_u24lambda_u246.put((byte)0);
        $this$buildIHDR_u24lambda_u246.put((byte)0);
        $this$buildIHDR_u24lambda_u246.put((byte)0);
        return byteBuffer.array();
    }

    private final void writePngChunk(OutputStream $this$writePngChunk, String type, byte[] data) {
        byte[] typeBytes = StringsKt.encodeToByteArray((String)type);
        byte[] crcInput = ArraysKt.plus((byte[])typeBytes, (byte[])data);
        int crc = Crc32.Companion.compute$default(Crc32.Companion, crcInput, 0, 0, 6, null);
        this.writeInt($this$writePngChunk, data.length);
        $this$writePngChunk.write(typeBytes);
        $this$writePngChunk.write(data);
        this.writeInt($this$writePngChunk, crc);
    }

    private final void writeInt(OutputStream $this$writeInt, int value) {
        $this$writeInt.write(value >> 24 & 0xFF);
        $this$writeInt.write(value >> 16 & 0xFF);
        $this$writeInt.write(value >> 8 & 0xFF);
        $this$writeInt.write(value & 0xFF);
    }

    private final int readInt(InputPngStream stream) {
        return stream.read() << 24 | stream.read() << 16 | stream.read() << 8 | stream.read();
    }

    private final void arraycopy(byte[] src, int srcPos, byte[] dest, int destPos, int length) {
        ArraysKt.copyInto((byte[])src, (byte[])dest, (int)destPos, (int)srcPos, (int)(srcPos + length));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\u0003J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\u0006J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tJ\u000e\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/letsPlot/commons/encoding/Png$ByteBuffer;", "", "buffer", "", "([B)V", "position", "", "array", "get", "", "getInt", "put", "", "value", "putInt", "commons"})
    private static final class ByteBuffer {
        @NotNull
        private final byte[] buffer;
        private int position;

        public ByteBuffer(@NotNull byte[] buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            this.buffer = buffer;
        }

        public final byte get() {
            if (this.position >= this.buffer.length) {
                throw new IndexOutOfBoundsException("Buffer underflow");
            }
            int n = this.position;
            this.position = n + 1;
            return this.buffer[n];
        }

        public final void put(byte value) {
            if (this.position >= this.buffer.length) {
                throw new IndexOutOfBoundsException("Buffer overflow");
            }
            int n = this.position;
            this.position = n + 1;
            this.buffer[n] = value;
        }

        public final int getInt() {
            return (this.get() & 0xFF) << 24 | (this.get() & 0xFF) << 16 | (this.get() & 0xFF) << 8 | this.get() & 0xFF;
        }

        public final void putInt(int value) {
            this.put((byte)(value >> 24));
            this.put((byte)(value >> 16));
            this.put((byte)(value >> 8));
            this.put((byte)value);
        }

        @NotNull
        public final byte[] array() {
            byte[] byArray = Arrays.copyOf(this.buffer, this.buffer.length);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
            return byArray;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0004J\u0006\u0010\u0006\u001a\u00020\u0007J\"\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\u00042\b\b\u0002\u0010\f\u001a\u00020\u0004J\u000e\u0010\b\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/letsPlot/commons/encoding/Png$Crc32;", "", "()V", "crc", "", "getValue", "reset", "", "update", "bytes", "", "offset", "length", "byte", "Companion", "commons"})
    private static final class Crc32 {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private int crc = -1;
        @NotNull
        private static final Lazy<int[]> crcTable$delegate = LazyKt.lazy((Function0)Companion.crcTable.2.INSTANCE);

        public final void update(int n) {
            int index = (this.crc ^ n) & 0xFF;
            this.crc = this.crc >>> 8 ^ Crc32.Companion.getCrcTable()[index];
        }

        public final void update(@NotNull byte[] bytes, int offset, int length) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            int n = offset + length;
            for (int i = offset; i < n; ++i) {
                this.update(bytes[i] & 0xFF);
            }
        }

        public static /* synthetic */ void update$default(Crc32 crc32, byte[] byArray, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n = 0;
            }
            if ((n3 & 4) != 0) {
                n2 = byArray.length;
            }
            crc32.update(byArray, n, n2);
        }

        public final int getValue() {
            return ~this.crc;
        }

        public final void reset() {
            this.crc = -1;
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\n2\b\b\u0002\u0010\u000e\u001a\u00020\nR\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/letsPlot/commons/encoding/Png$Crc32$Companion;", "", "()V", "crcTable", "", "getCrcTable", "()[I", "crcTable$delegate", "Lkotlin/Lazy;", "compute", "", "bytes", "", "offset", "length", "commons"})
        public static final class Companion {
            private Companion() {
            }

            public final int compute(@NotNull byte[] bytes, int offset, int length) {
                Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
                Crc32 crc32 = new Crc32();
                crc32.update(bytes, offset, length);
                return crc32.getValue();
            }

            public static /* synthetic */ int compute$default(Companion companion, byte[] byArray, int n, int n2, int n3, Object object) {
                if ((n3 & 2) != 0) {
                    n = 0;
                }
                if ((n3 & 4) != 0) {
                    n2 = byArray.length;
                }
                return companion.compute(byArray, n, n2);
            }

            private final int[] getCrcTable() {
                Lazy lazy = crcTable$delegate;
                return (int[])lazy.getValue();
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\n\u001a\u00020\u0006J\u000e\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0003J\u001e\u0010\n\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/letsPlot/commons/encoding/Png$InputPngStream;", "", "data", "", "([B)V", "available", "", "getAvailable", "()I", "i", "read", "outBuffer", "b", "off", "len", "skip", "", "toString", "", "commons"})
    @SourceDebugExtension(value={"SMAP\nPng.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Png.kt\norg/jetbrains/letsPlot/commons/encoding/Png$InputPngStream\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,348:1\n1#2:349\n*E\n"})
    private static final class InputPngStream {
        @NotNull
        private final byte[] data;
        private int i;

        public InputPngStream(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.data = data;
        }

        private final int getAvailable() {
            return this.data.length - this.i;
        }

        public final int read() {
            int n = this.i;
            this.i = n + 1;
            return this.data[n] & 0xFF;
        }

        public final int read(@NotNull byte[] b2, int off, int len) {
            Intrinsics.checkNotNullParameter((Object)b2, (String)"b");
            int read = 0;
            int end = Math.min(len, this.getAvailable());
            while (read < end) {
                b2[off + read++] = (byte)this.read();
            }
            return read;
        }

        public final long skip(long len) {
            int n;
            int it = n = Math.min(this.getAvailable(), (int)len);
            boolean bl = false;
            this.i += it;
            return n;
        }

        public final int read(@NotNull byte[] outBuffer) {
            Intrinsics.checkNotNullParameter((Object)outBuffer, (String)"outBuffer");
            return this.read(outBuffer, 0, outBuffer.length);
        }

        @NotNull
        public String toString() {
            return ArraysKt.joinToString$default((byte[])this.data, null, null, null, (int)0, null, (Function1)toString.1.INSTANCE, (int)31, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0010R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/letsPlot/commons/encoding/Png$OutputStream;", "", "()V", "buffer", "", "", "byteArray", "", "getByteArray", "()[B", "toString", "", "write", "", "data", "off", "", "len", "b", "commons"})
    @SourceDebugExtension(value={"SMAP\nPng.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Png.kt\norg/jetbrains/letsPlot/commons/encoding/Png$OutputStream\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,348:1\n1855#2,2:349\n*S KotlinDebug\n*F\n+ 1 Png.kt\norg/jetbrains/letsPlot/commons/encoding/Png$OutputStream\n*L\n330#1:349,2\n*E\n"})
    private static final class OutputStream {
        @NotNull
        private final List<Byte> buffer = new ArrayList();

        @NotNull
        public final byte[] getByteArray() {
            return CollectionsKt.toByteArray((Collection)this.buffer);
        }

        public final void write(@NotNull byte[] data, int off, int len) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)off, (int)(off + len));
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                int element$iv;
                int i = element$iv = ((IntIterator)iterator2).nextInt();
                boolean bl = false;
                this.buffer.add(data[i]);
            }
        }

        public final void write(int b2) {
            this.buffer.add((byte)b2);
        }

        public final void write(@NotNull byte[] data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.write(data, 0, data.length);
        }

        @NotNull
        public String toString() {
            return CollectionsKt.joinToString$default((Iterable)this.buffer, null, null, null, (int)0, null, (Function1)toString.1.INSTANCE, (int)31, null);
        }
    }
}

