/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.target.TargetEnvironmentType;
import com.intellij.javascript.nodejs.execution.NodeTargetRunOptions;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterType;
import com.intellij.javascript.nodejs.interpreter.NodeTargetRunSetup;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.util.NullableConsumer;
import com.intellij.util.text.SemVer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public abstract class NodeJsInterpreter {
    @NotNull
    public abstract NodeJsInterpreterType<? extends NodeJsInterpreter> getType();

    @NotNull
    @NonNls
    public abstract String getReferenceName();

    @NotNull
    @Nls
    public abstract String getPresentableName();

    @Nullable
    public abstract Ref<SemVer> getCachedVersion();

    public abstract void fetchVersion(@NotNull NullableConsumer<? super SemVer> var1);

    public void provideCachedVersionOrFetch(@NotNull NullableConsumer<? super SemVer> consumer) {
        Ref<SemVer> versionRef;
        if (consumer == null) {
            NodeJsInterpreter.$$$reportNull$$$0(0);
        }
        if ((versionRef = this.getCachedVersion()) != null) {
            consumer.consume(versionRef.get());
        } else {
            this.fetchVersion(consumer);
        }
    }

    @NotNull
    public Promise<SemVer> provideCachedVersionOrFetch() {
        Ref<SemVer> versionRef = this.getCachedVersion();
        if (versionRef != null) {
            Promise promise = Promises.resolvedPromise((Object)((SemVer)versionRef.get()));
            if (promise == null) {
                NodeJsInterpreter.$$$reportNull$$$0(1);
            }
            return promise;
        }
        AsyncPromise promise = new AsyncPromise();
        this.fetchVersion((NullableConsumer<? super SemVer>)((NullableConsumer)ver -> promise.setResult(ver)));
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            NodeJsInterpreter.$$$reportNull$$$0(2);
        }
        return asyncPromise;
    }

    @Nullable
    @InspectionMessage
    public abstract String validate(@Nullable Project var1);

    public boolean deepEquals(@Nullable NodeJsInterpreter other) {
        return this.equals(other);
    }

    @NotNull
    public NodeJsInterpreterRef toRef() {
        NodeJsInterpreterRef nodeJsInterpreterRef = NodeJsInterpreterRef.create(this.getReferenceName());
        if (nodeJsInterpreterRef == null) {
            NodeJsInterpreter.$$$reportNull$$$0(3);
        }
        return nodeJsInterpreterRef;
    }

    @NotNull
    public NodeTargetRunSetup createTargetRunSetup(@NotNull Project project, @NotNull NodeTargetRunOptions options) throws ExecutionException {
        if (project == null) {
            NodeJsInterpreter.$$$reportNull$$$0(4);
        }
        if (options == null) {
            NodeJsInterpreter.$$$reportNull$$$0(5);
        }
        throw new ExecutionException(JavaScriptBundle.message((String)"node.interpreter.unavailable.target", (Object[])new Object[]{this.getPresentableName()}));
    }

    @Nullable
    public TargetEnvironmentType<?> getTargetEnvironmentType() throws IllegalStateException {
        throw new IllegalStateException(JavaScriptBundle.message((String)"node.interpreter.unavailable.target", (Object[])new Object[]{this.getPresentableName()}));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreter";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "provideCachedVersionOrFetch";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "provideCachedVersionOrFetch";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createTargetRunSetup";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3 -> new IllegalStateException(string);
        };
    }
}

