/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.couchbase.introspector;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.introspector.BaseIntrospector;
import com.intellij.database.dialects.base.introspector.BaseNativeIntrospector;
import com.intellij.database.dialects.base.introspector.BaseSingleDatabaseIntrospector;
import com.intellij.database.dialects.couchbase.introspector.CouchbaseIntroQueries;
import com.intellij.database.dialects.couchbase.introspector.CouchbaseIntrospector;
import com.intellij.database.dialects.couchbase.introspector.CouchbaseIntrospector$applySchemas$lambda$0$;
import com.intellij.database.dialects.couchbase.model.CouchbaseIndex;
import com.intellij.database.dialects.couchbase.model.CouchbaseRoot;
import com.intellij.database.dialects.couchbase.model.CouchbaseSchema;
import com.intellij.database.dialects.couchbase.model.CouchbaseTable;
import com.intellij.database.dialects.couchbase.model.CouchbaseTableColumn;
import com.intellij.database.introspection.DBIntrospectionContext;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.layoutedQueries.DBTransaction;
import com.intellij.database.model.BaseModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DataType;
import com.intellij.database.model.ElementCacheKt;
import com.intellij.database.model.ElementCacheOptimizersKt;
import com.intellij.database.model.ElementChecker;
import com.intellij.database.model.ElementSearchCache;
import com.intellij.database.model.ElementSearcher;
import com.intellij.database.model.ElementSearcherNN;
import com.intellij.database.model.FamilySearcher;
import com.intellij.database.model.ModelFactory;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PerObjectVersion;
import com.intellij.database.model.SqlObjectBuilder;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModMateNamespace;
import com.intellij.database.model.basic.BasicModSchema;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.remote.jdba.core.ConnectionInfo;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.database.util.Version;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.psi.SqlCreateIndexStatement;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlStatement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 /2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0003./0B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0016J&\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0014J \u0010\u0014\u001a\u00020\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J4\u0010\u0019\u001a\u00020\u000b\"\b\b\u0000\u0010\u001a*\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u00182\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001a0 H\u0002J1\u0010!\u001a\u0004\u0018\u0001H\u001a\"\b\b\u0000\u0010\u001a*\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u00182\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H\u001a0 H\u0002\u00a2\u0006\u0002\u0010%J6\u0010&\u001a \u0012\u0006\b\u0001\u0012\u00020\u00020'R\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030(2\u0006\u0010)\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020\u0002H\u0014J6\u0010+\u001a \u0012\u0006\b\u0001\u0012\u00020\u00030,R\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030(2\u0006\u0010)\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020\u0003H\u0014\u00a8\u00061"}, d2={"Lcom/intellij/database/dialects/couchbase/introspector/CouchbaseIntrospector;", "Lcom/intellij/database/dialects/base/introspector/BaseSingleDatabaseIntrospector;", "Lcom/intellij/database/dialects/couchbase/model/CouchbaseRoot;", "Lcom/intellij/database/dialects/couchbase/model/CouchbaseSchema;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "<init>", "(Lcom/intellij/database/introspection/DBIntrospectionContext;Lcom/intellij/database/model/ModelFactory;)V", "retrieveAndApplySchemas", "", "introspectSchemasAuto", "tran", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schemas", "", "whole", "", "introspectNamespacesInTran", "applySchemas", "newSchemas", "Lcom/intellij/database/dialects/couchbase/introspector/CouchbaseIntroQueries$OneSchema;", "currentSchema", "", "buildObject", "T", "Lcom/intellij/sql/psi/SqlCreateStatement;", "obj", "Lcom/intellij/database/model/basic/BasicModElement;", "ddl", "statementClass", "Ljava/lang/Class;", "getStatement", "Lcom/intellij/sql/psi/SqlStatement;", "sql", "clazz", "(Ljava/lang/String;Ljava/lang/Class;)Lcom/intellij/sql/psi/SqlStatement;", "createDatabaseRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractDatabaseRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "transaction", "database", "createSchemaRetriever", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever;", "schema", "Factory", "Companion", "CouchbaseSchemaRetriever", "intellij.database.dialects.couchbase"})
@SourceDebugExtension(value={"SMAP\nCouchbaseIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CouchbaseIntrospector.kt\ncom/intellij/database/dialects/couchbase/introspector/CouchbaseIntrospector\n+ 2 ModelFun.kt\ncom/intellij/database/model/ModelFun\n+ 3 ElementCache.kt\ncom/intellij/database/model/FamilySearcher\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,276:1\n443#2,10:277\n453#2,9:297\n462#2:307\n454#2:308\n455#2,9:310\n464#2,3:320\n456#2:323\n457#2:325\n189#3,10:287\n202#3:324\n1869#4:306\n1870#4:319\n1#5:309\n*S KotlinDebug\n*F\n+ 1 CouchbaseIntrospector.kt\ncom/intellij/database/dialects/couchbase/introspector/CouchbaseIntrospector\n*L\n80#1:277,10\n80#1:297,9\n80#1:307\n80#1:308\n80#1:310,9\n80#1:320,3\n80#1:323\n80#1:325\n80#1:287,10\n80#1:324\n80#1:306\n80#1:319\n80#1:309\n*E\n"})
public final class CouchbaseIntrospector
extends BaseSingleDatabaseIntrospector<CouchbaseRoot, CouchbaseSchema> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public CouchbaseIntrospector(@NotNull DBIntrospectionContext context, @NotNull ModelFactory modelFactory) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
        BaseIntrospector.Nature nature = (BaseIntrospector.Nature)BaseIntrospector.DefaultNature.INSTANCE;
        Dbms dbms = Dbms.COUCHBASE_QUERY;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"COUCHBASE_QUERY");
        super(context, nature, dbms, modelFactory);
    }

    public void retrieveAndApplySchemas() {
        List schemas = (List)this.inTransaction(CouchbaseIntrospector::retrieveAndApplySchemas$lambda$0);
        this.applySchemas(schemas, this.getDbConnectionInfo().schemaName);
    }

    protected void introspectSchemasAuto(@NotNull DBTransaction tran, @NotNull List<? extends CouchbaseSchema> schemas, boolean whole) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        Intrinsics.checkNotNullParameter(schemas, (String)"schemas");
        for (CouchbaseSchema couchbaseSchema : schemas) {
            this.handleErrors("Introspect schema " + couchbaseSchema.getName(), () -> CouchbaseIntrospector.introspectSchemasAuto$lambda$0(this, tran, couchbaseSchema));
        }
    }

    protected void introspectNamespacesInTran(@NotNull DBTransaction tran) {
        Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
        List<CouchbaseIntroQueries.OneSchema> schemas = CouchbaseIntroQueries.INSTANCE.retrieveSchemas(tran);
        this.applySchemas(schemas, this.getDbConnectionInfo().schemaName);
    }

    private final void applySchemas(List<CouchbaseIntroQueries.OneSchema> newSchemas, String currentSchema) {
        this.inModel(arg_0 -> CouchbaseIntrospector.applySchemas$lambda$0(newSchemas, currentSchema, arg_0));
    }

    private final <T extends SqlCreateStatement> void buildObject(BasicModElement obj, String ddl, Class<T> statementClass) {
        if (obj == null) {
            return;
        }
        SqlCreateStatement sqlCreateStatement = (SqlCreateStatement)this.getStatement(ddl, statementClass);
        if (sqlCreateStatement == null) {
            return;
        }
        SqlCreateStatement statement = sqlCreateStatement;
        this.getSqlHelper().getBuilder().build(obj, (DasObject)statement, (SqlObjectBuilder.Context)this.getSqlHelper().getBuilderContext());
    }

    private final <T extends SqlStatement> T getStatement(String sql, Class<T> clazz) {
        if (sql == null) {
            return null;
        }
        try {
            return (T)((SqlStatement)this.getSqlHelper().statements(sql, clazz).first());
        }
        catch (Exception e) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.log.error((Throwable)e);
            }
            this.log.warn("Failed to parse sources", (Throwable)e);
            return null;
        }
    }

    @NotNull
    protected BaseNativeIntrospector.AbstractDatabaseRetriever<? extends CouchbaseRoot> createDatabaseRetriever(@NotNull DBTransaction transaction, @NotNull CouchbaseRoot database) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        return (BaseNativeIntrospector.AbstractDatabaseRetriever)new BaseNativeIntrospector.AbstractDatabaseRetriever<CouchbaseRoot>(this, transaction, database){};
    }

    @NotNull
    protected BaseNativeIntrospector.AbstractSchemaRetriever<? extends CouchbaseSchema> createSchemaRetriever(@NotNull DBTransaction transaction, @NotNull CouchbaseSchema schema) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        return new CouchbaseSchemaRetriever(transaction, schema);
    }

    private static final List retrieveAndApplySchemas$lambda$0(DBTransaction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return CouchbaseIntroQueries.INSTANCE.retrieveSchemas(it);
    }

    private static final Unit introspectSchemasAuto$lambda$0(CouchbaseIntrospector this$0, DBTransaction $tran, CouchbaseSchema $schema) {
        BaseNativeIntrospector.AbstractSchemaRetriever<? extends CouchbaseSchema> retriever = this$0.createSchemaRetriever($tran, $schema);
        retriever.process();
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Unit applySchemas$lambda$0(List $newSchemas, String $currentSchema, CouchbaseRoot root) {
        void $this$iv$iv$iv;
        void $this$applySchemasNamed$iv$iv;
        void searchCache$iv$iv;
        void $this$applySchemasNamed$iv;
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        ModNamingFamily<? extends CouchbaseSchema> modNamingFamily = root.getSchemas();
        Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getSchemas(...)");
        ModNamingFamily<? extends CouchbaseSchema> modNamingFamily2 = modNamingFamily;
        List scs$iv = $newSchemas;
        boolean $i$f$applySchemasNamed = false;
        void var6_6 = $this$applySchemasNamed$iv;
        ElementSearchCache elementSearchCache = new ElementSearchCache();
        List scs$iv$iv = scs$iv;
        boolean $i$f$applySchemasNamed2 = false;
        FamilySearcher familySearcher = ElementCacheOptimizersKt.byName((ElementChecker)ElementCacheKt.searchElement((ElementSearchCache)searchCache$iv$iv), (Function1)((Function1)new Function1<CouchbaseIntroQueries.OneSchema, String>(){

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final String invoke(Object $this$byName) {
                CouchbaseIntroQueries.OneSchema p0 = (CouchbaseIntroQueries.OneSchema)$this$byName;
                boolean bl = false;
                return p0.id;
            }
        })).inFamily((Family)$this$applySchemasNamed$iv$iv);
        Function2 filler$iv$iv$iv = applySchemas$lambda$0$$inlined$applySchemasNamed$2.INSTANCE;
        boolean $i$f$orCreateBulk = false;
        ArrayList items$iv$iv$iv = new ArrayList();
        ElementSearcherNN searcher$iv$iv$iv = ElementCacheKt.orCreateElement((ElementSearcher)((ElementSearcher)$this$iv$iv$iv), (Function1)new Function1<D, T>((FamilySearcher)$this$iv$iv$iv, filler$iv$iv$iv, items$iv$iv$iv){
            final /* synthetic */ FamilySearcher this$0;
            final /* synthetic */ Function2 $filler;
            final /* synthetic */ ArrayList $items;
            {
                this.this$0 = $receiver;
                this.$filler = $filler;
                this.$items = $items;
            }

            public final T invoke(D it) {
                BasicElement basicElement = BasicMetaUtils.getMetaObject((Family)this.this$0.getFamily()).newDataObject();
                Intrinsics.checkNotNullExpressionValue((Object)basicElement, (String)"newDataObject(...)");
                BasicElement basicElement2 = basicElement;
                FamilySearcher familySearcher = this.this$0;
                Function2 function2 = this.$filler;
                ArrayList arrayList = this.$items;
                BasicElement $this$invoke_u24lambda_u240 = basicElement2;
                boolean bl = false;
                familySearcher.fillImpl($this$invoke_u24lambda_u240, it, function2);
                ((Collection)arrayList).add($this$invoke_u24lambda_u240);
                return (T)basicElement2;
            }
        });
        try {
            void $this$applySchemasImpl$iv$iv$iv;
            ElementSearcherNN schemas$iv$iv = searcher$iv$iv$iv;
            boolean bl = false;
            void var17_18 = $this$applySchemasNamed$iv$iv;
            List scs$iv$iv$iv = scs$iv$iv;
            boolean $i$f$applySchemasImpl = false;
            $this$applySchemasImpl$iv$iv$iv.markChildrenAsSyncPending();
            Iterable $this$forEach$iv$iv$iv$iv = scs$iv$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                void s;
                void sc$iv$iv;
                Object element$iv$iv$iv$iv;
                Object sc$iv$iv$iv = element$iv$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                Object t = sc$iv$iv$iv;
                void $this$applySchemasNamed_u24lambda_u240_u240$iv$iv = $this$applySchemasImpl$iv$iv$iv;
                boolean bl3 = false;
                BasicModMateNamespace $this$applySchemasNamed_u24lambda_u240_u240_u240$iv$iv = (BasicModMateNamespace)schemas$iv$iv.find((Object)sc$iv$iv);
                boolean bl4 = false;
                CouchbaseIntroQueries.OneSchema oneSchema = (CouchbaseIntroQueries.OneSchema)sc$iv$iv;
                CouchbaseSchema $this$applySchemas_u24lambda_u240_u240 = (CouchbaseSchema)$this$applySchemasNamed_u24lambda_u240_u240_u240$iv$iv;
                boolean bl5 = false;
                $this$applySchemas_u24lambda_u240_u240.setCurrent(Intrinsics.areEqual((Object)s.name, (Object)$currentSchema));
            }
            $this$applySchemasImpl$iv$iv$iv.removeSyncPendingChildren();
            $this$applySchemasImpl$iv$iv$iv.sort();
        }
        finally {
            Family family = $this$iv$iv$iv.getFamily();
            Intrinsics.checkNotNull((Object)family, (String)"null cannot be cast to non-null type com.intellij.database.model.families.Family<T of com.intellij.database.model.FamilySearcher>");
            BaseModel.createBulk((Family)family, (Iterable)items$iv$iv$iv);
        }
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ ConnectionInfo access$getDbConnectionInfo(CouchbaseIntrospector $this) {
        return $this.getDbConnectionInfo();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/dialects/couchbase/introspector/CouchbaseIntrospector$Companion;", "Lcom/intellij/database/dialects/base/introspector/BaseIntrospector$Nature;", "<init>", "()V", "supportServerObjects", "", "getSupportServerObjects", "()Z", "supportLevelByLevelIntrospection", "getSupportLevelByLevelIntrospection", "supportFragmentIntrospection", "getSupportFragmentIntrospection", "supportFragmentKinds", "", "Lcom/intellij/database/model/ObjectKind;", "getSupportFragmentKinds", "()Ljava/util/Set;", "intellij.database.dialects.couchbase"})
    public static final class Companion
    implements BaseIntrospector.Nature {
        private Companion() {
        }

        public boolean getSupportServerObjects() {
            return false;
        }

        public boolean getSupportLevelByLevelIntrospection() {
            return false;
        }

        public boolean getSupportFragmentIntrospection() {
            return false;
        }

        @NotNull
        public Set<ObjectKind> getSupportFragmentKinds() {
            return SetsKt.emptySet();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u001e\u0012\u0004\u0012\u00020\u00020\u0001R\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00020\u0003B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0014J\b\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J<\u0010\u0013\u001a\u00020\u000e2\u000e\u0010\u0014\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00152\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00190\u00172\b\b\u0002\u0010\u001a\u001a\u00020\u0018H\u0002J\u0010\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002J\u0018\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u0018H\u0002J-\u0010#\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u00022\u001b\u0010$\u001a\u0017\u0012\b\u0012\u0006\u0012\u0002\b\u00030&\u0012\u0004\u0012\u00020\u000e0%\u00a2\u0006\u0002\b'H\u0002J@\u0010(\u001a\u00020\u000e2'\u0010)\u001a#\u0012\u0019\u0012\u0017\u0012\b\u0012\u0006\u0012\u0002\b\u00030&\u0012\u0004\u0012\u00020\u000e0%\u00a2\u0006\u0002\b'\u0012\u0004\u0012\u00020\u000e0%2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u000e0+H\u0082\bJ\u0010\u0010,\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u00a8\u0006-"}, d2={"Lcom/intellij/database/dialects/couchbase/introspector/CouchbaseIntrospector$CouchbaseSchemaRetriever;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector$AbstractSchemaRetriever;", "Lcom/intellij/database/dialects/couchbase/model/CouchbaseSchema;", "Lcom/intellij/database/dialects/base/introspector/BaseNativeIntrospector;", "Lcom/intellij/database/dialects/couchbase/model/CouchbaseRoot;", "transaction", "Lcom/intellij/database/layoutedQueries/DBTransaction;", "schema", "<init>", "(Lcom/intellij/database/dialects/couchbase/introspector/CouchbaseIntrospector;Lcom/intellij/database/layoutedQueries/DBTransaction;Lcom/intellij/database/dialects/couchbase/model/CouchbaseSchema;)V", "isPossibleToIntrospectSchemaIncrementally", "", "tran", "retrieveMainContent", "", "processPreliminaryPhase", "retrieveTables", "retrieveColumnsWithSampling", "retrieveColumnsWithInfer", "processProperties", "properties", "", "nameToTypes", "", "", "", "prefix", "retrieveIndices", "populateIndexColumns", "schemaIndex", "Lcom/intellij/database/dialects/couchbase/model/CouchbaseIndex;", "dbIndex", "Lcom/intellij/database/dialects/couchbase/introspector/CouchbaseIntroQueries$OneIndex;", "unquoteIndexColumnName", "name", "doForEachIndex", "f", "Lkotlin/Function1;", "Lcom/intellij/database/model/families/ModFamily;", "Lkotlin/ExtensionFunctionType;", "cleanupFamiliesWithoutSort", "v", "action", "Lkotlin/Function0;", "sortIndices", "intellij.database.dialects.couchbase"})
    @SourceDebugExtension(value={"SMAP\nCouchbaseIntrospector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CouchbaseIntrospector.kt\ncom/intellij/database/dialects/couchbase/introspector/CouchbaseIntrospector$CouchbaseSchemaRetriever\n+ 2 BaseIntrospectionFunctions.kt\ncom/intellij/database/dialects/base/introspector/BaseIntrospectionFunctions\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,276:1\n262#1,8:347\n179#2,7:277\n337#2,3:288\n340#2:293\n198#2,5:294\n204#2,5:304\n341#2:309\n337#2,3:314\n340#2:319\n198#2,5:320\n204#2,5:328\n341#2:333\n1563#3:284\n1634#3,3:285\n1869#3:299\n1056#3:300\n1869#3,2:301\n1870#3:303\n1563#3:310\n1634#3,3:311\n1869#3:325\n1056#3:326\n1870#3:327\n1869#3:334\n808#3,11:335\n1870#3:346\n1869#3,2:355\n37#4,2:291\n37#4,2:317\n*S KotlinDebug\n*F\n+ 1 CouchbaseIntrospector.kt\ncom/intellij/database/dialects/couchbase/introspector/CouchbaseIntrospector$CouchbaseSchemaRetriever\n*L\n205#1:347,8\n132#1:277,7\n153#1:288,3\n153#1:293\n153#1:294,5\n153#1:304,5\n153#1:309\n169#1:314,3\n169#1:319\n169#1:320,5\n169#1:328,5\n169#1:333\n153#1:284\n153#1:285,3\n154#1:299\n158#1:300\n159#1:301,2\n154#1:303\n169#1:310\n169#1:311,3\n170#1:325\n178#1:326\n170#1:327\n189#1:334\n195#1:335,11\n189#1:346\n259#1:355,2\n153#1:291,2\n169#1:317,2\n*E\n"})
    private final class CouchbaseSchemaRetriever
    extends BaseNativeIntrospector.AbstractSchemaRetriever<CouchbaseSchema> {
        public CouchbaseSchemaRetriever(@NotNull DBTransaction transaction, CouchbaseSchema schema) {
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            super((BaseNativeIntrospector)CouchbaseIntrospector.this, transaction, (BasicModSchema)schema);
        }

        protected boolean isPossibleToIntrospectSchemaIncrementally(@NotNull DBTransaction tran, @NotNull CouchbaseSchema schema) {
            Intrinsics.checkNotNullParameter((Object)tran, (String)"tran");
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            return false;
        }

        protected void retrieveMainContent() {
            this.inSchema(arg_0 -> CouchbaseSchemaRetriever.retrieveMainContent$lambda$0(this, CouchbaseIntrospector.this, arg_0));
        }

        public void processPreliminaryPhase() {
        }

        private final void retrieveTables(CouchbaseSchema schema) {
            ObjectKind objectKind = ObjectKind.TABLE;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"TABLE");
            CouchbaseIntrospector.this.reportRetrieving(objectKind);
            ModFamily $this$modifyAndCleanup_u24default$iv = (ModFamily)schema.getTables();
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyAndCleanup = false;
            $this$modifyAndCleanup_u24default$iv.markChildrenAsSyncPending();
            ModNamingFamily it = (ModNamingFamily)$this$modifyAndCleanup_u24default$iv;
            boolean bl = false;
            boolean sysSchema = Intrinsics.areEqual((Object)schema.getName(), (Object)"system");
            CouchbaseIntroQueries.INSTANCE.processTables(this.getTransaction(), schema, (Function1<? super CouchbaseIntroQueries.OneTable, Unit>)((Function1)arg_0 -> CouchbaseSchemaRetriever.retrieveTables$lambda$0$0(schema, sysSchema, this, arg_0)));
            $this$modifyAndCleanup_u24default$iv.removeSyncPendingChildren();
            $this$modifyAndCleanup_u24default$iv.sort();
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveColumnsWithSampling(CouchbaseSchema schema) {
            void families$iv$iv;
            void $this$mapTo$iv$iv;
            ObjectKind objectKind = ObjectKind.COLUMN;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"COLUMN");
            CouchbaseIntrospector.this.reportRetrieving(objectKind);
            ModNamingFamily<? extends CouchbaseTable> modNamingFamily = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getTables(...)");
            Iterable $this$map$iv = (Iterable)modNamingFamily;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                CouchbaseTable couchbaseTable = (CouchbaseTable)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getColumns());
            }
            ModFamily[] families$iv = (ModFamily[])((List)destination$iv$iv);
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            ModFamily[] $this$toTypedArray$iv$iv = families$iv;
            boolean $i$f$toTypedArray = false;
            ModFamily[] thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            ModFamily[] fs$iv = (ModFamily[])thisCollection$iv$iv.toArray(new ModPositioningNamingFamily[0]);
            $this$toTypedArray$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
            boolean removeUnaffected$iv$iv = removeUnaffected$iv;
            boolean $i$f$modifyFamiliesAndCleanup2 = false;
            for (void f$iv$iv : families$iv$iv) {
                f$iv$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            ModNamingFamily<? extends CouchbaseTable> modNamingFamily2 = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily2, (String)"getTables(...)");
            Iterable $this$forEach$iv = (Iterable)modNamingFamily2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$forEach$iv2;
                Iterable $this$sortedBy$iv;
                CouchbaseTable t = (CouchbaseTable)element$iv;
                boolean bl2 = false;
                if (!t.isSystem() && t.getIndices().isEmpty()) continue;
                short position = 0;
                position = 1;
                DBTransaction dBTransaction = this.getTransaction();
                Intrinsics.checkNotNull((Object)t);
                Iterable iterable2 = CouchbaseIntroQueries.INSTANCE.retrieveTableColumns(dBTransaction, t);
                boolean $i$f$sortedBy = false;
                $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        CouchbaseIntroQueries.OneTableColumns it = (CouchbaseIntroQueries.OneTableColumns)a;
                        boolean bl = false;
                        it = (CouchbaseIntroQueries.OneTableColumns)b;
                        Comparable comparable = (Comparable)((Object)it.name);
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)it.name)));
                    }
                });
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    CouchbaseIntroQueries.OneTableColumns c = (CouchbaseIntroQueries.OneTableColumns)element$iv2;
                    boolean bl3 = false;
                    short s = position;
                    position = (short)(s + 1);
                    CouchbaseTableColumn column = (CouchbaseTableColumn)t.getColumns().renewAt(s, c.name);
                    DataType dataType = DataTypeFactory.of((String)c.typeName);
                    Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
                    column.setStoredType(DasUnresolvedTypeReference.Companion.of(dataType));
                }
            }
            for (void f$iv$iv : families$iv$iv) {
                f$iv$iv.removeSyncPendingChildren();
                f$iv$iv.sort();
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void retrieveColumnsWithInfer(CouchbaseSchema schema) {
            void families$iv$iv;
            void $this$mapTo$iv$iv;
            ObjectKind objectKind = ObjectKind.COLUMN;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"COLUMN");
            CouchbaseIntrospector.this.reportRetrieving(objectKind);
            ModNamingFamily<? extends CouchbaseTable> modNamingFamily = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getTables(...)");
            Iterable $this$map$iv = (Iterable)modNamingFamily;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                CouchbaseTable couchbaseTable = (CouchbaseTable)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getColumns());
            }
            ModFamily[] families$iv = (ModFamily[])((List)destination$iv$iv);
            boolean removeUnaffected$iv = true;
            boolean $i$f$modifyFamiliesAndCleanup = false;
            ModFamily[] $this$toTypedArray$iv$iv = families$iv;
            boolean $i$f$toTypedArray = false;
            ModFamily[] thisCollection$iv$iv = $this$toTypedArray$iv$iv;
            ModFamily[] fs$iv = (ModFamily[])thisCollection$iv$iv.toArray(new ModPositioningNamingFamily[0]);
            $this$toTypedArray$iv$iv = Arrays.copyOf(fs$iv, fs$iv.length);
            boolean removeUnaffected$iv$iv = removeUnaffected$iv;
            boolean $i$f$modifyFamiliesAndCleanup2 = false;
            for (void f$iv$iv : families$iv$iv) {
                f$iv$iv.markChildrenAsSyncPending();
            }
            boolean bl = false;
            ModNamingFamily<? extends CouchbaseTable> modNamingFamily2 = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily2, (String)"getTables(...)");
            Iterable $this$forEach$iv = (Iterable)modNamingFamily2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CouchbaseTable t = (CouchbaseTable)element$iv;
                boolean bl2 = false;
                Map nameToType = new LinkedHashMap();
                DBTransaction dBTransaction = this.getTransaction();
                Intrinsics.checkNotNull((Object)t);
                CouchbaseIntroQueries.INSTANCE.inferTableSchema(dBTransaction, t, (Function1<? super CouchbaseIntroQueries.OneInferTableInfo, Unit>)((Function1)arg_0 -> CouchbaseSchemaRetriever.retrieveColumnsWithInfer$lambda$1$0$0(this, nameToType, arg_0)));
                short position = 1;
                Iterable $this$sortedBy$iv = nameToType.entrySet();
                boolean $i$f$sortedBy = false;
                for (Map.Entry entry : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Map.Entry it = (Map.Entry)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)((String)it.getKey()));
                        it = (Map.Entry)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getKey()))));
                    }
                })) {
                    String name2 = (String)entry.getKey();
                    Set types = (Set)entry.getValue();
                    short s = position;
                    position = (short)(s + 1);
                    CouchbaseTableColumn column = (CouchbaseTableColumn)t.getColumns().renewAt(s, name2);
                    DataType dataType = DataTypeFactory.of((String)CollectionsKt.joinToString$default((Iterable)types, (CharSequence)"|", null, null, (int)0, null, null, (int)62, null));
                    Intrinsics.checkNotNullExpressionValue((Object)dataType, (String)"of(...)");
                    column.setStoredType(DasUnresolvedTypeReference.Companion.of(dataType));
                }
            }
            for (void f$iv$iv : families$iv$iv) {
                f$iv$iv.removeSyncPendingChildren();
                f$iv$iv.sort();
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void processProperties(Map<?, ?> properties, Map<String, Set<String>> nameToTypes, String prefix) {
            Iterable $this$forEach$iv = properties.entrySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Iterable<Object> iterable;
                Object newTypes;
                String shortName;
                Map.Entry entry = (Map.Entry)element$iv;
                boolean bl = false;
                Object key = entry.getKey();
                Object value = entry.getValue();
                Object k = key;
                if (k == null || (k = k.toString()) == null) {
                    k = "unnamed";
                }
                char[] cArray = new char[]{'\\', '.'};
                Intrinsics.checkNotNullExpressionValue((Object)StringUtil.escapeChars(k, (char[])cArray), (String)"escapeChars(...)");
                String name2 = ((CharSequence)prefix).length() == 0 ? shortName : prefix + "." + shortName;
                Intrinsics.checkNotNullExpressionValue((Object)nameToTypes.computeIfAbsent(name2, arg_0 -> CouchbaseSchemaRetriever.processProperties$lambda$0$1(CouchbaseSchemaRetriever::processProperties$lambda$0$0, arg_0)), (String)"computeIfAbsent(...)");
                Map map = value instanceof Map ? (Map)value : null;
                Object object = newTypes = map != null ? map.get("type") : null;
                if (newTypes instanceof String) {
                    v3 = types.add(newTypes);
                } else if (newTypes instanceof Collection) {
                    void $this$filterIsInstanceTo$iv$iv;
                    void $this$filterIsInstance$iv;
                    iterable = (Iterable)newTypes;
                    Set set = types;
                    boolean $i$f$filterIsInstance = false;
                    void var19_19 = $this$filterIsInstance$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterIsInstanceTo = false;
                    for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof String)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    v3 = set.addAll((List)destination$iv$iv);
                } else {
                    v3 = types.add("unknown");
                }
                Map map2 = value instanceof Map ? (Map)value : null;
                iterable = map2 != null ? map2.get("properties") : null;
                Map subProperties = iterable instanceof Map ? (Map)((Object)iterable) : null;
                if (subProperties == null) continue;
                this.processProperties(subProperties, nameToTypes, name2);
            }
        }

        static /* synthetic */ void processProperties$default(CouchbaseSchemaRetriever couchbaseSchemaRetriever, Map map, Map map2, String string, int n, Object object) {
            if ((n & 4) != 0) {
                string = "";
            }
            couchbaseSchemaRetriever.processProperties(map, map2, string);
        }

        private final void retrieveIndices(CouchbaseSchema schema) {
            ObjectKind objectKind = ObjectKind.INDEX;
            Intrinsics.checkNotNullExpressionValue((Object)objectKind, (String)"INDEX");
            CouchbaseIntrospector.this.reportRetrieving(objectKind);
            CouchbaseSchemaRetriever couchbaseSchemaRetriever = this;
            CouchbaseIntrospector couchbaseIntrospector = CouchbaseIntrospector.this;
            boolean $i$f$cleanupFamiliesWithoutSort = false;
            Function1 it = cleanupFamiliesWithoutSort.1.INSTANCE;
            boolean bl = false;
            this.doForEachIndex(schema, it);
            boolean bl2 = false;
            CouchbaseIntroQueries.INSTANCE.processIndices(this.getTransaction(), schema, (Function1<? super CouchbaseIntroQueries.OneIndex, Unit>)((Function1)arg_0 -> CouchbaseSchemaRetriever.retrieveIndices$lambda$1$0(schema, this, arg_0)));
            if (schema.getTables().size() != 0) {
                CouchbaseIntroQueries.INSTANCE.processIndicesAdditional(this.getTransaction(), (Function1<? super CouchbaseIntroQueries.OneIndexAdditional, Unit>)((Function1)arg_0 -> CouchbaseSchemaRetriever.retrieveIndices$lambda$1$1(schema, couchbaseIntrospector, arg_0)));
            }
            it = cleanupFamiliesWithoutSort.2.INSTANCE;
            bl = false;
            this.doForEachIndex(schema, it);
        }

        private final void populateIndexColumns(CouchbaseIndex schemaIndex, CouchbaseIntroQueries.OneIndex dbIndex) {
            List<String> columns = dbIndex.index_key;
            LinkedHashSet<String> cols = new LinkedHashSet<String>();
            HashSet<String> revs = new HashSet<String>();
            Collection collection = columns;
            if (collection == null || collection.isEmpty()) {
                schemaIndex.setColNames(CollectionsKt.listOf((Object)"id"));
                schemaIndex.setReverseColNames(SetsKt.emptySet());
                return;
            }
            for (String col : columns) {
                String string;
                boolean isReverse = StringsKt.endsWith$default((String)col, (String)"DESC", (boolean)false, (int)2, null);
                if (isReverse) {
                    String string2 = col.substring(0, StringsKt.lastIndexOf$default((CharSequence)col, (String)"DESC", (int)0, (boolean)false, (int)6, null));
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                } else {
                    string = col;
                }
                String quotedName = string;
                String colName = this.unquoteIndexColumnName(((Object)StringsKt.trim((CharSequence)quotedName)).toString());
                cols.add(colName);
                if (!isReverse) continue;
                revs.add(colName);
            }
            schemaIndex.setColNames(CollectionsKt.toList((Iterable)cols));
            schemaIndex.setReverseColNames(revs);
        }

        private final String unquoteIndexColumnName(String name2) {
            if (StringsKt.startsWith$default((String)name2, (String)"(", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)name2, (String)")", (boolean)false, (int)2, null)) {
                String string = name2.substring(1, StringsKt.getLastIndex((CharSequence)name2));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                return string;
            }
            return name2;
        }

        private final void doForEachIndex(CouchbaseSchema schema, Function1<? super ModFamily<?>, Unit> f) {
            ModNamingFamily<? extends CouchbaseTable> modNamingFamily = schema.getTables();
            Intrinsics.checkNotNullExpressionValue(modNamingFamily, (String)"getTables(...)");
            Iterable $this$forEach$iv = (Iterable)modNamingFamily;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CouchbaseTable t = (CouchbaseTable)element$iv;
                boolean bl = false;
                ModNamingFamily<? extends CouchbaseIndex> modNamingFamily2 = t.getIndices();
                Intrinsics.checkNotNullExpressionValue(modNamingFamily2, (String)"getIndices(...)");
                f.invoke(modNamingFamily2);
            }
        }

        private final void cleanupFamiliesWithoutSort(Function1<? super Function1<? super ModFamily<?>, Unit>, Unit> v, Function0<Unit> action) {
            boolean $i$f$cleanupFamiliesWithoutSort = false;
            v.invoke((Object)cleanupFamiliesWithoutSort.1.INSTANCE);
            action.invoke();
            v.invoke((Object)cleanupFamiliesWithoutSort.2.INSTANCE);
        }

        private final void sortIndices(CouchbaseSchema schema) {
            this.doForEachIndex(schema, CouchbaseSchemaRetriever::sortIndices$lambda$0);
        }

        /*
         * Unable to fully structure code
         */
        private static final Unit retrieveMainContent$lambda$0(CouchbaseSchemaRetriever this$0, CouchbaseIntrospector this$1, CouchbaseSchema schema) {
            Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
            this$0.retrieveTables(schema);
            this$0.retrieveIndices(schema);
            if (Intrinsics.areEqual((Object)schema.getName(), (Object)"system")) ** GOTO lbl-1000
            var3_3 = new int[]{0, 5};
            if (CouchbaseIntrospector.access$getDbConnectionInfo((CouchbaseIntrospector)this$1).driverVersion.less(var3_3)) lbl-1000:
            // 2 sources

            {
                this$0.retrieveColumnsWithSampling(schema);
            } else {
                this$0.retrieveColumnsWithInfer(schema);
            }
            this$0.sortIndices(schema);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveTables$lambda$0$0(CouchbaseSchema $schema, boolean $sysSchema, CouchbaseSchemaRetriever this$0, CouchbaseIntroQueries.OneTable t) {
            CouchbaseIntroQueries.OneTableSettings tableSettings;
            Object object;
            CouchbaseIntroQueries.OneTableSettings oneTableSettings;
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            ModNamingFamily<? extends CouchbaseTable> modNamingFamily = $schema.getTables();
            String string = t.id;
            if (string == null) {
                string = t.name;
            }
            Intrinsics.checkNotNull((Object)string);
            CouchbaseTable table = (CouchbaseTable)modNamingFamily.createOrGet(string);
            table.setSystem($sysSchema);
            if ($sysSchema) {
                oneTableSettings = null;
            } else {
                DBTransaction dBTransaction = this$0.getTransaction();
                Intrinsics.checkNotNull((Object)table);
                oneTableSettings = CouchbaseIntroQueries.INSTANCE.retrieveTableAdditional(dBTransaction, table);
            }
            table.setFlushEnabled((object = (tableSettings = oneTableSettings)) != null && (object = ((CouchbaseIntroQueries.OneTableSettings)object).flushEnabled) != null ? (Boolean)object : false);
            Object object2 = tableSettings;
            table.setRamQuotaMB(object2 != null && (object2 = ((CouchbaseIntroQueries.OneTableSettings)object2).ramQuotaMB) != null ? (Long)object2 : 100L);
            Object object3 = tableSettings;
            table.setReplicaNumber(object3 != null && (object3 = ((CouchbaseIntroQueries.OneTableSettings)object3).replicaNumber) != null ? (Integer)object3 : 1);
            Object object4 = tableSettings;
            table.setReplicaIndexes(object4 != null && (object4 = ((CouchbaseIntroQueries.OneTableSettings)object4).replicaIndexes) != null ? (Boolean)object4 : false);
            Object object5 = tableSettings;
            table.setMaxTTL(object5 != null && (object5 = ((CouchbaseIntroQueries.OneTableSettings)object5).maxTTL) != null ? (Integer)object5 : 0);
            Object object6 = tableSettings;
            if (object6 == null || (object6 = ((CouchbaseIntroQueries.OneTableSettings)object6).compressionMode) == null) {
                object6 = "passive";
            }
            table.setCompressionMode((String)object6);
            Object object7 = tableSettings;
            if (object7 == null || (object7 = ((CouchbaseIntroQueries.OneTableSettings)object7).bucketType) == null) {
                object7 = "membase";
            }
            table.setBucketType((String)object7);
            Object object8 = tableSettings;
            if (object8 == null || (object8 = ((CouchbaseIntroQueries.OneTableSettings)object8).conflictResolutionType) == null) {
                object8 = "seqno";
            }
            table.setConflictResolutionType((String)object8);
            Object object9 = tableSettings;
            if (object9 == null || (object9 = ((CouchbaseIntroQueries.OneTableSettings)object9).evictionPolicy) == null) {
                object9 = "valueOnly";
            }
            table.setEvictionPolicy((String)object9);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveColumnsWithInfer$lambda$1$0$0(CouchbaseSchemaRetriever this$0, Map $nameToType, CouchbaseIntroQueries.OneInferTableInfo info) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                Map<Object, ? extends Object> map = info.properties;
                if (map == null) break block0;
                Map<Object, ? extends Object> it = map;
                boolean bl = false;
                CouchbaseSchemaRetriever.processProperties$default(this$0, it, $nameToType, null, 4, null);
            }
            return Unit.INSTANCE;
        }

        private static final Set processProperties$lambda$0$0(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new LinkedHashSet();
        }

        private static final Set processProperties$lambda$0$1(Function1 $tmp0, Object p0) {
            return (Set)$tmp0.invoke(p0);
        }

        private static final Unit retrieveIndices$lambda$1$0(CouchbaseSchema $schema, CouchbaseSchemaRetriever this$0, CouchbaseIntroQueries.OneIndex i) {
            Intrinsics.checkNotNullParameter((Object)i, (String)"i");
            CouchbaseTable couchbaseTable = (CouchbaseTable)$schema.getTables().get(i.keyspace_id);
            if (couchbaseTable == null) {
                return Unit.INSTANCE;
            }
            CouchbaseTable table = couchbaseTable;
            CouchbaseIndex index = (CouchbaseIndex)table.getIndices().createOrGet(i.name);
            index.setCondition(i.condition);
            index.setUnique(i.is_primary);
            index.setUsing(i.using);
            index.setPartition(i.partition);
            Intrinsics.checkNotNull((Object)index);
            this$0.populateIndexColumns(index, i);
            return Unit.INSTANCE;
        }

        private static final Unit retrieveIndices$lambda$1$1(CouchbaseSchema $schema, CouchbaseIntrospector this$0, CouchbaseIntroQueries.OneIndexAdditional i) {
            CouchbaseIndex index;
            Intrinsics.checkNotNullParameter((Object)i, (String)"i");
            String string = i.bucket;
            if (string == null) {
                return Unit.INSTANCE;
            }
            String tableName = string;
            CouchbaseTable couchbaseTable = (CouchbaseTable)$schema.getTables().get(tableName);
            if (couchbaseTable == null) {
                return Unit.INSTANCE;
            }
            CouchbaseTable table = couchbaseTable;
            String string2 = i.indexName;
            if (string2 == null) {
                return Unit.INSTANCE;
            }
            String indexName = string2;
            CouchbaseIndex couchbaseIndex = index = (CouchbaseIndex)table.getIndices().get(indexName);
            if (couchbaseIndex != null) {
                Integer n = i.numReplica;
                couchbaseIndex.setNumReplica(n != null ? n : 0);
            }
            CouchbaseIndex couchbaseIndex2 = index;
            int defaultPartitions = (couchbaseIndex2 != null ? couchbaseIndex2.getPartition() : null) == null ? 1 : 8;
            CouchbaseIndex couchbaseIndex3 = index;
            if (couchbaseIndex3 != null) {
                Integer n = i.numPartition;
                couchbaseIndex3.setNumPartition(n != null ? n : defaultPartitions);
            }
            this$0.buildObject((BasicModElement)index, i.definition, SqlCreateIndexStatement.class);
            return Unit.INSTANCE;
        }

        private static final Unit sortIndices$lambda$0(ModFamily $this$doForEachIndex) {
            Intrinsics.checkNotNullParameter((Object)$this$doForEachIndex, (String)"$this$doForEachIndex");
            $this$doForEachIndex.sort();
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u00020\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/intellij/database/dialects/couchbase/introspector/CouchbaseIntrospector$Factory;", "Lcom/intellij/database/introspection/DBIntrospector$Factory;", "<init>", "()V", "isSupported", "", "version", "Lcom/intellij/database/util/Version;", "createIntrospector", "Lcom/intellij/database/introspection/DBIntrospector;", "context", "Lcom/intellij/database/introspection/DBIntrospectionContext;", "dbms", "Lcom/intellij/database/Dbms;", "modelFactory", "Lcom/intellij/database/model/ModelFactory;", "getVersion", "", "kind", "Lcom/intellij/database/model/ObjectKind;", "isOutdatedCheckSupported", "e", "Lcom/intellij/database/model/basic/BasicElement;", "VERSION", "intellij.database.dialects.couchbase"})
    public static final class Factory
    implements DBIntrospector.Factory {
        public boolean isSupported(@NotNull Version version) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            int[] nArray = new int[]{6, 5};
            return version.isOrGreater(nArray);
        }

        @NotNull
        public DBIntrospector createIntrospector(@NotNull DBIntrospectionContext context, @NotNull Dbms dbms, @NotNull ModelFactory modelFactory) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
            Intrinsics.checkNotNullParameter((Object)modelFactory, (String)"modelFactory");
            return (DBIntrospector)new CouchbaseIntrospector(context, modelFactory);
        }

        public int getVersion(@NotNull ObjectKind kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return VERSION.INSTANCE.get(kind);
        }

        public boolean isOutdatedCheckSupported(@Nullable BasicElement e) {
            return false;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/database/dialects/couchbase/introspector/CouchbaseIntrospector$Factory$VERSION;", "Lcom/intellij/database/model/PerObjectVersion;", "<init>", "()V", "intellij.database.dialects.couchbase"})
        public static final class VERSION
        extends PerObjectVersion {
            @NotNull
            public static final VERSION INSTANCE = new VERSION();

            private VERSION() {
            }
        }
    }
}

