/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.inspections.fixes;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiField;
import com.intellij.ws.rest.RSBundle;
import com.intellij.ws.rest.utils.RSUtils;
import org.jetbrains.annotations.NotNull;

public class AnnotateElementWithPathParamFix
implements LocalQuickFix {
    private final PsiField myField;
    private final String myName;

    public AnnotateElementWithPathParamFix(PsiField field, String name) {
        this.myField = field;
        this.myName = name;
    }

    @NotNull
    public String getFamilyName() {
        String string = RSBundle.message("annotate.field.with.path.param", this.myName, this.myName);
        if (string == null) {
            AnnotateElementWithPathParamFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            AnnotateElementWithPathParamFix.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            AnnotateElementWithPathParamFix.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().runWriteAction(() -> RSUtils.annotateFieldWithPathParam(project, this.myField, this.myName));
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull ProblemDescriptor previewDescriptor) {
        if (project == null) {
            AnnotateElementWithPathParamFix.$$$reportNull$$$0(3);
        }
        if (previewDescriptor == null) {
            AnnotateElementWithPathParamFix.$$$reportNull$$$0(4);
        }
        return new IntentionPreviewInfo.CustomDiff((FileType)JavaFileType.INSTANCE, "", "@PathParam(\"" + this.myName + "\") " + this.myField.getText());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/rest/inspections/fixes/AnnotateElementWithPathParamFix";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/rest/inspections/fixes/AnnotateElementWithPathParamFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

