/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.search.SpringGlobalSearchScopes;
import com.intellij.util.Query;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

final class BeanClassSearchInheritorsCache {
    private static final Key<CachedValue<Map<PsiClass, Collection<SpringModelSearchParameters.BeanClass>>>> WITHOUT_TESTS = Key.create((String)"BeanClassSearchInheritorsCache");
    private static final Key<CachedValue<Map<PsiClass, Collection<SpringModelSearchParameters.BeanClass>>>> INCLUDE_TESTS = Key.create((String)"BeanClassSearchInheritorsCache_Tests");

    BeanClassSearchInheritorsCache() {
    }

    static Collection<SpringModelSearchParameters.BeanClass> getInheritorSearchParameters(Module module, boolean isInTestSource, SpringModelSearchParameters.BeanClass parameters) {
        PsiClass searchClass = PsiTypesUtil.getPsiClass((PsiType)parameters.getSearchType());
        if (searchClass == null) {
            return Collections.emptyList();
        }
        Map<PsiClass, Collection<SpringModelSearchParameters.BeanClass>> cache = BeanClassSearchInheritorsCache.getCache(module, isInTestSource);
        return cache.get(searchClass);
    }

    private static Map<PsiClass, Collection<SpringModelSearchParameters.BeanClass>> getCache(Module module, boolean isInTestSource) {
        return (Map)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, BeanClassSearchInheritorsCache.getCacheKey(isInTestSource), () -> {
            ConcurrentMap map = ConcurrentFactoryMap.createMap(searchClass -> {
                if (BeanClassSearchInheritorsCache.canSearchForInheritors(searchClass)) {
                    SmartList inheritorSearchParameters = new SmartList();
                    GlobalSearchScope inheritorsSearchScope = SpringGlobalSearchScopes.runtime((Module)module, (boolean)isInTestSource);
                    Query inheritorsQuery = ClassInheritorsSearch.search((PsiClass)searchClass, (SearchScope)inheritorsSearchScope, (boolean)true, (boolean)true, (boolean)false);
                    inheritorsQuery.asIterable().forEach(arg_0 -> BeanClassSearchInheritorsCache.lambda$getCache$0((List)inheritorSearchParameters, arg_0));
                    return inheritorSearchParameters.isEmpty() ? Collections.emptyList() : inheritorSearchParameters;
                }
                return Collections.emptyList();
            });
            return CachedValueProvider.Result.create((Object)map, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        }, false);
    }

    private static Key<CachedValue<Map<PsiClass, Collection<SpringModelSearchParameters.BeanClass>>>> getCacheKey(boolean isInTestSource) {
        return isInTestSource ? INCLUDE_TESTS : WITHOUT_TESTS;
    }

    private static boolean canSearchForInheritors(PsiClass psiClass) {
        return !"java.lang.Object".equals(psiClass.getQualifiedName());
    }

    private static boolean canBeInstantiated(PsiClass inheritor) {
        return !inheritor.isInterface() && !inheritor.hasModifierProperty("abstract") && !inheritor.hasModifierProperty("private") && inheritor.getQualifiedName() != null;
    }

    private static /* synthetic */ void lambda$getCache$0(List inheritorSearchParameters, PsiClass psiClass) {
        if (BeanClassSearchInheritorsCache.canBeInstantiated(psiClass)) {
            SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)psiClass);
            inheritorSearchParameters.add(searchParameters);
        }
    }
}

