/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.charset;

import com.oracle.truffle.regex.charset.CodePointSet;
import com.oracle.truffle.regex.charset.CodePointSetAccumulator;
import com.oracle.truffle.regex.tregex.parser.CaseFoldData;
import com.oracle.truffle.regex.tregex.util.json.JsonConvertible;
import com.oracle.truffle.regex.tregex.util.json.JsonValue;
import org.graalvm.collections.EconomicSet;

public final class ClassSetContents
implements JsonConvertible {
    private final Kind kind;
    private final CodePointSet codePointSet;
    private final EconomicSet<String> strings;
    private final boolean mayContainStrings;

    private ClassSetContents(Kind kind, CodePointSet codePointSet, EconomicSet<String> strings, boolean mayContainStrings) {
        this.kind = kind;
        this.codePointSet = codePointSet;
        this.strings = strings;
        this.mayContainStrings = mayContainStrings;
    }

    public static ClassSetContents createCharacter(int codePoint) {
        return new ClassSetContents(Kind.Character, CodePointSet.create(codePoint), EconomicSet.create(), false);
    }

    public static ClassSetContents createUnicodePropertyOfStrings(CodePointSet codePointSet, EconomicSet<String> strings) {
        return new ClassSetContents(Kind.Class, codePointSet, strings, true);
    }

    public static ClassSetContents createCharacterClass(CodePointSet codePointSet) {
        return new ClassSetContents(Kind.Class, codePointSet, EconomicSet.create(), false);
    }

    public static ClassSetContents createClass(CodePointSet codePointSet, EconomicSet<String> strings, boolean mayContainStrings) {
        return new ClassSetContents(Kind.Class, codePointSet, strings, mayContainStrings);
    }

    public static ClassSetContents createStrings(CodePointSet singleCodePoints, EconomicSet<String> strings) {
        return new ClassSetContents(Kind.Strings, singleCodePoints, strings, !strings.isEmpty());
    }

    public static ClassSetContents createRange(int lo, int hi) {
        return new ClassSetContents(Kind.Range, CodePointSet.create(lo, hi), EconomicSet.create(), false);
    }

    public static ClassSetContents createPOSIXCollationElement(int codePoint) {
        return new ClassSetContents(Kind.POSIXCollationElement, CodePointSet.create(codePoint), EconomicSet.create(), false);
    }

    public static ClassSetContents createPOSIXCollationElement(String string) {
        EconomicSet<String> strings = EconomicSet.create();
        strings.add(string);
        return new ClassSetContents(Kind.POSIXCollationElement, CodePointSet.getEmpty(), strings, true);
    }

    public static ClassSetContents createPOSIXCollationEquivalenceClass(int codePoint) {
        return new ClassSetContents(Kind.POSIXCollationEquivalenceClass, CodePointSet.create(codePoint), EconomicSet.create(), false);
    }

    public static ClassSetContents createPOSIXCollationEquivalenceClass(String string) {
        EconomicSet<String> strings = EconomicSet.create();
        strings.add(string);
        return new ClassSetContents(Kind.POSIXCollationEquivalenceClass, CodePointSet.getEmpty(), strings, true);
    }

    public ClassSetContents caseFold(CodePointSetAccumulator tmp) {
        EconomicSet<String> foldedStrings = EconomicSet.create(this.strings.size());
        for (String string : this.strings) {
            foldedStrings.add(CaseFoldData.icuSimpleCaseFold(string));
        }
        return new ClassSetContents(this.kind, CaseFoldData.simpleCaseFold(this.codePointSet, tmp), foldedStrings, this.mayContainStrings);
    }

    public EconomicSet<String> getStrings() {
        return this.strings;
    }

    public CodePointSet getCodePointSet() {
        return this.codePointSet;
    }

    public boolean isCharacter() {
        return this.kind == Kind.Character;
    }

    public boolean isRange() {
        return this.kind == Kind.Range;
    }

    public boolean isPosixCollationEquivalenceClass() {
        return this.kind == Kind.POSIXCollationEquivalenceClass;
    }

    public boolean isAllowedInRange() {
        return this.kind == Kind.Character || this.kind == Kind.POSIXCollationElement || this.kind == Kind.POSIXCollationEquivalenceClass;
    }

    public int getCodePoint() {
        assert (this.isAllowedInRange());
        return this.codePointSet.getLo(0);
    }

    public boolean isCodePointSetOnly() {
        return this.strings.isEmpty();
    }

    public boolean mayContainStrings() {
        return this.mayContainStrings;
    }

    @Override
    public JsonValue toJson() {
        return null;
    }

    static enum Kind {
        Character,
        Class,
        Strings,
        Range,
        POSIXCollationElement,
        POSIXCollationEquivalenceClass;

    }
}

