/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.Dbms;
import com.intellij.database.types.DasTypeCategory;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.impl.SqlPsiUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a&\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a \u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a \u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\u0010"}, d2={"calcTypeForBinaryExpression", "Lcom/intellij/database/types/DasTypeCategory;", "lType", "rType", "sign", "Lcom/intellij/psi/tree/IElementType;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "convertsToNumeric", "", "type", "dbms", "Lcom/intellij/database/Dbms;", "convertsToInt", "balanceNumericTypes", "balanceIntTypes", "intellij.database.sql.core.impl"})
public final class SqlTypeConversionUtilKt {
    @NotNull
    public static final DasTypeCategory calcTypeForBinaryExpression(@NotNull DasTypeCategory lType, @NotNull DasTypeCategory rType, @NotNull IElementType sign, @NotNull SqlLanguageDialectEx dialect) {
        Intrinsics.checkNotNullParameter((Object)lType, (String)"lType");
        Intrinsics.checkNotNullParameter((Object)rType, (String)"rType");
        Intrinsics.checkNotNullParameter((Object)sign, (String)"sign");
        Intrinsics.checkNotNullParameter((Object)((Object)dialect), (String)"dialect");
        Dbms dbms = dialect.getDbms();
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"getDbms(...)");
        Dbms dbms2 = dbms;
        if (SqlPsiUtilKt.isStringConcat(sign, dbms2)) {
            if (Intrinsics.areEqual((Object)sign, (Object)SqlCommonTokens.SQL_OP_PLUS) && rType == DasTypeCategory.STRING && lType == DasTypeCategory.STRING) {
                return DasTypeCategory.STRING;
            }
            if (!(Intrinsics.areEqual((Object)sign, (Object)SqlCommonTokens.SQL_OP_PLUS) || rType != DasTypeCategory.STRING && lType != DasTypeCategory.STRING)) {
                return DasTypeCategory.STRING;
            }
        }
        if (SqlPsiUtilKt.isBooleanOperation(sign, dbms2) || SqlPsiUtilKt.isLogicalAnd(sign) || SqlPsiUtilKt.isLogicalOr(sign) || SqlPsiUtilKt.isLogicalXor(sign, dbms2)) {
            return DasTypeCategory.BOOLEAN;
        }
        if (SqlPsiUtilKt.isIntDiv(sign, dbms2)) {
            return SqlTypeConversionUtilKt.balanceIntTypes(lType, rType, dbms2);
        }
        if (Intrinsics.areEqual((Object)sign, (Object)SqlCommonTokens.SQL_OP_DIV) && dbms2.isMysql()) {
            return DasTypeCategory.REAL;
        }
        if (Intrinsics.areEqual((Object)sign, (Object)SqlCommonTokens.SQL_OP_PLUS) || Intrinsics.areEqual((Object)sign, (Object)SqlCommonTokens.SQL_OP_MINUS) || Intrinsics.areEqual((Object)sign, (Object)SqlCommonTokens.SQL_OP_MUL) || Intrinsics.areEqual((Object)sign, (Object)SqlCommonTokens.SQL_OP_DIV) || SqlPsiUtilKt.isMod(sign, dbms2)) {
            return !SqlTypeConversionUtilKt.convertsToNumeric(lType, dbms2) && !SqlTypeConversionUtilKt.convertsToNumeric(rType, dbms2) ? DasTypeCategory.UNKNOWN : SqlTypeConversionUtilKt.balanceNumericTypes(lType, rType, dbms2);
        }
        if (SqlPsiUtilKt.isBitwiseOperation(sign, dbms2)) {
            return SqlTypeConversionUtilKt.balanceIntTypes(lType, rType, dbms2);
        }
        return DasTypeCategory.UNKNOWN;
    }

    private static final boolean convertsToNumeric(DasTypeCategory type, Dbms dbms) {
        return type == DasTypeCategory.INTEGER || type == DasTypeCategory.REAL || type == DasTypeCategory.STRING || type == DasTypeCategory.BOOLEAN && dbms.isMysql();
    }

    private static final boolean convertsToInt(DasTypeCategory type, Dbms dbms) {
        return dbms.isMysql() ? true : (dbms.isMicrosoft() || dbms.isPostgres() ? type == DasTypeCategory.INTEGER || type == DasTypeCategory.STRING : type == DasTypeCategory.INTEGER);
    }

    private static final DasTypeCategory balanceNumericTypes(DasTypeCategory lType, DasTypeCategory rType, Dbms dbms) {
        return rType == DasTypeCategory.REAL || lType == DasTypeCategory.REAL ? DasTypeCategory.REAL : (dbms.isMysql() && (rType == DasTypeCategory.STRING || lType == DasTypeCategory.STRING) ? DasTypeCategory.REAL : SqlTypeConversionUtilKt.balanceIntTypes(lType, rType, dbms));
    }

    private static final DasTypeCategory balanceIntTypes(DasTypeCategory lType, DasTypeCategory rType, Dbms dbms) {
        return !SqlTypeConversionUtilKt.convertsToInt(rType, dbms) || !SqlTypeConversionUtilKt.convertsToInt(rType, dbms) ? DasTypeCategory.UNKNOWN : (rType == DasTypeCategory.STRING && lType == DasTypeCategory.STRING && !dbms.isMysql() ? DasTypeCategory.UNKNOWN : DasTypeCategory.INTEGER);
    }
}

