/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.intellij.diff;

import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.diff.Difference;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.ext.intellij.database.IntellijDatabase;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.PrimaryKey;
import liquibase.structure.core.Relation;
import one.util.streamex.StreamEx;

public class ChangedPrimaryKeyChangeGenerator
extends liquibase.diff.output.changelog.core.ChangedPrimaryKeyChangeGenerator {
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (PrimaryKey.class.isAssignableFrom(objectType)) {
            return 50;
        }
        return -1;
    }

    public Change[] fixChanged(DatabaseObject changedObject, ObjectDifferences differences, DiffOutputControl control, Database referenceDatabase, Database comparisonDatabase, ChangeGeneratorChain chain) {
        if (referenceDatabase instanceof IntellijDatabase || comparisonDatabase instanceof IntellijDatabase) {
            differences.removeDifference("unique");
            differences.removeDifference("validate");
            this.removeColumnsDiff(differences);
            if (!differences.hasDifferences()) {
                return new Change[0];
            }
        }
        return super.fixChanged(changedObject, differences, control, referenceDatabase, comparisonDatabase, chain);
    }

    private void removeColumnsDiff(ObjectDifferences differences) {
        Set<String> comparedCollection;
        Difference diffColumns = differences.getDifference("columns");
        if (diffColumns == null) {
            return;
        }
        Object comparedValue = diffColumns.getComparedValue();
        Object referenceValue = diffColumns.getReferenceValue();
        if (!(comparedValue instanceof Collection) || !(referenceValue instanceof Collection)) {
            return;
        }
        Set<String> referenceCollection = this.convertToColumnPresentation((Collection)referenceValue);
        if (referenceCollection.equals(comparedCollection = this.convertToColumnPresentation((Collection)comparedValue))) {
            differences.removeDifference("columns");
        }
    }

    private Set<String> convertToColumnPresentation(Collection<?> diffColumns) {
        return StreamEx.of(diffColumns).select(Column.class).map(column -> {
            Relation relation = column.getRelation();
            String tableName = relation == null ? "" : relation.getName();
            return (tableName + "_" + column.getName()).toLowerCase(Locale.ROOT);
        }).toSet();
    }
}

