/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.structure.sections;

import com.intellij.liquibase.common.LiquibaseConstant;
import com.intellij.liquibase.structure.LiquibaseTreeElement;
import com.intellij.liquibase.structure.sections.LiquibaseOrderedSection;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004B\u001f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u000e\u001a\u00020\u0003H\u0016J\n\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0017"}, d2={"Lcom/intellij/liquibase/structure/sections/LiquibaseTagElement;", "Lcom/intellij/liquibase/structure/LiquibaseTreeElement;", "Lcom/intellij/psi/xml/XmlTag;", "Lcom/intellij/navigation/ItemPresentation;", "Lcom/intellij/liquibase/structure/sections/LiquibaseOrderedSection;", "project", "Lcom/intellij/openapi/project/Project;", "xmlTag", "order", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/xml/XmlTag;I)V", "getOrder", "()I", "getPresentation", "getLocationString", "", "getIcon", "Ljavax/swing/Icon;", "unused", "", "getChangelogDirectory", "Lcom/intellij/psi/PsiDirectory;", "intellij.liquibase"})
public abstract class LiquibaseTagElement
extends LiquibaseTreeElement<XmlTag>
implements ItemPresentation,
LiquibaseOrderedSection {
    private final int order;

    public LiquibaseTagElement(@NotNull Project project, @NotNull XmlTag xmlTag, int order) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)xmlTag, (String)"xmlTag");
        super(project, (XmlElement)xmlTag);
        this.order = order;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    @NotNull
    public ItemPresentation getPresentation() {
        return this;
    }

    @Nullable
    public String getLocationString() {
        return " " + ((XmlTag)this.getValue()).getName();
    }

    @NotNull
    public Icon getIcon(boolean unused) {
        String string = ((XmlTag)this.getValue()).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return LiquibaseConstant.getIconByTag(string);
    }

    @Override
    @Nullable
    public PsiDirectory getChangelogDirectory() {
        return ((XmlTag)this.getValue()).getContainingFile().getContainingDirectory();
    }
}

