/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common.structure.logical.model;

import com.intellij.icons.AllIcons;
import com.intellij.ide.presentation.PresentationProvider;
import com.intellij.jpa.jpb.model.util.HPsiUtil;
import com.intellij.liquibase.common.config.DatabaseMigrationConfig;
import com.intellij.liquibase.common.structure.logical.model.LiquibaseFileLogicalModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0010\u0010\b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0002H\u0017J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/liquibase/common/structure/logical/model/LiquibaseFileLogicalModelPresentationProvider;", "Lcom/intellij/ide/presentation/PresentationProvider;", "Lcom/intellij/liquibase/common/structure/logical/model/LiquibaseFileLogicalModel;", "<init>", "()V", "getName", "", "t", "getTypeName", "getIcon", "Ljavax/swing/Icon;", "intellij.liquibase.common"})
public final class LiquibaseFileLogicalModelPresentationProvider
extends PresentationProvider<LiquibaseFileLogicalModel> {
    @NotNull
    public String getName(@NotNull LiquibaseFileLogicalModel t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        String string = t.getFile().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @NlsSafe
    @NotNull
    public String getTypeName(@NotNull LiquibaseFileLogicalModel t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        PsiFile file = t.getFile();
        Object object = file.getContainingDirectory();
        if (object == null || (object = HPsiUtil.getClassPathRelativePath((PsiFileSystemItem)((PsiFileSystemItem)object), (char)'/')) == null) {
            return "";
        }
        Object relativePath = object;
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        String defaultPath = StringsKt.substringBefore$default((String)DatabaseMigrationConfig.Companion.getInstance(project).getState().getMainChangeLogDir(), (String)"/#", null, (int)2, null);
        return StringsKt.removePrefix((String)StringsKt.removePrefix((String)relativePath, (CharSequence)defaultPath), (CharSequence)"/");
    }

    @NotNull
    public Icon getIcon(@NotNull LiquibaseFileLogicalModel t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        Icon icon = AllIcons.Providers.Liquibase;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Liquibase");
        return icon;
    }
}

