/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.structure;

import com.intellij.jupyter.core.jupyter.actions.CellExecutionListener;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterExecutionStatus;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.jupyter.structure.JupyterStructureViewModel;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.time.ZonedDateTime;
import java.util.EventListener;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u00012\u00020\u0002:\u0001\u0014B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000eH\u0016J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewUpdater;", "Lcom/intellij/jupyter/core/jupyter/actions/CellExecutionListener;", "Lcom/intellij/openapi/Disposable$Default;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/openapi/editor/Editor;)V", "updateQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "executionStarted", "", "cellPointer", "Lcom/intellij/notebooks/visualization/NotebookIntervalPointer;", "startTime", "Ljava/time/ZonedDateTime;", "executionStopped", "jupyterStatus", "Lcom/intellij/jupyter/core/jupyter/connections/execution/JupyterExecutionStatus;", "endTime", "updateIcons", "Companion", "intellij.jupyter.core"})
public final class JupyterStructureViewUpdater
implements CellExecutionListener,
Disposable.Default {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    @NotNull
    private final MergingUpdateQueue updateQueue;
    private static final int TIMEOUT_MILLIS = 500;

    public JupyterStructureViewUpdater(@NotNull Editor editor) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            this.editor = editor;
            this.updateQueue = new MergingUpdateQueue("NotebookStructureViewUpdateQueue", 500, true, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD, null, 128, null);
            this.updateQueue.setRestartTimerOnAdd(true);
            EventDispatcher<CellExecutionListener> eventDispatcher = JupyterEditorExtensionsKt.getNotebookFileOrNull(this.editor);
            if (eventDispatcher == null || (eventDispatcher = eventDispatcher.getNotebook()) == null || (eventDispatcher = eventDispatcher.getListeners()) == null || (eventDispatcher = eventDispatcher.getCellExecutionListeners()) == null) break block0;
            eventDispatcher.addListener((EventListener)this, (Disposable)this);
        }
    }

    @Override
    public void executionStarted(@NotNull NotebookIntervalPointer cellPointer, @NotNull ZonedDateTime startTime) {
        Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        this.updateIcons(cellPointer);
    }

    @Override
    public void executionStopped(@NotNull NotebookIntervalPointer cellPointer, @NotNull JupyterExecutionStatus jupyterStatus, @NotNull ZonedDateTime endTime) {
        Intrinsics.checkNotNullParameter((Object)cellPointer, (String)"cellPointer");
        Intrinsics.checkNotNullParameter((Object)((Object)jupyterStatus), (String)"jupyterStatus");
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        this.updateIcons(cellPointer);
    }

    private final void updateIcons(NotebookIntervalPointer cellPointer) {
        this.updateQueue.queue(new Update(cellPointer, this){
            final /* synthetic */ JupyterStructureViewUpdater this$0;
            {
                this.this$0 = $receiver;
                super((Object)$cellPointer, false, 0, 6, null);
            }

            public void run() {
                block0: {
                    JupyterStructureViewModel jupyterStructureViewModel = (JupyterStructureViewModel)((Object)JupyterStructureViewUpdater.access$getEditor$p(this.this$0).getUserData(JupyterStructureViewModel.Companion.getJUPYTER_STRUCTURE_MODEL_KEY()));
                    if (jupyterStructureViewModel == null) break block0;
                    jupyterStructureViewModel.fireModelUpdate();
                }
            }
        });
    }

    public static final /* synthetic */ Editor access$getEditor$p(JupyterStructureViewUpdater $this) {
        return $this.editor;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/jupyter/core/jupyter/structure/JupyterStructureViewUpdater$Companion;", "", "<init>", "()V", "TIMEOUT_MILLIS", "", "install", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        public final void install(@NotNull EditorImpl editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            JupyterStructureViewUpdater executionInfo = new JupyterStructureViewUpdater((Editor)editor);
            Disposer.register((Disposable)editor.getDisposable(), (Disposable)((Disposable)executionInfo));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

