/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.sqlite;

import com.intellij.database.data.types.BaseDomainRegistry;
import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.domain.BinaryDomain;
import com.intellij.database.data.types.domain.BooleanDomain;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.FloatDomain;
import com.intellij.database.data.types.domain.FractionDomain;
import com.intellij.database.data.types.domain.IntegerDomain;
import com.intellij.database.data.types.domain.Number2Domain;
import com.intellij.database.data.types.domain.OperationSupport;
import com.intellij.database.data.types.domain.SimpleDomain;
import com.intellij.database.data.types.domain.TextDomain;

public final class SqliteDomains
extends BaseDomainRegistry {
    private static final int MAX_CHAR = 20;
    private static final int MAX_NCHAR = 55;
    private static final int MAX_VARCHAR = 255;

    public SqliteDomains() {
        this.add(new IntegerDomain("integer", ConversionPoint.NUMBER, -2.147483648E9, 2.147483647E9).withAliases(new String[]{"int", "mediumint"}));
        this.add(new IntegerDomain("unsigned integer", ConversionPoint.NUMBER, 0.0, 2.147483647E9).withAliases(new String[]{"unsigned int"}));
        this.add(new IntegerDomain("bigint", ConversionPoint.NUMBER, -9.223372036854776E18, 9.223372036854776E18).withAliases(new String[]{"int8"}));
        this.add(new IntegerDomain("unsigned bigint", ConversionPoint.NUMBER, 0.0, 9.223372036854776E18).withAliases(new String[]{"unsigned big int"}));
        this.add(new BooleanDomain("boolean", ConversionPoint.BOOLEAN_NUMBER).withAliases(new String[]{"bool"}));
        this.add(new IntegerDomain("smallint", ConversionPoint.NUMBER, -32768.0, 32767.0).withAliases(new String[]{"int2"}));
        this.add((Domain)new IntegerDomain("tinyint", ConversionPoint.NUMBER, -128.0, 127.0));
        this.add(new FloatDomain("double", ConversionPoint.DOUBLE_PRECISION, -1.7976931348623157E308, Double.MAX_VALUE).withAliases(new String[]{"double precision"}));
        this.add((Domain)new FloatDomain("float", ConversionPoint.SINGLE_PRECISION, -3.4028234663852886E38, 3.4028234663852886E38));
        this.add((Domain)new FloatDomain("real", ConversionPoint.SINGLE_PRECISION, -3.4028234663852886E38, 3.4028234663852886E38));
        this.add((Domain)new TextDomain("text", ConversionPoint.TEXT, 0L, Integer.MAX_VALUE, false, true));
        this.add((Domain)new TextDomain("clob", ConversionPoint.TEXT, 0L, Integer.MAX_VALUE, false, true));
        this.add(new SimpleDomain("date", ConversionPoint.TEXT_DATE).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new FractionDomain("datetime", ConversionPoint.TEXT_TIMESTAMP, 0, -1, false).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new BinaryDomain("blob", ConversionPoint.BLOB_TEXT, Integer.MAX_VALUE, -1L, false, true).withOperationSupport(OperationSupport.SUPPORTS_LIKE));
        this.add(new TextDomain("character", ConversionPoint.CHAR, 20L, 1L, true, true).withAliases(new String[]{"char"}));
        this.add((Domain)new TextDomain("native character", ConversionPoint.CHAR, 20L, 1L, true, true));
        this.add((Domain)new TextDomain("nchar", ConversionPoint.NCHAR, 55L));
        this.add(new TextDomain("varchar", ConversionPoint.VARCHAR, 255L, -1L, true, true).withAliases(new String[]{"varying character"}));
        this.add((Domain)new TextDomain("longvarchar", ConversionPoint.TEXT, Long.MAX_VALUE));
        this.add((Domain)new TextDomain("nvarchar", ConversionPoint.NVARCHAR, 255L));
        this.add((Domain)new FloatDomain("numeric", ConversionPoint.NUMBER, -1.7976931348623157E308, Double.MAX_VALUE));
        this.add((Domain)new Number2Domain("decimal", ConversionPoint.BIG_DECIMAL, Integer.MAX_VALUE, Integer.MAX_VALUE, true));
    }
}

