/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.invalid;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.model.psi.PsiSymbolReferenceService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.css.resolve.CssCustomPropertyReference;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

public final class CssUnresolvedCustomPropertyInspection
extends CssBaseInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            CssUnresolvedCustomPropertyInspection.$$$reportNull$$$0(0);
        }
        return new CssElementVisitor(this){

            public void visitCssFunction(CssFunction function) {
                super.visitCssFunction(function);
                String name = function.getName();
                if ("var".equals(name)) {
                    CssTermList value = function.getValue();
                    if (value == null) {
                        return;
                    }
                    Object[] terms = value.getTerms();
                    CssTerm term = (CssTerm)ArrayUtil.getFirstElement((Object[])terms);
                    if (term == null) {
                        return;
                    }
                    PsiElement child = term.getFirstChild();
                    if (child == null) {
                        return;
                    }
                    for (PsiReference reference : child.getReferences()) {
                        ResolveResult[] results;
                        if (!(reference instanceof CssCustomPropertyReference) || (results = ((CssCustomPropertyReference)reference).multiResolve(false)).length != 0 || !PsiSymbolReferenceService.getService().getReferences((PsiElement)term).isEmpty()) continue;
                        String elementName = reference.getCanonicalText();
                        holder.registerProblem(child, CssBundle.message((String)"css.inspections.unresolved.custom.property.at.rule.message", (Object[])new Object[]{elementName}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                    }
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/psi/css/inspections/invalid/CssUnresolvedCustomPropertyInspection", "buildVisitor"));
    }
}

