/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mssql;

import com.intellij.database.Dbms;
import com.intellij.database.datagrid.GridUtilCore;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.base.LimitPlace;
import com.intellij.database.dialects.mssql.MsDialect;
import com.intellij.database.dialects.mssql.TsqlDmlHelper;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.registry.Registry;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\u001a\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J:\u0010\u0016\u001a\u00020\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u0007H\u0016J\u0012\u0010\u001e\u001a\u00020\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u0017H\u0016J \u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u001bH\u0004R\u0014\u0010\u0006\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006!"}, d2={"Lcom/intellij/database/dialects/mssql/MsDmlHelper;", "Lcom/intellij/database/dialects/mssql/TsqlDmlHelper;", "dbms", "Lcom/intellij/database/Dbms;", "<init>", "(Lcom/intellij/database/Dbms;)V", "supportsInsertDefaultValues", "", "getSupportsInsertDefaultValues", "()Z", "getPlaceForLimit", "Lcom/intellij/database/dialects/base/LimitPlace;", "hasRowId", "table", "Lcom/intellij/database/model/DasTable;", "version", "Lcom/intellij/database/util/Version;", "appendRowId", "Lcom/intellij/database/util/DdlBuilder;", "builder", "alias", "", "appendLimit", "Lcom/intellij/database/model/DasObject;", "dialect", "Lcom/intellij/database/dialects/DatabaseDialectEx;", "limit", "", "offset", "atBeginning", "supportsOffset", "offsetFetch", "rows", "intellij.database.dialects.mssql"})
public final class MsDmlHelper
extends TsqlDmlHelper {
    public MsDmlHelper(@NotNull Dbms dbms) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        super(dbms);
    }

    public boolean getSupportsInsertDefaultValues() {
        return true;
    }

    @Override
    @NotNull
    public LimitPlace getPlaceForLimit() {
        return Registry.Companion.is("sql.dialects.mssql.use.offset.fetch", false) ? LimitPlace.END : LimitPlace.BEGIN;
    }

    public boolean hasRowId(@NotNull DasTable table, @Nullable Version version) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        return this.getDbms().eq(Dbms.AZURE) || this.getDbms().eq(Dbms.MSSQL) && MsDialect.isMsSql2008(version);
    }

    @NotNull
    public DdlBuilder appendRowId(@NotNull DdlBuilder builder, @Nullable String alias) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        DdlBuilder ddlBuilder = builder.symbol(",").space().literal("%%physloc%% as \"%%physloc%%\"");
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder, (String)"literal(...)");
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder appendLimit(@Nullable DasObject table, @NotNull DdlBuilder builder, @NotNull DatabaseDialectEx dialect, int limit, int offset, boolean atBeginning) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        return GridUtilCore.isPageSizeUnlimited((int)limit) ? builder : (Registry.Companion.is("sql.dialects.mssql.use.offset.fetch", false) ? this.offsetFetch(builder, offset, limit) : this.top(builder, "TOP", limit));
    }

    public boolean supportsOffset(@Nullable DasObject table) {
        return Registry.Companion.is("sql.dialects.mssql.use.offset.fetch", false);
    }

    @NotNull
    protected final DdlBuilder offsetFetch(@NotNull DdlBuilder builder, int offset, int rows) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        String string = builder.getStatement();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStatement(...)");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"ORDER", (boolean)false, (int)2, null)) {
            String[] stringArray = new String[]{"ROWS", "FETCH", "NEXT"};
            DdlBuilder ddlBuilder = builder.newLine().keyword("OFFSET").space().literal(String.valueOf(offset)).space().keywords(stringArray).space().literal(String.valueOf(rows)).space();
            stringArray = new String[]{"ROWS", "ONLY"};
            DdlBuilder ddlBuilder2 = ddlBuilder.keywords(stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder2, (String)"keywords(...)");
            return ddlBuilder2;
        }
        String[] stringArray = new String[]{"ORDER", "BY", "(", "SELECT", "NULL", ")"};
        DdlBuilder ddlBuilder = builder.newLine().keywords(stringArray).newLine().keyword("OFFSET").space().literal(String.valueOf(offset)).space();
        stringArray = new String[]{"ROWS", "FETCH", "NEXT"};
        DdlBuilder ddlBuilder3 = ddlBuilder.keywords(stringArray).space().literal(String.valueOf(rows)).space();
        stringArray = new String[]{"ROWS", "ONLY"};
        DdlBuilder ddlBuilder4 = ddlBuilder3.keywords(stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)ddlBuilder4, (String)"keywords(...)");
        return ddlBuilder4;
    }
}

