/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jboss.config;

import com.intellij.javaee.oss.jboss.config.JBossConfigProcessor;
import com.intellij.javaee.oss.jboss.server.JBossLocalModel;
import com.intellij.javaee.oss.jboss.version.JBossVersion7Handler;
import com.intellij.javaee.oss.util.CachedConfig;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;
import org.jetbrains.annotations.NotNull;

public class JBoss7HttpsSocketBindingConfig
extends CachedConfig<JBossLocalModel> {
    private static final Map<CachedConfig.Key, JBoss7HttpsSocketBindingConfig> ourCache = new HashMap<CachedConfig.Key, JBoss7HttpsSocketBindingConfig>();
    private static final CachedConfig.Factory<JBossLocalModel, JBoss7HttpsSocketBindingConfig> ourFactory = new CachedConfig.Factory<JBossLocalModel, JBoss7HttpsSocketBindingConfig>(){

        @NotNull
        public CachedConfig.Key createKey(JBossLocalModel data) {
            return new CachedConfig.Key(new String[]{data.getHome()});
        }

        @NotNull
        public JBoss7HttpsSocketBindingConfig createConfig(JBossLocalModel data) {
            return new JBoss7HttpsSocketBindingConfig();
        }
    };
    private Boolean myHttpsSocketBindingEnabled;

    private static File getConfigFile(JBossLocalModel data) {
        return JBossVersion7Handler.getConfigFile(data);
    }

    public static boolean isHttpsSocketBindingEnabled(JBossLocalModel model) {
        return Optional.ofNullable((JBoss7HttpsSocketBindingConfig)JBoss7HttpsSocketBindingConfig.get(ourCache, ourFactory, (Object)((Object)model))).map(instance -> instance.myHttpsSocketBindingEnabled).orElse(false);
    }

    protected long getStamp(JBossLocalModel data) {
        return JBoss7HttpsSocketBindingConfig.getStamp((File)JBoss7HttpsSocketBindingConfig.getConfigFile(data));
    }

    protected void update(JBossLocalModel data) {
        String xPath = "/ns:server/ns:management/ns:management-interfaces/ns:http-interface/ns:socket-binding[@https='management-https']";
        this.myHttpsSocketBindingEnabled = (Boolean)new JBossConfigProcessor<Boolean>(this, xPath, Boolean.valueOf(false)){

            @Override
            protected Boolean process(XPath xpath, Document doc) throws JDOMException, IOException {
                return xpath.selectSingleNode((Object)doc) != null;
            }
        }.get(JBoss7HttpsSocketBindingConfig.getConfigFile(data));
    }
}

