/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.utils;

import com.intellij.cdi.beans.CdiCustomizationManager;
import com.intellij.cdi.beans.CdiExtensionBeanDescriptor;
import com.intellij.cdi.constants.CdiClassesConstants;
import com.intellij.cdi.jam.CdiJamModel;
import com.intellij.cdi.jam.events.CdiObserves;
import com.intellij.cdi.jam.producers.CdiProduces;
import com.intellij.cdi.utils.CdiManagedBeanValidationUtils;
import com.intellij.cdi.utils.CdiVersion;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.jam.JamService;
import com.intellij.java.analysis.OuterModelsModificationTrackerManager;
import com.intellij.java.library.JavaLibraryModificationTracker;
import com.intellij.java.library.JavaLibraryUtil;
import com.intellij.javaee.constants.CdiAnnoConstants;
import com.intellij.javaee.ejb.model.EjbAnnotationConstants;
import com.intellij.javaee.utils.JavaeeClass;
import com.intellij.javaee.utils.JavaeeType;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedMembersSearch;
import com.intellij.psi.search.searches.AnnotatedPackagesSearch;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.uast.UastModificationTracker;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UParameter;

public final class CdiCommonUtils {
    public static final List<String> NORMAL_SCOPE_ANNOTATIONS = List.of(CdiAnnoConstants.REQUEST_SCOPED_ANNOTATION.javax(), CdiAnnoConstants.REQUEST_SCOPED_ANNOTATION.jakarta(), CdiAnnoConstants.APPLICATION_SCOPED_ANNOTATION.javax(), CdiAnnoConstants.APPLICATION_SCOPED_ANNOTATION.jakarta(), CdiAnnoConstants.SESSION_SCOPED_ANNOTATION.javax(), CdiAnnoConstants.SESSION_SCOPED_ANNOTATION.jakarta());
    private static final List<String> QUALIFIER_ANNOTATIONS = List.of(CdiAnnoConstants.QUALIFIER_ANNOTATION.javax(), CdiAnnoConstants.QUALIFIER_ANNOTATION.jakarta());

    private CdiCommonUtils() {
    }

    public static PsiAnnotation @NotNull [] getQualifierAnnotations(@Nullable PsiModifierListOwner psiModifierListOwner, @Nullable Module module) {
        if (psiModifierListOwner == null) {
            if (PsiAnnotation.EMPTY_ARRAY == null) {
                CdiCommonUtils.$$$reportNull$$$0(0);
            }
            return PsiAnnotation.EMPTY_ARRAY;
        }
        Set<PsiClass> allQualifiers = CdiCommonUtils.getAllQualifierPsiClasses(psiModifierListOwner, module);
        PsiAnnotation[] psiAnnotationArray = (PsiAnnotation[])CachedValuesManager.getCachedValue((PsiElement)psiModifierListOwner, () -> {
            PsiAnnotation[] qualifierAnnotations = ContainerUtil.mapNotNull((Collection)allQualifiers, qualifierPsiClass -> {
                String mappedQualifier = CdiCommonUtils.getQualifierBeanAnnotation(psiModifierListOwner.getProject(), qualifierPsiClass.getQualifiedName());
                return (PsiAnnotation)ContainerUtil.find((Object[])psiModifierListOwner.getAnnotations(), psiAnnotation -> Objects.equals(mappedQualifier, psiAnnotation.getQualifiedName()));
            }).toArray(PsiAnnotation.EMPTY_ARRAY);
            return CachedValueProvider.Result.create((Object)qualifierAnnotations, (Object[])new Object[]{JavaLibraryModificationTracker.getInstance((Project)psiModifierListOwner.getProject()), OuterModelsModificationTrackerManager.getTracker((Project)psiModifierListOwner.getProject())});
        });
        if (psiAnnotationArray == null) {
            CdiCommonUtils.$$$reportNull$$$0(1);
        }
        return psiAnnotationArray;
    }

    @NotNull
    private static Set<PsiClass> getAllQualifierPsiClasses(PsiModifierListOwner modifierListOwner, @Nullable Module module) {
        Iterable iterable = ContainerUtil.concat(module != null ? CdiCommonUtils.getQualifierClasses(module) : CdiCommonUtils.detectQualifierClasses(modifierListOwner), CdiCustomizationManager.getCustomQualifiers(module));
        HashSet<PsiClass> result = new HashSet<PsiClass>();
        for (PsiClass psiClass : iterable) {
            result.add(psiClass);
        }
        HashSet<PsiClass> hashSet = result;
        if (hashSet == null) {
            CdiCommonUtils.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    public static PsiAnnotation @NotNull [] getQualifierAnnotations(@NotNull PsiModifierListOwner psiModifierListOwner) {
        if (psiModifierListOwner == null) {
            CdiCommonUtils.$$$reportNull$$$0(3);
        }
        return CdiCommonUtils.getQualifierAnnotations(psiModifierListOwner, ModuleUtilCore.findModuleForPsiElement((PsiElement)psiModifierListOwner));
    }

    public static PsiAnnotation @NotNull [] getQualifierAnnotations(UDeclaration uDeclaration) {
        PsiElement sourcePsi = uDeclaration.getSourcePsi();
        if (sourcePsi instanceof PsiModifierListOwner) {
            PsiModifierListOwner modifierListOwner = (PsiModifierListOwner)sourcePsi;
            return CdiCommonUtils.getQualifierAnnotations(modifierListOwner);
        }
        if (PsiAnnotation.EMPTY_ARRAY == null) {
            CdiCommonUtils.$$$reportNull$$$0(4);
        }
        return PsiAnnotation.EMPTY_ARRAY;
    }

    @NotNull
    public static Set<PsiClass> getInterceptorBindingTypesClasses(PsiModifierListOwner modifierListOwner, @Nullable Module module) {
        HashSet<PsiClass> bindingTypes = new HashSet<PsiClass>();
        for (PsiClass anno : CdiCommonUtils.getInterceptorBindingTypesClasses(module)) {
            String annoQualifiedName = anno.getQualifiedName();
            if (annoQualifiedName == null || !AnnotationUtil.isAnnotated((PsiModifierListOwner)modifierListOwner, (String)annoQualifiedName, (int)1)) continue;
            bindingTypes.add(anno);
        }
        HashSet<PsiClass> hashSet = bindingTypes;
        if (hashSet == null) {
            CdiCommonUtils.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    @NotNull
    public static Collection<PsiClass> getQualifierClasses(@Nullable Module module) {
        Collection<Object> collection = module == null ? Collections.emptyList() : MetaAnnotationUtil.getAnnotationTypesWithChildren((Module)module, (String)CdiAnnoConstants.QUALIFIER_ANNOTATION.fqn(module), (boolean)false);
        if (collection == null) {
            CdiCommonUtils.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiClass> getInterceptorBindingTypesClasses(@Nullable Module module) {
        Collection<Object> collection = module == null ? Collections.emptyList() : MetaAnnotationUtil.getAnnotationTypesWithChildren((Module)module, (String)CdiAnnoConstants.INTERCEPTOR_BINDING_ANNOTATION.fqn(module), (boolean)false);
        if (collection == null) {
            CdiCommonUtils.$$$reportNull$$$0(7);
        }
        return collection;
    }

    @NotNull
    public static Collection<String> getBindingTypesQualifiedNames(@NotNull Module module) {
        if (module == null) {
            CdiCommonUtils.$$$reportNull$$$0(8);
        }
        return CdiCommonUtils.getQualifiedNames(CdiCommonUtils.getQualifierClasses(module));
    }

    @NotNull
    public static Collection<PsiClass> getNormalScopeTypesClasses(@NotNull Module module) {
        if (module == null) {
            CdiCommonUtils.$$$reportNull$$$0(9);
        }
        Collection collection = MetaAnnotationUtil.getAnnotatedTypes((Module)module, (String)CdiAnnoConstants.NORMAL_SCOPE_ANNOTATION.fqn(module));
        if (collection == null) {
            CdiCommonUtils.$$$reportNull$$$0(10);
        }
        return collection;
    }

    @NotNull
    public static Collection<String> getNormalScopeQualifiedNames(@Nullable Module module) {
        if (module == null) {
            List<String> list = NORMAL_SCOPE_ANNOTATIONS;
            if (list == null) {
                CdiCommonUtils.$$$reportNull$$$0(11);
            }
            return list;
        }
        Collection collection = (Collection)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.create(CdiCommonUtils.getQualifiedNames(CdiCommonUtils.getNormalScopeTypesClasses(module)), (Object[])new Object[]{OuterModelsModificationTrackerManager.getTracker((Project)module.getProject()), JavaLibraryModificationTracker.getInstance((Project)module.getProject())}));
        if (collection == null) {
            CdiCommonUtils.$$$reportNull$$$0(12);
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiClass> getScopeTypesClasses(@NotNull Module module) {
        if (module == null) {
            CdiCommonUtils.$$$reportNull$$$0(13);
        }
        Collection collection = MetaAnnotationUtil.getAnnotatedTypes((Module)module, (String)CdiAnnoConstants.SCOPE_ANNOTATION.fqn(module));
        if (collection == null) {
            CdiCommonUtils.$$$reportNull$$$0(14);
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiClass> getDeploymentTypesClasses(@NotNull Module module) {
        if (module == null) {
            CdiCommonUtils.$$$reportNull$$$0(15);
        }
        Collection collection = MetaAnnotationUtil.getAnnotatedTypes((Module)module, (String)CdiAnnoConstants.DEPLOYMENT_TYPE_ANNOTATION.fqn(module));
        if (collection == null) {
            CdiCommonUtils.$$$reportNull$$$0(16);
        }
        return collection;
    }

    @NotNull
    public static Collection<String> getStereotypeAnnotationNames(@NotNull Module module) {
        if (module == null) {
            CdiCommonUtils.$$$reportNull$$$0(17);
        }
        return CdiCommonUtils.getQualifiedNames(CdiCommonUtils.getStereotypeAnnotationClasses(module));
    }

    @NotNull
    public static Collection<PsiClass> getStereotypeAnnotationClasses(@NotNull Module module) {
        if (module == null) {
            CdiCommonUtils.$$$reportNull$$$0(18);
        }
        Collection collection = MetaAnnotationUtil.getAnnotatedTypes((Module)module, (String)CdiAnnoConstants.STEREOTYPE_ANNOTATION.fqn(module));
        if (collection == null) {
            CdiCommonUtils.$$$reportNull$$$0(19);
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiPackage> getVetoedPackages(@NotNull Module module) {
        if (module == null) {
            CdiCommonUtils.$$$reportNull$$$0(20);
        }
        Collection collection = (Collection)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)false);
            PsiClass psiClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(CdiAnnoConstants.VETOED_ANNOTATION.fqn(module), scope);
            Set packages = psiClass == null ? Collections.emptySet() : AnnotatedPackagesSearch.search((PsiClass)psiClass, (SearchScope)scope).findAll();
            return CachedValueProvider.Result.createSingleDependency(packages, (Object)UastModificationTracker.getInstance((Project)module.getProject()));
        });
        if (collection == null) {
            CdiCommonUtils.$$$reportNull$$$0(21);
        }
        return collection;
    }

    @NotNull
    public static Collection<PsiClass> getAlternativeStereotypeAnnotationClasses(@NotNull Module module) {
        if (module == null) {
            CdiCommonUtils.$$$reportNull$$$0(22);
        }
        HashSet alternativeStereotypeAnnotations = new HashSet();
        String alternativeAnnotationFqn = CdiAnnoConstants.ALTERNATIVE_ANNOTATION.fqn(module);
        for (PsiClass psiClass : MetaAnnotationUtil.getAnnotatedTypes((Module)module, (String)CdiAnnoConstants.STEREOTYPE_ANNOTATION.fqn(module))) {
            if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)alternativeAnnotationFqn, (int)1)) continue;
            alternativeStereotypeAnnotations.add(psiClass);
        }
        Set<Object> set = alternativeStereotypeAnnotations.isEmpty() ? Collections.emptySet() : alternativeStereotypeAnnotations;
        if (set == null) {
            CdiCommonUtils.$$$reportNull$$$0(23);
        }
        return set;
    }

    @NotNull
    public static Collection<PsiClass> getStereotypeAnnotationClasses(@NotNull Module module, String ... encapsulatedClasses) {
        if (module == null) {
            CdiCommonUtils.$$$reportNull$$$0(24);
        }
        if (encapsulatedClasses == null) {
            CdiCommonUtils.$$$reportNull$$$0(25);
        }
        if (encapsulatedClasses.length == 0) {
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                CdiCommonUtils.$$$reportNull$$$0(26);
            }
            return list;
        }
        ArrayList stereotypes = new ArrayList();
        for (PsiClass stereotypeAnnoPsiClass : CdiCommonUtils.getStereotypeAnnotationClasses(module)) {
            if (!stereotypeAnnoPsiClass.isAnnotationType() || !AnnotationUtil.isAnnotated((PsiModifierListOwner)stereotypeAnnoPsiClass, Arrays.asList(encapsulatedClasses), (int)0)) continue;
            stereotypes.add(stereotypeAnnoPsiClass);
        }
        List<Object> list = stereotypes.isEmpty() ? Collections.emptyList() : stereotypes;
        if (list == null) {
            CdiCommonUtils.$$$reportNull$$$0(27);
        }
        return list;
    }

    @NotNull
    public static MultiMap<PsiClass, Module> getStereotypeAnnotationClasses(@NotNull Collection<Module> modules, String ... encapsulatedClasses) {
        if (modules == null) {
            CdiCommonUtils.$$$reportNull$$$0(28);
        }
        if (encapsulatedClasses == null) {
            CdiCommonUtils.$$$reportNull$$$0(29);
        }
        if (encapsulatedClasses.length == 0) {
            MultiMap multiMap = MultiMap.empty();
            if (multiMap == null) {
                CdiCommonUtils.$$$reportNull$$$0(30);
            }
            return multiMap;
        }
        MultiMap stereotypes = MultiMap.create();
        for (Module module : modules) {
            Collection<PsiClass> classes = CdiCommonUtils.getStereotypeAnnotationClasses(module, encapsulatedClasses);
            for (PsiClass aClass : classes) {
                stereotypes.putValue((Object)aClass, (Object)module);
            }
        }
        MultiMap multiMap = stereotypes.isEmpty() ? MultiMap.empty() : stereotypes;
        if (multiMap == null) {
            CdiCommonUtils.$$$reportNull$$$0(31);
        }
        return multiMap;
    }

    @NotNull
    public static Collection<String> getQualifiedNames(Iterable<? extends PsiClass> annotations) {
        List list = ContainerUtil.mapNotNull(annotations, psiClass -> psiClass.getQualifiedName());
        if (list == null) {
            CdiCommonUtils.$$$reportNull$$$0(32);
        }
        return list;
    }

    public static boolean isManagedBean(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            CdiCommonUtils.$$$reportNull$$$0(33);
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> {
            Project project = psiClass.getProject();
            return CachedValueProvider.Result.create((Object)CdiManagedBeanValidationUtils.isManagedBean(psiClass), (Object[])new Object[]{OuterModelsModificationTrackerManager.getTracker((Project)project), JavaLibraryModificationTracker.getInstance((Project)project)});
        });
    }

    public static boolean isInjectAvailable(@Nullable Module module) {
        if (module == null || module.isDisposed()) {
            return false;
        }
        return JavaLibraryUtil.hasLibraryClass((Module)module, (String)CdiAnnoConstants.INJECT_ANNOTATION.javax()) || JavaLibraryUtil.hasLibraryClass((Module)module, (String)CdiAnnoConstants.INJECT_ANNOTATION.jakarta());
    }

    public static boolean isCdiInstalled(@Nullable Module module) {
        if (module == null || module.isDisposed()) {
            return false;
        }
        return JavaLibraryUtil.hasLibraryClass((Module)module, (String)CdiClassesConstants.ENTERPRISE_INJECT_INSTANCE.javax()) || JavaLibraryUtil.hasLibraryClass((Module)module, (String)CdiClassesConstants.ENTERPRISE_INJECT_INSTANCE.jakarta());
    }

    public static boolean hasCdiApiLibrary(@Nullable Module module) {
        if (module == null || module.isDisposed()) {
            return false;
        }
        return JavaLibraryUtil.hasLibraryJar((Module)module, (String)"jakarta.enterprise:jakarta.enterprise.cdi-api") || JavaLibraryUtil.hasLibraryJar((Module)module, (String)"javax.enterprise:cdi-api");
    }

    public static boolean isCdiAvailable(@Nullable Project project) {
        for (String className : CdiClassesConstants.ENTERPRISE_INJECT_INSTANCE.all()) {
            if (!JavaLibraryUtil.hasLibraryClass((Project)project, (String)className)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCdiInstalled(@Nullable Module module, @NotNull CdiVersion version) {
        if (version == null) {
            CdiCommonUtils.$$$reportNull$$$0(34);
        }
        if (version == CdiVersion.CDI_4_1) {
            return JavaLibraryUtil.hasLibraryClass((Module)module, (String)CdiClassesConstants.BEAN_INFO.jakarta());
        }
        if (version == CdiVersion.CDI_4_0) {
            return JavaLibraryUtil.hasLibraryClass((Module)module, (String)CdiClassesConstants.BEAN_INFO.jakarta());
        }
        if (version == CdiVersion.CDI_3_0) {
            return JavaLibraryUtil.hasLibraryClass((Module)module, (String)CdiClassesConstants.REQUEST_CONTEXT_CONTROLLER.jakarta());
        }
        if (version == CdiVersion.CDI_2_0) {
            return JavaLibraryUtil.hasLibraryClass((Module)module, (String)CdiClassesConstants.REQUEST_CONTEXT_CONTROLLER.javax());
        }
        if (version == CdiVersion.CDI_1_1) {
            return JavaLibraryUtil.hasLibraryClass((Module)module, (String)CdiAnnoConstants.VETOED_ANNOTATION.javax());
        }
        if (version == CdiVersion.CDI_1_0) {
            return JavaLibraryUtil.hasLibraryClass((Module)module, (String)CdiClassesConstants.ENTERPRISE_INJECT_INSTANCE.javax());
        }
        return false;
    }

    public static List<String> getCdiAnnotations(Module module) {
        return (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            DumbService dumbService = DumbService.getInstance((Project)module.getProject());
            if (dumbService.isDumb()) {
                return CachedValueProvider.Result.createSingleDependency(Collections.emptyList(), (Object)dumbService);
            }
            return CachedValueProvider.Result.createSingleDependency(CdiCommonUtils.findCdiAnnotationsFromCdiAnnoConstants(module), (Object)JavaLibraryModificationTracker.getInstance((Project)module.getProject()));
        });
    }

    private static @Unmodifiable List<String> findCdiAnnotationsFromCdiAnnoConstants(Module module) {
        ArrayList<String> annotations = new ArrayList<String>();
        try {
            for (Field field : CdiAnnoConstants.class.getFields()) {
                Object value = field.get(null);
                if (value instanceof String) {
                    annotations.add((String)value);
                    continue;
                }
                if (!(value instanceof JavaeeClass)) continue;
                ContainerUtil.addAll(annotations, (Object[])((JavaeeClass)value).all());
            }
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        JavaPsiFacade javaPsi = JavaPsiFacade.getInstance((Project)module.getProject());
        GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        return ContainerUtil.filter(annotations, annotationFqn -> javaPsi.findClass(annotationFqn, scope) != null);
    }

    public static boolean isDecorator(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            CdiCommonUtils.$$$reportNull$$$0(35);
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)CdiAnnoConstants.DECORATOR_ANNOTATION.fqn((PsiElement)psiClass), (int)0);
    }

    public static boolean isInterceptor(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            CdiCommonUtils.$$$reportNull$$$0(36);
        }
        return AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)CdiAnnoConstants.INTERCEPTOR_ANNOTATION.fqn((PsiElement)psiClass), (int)0);
    }

    public static boolean isAlternative(@NotNull PsiMember psiMember) {
        if (psiMember == null) {
            CdiCommonUtils.$$$reportNull$$$0(37);
        }
        if (CdiCommonUtils.isAlternativeAnnotated(psiMember)) {
            return true;
        }
        return psiMember instanceof PsiClass && CdiCommonUtils.hasAlternativeProducers((PsiClass)psiMember);
    }

    public static boolean isAlternativeAnnotated(@NotNull PsiMember psiMember) {
        if (psiMember == null) {
            CdiCommonUtils.$$$reportNull$$$0(38);
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMember, (String)CdiAnnoConstants.ALTERNATIVE_ANNOTATION.fqn((PsiElement)psiMember), (int)0)) {
            return true;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiMember);
        if (module != null) {
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMember, CdiCommonUtils.getQualifiedNames(CdiCommonUtils.getAlternativeStereotypeAnnotationClasses(module)), (int)0)) {
                return true;
            }
            List<String> alternativeAnnotations = CdiCustomizationManager.getCustomAlternativeAnnotations(module);
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMember, alternativeAnnotations, (int)0)) {
                return true;
            }
        }
        return false;
    }

    public static boolean hasAlternativeProducers(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            CdiCommonUtils.$$$reportNull$$$0(39);
        }
        for (PsiField field : CdiCommonUtils.getProducerFields(psiClass)) {
            if (!CdiCommonUtils.isAlternativeAnnotated((PsiMember)field)) continue;
            return true;
        }
        for (PsiMethod psiMethod : CdiCommonUtils.getProducerMethods(psiClass)) {
            if (!CdiCommonUtils.isAlternativeAnnotated((PsiMember)psiMethod)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PsiClass getOriginalPsiClass(PsiType type, @NotNull Module module) {
        String name;
        if (module == null) {
            CdiCommonUtils.$$$reportNull$$$0(40);
        }
        if (type instanceof PsiClassType) {
            PsiType genericPsiType;
            List<PsiType> psiTypes;
            PsiClassType psiClassType = (PsiClassType)type;
            PsiClassType providerClass = CdiCommonUtils.getProviderClass(psiClassType);
            if (providerClass != null && (psiTypes = CdiCommonUtils.resolveGenerics(providerClass)).size() == 1 && (genericPsiType = psiTypes.get(0)) instanceof PsiClassType) {
                return ((PsiClassType)genericPsiType).resolve();
            }
            return psiClassType.resolve();
        }
        if (type instanceof PsiPrimitiveType && !StringUtil.isEmptyOrSpaces((String)(name = ((PsiPrimitiveType)type).getBoxedTypeName()))) {
            return JavaPsiFacade.getInstance((Project)module.getProject()).findClass(name, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module));
        }
        return null;
    }

    @Nullable
    private static PsiClassType getProviderClass(@NotNull PsiClassType psiClassType) {
        PsiClass psiClass;
        if (psiClassType == null) {
            CdiCommonUtils.$$$reportNull$$$0(41);
        }
        if ((psiClass = psiClassType.resolve()) == null) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        if (module == null) {
            return null;
        }
        String qualifiedName = psiClass.getQualifiedName();
        if (CdiClassesConstants.INJECT_PROVIDER.isFqn(qualifiedName)) {
            return psiClassType;
        }
        for (PsiType type : CdiCommonUtils.getSuperTypes(psiClassType, module)) {
            PsiClass superClass;
            if (!(type instanceof PsiClassType) || (superClass = ((PsiClassType)type).resolve()) == null || !CdiClassesConstants.INJECT_PROVIDER.isFqn(superClass.getQualifiedName())) continue;
            return (PsiClassType)type;
        }
        return null;
    }

    private static Set<PsiType> getSuperTypes(@NotNull PsiClassType psiClassType, @NotNull Module module) {
        if (psiClassType == null) {
            CdiCommonUtils.$$$reportNull$$$0(42);
        }
        if (module == null) {
            CdiCommonUtils.$$$reportNull$$$0(43);
        }
        return (Set)((Map)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            ConcurrentMap map = ConcurrentFactoryMap.createMap(key -> ContainerUtil.newHashSet((Object[])key.getSuperTypes()));
            return CachedValueProvider.Result.create((Object)map, (Object[])new Object[]{OuterModelsModificationTrackerManager.getTracker((Project)module.getProject()), JavaLibraryModificationTracker.getInstance((Project)module.getProject())});
        })).get(psiClassType);
    }

    public static List<PsiType> resolveGenerics(PsiClassType classType) {
        SmartList generics = new SmartList();
        PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
        PsiClass psiClass = resolveResult.getElement();
        PsiSubstitutor substitutor = resolveResult.getSubstitutor();
        if (psiClass != null) {
            for (PsiTypeParameter typeParameter : psiClass.getTypeParameters()) {
                generics.add(substitutor.substitute(typeParameter));
            }
        }
        return generics;
    }

    public static boolean canBeProxied(@NotNull PsiType psiType) {
        if (psiType == null) {
            CdiCommonUtils.$$$reportNull$$$0(44);
        }
        if (psiType instanceof PsiPrimitiveType) {
            return false;
        }
        if (psiType instanceof PsiArrayType) {
            return false;
        }
        if (psiType instanceof PsiClassType) {
            return CdiCommonUtils.canBeProxied(((PsiClassType)psiType).resolve());
        }
        return false;
    }

    public static boolean canBeProxied(@Nullable PsiClass psiClass) {
        if (psiClass == null) {
            return false;
        }
        if (psiClass.isInterface()) {
            return true;
        }
        if (!CdiManagedBeanValidationUtils.hasAppropriateConstructor(psiClass)) {
            return false;
        }
        PsiModifierList list = psiClass.getModifierList();
        if (list != null && (list.hasModifierProperty("private") || list.hasModifierProperty("final"))) {
            return false;
        }
        for (PsiMethod psiMethod : psiClass.getMethods()) {
            if (!psiMethod.getModifierList().hasModifierProperty("final")) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static List<PsiMethod> getProducerMethods(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            CdiCommonUtils.$$$reportNull$$$0(45);
        }
        List list = CdiCommonUtils.filterProducers((PsiMember[])psiClass.getAllMethods());
        if (list == null) {
            CdiCommonUtils.$$$reportNull$$$0(46);
        }
        return list;
    }

    @NotNull
    public static List<PsiField> getProducerFields(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            CdiCommonUtils.$$$reportNull$$$0(47);
        }
        List list = CdiCommonUtils.filterProducers((PsiMember[])psiClass.getAllFields());
        if (list == null) {
            CdiCommonUtils.$$$reportNull$$$0(48);
        }
        return list;
    }

    private static <T extends PsiMember> @Unmodifiable List<T> filterProducers(T[] members) {
        return ContainerUtil.filter((Object[])members, m -> CdiAnnoConstants.PRODUCES_ANNOTATION.isAnnotated((PsiModifierListOwner)m, 0));
    }

    public static List<PsiMember> getPsiTypeProducers(@NotNull Module module, @NotNull PsiType psiType) {
        if (module == null) {
            CdiCommonUtils.$$$reportNull$$$0(49);
        }
        if (psiType == null) {
            CdiCommonUtils.$$$reportNull$$$0(50);
        }
        ArrayList<PsiMember> producers = new ArrayList<PsiMember>();
        for (CdiProduces<?> jamProduces : CdiJamModel.getModel(module).getProduces()) {
            PsiType productType = jamProduces.getProductType();
            if (productType == null || !productType.isAssignableFrom(psiType)) continue;
            producers.add((PsiMember)jamProduces.getPsiElement());
        }
        return producers;
    }

    @NotNull
    public static Set<PsiMethod> getDisposerMethods(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            CdiCommonUtils.$$$reportNull$$$0(51);
        }
        String disposerAnno = CdiAnnoConstants.DISPOSES_ANNOTATION.fqn((PsiElement)psiClass);
        PsiMethod[] methods = psiClass.getAllMethods();
        HashSet<PsiMethod> disposerMethods = new HashSet<PsiMethod>();
        block0: for (PsiMethod psiMethod : methods) {
            for (PsiParameter psiParameter : psiMethod.getParameterList().getParameters()) {
                if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)psiParameter, (String)disposerAnno, (int)0)) continue;
                disposerMethods.add(psiMethod);
                continue block0;
            }
        }
        HashSet<PsiMethod> hashSet = disposerMethods;
        if (hashSet == null) {
            CdiCommonUtils.$$$reportNull$$$0(52);
        }
        return hashSet;
    }

    @NotNull
    public static List<PsiMethod> getObservesMethods(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            CdiCommonUtils.$$$reportNull$$$0(53);
        }
        PsiMethod[] methods = psiClass.getAllMethods();
        SmartList observesMethods = new SmartList();
        List<String> annotations = Arrays.asList(CdiAnnoConstants.OBSERVES_ANNOTATION.fqn((PsiElement)psiClass), CdiAnnoConstants.OBSERVES_ASYNC_ANNOTATION.fqn((PsiElement)psiClass));
        for (PsiMethod psiMethod : methods) {
            for (PsiParameter psiParameter : psiMethod.getParameterList().getParameters()) {
                if (!AnnotationUtil.isAnnotated((PsiModifierListOwner)psiParameter, annotations, (int)0)) continue;
                observesMethods.add(psiMethod);
            }
        }
        SmartList smartList = observesMethods;
        if (smartList == null) {
            CdiCommonUtils.$$$reportNull$$$0(54);
        }
        return smartList;
    }

    public static boolean isClassContainsCdiAnnotations(PsiClass psiClass, Module module) {
        List<String> annotations = CdiCommonUtils.collectCdiBeansAnnotations(module);
        return CdiCommonUtils.isClassContainsCdiAnnotations(psiClass, annotations);
    }

    public static boolean isClassContainsCdiAnnotations(UClass uClass, Module module) {
        List<String> annotations = CdiCommonUtils.collectCdiBeansAnnotations(module);
        return CdiCommonUtils.isClassContainsCdiAnnotations(uClass, annotations);
    }

    private static boolean isClassContainsCdiAnnotations(@NotNull UClass uClass, @NotNull List<String> annotations) {
        Condition condition;
        Predicate<UDeclaration> isCdiDeclaration;
        if (uClass == null) {
            CdiCommonUtils.$$$reportNull$$$0(55);
        }
        if (annotations == null) {
            CdiCommonUtils.$$$reportNull$$$0(56);
        }
        if ((isCdiDeclaration = arg_0 -> CdiCommonUtils.lambda$isClassContainsCdiAnnotations$13(condition = uAnno -> {
            String qualifiedName = uAnno.getQualifiedName();
            return qualifiedName != null && annotations.contains(qualifiedName);
        }, arg_0)).test((UDeclaration)uClass)) {
            return true;
        }
        for (UField uField : uClass.getFields()) {
            if (!isCdiDeclaration.test((UDeclaration)uField)) continue;
            return true;
        }
        for (UField uField : uClass.getMethods()) {
            if (isCdiDeclaration.test((UDeclaration)uField)) {
                return true;
            }
            for (UParameter uParam : uField.getUastParameters()) {
                if (!isCdiDeclaration.test((UDeclaration)uParam)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isClassContainsCdiAnnotations(@NotNull PsiClass psiClass, @NotNull List<String> annotations) {
        if (psiClass == null) {
            CdiCommonUtils.$$$reportNull$$$0(57);
        }
        if (annotations == null) {
            CdiCommonUtils.$$$reportNull$$$0(58);
        }
        if (AnnotationUtil.findAnnotation((PsiModifierListOwner)psiClass, annotations) != null) {
            return true;
        }
        for (PsiField psiField : psiClass.getFields()) {
            if (AnnotationUtil.findAnnotation((PsiModifierListOwner)psiField, annotations) == null) continue;
            return true;
        }
        for (PsiField psiField : psiClass.getMethods()) {
            if (AnnotationUtil.findAnnotation((PsiModifierListOwner)psiField, annotations) != null) {
                return true;
            }
            for (PsiParameter parameter : psiField.getParameterList().getParameters()) {
                if (AnnotationUtil.findAnnotation((PsiModifierListOwner)parameter, annotations) == null) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static List<String> collectCdiBeansAnnotations(@NotNull Module module) {
        if (module == null) {
            CdiCommonUtils.$$$reportNull$$$0(59);
        }
        List list = (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            ArrayList<String> annotations = new ArrayList<String>(CdiCommonUtils.getCdiAnnotations(module));
            annotations.addAll(CdiCommonUtils.getBindingTypesQualifiedNames(module));
            annotations.addAll(CdiCommonUtils.getQualifiedNames(CdiCommonUtils.getNormalScopeTypesClasses(module)));
            annotations.addAll(CdiCommonUtils.getQualifiedNames(CdiCommonUtils.getDeploymentTypesClasses(module)));
            annotations.addAll(CdiCommonUtils.getQualifiedNames(CdiCommonUtils.getStereotypeAnnotationClasses(module)));
            annotations.addAll(CdiCommonUtils.getQualifiedNames(CdiCommonUtils.getScopeTypesClasses(module)));
            annotations.addAll(CdiCustomizationManager.getCustomBeanAnnotations(module));
            return CachedValueProvider.Result.create(List.copyOf(annotations), (Object[])new Object[]{OuterModelsModificationTrackerManager.getTracker((Project)module.getProject()), JavaLibraryModificationTracker.getInstance((Project)module.getProject())});
        });
        if (list == null) {
            CdiCommonUtils.$$$reportNull$$$0(60);
        }
        return list;
    }

    public static boolean hasImplicitArchive(@NotNull Module module) {
        if (module == null) {
            CdiCommonUtils.$$$reportNull$$$0(61);
        }
        return (Boolean)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> new CachedValueProvider.Result((Object)CdiCommonUtils.hasBeanDefinedClasses(module), new Object[]{UastModificationTracker.getInstance((Project)module.getProject())}));
    }

    public static boolean hasBeanDefinedClasses(@NotNull Module module) {
        if (module == null) {
            CdiCommonUtils.$$$reportNull$$$0(62);
        }
        JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)module.getProject());
        GlobalSearchScope searchScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
        for (String anno : CdiCommonUtils.getBeanDefiningAnnotations(module)) {
            if (!CdiCommonUtils.hasAnnotatedMembers(javaPsiFacade, searchScope, anno)) continue;
            return true;
        }
        if (CdiCommonUtils.hasAnnotatedMembers(javaPsiFacade, searchScope, EjbAnnotationConstants.STATEFUL_ANNO.fqn(module))) {
            return true;
        }
        return CdiCommonUtils.hasAnnotatedMembers(javaPsiFacade, searchScope, EjbAnnotationConstants.STATELESS_ANNO.fqn(module));
    }

    public static boolean hasAnnotatedMembers(@NotNull JavaPsiFacade javaPsiFacade, @NotNull GlobalSearchScope searchScope, @NotNull String anno) {
        PsiClass annoClass;
        if (javaPsiFacade == null) {
            CdiCommonUtils.$$$reportNull$$$0(63);
        }
        if (searchScope == null) {
            CdiCommonUtils.$$$reportNull$$$0(64);
        }
        if (anno == null) {
            CdiCommonUtils.$$$reportNull$$$0(65);
        }
        return (annoClass = javaPsiFacade.findClass(anno, searchScope)) != null && AnnotatedMembersSearch.search((PsiClass)annoClass, (SearchScope)searchScope).findFirst() != null;
    }

    @NotNull
    public static List<PsiClass> collectBeanDefiningAnnotations(@NotNull Module module) {
        if (module == null) {
            CdiCommonUtils.$$$reportNull$$$0(66);
        }
        List list = (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            Set<String> beanDefiningAnnotations = CdiCommonUtils.getBeanDefiningAnnotations(module);
            if (beanDefiningAnnotations.isEmpty()) {
                return CachedValueProvider.Result.create(Collections.emptyList(), (Object[])new Object[]{OuterModelsModificationTrackerManager.getTracker((Project)module.getProject()), JavaLibraryModificationTracker.getInstance((Project)module.getProject())});
            }
            JavaPsiFacade javaPsiFacade = JavaPsiFacade.getInstance((Project)module.getProject());
            List annoPsiClasses = ContainerUtil.mapNotNull(beanDefiningAnnotations, annoFqn -> javaPsiFacade.findClass(annoFqn, GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module)));
            return CachedValueProvider.Result.create((Object)annoPsiClasses, (Object[])new Object[]{OuterModelsModificationTrackerManager.getTracker((Project)module.getProject()), JavaLibraryModificationTracker.getInstance((Project)module.getProject())});
        });
        if (list == null) {
            CdiCommonUtils.$$$reportNull$$$0(67);
        }
        return list;
    }

    @NotNull
    public static Set<String> getBeanDefiningAnnotations(@NotNull Module module) {
        if (module == null) {
            CdiCommonUtils.$$$reportNull$$$0(68);
        }
        LinkedHashSet<String> annotations = new LinkedHashSet<String>(CdiCommonUtils.getNormalScopeQualifiedNames(module));
        annotations.add(CdiAnnoConstants.SINGLETON_ANNOTATION.fqn(module));
        annotations.add(CdiAnnoConstants.DECORATOR_ANNOTATION.fqn(module));
        annotations.add(CdiAnnoConstants.INTERCEPTOR_ANNOTATION.fqn(module));
        annotations.addAll(CdiCommonUtils.getStereotypeAnnotationNames(module));
        annotations.add(CdiAnnoConstants.DEPENDENT_ANNOTATION.fqn(module));
        annotations.addAll(CdiCustomizationManager.getCustomBeanAnnotations(module));
        LinkedHashSet<String> linkedHashSet = annotations;
        if (linkedHashSet == null) {
            CdiCommonUtils.$$$reportNull$$$0(69);
        }
        return linkedHashSet;
    }

    @NotNull
    public static Set<CdiExtensionBeanDescriptor> collectExtensionBeanDescriptors(@NotNull Project project) {
        if (project == null) {
            CdiCommonUtils.$$$reportNull$$$0(70);
        }
        Set set = (Set)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            Set<CdiExtensionBeanDescriptor> descriptors = new HashSet<CdiExtensionBeanDescriptor>();
            GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
            descriptors.addAll(CdiCommonUtils.findJavaeeDescriptors(project, JavaeeType.JAVAX, scope));
            descriptors.addAll(CdiCommonUtils.findJavaeeDescriptors(project, JavaeeType.JAKARTA, scope));
            if (descriptors.isEmpty()) {
                descriptors = Collections.emptySet();
            }
            return CachedValueProvider.Result.create(descriptors, (Object[])new Object[]{OuterModelsModificationTrackerManager.getTracker((Project)project), JavaLibraryModificationTracker.getInstance((Project)project)});
        });
        if (set == null) {
            CdiCommonUtils.$$$reportNull$$$0(71);
        }
        return set;
    }

    @NotNull
    public static Set<CdiExtensionBeanDescriptor> collectExtensionBeanDescriptors(@NotNull Module module) {
        if (module == null) {
            CdiCommonUtils.$$$reportNull$$$0(72);
        }
        Set set = (Set)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            GlobalSearchScope scope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module, (boolean)true).union((SearchScope)GlobalSearchScope.moduleWithDependentsScope((Module)module));
            Set<CdiExtensionBeanDescriptor> descriptors = new HashSet<CdiExtensionBeanDescriptor>(CdiCommonUtils.findJavaeeDescriptors(module.getProject(), JavaeeType.discover((Module)module, (JavaeeClass)CdiAnnoConstants.INJECT_ANNOTATION), scope));
            if (descriptors.isEmpty()) {
                descriptors = Collections.emptySet();
            }
            return CachedValueProvider.Result.create(descriptors, (Object[])new Object[]{OuterModelsModificationTrackerManager.getTracker((Project)module.getProject()), JavaLibraryModificationTracker.getInstance((Project)module.getProject())});
        });
        if (set == null) {
            CdiCommonUtils.$$$reportNull$$$0(73);
        }
        return set;
    }

    @NotNull
    private static List<CdiExtensionBeanDescriptor> findJavaeeDescriptors(@NotNull Project project, @NotNull JavaeeType javaeeType, @NotNull GlobalSearchScope scope) {
        if (project == null) {
            CdiCommonUtils.$$$reportNull$$$0(74);
        }
        if (javaeeType == null) {
            CdiCommonUtils.$$$reportNull$$$0(75);
        }
        if (scope == null) {
            CdiCommonUtils.$$$reportNull$$$0(76);
        }
        ArrayList<CdiExtensionBeanDescriptor> descriptors = new ArrayList<CdiExtensionBeanDescriptor>();
        Collection<CdiObserves> afterBeanDiscoveryObserves = CdiCommonUtils.getAfterBeanDiscoveryObserves(project, javaeeType, scope);
        if (!afterBeanDiscoveryObserves.isEmpty()) {
            for (CdiObserves observe : afterBeanDiscoveryObserves) {
                ContainerUtil.addAllNotNull(descriptors, CdiCommonUtils.collectBeanDescriptors(observe, javaeeType));
            }
        }
        ArrayList<CdiExtensionBeanDescriptor> arrayList = descriptors;
        if (arrayList == null) {
            CdiCommonUtils.$$$reportNull$$$0(77);
        }
        return arrayList;
    }

    @NotNull
    private static Set<CdiExtensionBeanDescriptor> collectBeanDescriptors(@NotNull CdiObserves observe, @NotNull JavaeeType javaeeType) {
        PsiClass aClass;
        PsiMethod method;
        if (observe == null) {
            CdiCommonUtils.$$$reportNull$$$0(78);
        }
        if (javaeeType == null) {
            CdiCommonUtils.$$$reportNull$$$0(79);
        }
        if ((method = observe.getPsiMethod()) != null && (aClass = JavaPsiFacade.getInstance((Project)method.getProject()).findClass(CdiClassesConstants.AFTER_BEAN_DISCOVERY.fqn(javaeeType), method.getResolveScope())) != null) {
            PsiMethod[] methods;
            for (PsiMethod psiMethod : methods = aClass.findMethodsByName("addBean", true)) {
                if (psiMethod.getParameterList().getParametersCount() != 0) continue;
                return CdiCommonUtils.searchAddBeanExpressions(psiMethod, (SearchScope)new LocalSearchScope((PsiElement)method));
            }
        }
        Set<CdiExtensionBeanDescriptor> set = Collections.emptySet();
        if (set == null) {
            CdiCommonUtils.$$$reportNull$$$0(80);
        }
        return set;
    }

    @NotNull
    private static Set<CdiExtensionBeanDescriptor> searchAddBeanExpressions(@NotNull PsiMethod fireEventMethod, @NotNull SearchScope searchScope) {
        if (fireEventMethod == null) {
            CdiCommonUtils.$$$reportNull$$$0(81);
        }
        if (searchScope == null) {
            CdiCommonUtils.$$$reportNull$$$0(82);
        }
        @NotNull LinkedHashSet<CdiExtensionBeanDescriptor> set = new LinkedHashSet<CdiExtensionBeanDescriptor>();
        MethodReferencesSearch.search((PsiMethod)fireEventMethod, (SearchScope)searchScope, (boolean)true).forEach(psiReference -> {
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)psiReference.getElement(), PsiMethodCallExpression.class);
            if (methodCallExpression != null) {
                set.add(CdiExtensionBeanDescriptor.create(methodCallExpression));
            }
            return true;
        });
        LinkedHashSet<CdiExtensionBeanDescriptor> linkedHashSet = set;
        if (linkedHashSet == null) {
            CdiCommonUtils.$$$reportNull$$$0(83);
        }
        return linkedHashSet;
    }

    @NotNull
    private static Collection<CdiObserves> getAfterBeanDiscoveryObserves(@NotNull Project project, @NotNull JavaeeType javaeeType, @NotNull GlobalSearchScope scope) {
        if (project == null) {
            CdiCommonUtils.$$$reportNull$$$0(84);
        }
        if (javaeeType == null) {
            CdiCommonUtils.$$$reportNull$$$0(85);
        }
        if (scope == null) {
            CdiCommonUtils.$$$reportNull$$$0(86);
        }
        List observes = JamService.getJamService((Project)project).getJamParameterElements(CdiObserves.OBSERVES_JAM_KEY, CdiAnnoConstants.OBSERVES_ANNOTATION.fqn(javaeeType), scope);
        Collection collection = observes.stream().filter(cdiObserves -> InheritanceUtil.isInheritor((PsiType)cdiObserves.getType(), (String)CdiClassesConstants.AFTER_BEAN_DISCOVERY.fqn(javaeeType))).collect(Collectors.toSet());
        if (collection == null) {
            CdiCommonUtils.$$$reportNull$$$0(87);
        }
        return collection;
    }

    @Nullable
    public static String getQualifierBeanAnnotation(@NotNull Project project, @Nullable String beanQualifier) {
        if (project == null) {
            CdiCommonUtils.$$$reportNull$$$0(88);
        }
        if (beanQualifier == null) {
            return null;
        }
        Pair<String, String> targetAnnotation = CdiCustomizationManager.getQualifierAnnotationMapping(project, beanQualifier);
        if (targetAnnotation != null) {
            return (String)targetAnnotation.second;
        }
        return beanQualifier;
    }

    public static boolean isAppropriateBeanCandidate(@NotNull PsiClass candidate) {
        if (candidate == null) {
            CdiCommonUtils.$$$reportNull$$$0(89);
        }
        return (CdiManagedBeanValidationUtils.isConcreteClass(candidate) || CdiManagedBeanValidationUtils.isAnnotatedAsCustomBean(candidate)) && CdiManagedBeanValidationUtils.hasAppropriateConstructor(candidate) && !CdiManagedBeanValidationUtils.isNonStaticInner(candidate);
    }

    public static boolean hasExternalListenerMethods(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            CdiCommonUtils.$$$reportNull$$$0(90);
        }
        List<String> scheduledAnnotations = CdiCustomizationManager.getExternalListenerAnnotations(psiClass.getProject());
        for (PsiMethod method : psiClass.getAllMethods()) {
            if (!CdiCommonUtils.isExternalListenerCandidate(method) || !AnnotationUtil.isAnnotated((PsiModifierListOwner)method, scheduledAnnotations, (int)0)) continue;
            return true;
        }
        return false;
    }

    public static boolean isExternalListenerCandidate(PsiMethod psiMethod) {
        return !psiMethod.isConstructor() && !psiMethod.hasModifier(JvmModifier.ABSTRACT) && !psiMethod.hasModifier(JvmModifier.STATIC);
    }

    @NotNull
    private static Collection<PsiClass> detectQualifierClasses(PsiModifierListOwner modifierListOwner) {
        if (modifierListOwner == null) {
            List<PsiClass> list = Collections.emptyList();
            if (list == null) {
                CdiCommonUtils.$$$reportNull$$$0(91);
            }
            return list;
        }
        Collection collection = Arrays.stream(modifierListOwner.getAnnotations()).map(PsiAnnotation::resolveAnnotationType).filter(annoPsiClass -> annoPsiClass != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)annoPsiClass, QUALIFIER_ANNOTATIONS, (int)0)).collect(Collectors.toList());
        if (collection == null) {
            CdiCommonUtils.$$$reportNull$$$0(92);
        }
        return collection;
    }

    @NotNull
    public static String decapitalizeBeanName(@NotNull String beanName) {
        if (beanName == null) {
            CdiCommonUtils.$$$reportNull$$$0(93);
        }
        if (beanName.isEmpty()) {
            String string = beanName;
            if (string == null) {
                CdiCommonUtils.$$$reportNull$$$0(94);
            }
            return string;
        }
        char[] chars = beanName.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (!Character.isUpperCase(chars[i])) {
                if (i <= 1 || !Character.isUpperCase(beanName.charAt(i - 1))) break;
                chars[i - 1] = Character.toUpperCase(chars[i - 1]);
                break;
            }
            chars[i] = Character.toLowerCase(chars[i]);
        }
        return new String(chars);
    }

    private static /* synthetic */ boolean lambda$isClassContainsCdiAnnotations$13(Condition condition, UDeclaration uDeclaration) {
        return ContainerUtil.exists((Iterable)uDeclaration.getUAnnotations(), (Condition)condition);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 8, 9, 13, 15, 17, 18, 20, 22, 24, 25, 28, 29, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 49, 50, 51, 53, 55, 56, 57, 58, 59, 61, 62, 63, 64, 65, 66, 68, 70, 72, 74, 75, 76, 78, 79, 81, 82, 84, 85, 86, 88, 89, 90, 93 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cdi/utils/CdiCommonUtils";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiModifierListOwner";
                break;
            }
            case 8: 
            case 9: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 40: 
            case 43: 
            case 49: 
            case 59: 
            case 61: 
            case 62: 
            case 66: 
            case 68: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encapsulatedClasses";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 33: 
            case 35: 
            case 36: 
            case 39: 
            case 45: 
            case 47: 
            case 51: 
            case 53: 
            case 57: 
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMember";
                break;
            }
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClassType";
                break;
            }
            case 44: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiType";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uClass";
                break;
            }
            case 56: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaPsiFacade";
                break;
            }
            case 64: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anno";
                break;
            }
            case 70: 
            case 74: 
            case 84: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 75: 
            case 79: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaeeType";
                break;
            }
            case 76: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "observe";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fireEventMethod";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierAnnotations";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllQualifierPsiClasses";
                break;
            }
            case 3: 
            case 8: 
            case 9: 
            case 13: 
            case 15: 
            case 17: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 49: 
            case 50: 
            case 51: 
            case 53: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 70: 
            case 72: 
            case 74: 
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 81: 
            case 82: 
            case 84: 
            case 85: 
            case 86: 
            case 88: 
            case 89: 
            case 90: 
            case 93: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cdi/utils/CdiCommonUtils";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterceptorBindingTypesClasses";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierClasses";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalScopeTypesClasses";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalScopeQualifiedNames";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeTypesClasses";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeploymentTypesClasses";
                break;
            }
            case 19: 
            case 26: 
            case 27: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getStereotypeAnnotationClasses";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getVetoedPackages";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getAlternativeStereotypeAnnotationClasses";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedNames";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getProducerMethods";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getProducerFields";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisposerMethods";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getObservesMethods";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "collectCdiBeansAnnotations";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "collectBeanDefiningAnnotations";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "getBeanDefiningAnnotations";
                break;
            }
            case 71: 
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "collectExtensionBeanDescriptors";
                break;
            }
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "findJavaeeDescriptors";
                break;
            }
            case 80: {
                objectArray = objectArray2;
                objectArray2[1] = "collectBeanDescriptors";
                break;
            }
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "searchAddBeanExpressions";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "getAfterBeanDiscoveryObserves";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "detectQualifierClasses";
                break;
            }
            case 94: {
                objectArray = objectArray2;
                objectArray2[1] = "decapitalizeBeanName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierAnnotations";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getBindingTypesQualifiedNames";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getNormalScopeTypesClasses";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getScopeTypesClasses";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getDeploymentTypesClasses";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getStereotypeAnnotationNames";
                break;
            }
            case 18: 
            case 24: 
            case 25: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getStereotypeAnnotationClasses";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getVetoedPackages";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getAlternativeStereotypeAnnotationClasses";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "isManagedBean";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "isCdiInstalled";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isDecorator";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isInterceptor";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isAlternative";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isAlternativeAnnotated";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "hasAlternativeProducers";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalPsiClass";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getProviderClass";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getSuperTypes";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "canBeProxied";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getProducerMethods";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getProducerFields";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getPsiTypeProducers";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getDisposerMethods";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getObservesMethods";
                break;
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "isClassContainsCdiAnnotations";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "collectCdiBeansAnnotations";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "hasImplicitArchive";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "hasBeanDefinedClasses";
                break;
            }
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "hasAnnotatedMembers";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "collectBeanDefiningAnnotations";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getBeanDefiningAnnotations";
                break;
            }
            case 70: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "collectExtensionBeanDescriptors";
                break;
            }
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "findJavaeeDescriptors";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "collectBeanDescriptors";
                break;
            }
            case 81: 
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "searchAddBeanExpressions";
                break;
            }
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "getAfterBeanDiscoveryObserves";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierBeanAnnotation";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "isAppropriateBeanCandidate";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "hasExternalListenerMethods";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "decapitalizeBeanName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 8, 9, 13, 15, 17, 18, 20, 22, 24, 25, 28, 29, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 49, 50, 51, 53, 55, 56, 57, 58, 59, 61, 62, 63, 64, 65, 66, 68, 70, 72, 74, 75, 76, 78, 79, 81, 82, 84, 85, 86, 88, 89, 90, 93 -> new IllegalArgumentException(string);
        };
    }
}

