/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.view;

import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphEditModeFactory;
import com.intellij.openapi.graph.builder.event.GraphBuilderListener;
import com.intellij.openapi.graph.view.BaseGraphEdgeCreationMode;
import com.intellij.openapi.graph.view.BaseGraphEditEdgeMode;
import com.intellij.openapi.graph.view.BaseGraphHotSpotMode;
import com.intellij.openapi.graph.view.BaseGraphMoveSelectionMode;
import com.intellij.openapi.graph.view.CellEditorMode;
import com.intellij.openapi.graph.view.CreateEdgeMode;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.HotSpotMode;
import com.intellij.openapi.graph.view.MagnifierViewMode;
import com.intellij.openapi.graph.view.MouseInputMode;
import com.intellij.openapi.graph.view.MoveLabelMode;
import com.intellij.openapi.graph.view.MoveNodePortMode;
import com.intellij.openapi.graph.view.MovePortMode;
import com.intellij.openapi.graph.view.MoveSelectionMode;
import com.intellij.openapi.graph.view.MoveViewPortMode;
import com.intellij.openapi.graph.view.NavigationMode;
import com.intellij.openapi.graph.view.OrthogonalMoveBendsMode;
import com.intellij.openapi.graph.view.PopupMode;
import com.intellij.openapi.graph.view.SelectionBoxMode;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.EventDispatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GraphViewControllerBuilder<Self extends GraphViewControllerBuilder<Self>> {
    @NotNull
    private final GraphBuilder<?, ?> myBuilder;
    @NotNull
    private final EventDispatcher<GraphBuilderListener> myDispatcher;
    @NotNull
    private EditMode myEditMode;
    @NotNull
    private CellEditorMode myCellEditorMode;
    @NotNull
    private CreateEdgeMode myCreateEdgeMode;
    @NotNull
    private HotSpotMode myHotSpotMode;
    @NotNull
    private MouseInputMode myMouseInputMode;
    @NotNull
    private MoveLabelMode myMoveLabelMode;
    @NotNull
    private MoveNodePortMode myMoveNodePortMode;
    @NotNull
    private MovePortMode myMovePortMode;
    @NotNull
    private MoveSelectionMode myMoveSelectionMode;
    @NotNull
    private MoveViewPortMode myMoveViewPortMode;
    @NotNull
    private OrthogonalMoveBendsMode myOrthogonalMoveBendsMode;
    @NotNull
    private PopupMode myPopupMode;
    @Nullable
    private SelectionBoxMode mySelectionBoxMode;
    @NotNull
    private NavigationMode myNavigationMode;
    @NotNull
    private MagnifierViewMode myMagnifierViewMode;
    private boolean myIsSnappingEnabled;

    protected GraphViewControllerBuilder(@NotNull GraphBuilder<?, ?> builder, @NotNull EventDispatcher<GraphBuilderListener> dispatcher) {
        if (builder == null) {
            GraphViewControllerBuilder.$$$reportNull$$$0(0);
        }
        if (dispatcher == null) {
            GraphViewControllerBuilder.$$$reportNull$$$0(1);
        }
        this.myBuilder = builder;
        this.myDispatcher = dispatcher;
        GraphEditModeFactory editModeFactory = GraphEditModeFactory.getInstance(this.myBuilder.getProject());
        this.myEditMode = editModeFactory.createEditMode(this.myBuilder);
        this.myCellEditorMode = editModeFactory.createCellEditorMode(this.myBuilder);
        this.myCreateEdgeMode = new BaseGraphEdgeCreationMode(this.myBuilder.getGraphPresentationModel().getEdgeCreationPolicy(), this.myBuilder);
        this.myHotSpotMode = new BaseGraphHotSpotMode(this.myBuilder.getView());
        this.myMouseInputMode = new MouseInputMode();
        this.myMoveLabelMode = new MoveLabelMode();
        this.myMoveNodePortMode = new MoveNodePortMode();
        this.myMovePortMode = new MovePortMode();
        this.myMoveSelectionMode = new BaseGraphMoveSelectionMode(this.myBuilder, this.myDispatcher);
        this.myMoveViewPortMode = new MoveViewPortMode();
        this.myOrthogonalMoveBendsMode = new BaseGraphEditEdgeMode(this.myBuilder, this.myDispatcher);
        this.mySelectionBoxMode = new SelectionBoxMode();
        this.myPopupMode = editModeFactory.createPopupMode(this.myBuilder);
        this.myNavigationMode = new NavigationMode();
        this.myMagnifierViewMode = new MagnifierViewMode();
        this.myIsSnappingEnabled = Registry.is((String)"diagrams.use.snapping");
    }

    @NotNull
    protected abstract Self self();

    public abstract void endSetup();

    @NotNull
    public Self setEditMode(@NotNull EditMode editMode) {
        if (editMode == null) {
            GraphViewControllerBuilder.$$$reportNull$$$0(2);
        }
        this.myEditMode = editMode;
        Self Self = this.self();
        if (Self == null) {
            GraphViewControllerBuilder.$$$reportNull$$$0(3);
        }
        return Self;
    }

    @NotNull
    public Self setCellEditorMode(@NotNull CellEditorMode cellEditorMode) {
        if (cellEditorMode == null) {
            GraphViewControllerBuilder.$$$reportNull$$$0(4);
        }
        this.myCellEditorMode = cellEditorMode;
        Self Self = this.self();
        if (Self == null) {
            GraphViewControllerBuilder.$$$reportNull$$$0(5);
        }
        return Self;
    }

    @NotNull
    public Self setCreateEdgeMode(@NotNull CreateEdgeMode createEdgeMode) {
        if (createEdgeMode == null) {
            GraphViewControllerBuilder.$$$reportNull$$$0(6);
        }
        this.myCreateEdgeMode = createEdgeMode;
        Self Self = this.self();
        if (Self == null) {
            GraphViewControllerBuilder.$$$reportNull$$$0(7);
        }
        return Self;
    }

    @NotNull
    public Self setHotSpotMode(@NotNull HotSpotMode hotSpotMode) {
        if (hotSpotMode == null) {
            GraphViewControllerBuilder.$$$reportNull$$$0(8);
        }
        this.myHotSpotMode = hotSpotMode;
        Self Self = this.self();
        if (Self == null) {
            GraphViewControllerBuilder.$$$reportNull$$$0(9);
        }
        return Self;
    }

    @NotNull
    public Self setMouseInputMode(@NotNull MouseInputMode mouseInputMode) {
        if (mouseInputMode == null) {
            GraphViewControllerBuilder.$$$reportNull$$$0(10);
        }
        this.myMouseInputMode = mouseInputMode;
        Self Self = this.self();
        if (Self == null) {
            GraphViewControllerBuilder.$$$reportNull$$$0(11);
        }
        return Self;
    }

    @NotNull
    public Self setMoveLabelMode(@NotNull MoveLabelMode moveLabelMode) {
        if (moveLabelMode == null) {
            GraphViewControllerBuilder.$$$reportNull$$$0(12);
        }
        this.myMoveLabelMode = moveLabelMode;
        Self Self = this.self();
        if (Self == null) {
            GraphViewControllerBuilder.$$$reportNull$$$0(13);
        }
        return Self;
    }

    @NotNull
    public Self setMoveNodePortMode(@NotNull MoveNodePortMode moveNodePortMode) {
        if (moveNodePortMode == null) {
            GraphViewControllerBuilder.$$$reportNull$$$0(14);
        }
        this.myMoveNodePortMode = moveNodePortMode;
        Self Self = this.self();
        if (Self == null) {
            GraphViewControllerBuilder.$$$reportNull$$$0(15);
        }
        return Self;
    }

    @NotNull
    public Self setMovePortMode(@NotNull MovePortMode movePortMode) {
        if (movePortMode == null) {
            GraphViewControllerBuilder.$$$reportNull$$$0(16);
        }
        this.myMovePortMode = movePortMode;
        Self Self = this.self();
        if (Self == null) {
            GraphViewControllerBuilder.$$$reportNull$$$0(17);
        }
        return Self;
    }

    @NotNull
    public Self setMoveSelectionMode(@NotNull MoveSelectionMode moveSelectionMode) {
        if (moveSelectionMode == null) {
            GraphViewControllerBuilder.$$$reportNull$$$0(18);
        }
        this.myMoveSelectionMode = moveSelectionMode;
        Self Self = this.self();
        if (Self == null) {
            GraphViewControllerBuilder.$$$reportNull$$$0(19);
        }
        return Self;
    }

    @NotNull
    public Self setMoveViewPortMode(@NotNull MoveViewPortMode moveViewPortMode) {
        if (moveViewPortMode == null) {
            GraphViewControllerBuilder.$$$reportNull$$$0(20);
        }
        this.myMoveViewPortMode = moveViewPortMode;
        Self Self = this.self();
        if (Self == null) {
            GraphViewControllerBuilder.$$$reportNull$$$0(21);
        }
        return Self;
    }

    @NotNull
    public Self setOrthogonalMoveBendsMode(@NotNull OrthogonalMoveBendsMode orthogonalMoveBendsMode) {
        if (orthogonalMoveBendsMode == null) {
            GraphViewControllerBuilder.$$$reportNull$$$0(22);
        }
        this.myOrthogonalMoveBendsMode = orthogonalMoveBendsMode;
        Self Self = this.self();
        if (Self == null) {
            GraphViewControllerBuilder.$$$reportNull$$$0(23);
        }
        return Self;
    }

    @NotNull
    public Self setPopupMode(@NotNull PopupMode popupMode) {
        if (popupMode == null) {
            GraphViewControllerBuilder.$$$reportNull$$$0(24);
        }
        this.myPopupMode = popupMode;
        Self Self = this.self();
        if (Self == null) {
            GraphViewControllerBuilder.$$$reportNull$$$0(25);
        }
        return Self;
    }

    @NotNull
    public Self setSelectionBoxMode(@Nullable SelectionBoxMode selectionBoxMode) {
        this.mySelectionBoxMode = selectionBoxMode;
        Self Self = this.self();
        if (Self == null) {
            GraphViewControllerBuilder.$$$reportNull$$$0(26);
        }
        return Self;
    }

    @NotNull
    public Self setNavigationMode(@NotNull NavigationMode navigationMode) {
        if (navigationMode == null) {
            GraphViewControllerBuilder.$$$reportNull$$$0(27);
        }
        this.myNavigationMode = navigationMode;
        Self Self = this.self();
        if (Self == null) {
            GraphViewControllerBuilder.$$$reportNull$$$0(28);
        }
        return Self;
    }

    @NotNull
    public Self setMagnifierViewMode(@NotNull MagnifierViewMode magnifierViewMode) {
        if (magnifierViewMode == null) {
            GraphViewControllerBuilder.$$$reportNull$$$0(29);
        }
        this.myMagnifierViewMode = magnifierViewMode;
        Self Self = this.self();
        if (Self == null) {
            GraphViewControllerBuilder.$$$reportNull$$$0(30);
        }
        return Self;
    }

    @NotNull
    public Self setSnappingEnabled(boolean isSnappingEnabled) {
        this.myIsSnappingEnabled = isSnappingEnabled;
        Self Self = this.self();
        if (Self == null) {
            GraphViewControllerBuilder.$$$reportNull$$$0(31);
        }
        return Self;
    }

    protected void setEditModeConstituents(@NotNull EditMode editMode) {
        if (editMode == null) {
            GraphViewControllerBuilder.$$$reportNull$$$0(32);
        }
        editMode.setEditNodeMode(this.getCellEditorMode());
        editMode.setCreateEdgeMode(this.getCreateEdgeMode());
        editMode.setHotSpotMode(this.getHotSpotMode());
        editMode.setMouseInputMode(this.getMouseInputMode());
        editMode.setMoveLabelMode(this.getMoveLabelMode());
        editMode.setMoveNodePortMode(this.getMoveNodePortMode());
        editMode.setMovePortMode(this.getMovePortMode());
        editMode.setMoveSelectionMode(this.getMoveSelectionMode());
        editMode.setMoveViewPortMode(this.getMoveViewPortMode());
        editMode.setOrthogonalMoveBendsMode(this.getOrthogonalMoveBendsMode());
        editMode.setPopupMode(this.getPopupMode());
        editMode.setSelectionBoxMode(this.getSelectionBoxMode());
        editMode.setSnappingEnabled(this.isSnappingEnabled());
    }

    @NotNull
    protected GraphBuilder<?, ?> getBuilder() {
        GraphBuilder<?, ?> graphBuilder = this.myBuilder;
        if (graphBuilder == null) {
            GraphViewControllerBuilder.$$$reportNull$$$0(33);
        }
        return graphBuilder;
    }

    @NotNull
    protected EventDispatcher<GraphBuilderListener> getDispatcher() {
        EventDispatcher<GraphBuilderListener> eventDispatcher = this.myDispatcher;
        if (eventDispatcher == null) {
            GraphViewControllerBuilder.$$$reportNull$$$0(34);
        }
        return eventDispatcher;
    }

    @NotNull
    protected EditMode getEditMode() {
        EditMode editMode = this.myEditMode;
        if (editMode == null) {
            GraphViewControllerBuilder.$$$reportNull$$$0(35);
        }
        return editMode;
    }

    @NotNull
    protected CellEditorMode getCellEditorMode() {
        CellEditorMode cellEditorMode = this.myCellEditorMode;
        if (cellEditorMode == null) {
            GraphViewControllerBuilder.$$$reportNull$$$0(36);
        }
        return cellEditorMode;
    }

    @NotNull
    protected CreateEdgeMode getCreateEdgeMode() {
        CreateEdgeMode createEdgeMode = this.myCreateEdgeMode;
        if (createEdgeMode == null) {
            GraphViewControllerBuilder.$$$reportNull$$$0(37);
        }
        return createEdgeMode;
    }

    @NotNull
    protected HotSpotMode getHotSpotMode() {
        HotSpotMode hotSpotMode = this.myHotSpotMode;
        if (hotSpotMode == null) {
            GraphViewControllerBuilder.$$$reportNull$$$0(38);
        }
        return hotSpotMode;
    }

    @NotNull
    protected MouseInputMode getMouseInputMode() {
        MouseInputMode mouseInputMode = this.myMouseInputMode;
        if (mouseInputMode == null) {
            GraphViewControllerBuilder.$$$reportNull$$$0(39);
        }
        return mouseInputMode;
    }

    @NotNull
    protected MoveLabelMode getMoveLabelMode() {
        MoveLabelMode moveLabelMode = this.myMoveLabelMode;
        if (moveLabelMode == null) {
            GraphViewControllerBuilder.$$$reportNull$$$0(40);
        }
        return moveLabelMode;
    }

    @NotNull
    protected MoveNodePortMode getMoveNodePortMode() {
        MoveNodePortMode moveNodePortMode = this.myMoveNodePortMode;
        if (moveNodePortMode == null) {
            GraphViewControllerBuilder.$$$reportNull$$$0(41);
        }
        return moveNodePortMode;
    }

    @NotNull
    protected MovePortMode getMovePortMode() {
        MovePortMode movePortMode = this.myMovePortMode;
        if (movePortMode == null) {
            GraphViewControllerBuilder.$$$reportNull$$$0(42);
        }
        return movePortMode;
    }

    @NotNull
    protected MoveSelectionMode getMoveSelectionMode() {
        MoveSelectionMode moveSelectionMode = this.myMoveSelectionMode;
        if (moveSelectionMode == null) {
            GraphViewControllerBuilder.$$$reportNull$$$0(43);
        }
        return moveSelectionMode;
    }

    @NotNull
    protected MoveViewPortMode getMoveViewPortMode() {
        MoveViewPortMode moveViewPortMode = this.myMoveViewPortMode;
        if (moveViewPortMode == null) {
            GraphViewControllerBuilder.$$$reportNull$$$0(44);
        }
        return moveViewPortMode;
    }

    @NotNull
    protected OrthogonalMoveBendsMode getOrthogonalMoveBendsMode() {
        OrthogonalMoveBendsMode orthogonalMoveBendsMode = this.myOrthogonalMoveBendsMode;
        if (orthogonalMoveBendsMode == null) {
            GraphViewControllerBuilder.$$$reportNull$$$0(45);
        }
        return orthogonalMoveBendsMode;
    }

    @NotNull
    protected PopupMode getPopupMode() {
        PopupMode popupMode = this.myPopupMode;
        if (popupMode == null) {
            GraphViewControllerBuilder.$$$reportNull$$$0(46);
        }
        return popupMode;
    }

    @Nullable
    protected SelectionBoxMode getSelectionBoxMode() {
        return this.mySelectionBoxMode;
    }

    @NotNull
    protected NavigationMode getNavigationMode() {
        NavigationMode navigationMode = this.myNavigationMode;
        if (navigationMode == null) {
            GraphViewControllerBuilder.$$$reportNull$$$0(47);
        }
        return navigationMode;
    }

    @NotNull
    protected MagnifierViewMode getMagnifierViewMode() {
        MagnifierViewMode magnifierViewMode = this.myMagnifierViewMode;
        if (magnifierViewMode == null) {
            GraphViewControllerBuilder.$$$reportNull$$$0(48);
        }
        return magnifierViewMode;
    }

    protected boolean isSnappingEnabled() {
        return this.myIsSnappingEnabled;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 7, 9, 11, 13, 15, 17, 19, 21, 23, 25, 26, 28, 30, 31, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dispatcher";
                break;
            }
            case 2: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editMode";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/view/GraphViewControllerBuilder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cellEditorMode";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createEdgeMode";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hotSpotMode";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mouseInputMode";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moveLabelMode";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moveNodePortMode";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "movePortMode";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moveSelectionMode";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moveViewPortMode";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orthogonalMoveBendsMode";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupMode";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "navigationMode";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "magnifierViewMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/view/GraphViewControllerBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "setEditMode";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "setCellEditorMode";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "setCreateEdgeMode";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "setHotSpotMode";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "setMouseInputMode";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "setMoveLabelMode";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "setMoveNodePortMode";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "setMovePortMode";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "setMoveSelectionMode";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "setMoveViewPortMode";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "setOrthogonalMoveBendsMode";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "setPopupMode";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "setSelectionBoxMode";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "setNavigationMode";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "setMagnifierViewMode";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "setSnappingEnabled";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuilder";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getDispatcher";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditMode";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getCellEditorMode";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreateEdgeMode";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getHotSpotMode";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getMouseInputMode";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getMoveLabelMode";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getMoveNodePortMode";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getMovePortMode";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getMoveSelectionMode";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "getMoveViewPortMode";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrthogonalMoveBendsMode";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getPopupMode";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigationMode";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getMagnifierViewMode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setEditMode";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setCellEditorMode";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setCreateEdgeMode";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setHotSpotMode";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setMouseInputMode";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setMoveLabelMode";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setMoveNodePortMode";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setMovePortMode";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setMoveSelectionMode";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setMoveViewPortMode";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "setOrthogonalMoveBendsMode";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setPopupMode";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "setNavigationMode";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "setMagnifierViewMode";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "setEditModeConstituents";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 7, 9, 11, 13, 15, 17, 19, 21, 23, 25, 26, 28, 30, 31, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48 -> new IllegalStateException(string);
        };
    }
}

