/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.syntax.parser;

import com.intellij.java.syntax.element.JavaDocSyntaxElementType;
import com.intellij.java.syntax.element.JavaDocSyntaxTokenType;
import com.intellij.java.syntax.element.JavaSyntaxElementType;
import com.intellij.java.syntax.parser.JavaDocParserKt;
import com.intellij.java.syntax.parser.JavaParser;
import com.intellij.java.syntax.parser.JavaParserUtil;
import com.intellij.platform.syntax.SyntaxElementType;
import com.intellij.platform.syntax.SyntaxElementTypeSet;
import com.intellij.platform.syntax.element.SyntaxTokenTypes;
import com.intellij.platform.syntax.parser.SyntaxTreeBuilder;
import com.intellij.platform.syntax.parser.WhitespacesBinders;
import com.intellij.pom.java.LanguageLevel;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0013\u001a\u00020\u000fH\u0002J\u0006\u0010\u0014\u001a\u00020\u000fJ\b\u0010\u0015\u001a\u00020\u000fH\u0002J\u001a\u0010\u0016\u001a\u00020\u000f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u000fH\u0002J\b\u0010\u001c\u001a\u00020\u000fH\u0002J\b\u0010\u001d\u001a\u00020\u000fH\u0002J\b\u0010\u001e\u001a\u00020\u000fH\u0002J\b\u0010\u001f\u001a\u00020\u000fH\u0002J\u0014\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\"\u001a\u0004\u0018\u00010!H\u0002J&\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\"\u001a\u0004\u0018\u00010!2\b\u0010#\u001a\u0004\u0018\u00010!2\u0006\u0010$\u001a\u00020\u001aH\u0003J\b\u0010%\u001a\u00020\u000fH\u0002J\b\u0010&\u001a\u00020\u000fH\u0002J\b\u0010'\u001a\u00020\u000fH\u0002J\b\u0010(\u001a\u00020\u000fH\u0002J\u0010\u0010)\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u001aH\u0002J\u0012\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020,H\u0002J\u0010\u0010.\u001a\u00020\u000f2\u0006\u0010/\u001a\u00020,H\u0002J\u0010\u00100\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020,H\u0002J\b\u00101\u001a\u00020\u000fH\u0002J\b\u00102\u001a\u00020\u000fH\u0002J\n\u00103\u001a\u0004\u0018\u00010!H\u0002J\u0012\u00103\u001a\u0004\u0018\u00010!2\u0006\u00104\u001a\u00020\u001aH\u0002J\b\u00105\u001a\u00020\rH\u0002J\u0010\u00106\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u00107\u001a\u00020\u000fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/intellij/java/syntax/parser/JavaDocParser;", "", "builder", "Lcom/intellij/platform/syntax/parser/SyntaxTreeBuilder;", "languageLevel", "Lcom/intellij/pom/java/LanguageLevel;", "<init>", "(Lcom/intellij/platform/syntax/parser/SyntaxTreeBuilder;Lcom/intellij/pom/java/LanguageLevel;)V", "getBuilder", "()Lcom/intellij/platform/syntax/parser/SyntaxTreeBuilder;", "getLanguageLevel", "()Lcom/intellij/pom/java/LanguageLevel;", "braceScope", "", "parseJavadocReference", "", "parser", "Lcom/intellij/java/syntax/parser/JavaParser;", "parseJavadocType", "swallowTokens", "parseDocCommentText", "parseTag", "parseDataItem", "tagName", "", "isInline", "", "parseCommentData", "parseInlineCodeBlock", "parseCodeBlock", "parseMarkdownReferenceChecked", "parseMarkdownReference", "findInlineToken", "Lcom/intellij/platform/syntax/SyntaxElementType;", "needle", "travelToken", "isTravelTokenDisallowed", "parseSnippetTagValue", "parseSnippetTagBody", "parseSnippetAttributeList", "parseSnippetAttribute", "parseSeeTagValue", "allowBareFieldReference", "parseModuleRef", "Lcom/intellij/platform/syntax/parser/SyntaxTreeBuilder$Marker;", "refStart", "parseFragmentRef", "mark", "parseMethodRef", "parseParameterRef", "parseSimpleTagValue", "getTokenType", "skipWhitespace", "getBraceScope", "setBraceScope", "remapAndAdvance", "intellij.java.syntax"})
@SourceDebugExtension(value={"SMAP\nJavaDocParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaDocParser.kt\ncom/intellij/java/syntax/parser/JavaDocParser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,737:1\n1#2:738\n*E\n"})
public final class JavaDocParser {
    @NotNull
    private final SyntaxTreeBuilder builder;
    @NotNull
    private final LanguageLevel languageLevel;
    private int braceScope;

    public JavaDocParser(@NotNull SyntaxTreeBuilder builder, @NotNull LanguageLevel languageLevel) {
        this.builder = builder;
        this.languageLevel = languageLevel;
    }

    @NotNull
    public final SyntaxTreeBuilder getBuilder() {
        return this.builder;
    }

    @NotNull
    public final LanguageLevel getLanguageLevel() {
        return this.languageLevel;
    }

    public final void parseJavadocReference(@NotNull JavaParser parser) {
        parser.getReferenceParser().parseJavaCodeReference(this.builder, true, true, false, false);
        this.swallowTokens();
    }

    public final void parseJavadocType(@NotNull JavaParser parser) {
        parser.getReferenceParser().parseType(this.builder, 7);
        this.swallowTokens();
    }

    private final void swallowTokens() {
        while (!this.builder.eof()) {
            this.builder.advanceLexer();
        }
    }

    public final void parseDocCommentText() {
        this.builder.enforceCommentTokens(JavaDocParserKt.access$getSKIP_TOKENS$p());
        while (!this.builder.eof()) {
            SyntaxElementType tokenType = this.getTokenType();
            if (tokenType == JavaDocSyntaxTokenType.DOC_TAG_NAME) {
                this.parseTag();
                continue;
            }
            this.parseDataItem(null, false);
        }
    }

    private final void parseTag() {
        SyntaxElementType tokenType;
        String tagName = this.builder.getTokenText();
        SyntaxTreeBuilder.Marker tag = this.builder.mark();
        this.builder.advanceLexer();
        while ((tokenType = this.getTokenType()) != null && tokenType != JavaDocSyntaxTokenType.DOC_TAG_NAME && tokenType != JavaDocSyntaxTokenType.DOC_COMMENT_END) {
            this.parseDataItem(tagName, false);
        }
        tag.done(JavaDocSyntaxElementType.DOC_TAG);
    }

    private final void parseDataItem(String tagName, boolean isInline) {
        SyntaxElementType tokenType = this.getTokenType();
        if (tokenType == JavaDocSyntaxTokenType.DOC_INLINE_TAG_START) {
            int braceScope = this.getBraceScope();
            if (braceScope > 0) {
                this.setBraceScope(braceScope + 1);
                this.builder.remapCurrentToken(JavaDocSyntaxTokenType.DOC_COMMENT_DATA);
                this.builder.advanceLexer();
                return;
            }
            SyntaxTreeBuilder.Marker tag = this.builder.mark();
            this.builder.advanceLexer();
            tokenType = this.getTokenType();
            if (tokenType != JavaDocSyntaxTokenType.DOC_TAG_NAME && tokenType != JavaDocSyntaxTokenType.DOC_COMMENT_BAD_CHARACTER) {
                tag.rollbackTo();
                this.builder.remapCurrentToken(JavaDocSyntaxTokenType.DOC_COMMENT_DATA);
                this.builder.advanceLexer();
                return;
            }
            this.setBraceScope(braceScope + 1);
            String inlineTagName = "";
            while (true) {
                if ((tokenType = this.getTokenType()) == JavaDocSyntaxTokenType.DOC_TAG_NAME) {
                    inlineTagName = this.builder.getTokenText();
                } else if (tokenType == null || tokenType == JavaDocSyntaxTokenType.DOC_COMMENT_END) break;
                this.parseDataItem(inlineTagName, true);
                if (tokenType != JavaDocSyntaxTokenType.DOC_INLINE_TAG_END) continue;
                braceScope = this.getBraceScope();
                if (braceScope > 0) {
                    this.setBraceScope(--braceScope);
                }
                if (braceScope == 0) break;
            }
            if (Intrinsics.areEqual((Object)"@snippet", (Object)inlineTagName)) {
                tag.done(JavaDocSyntaxElementType.DOC_SNIPPET_TAG);
            } else {
                tag.done(JavaDocSyntaxElementType.DOC_INLINE_TAG);
            }
        } else if (JavaDocParserKt.access$getTAG_VALUES_SET$p().containsNullable(tokenType)) {
            if (Intrinsics.areEqual((Object)"@see", (Object)tagName) && !isInline || Intrinsics.areEqual((Object)"@link", (Object)tagName) && isInline || this.languageLevel.isAtLeast(LanguageLevel.JDK_1_4) && Intrinsics.areEqual((Object)"@linkplain", (Object)tagName) && isInline) {
                this.parseSeeTagValue(false);
            } else if (!isInline && tagName != null && JavaDocParserKt.access$getREFERENCE_TAGS$p().contains(tagName) || isInline && Intrinsics.areEqual((Object)tagName, (Object)"@inheritDoc")) {
                SyntaxTreeBuilder.Marker tagValue = this.builder.mark();
                this.builder.remapCurrentToken(JavaDocSyntaxElementType.DOC_REFERENCE_HOLDER);
                this.builder.advanceLexer();
                tagValue.done(JavaDocSyntaxElementType.DOC_TAG_VALUE_ELEMENT);
            } else if (!isInline && Intrinsics.areEqual((Object)"@param", (Object)tagName)) {
                this.parseParameterRef();
            } else if (this.languageLevel.isAtLeast(LanguageLevel.JDK_1_5) && Intrinsics.areEqual((Object)"@value", (Object)tagName) && isInline) {
                this.parseSeeTagValue(true);
            } else if (Intrinsics.areEqual((Object)"@snippet", (Object)tagName) && isInline) {
                this.parseSnippetTagValue();
            } else {
                this.parseSimpleTagValue();
            }
        } else if (tokenType == JavaDocSyntaxTokenType.DOC_INLINE_CODE_FENCE) {
            this.parseInlineCodeBlock();
        } else if (tokenType == JavaDocSyntaxTokenType.DOC_CODE_FENCE) {
            this.parseCodeBlock();
        } else if (tokenType == JavaDocSyntaxTokenType.DOC_LBRACKET) {
            this.parseMarkdownReferenceChecked();
        } else if (tokenType == JavaDocSyntaxTokenType.DOC_COMMENT_DATA) {
            this.parseCommentData();
        } else {
            this.remapAndAdvance();
        }
    }

    private final void parseCommentData() {
        SyntaxTreeBuilder.Marker commentData = this.builder.mark();
        int offset = this.builder.getCurrentOffset();
        while (JavaDocParserKt.access$getCOMMENT_DATA_TOKENS$p().containsNullable(this.builder.rawLookup(1))) {
            this.builder.advanceLexer();
        }
        if (this.builder.getCurrentOffset() != offset) {
            this.builder.advanceLexer();
            commentData.collapse(JavaDocSyntaxTokenType.DOC_COMMENT_DATA);
        } else {
            commentData.drop();
            this.builder.advanceLexer();
        }
    }

    private final void parseInlineCodeBlock() {
        SyntaxTreeBuilder.Marker tag = this.builder.mark();
        SyntaxElementType stopElementType = this.findInlineToken(JavaDocSyntaxTokenType.DOC_INLINE_CODE_FENCE);
        int endOffset = this.builder.getCurrentOffset();
        tag.rollbackTo();
        if (stopElementType != JavaDocSyntaxTokenType.DOC_INLINE_CODE_FENCE) {
            this.builder.advanceLexer();
            return;
        }
        tag = this.builder.mark();
        this.builder.advanceLexer();
        while (this.builder.getCurrentOffset() < endOffset && !this.builder.eof()) {
            this.builder.remapCurrentToken(JavaDocSyntaxTokenType.DOC_COMMENT_DATA);
            this.builder.advanceLexer();
        }
        if (!this.builder.eof()) {
            this.builder.advanceLexer();
        }
        tag.done(JavaDocSyntaxElementType.DOC_MARKDOWN_CODE_BLOCK);
    }

    private final void parseCodeBlock() {
        if (this.getBraceScope() > 0) {
            this.builder.remapCurrentToken(JavaDocSyntaxTokenType.DOC_COMMENT_DATA);
            this.builder.advanceLexer();
            return;
        }
        String string = this.builder.getTokenText();
        Intrinsics.checkNotNull((Object)string);
        char fenceStart = string.charAt(0);
        SyntaxTreeBuilder.Marker tag = this.builder.mark();
        while (!this.builder.eof()) {
            this.builder.advanceLexer();
            if (this.getTokenType() == JavaDocSyntaxTokenType.DOC_CODE_FENCE) {
                String string2 = this.builder.getTokenText();
                Intrinsics.checkNotNull((Object)string2);
                if (string2.charAt(0) == fenceStart) break;
            }
            this.builder.remapCurrentToken(JavaDocSyntaxTokenType.DOC_COMMENT_DATA);
        }
        if (!this.builder.eof()) {
            this.builder.advanceLexer();
        }
        tag.done(JavaDocSyntaxElementType.DOC_MARKDOWN_CODE_BLOCK);
    }

    private final void parseMarkdownReferenceChecked() {
        int endLabelOffset;
        boolean isShortRefEmpty;
        boolean hasLabel = true;
        SyntaxTreeBuilder.Marker tag = this.builder.mark();
        int leftBracketCount = 1;
        int rightBracketCount = 0;
        int startLabelOffset = this.builder.getCurrentOffset();
        while (!this.builder.eof()) {
            SyntaxElementType token = this.findInlineToken(JavaDocSyntaxTokenType.DOC_RBRACKET, JavaDocSyntaxTokenType.DOC_LBRACKET, true);
            if (token == JavaDocSyntaxTokenType.DOC_LBRACKET) {
                ++leftBracketCount;
                continue;
            }
            if (token != JavaDocSyntaxTokenType.DOC_RBRACKET || leftBracketCount != ++rightBracketCount) continue;
        }
        boolean bl = isShortRefEmpty = (endLabelOffset = this.builder.getCurrentOffset()) - startLabelOffset <= 1;
        if (leftBracketCount != rightBracketCount || isShortRefEmpty) {
            tag.rollbackTo();
            this.builder.advanceLexer();
            return;
        }
        SyntaxElementType firstReferenceToken = this.findInlineToken(JavaDocSyntaxTokenType.DOC_LBRACKET, JavaDocSyntaxTokenType.DOC_SPACE, false);
        if (firstReferenceToken != JavaDocSyntaxTokenType.DOC_LBRACKET) {
            hasLabel = false;
            if (leftBracketCount > 1 || firstReferenceToken == JavaDocSyntaxTokenType.DOC_LPAREN) {
                tag.rollbackTo();
                this.builder.advanceLexer();
                return;
            }
        }
        if (hasLabel && this.findInlineToken(JavaDocSyntaxTokenType.DOC_RBRACKET, JavaDocSyntaxTokenType.DOC_LBRACKET, true) != JavaDocSyntaxTokenType.DOC_RBRACKET) {
            hasLabel = false;
            if (leftBracketCount > 1) {
                tag.rollbackTo();
                this.builder.advanceLexer();
                return;
            }
        }
        tag.rollbackTo();
        tag = this.builder.mark();
        if (hasLabel) {
            this.builder.advanceLexer();
            SyntaxTreeBuilder.Marker label = this.builder.mark();
            while (!this.builder.eof()) {
                if (this.builder.getTokenType() == JavaDocSyntaxTokenType.DOC_INLINE_CODE_FENCE) {
                    this.parseInlineCodeBlock();
                    continue;
                }
                if (this.builder.getCurrentOffset() >= endLabelOffset) break;
                this.builder.remapCurrentToken(JavaDocSyntaxTokenType.DOC_COMMENT_DATA);
                this.builder.advanceLexer();
            }
            label.done(JavaDocSyntaxElementType.DOC_MARKDOWN_REFERENCE_LABEL);
            this.builder.advanceLexer();
        }
        this.builder.advanceLexer();
        this.parseMarkdownReference();
        this.builder.advanceLexer();
        tag.done(JavaDocSyntaxElementType.DOC_MARKDOWN_REFERENCE_LINK);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void parseMarkdownReference() {
        SyntaxTreeBuilder.Marker refStart = this.builder.mark();
        SyntaxTreeBuilder.Marker moduleMarker = this.parseModuleRef(this.builder.mark());
        boolean referenceParsed = false;
        boolean referenceEnded = false;
        boolean fragmentReference = false;
        if (this.getTokenType() == JavaDocSyntaxTokenType.DOC_RBRACKET) {
            if (moduleMarker == null) {
                refStart.drop();
                return;
            }
            referenceEnded = true;
        }
        if (!referenceEnded && this.getTokenType() != JavaDocSyntaxTokenType.DOC_SHARP && this.getTokenType() != JavaDocSyntaxTokenType.DOC_DOUBLE_SHARP) {
            this.builder.remapCurrentToken(JavaDocSyntaxElementType.DOC_REFERENCE_HOLDER);
            this.builder.advanceLexer();
        }
        if (!referenceEnded && this.getTokenType() == JavaDocSyntaxTokenType.DOC_SHARP) {
            this.builder.remapCurrentToken(JavaDocSyntaxTokenType.DOC_TAG_VALUE_SHARP_TOKEN);
            this.builder.advanceLexer();
            this.builder.remapCurrentToken(JavaDocSyntaxTokenType.DOC_TAG_VALUE_TOKEN);
            this.builder.advanceLexer();
            if (this.builder.getTokenType() == JavaDocSyntaxTokenType.DOC_LPAREN) {
                this.builder.advanceLexer();
                SyntaxTreeBuilder.Marker subValue = this.builder.mark();
                while (!this.builder.eof()) {
                    SyntaxElementType type = this.getTokenType();
                    if (type == JavaDocSyntaxTokenType.DOC_COMMENT_DATA) {
                        this.builder.remapCurrentToken(JavaDocSyntaxElementType.DOC_TYPE_HOLDER);
                    } else if (type != JavaDocSyntaxTokenType.DOC_COMMA) break;
                    this.builder.advanceLexer();
                }
                if (this.getTokenType() == JavaDocSyntaxTokenType.DOC_RPAREN) {
                    subValue.done(JavaDocSyntaxElementType.DOC_TAG_VALUE_ELEMENT);
                    this.builder.advanceLexer();
                } else {
                    subValue.drop();
                }
            }
            referenceParsed = true;
        } else if (!referenceEnded && this.getTokenType() == JavaDocSyntaxTokenType.DOC_DOUBLE_SHARP) {
            this.builder.remapCurrentToken(JavaDocSyntaxTokenType.DOC_TAG_VALUE_DOUBLE_SHARP_TOKEN);
            this.builder.advanceLexer();
            SyntaxTreeBuilder.Marker nameMarker = this.builder.mark();
            if (this.getTokenType() != JavaDocSyntaxTokenType.DOC_COMMENT_DATA) {
                nameMarker.rollbackTo();
            } else {
                this.builder.advanceLexer();
                nameMarker.done(JavaDocSyntaxElementType.DOC_FRAGMENT_NAME);
                referenceParsed = true;
                fragmentReference = true;
            }
        }
        if (referenceParsed || moduleMarker != null) {
            SyntaxTreeBuilder.Marker marker = moduleMarker;
            if (marker != null) {
                marker.done(JavaDocSyntaxElementType.DOC_TAG_VALUE_ELEMENT);
            }
            boolean bl = fragmentReference;
            if (bl) {
                refStart.done(JavaDocSyntaxElementType.DOC_FRAGMENT_REF);
                return;
            } else {
                if (bl) throw new NoWhenBranchMatchedException();
                refStart.done(JavaDocSyntaxElementType.DOC_METHOD_OR_FIELD_REF);
            }
            return;
        } else {
            refStart.drop();
        }
    }

    private final SyntaxElementType findInlineToken(SyntaxElementType needle) {
        return this.findInlineToken(needle, null, false);
    }

    @Contract(mutates="param1")
    private final SyntaxElementType findInlineToken(SyntaxElementType needle, SyntaxElementType travelToken, boolean isTravelTokenDisallowed) {
        SyntaxElementType token = null;
        SyntaxElementType previousToken = null;
        while (!this.builder.eof()) {
            boolean travelTokenFound;
            this.builder.advanceLexer();
            previousToken = token;
            token = this.getTokenType(false);
            if (token == needle) {
                return token;
            }
            boolean bl = travelTokenFound = travelToken == token;
            if (!(travelToken != null && (isTravelTokenDisallowed && travelTokenFound || !isTravelTokenDisallowed && !travelTokenFound)) && (token != SyntaxTokenTypes.getWHITE_SPACE() || previousToken != SyntaxTokenTypes.getWHITE_SPACE())) continue;
        }
        return this.builder.eof() ? null : token;
    }

    private final void parseSnippetTagValue() {
        SyntaxElementType token;
        SyntaxTreeBuilder.Marker snippetValue = this.builder.mark();
        snippetValue.setCustomEdgeTokenBinders(WhitespacesBinders.INSTANCE.greedyLeftBinder(), WhitespacesBinders.INSTANCE.greedyRightBinder());
        while ((token = this.getTokenType()) == JavaDocSyntaxTokenType.DOC_TAG_VALUE_QUOTE) {
            this.builder.advanceLexer();
        }
        SyntaxElementType tokenType = this.getTokenType();
        if (tokenType == JavaDocSyntaxTokenType.DOC_TAG_VALUE_COLON) {
            JavaParserUtil.INSTANCE.emptyElement(this.builder, JavaDocSyntaxElementType.DOC_SNIPPET_ATTRIBUTE_LIST);
            this.parseSnippetTagBody();
        } else if (tokenType == JavaDocSyntaxTokenType.DOC_TAG_VALUE_TOKEN) {
            this.parseSnippetAttributeList();
            if (this.builder.getTokenType() == JavaDocSyntaxTokenType.DOC_TAG_VALUE_COLON) {
                this.parseSnippetTagBody();
            }
        } else {
            JavaParserUtil.INSTANCE.emptyElement(this.builder, JavaDocSyntaxElementType.DOC_SNIPPET_ATTRIBUTE_LIST);
            SyntaxElementType current = this.getTokenType();
            while (current != null && current != JavaDocSyntaxTokenType.DOC_INLINE_TAG_END) {
                this.builder.advanceLexer();
                current = this.getTokenType();
            }
        }
        snippetValue.done(JavaDocSyntaxElementType.DOC_SNIPPET_TAG_VALUE);
    }

    private final void parseSnippetTagBody() {
        SyntaxElementType tokenType;
        SyntaxTreeBuilder.Marker body = this.builder.mark();
        body.setCustomEdgeTokenBinders(WhitespacesBinders.INSTANCE.greedyLeftBinder(), WhitespacesBinders.INSTANCE.greedyRightBinder());
        if (!(this.getTokenType() == JavaDocSyntaxTokenType.DOC_TAG_VALUE_COLON)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.builder.advanceLexer();
        while ((tokenType = this.getTokenType()) != null && tokenType != JavaDocSyntaxTokenType.DOC_INLINE_TAG_END) {
            this.builder.advanceLexer();
        }
        body.done(JavaDocSyntaxElementType.DOC_SNIPPET_BODY);
    }

    private final void parseSnippetAttributeList() {
        SyntaxTreeBuilder.Marker attributeList = this.builder.mark();
        block0: while (true) {
            SyntaxElementType type = this.getTokenType();
            while (type != JavaDocSyntaxTokenType.DOC_TAG_VALUE_TOKEN) {
                if (type != JavaDocSyntaxTokenType.DOC_TAG_VALUE_QUOTE) break block0;
                this.builder.advanceLexer();
                type = this.getTokenType();
            }
            this.parseSnippetAttribute();
        }
        attributeList.done(JavaDocSyntaxElementType.DOC_SNIPPET_ATTRIBUTE_LIST);
    }

    private final void parseSnippetAttribute() {
        SyntaxTreeBuilder.Marker attribute = this.builder.mark();
        if (!(this.builder.getTokenType() == JavaDocSyntaxTokenType.DOC_TAG_VALUE_TOKEN)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.builder.remapCurrentToken(JavaDocSyntaxTokenType.DOC_TAG_ATTRIBUTE_NAME);
        this.builder.advanceLexer();
        this.getTokenType();
        if (Intrinsics.areEqual((Object)"=", (Object)this.builder.getTokenText())) {
            this.builder.advanceLexer();
            SyntaxElementType afterEqToken = this.getTokenType();
            if (afterEqToken == JavaDocSyntaxTokenType.DOC_TAG_VALUE_QUOTE) {
                SyntaxTreeBuilder.Marker quotedValue = this.builder.mark();
                this.builder.advanceLexer();
                if (this.getTokenType() == JavaDocSyntaxTokenType.DOC_TAG_VALUE_TOKEN) {
                    this.builder.advanceLexer();
                }
                if (this.getTokenType() == JavaDocSyntaxTokenType.DOC_TAG_VALUE_QUOTE) {
                    this.builder.advanceLexer();
                }
                quotedValue.collapse(JavaDocSyntaxElementType.DOC_SNIPPET_ATTRIBUTE_VALUE);
            } else if (afterEqToken == JavaDocSyntaxTokenType.DOC_TAG_VALUE_TOKEN) {
                this.builder.remapCurrentToken(JavaDocSyntaxElementType.DOC_SNIPPET_ATTRIBUTE_VALUE);
                this.builder.advanceLexer();
            }
        }
        attribute.done(JavaDocSyntaxElementType.DOC_SNIPPET_ATTRIBUTE);
    }

    private final void parseSeeTagValue(boolean allowBareFieldReference) {
        block13: {
            SyntaxTreeBuilder.Marker moduleMarker = this.parseModuleRef(this.builder.mark());
            SyntaxElementType tokenType = this.getTokenType();
            if (tokenType == JavaDocSyntaxTokenType.DOC_TAG_VALUE_SHARP_TOKEN) {
                this.parseMethodRef(this.builder.mark());
            } else if (tokenType == JavaDocSyntaxTokenType.DOC_TAG_VALUE_DOUBLE_SHARP_TOKEN) {
                this.parseFragmentRef(this.builder.mark());
            } else if (tokenType == JavaDocSyntaxTokenType.DOC_TAG_VALUE_TOKEN) {
                SyntaxTreeBuilder.Marker refStart = this.builder.mark();
                this.builder.remapCurrentToken(JavaDocSyntaxElementType.DOC_REFERENCE_HOLDER);
                this.builder.advanceLexer();
                if (this.getTokenType() == JavaDocSyntaxTokenType.DOC_TAG_VALUE_SHARP_TOKEN) {
                    this.parseMethodRef(refStart);
                } else if (this.getTokenType() == JavaDocSyntaxTokenType.DOC_TAG_VALUE_DOUBLE_SHARP_TOKEN) {
                    this.parseFragmentRef(refStart);
                } else if (allowBareFieldReference) {
                    refStart.rollbackTo();
                    this.builder.remapCurrentToken(JavaDocSyntaxTokenType.DOC_TAG_VALUE_TOKEN);
                    this.parseMethodRef(this.builder.mark());
                } else {
                    refStart.drop();
                }
            } else if (moduleMarker == null) {
                SyntaxTreeBuilder.Marker tagValue = this.builder.mark();
                this.builder.advanceLexer();
                tagValue.done(JavaDocSyntaxElementType.DOC_TAG_VALUE_ELEMENT);
            }
            SyntaxTreeBuilder.Marker marker = moduleMarker;
            if (marker == null) break block13;
            marker.done(JavaDocSyntaxElementType.DOC_TAG_VALUE_ELEMENT);
        }
    }

    private final SyntaxTreeBuilder.Marker parseModuleRef(SyntaxTreeBuilder.Marker refStart) {
        this.builder.advanceLexer();
        if (this.getTokenType() == JavaDocSyntaxTokenType.DOC_TAG_VALUE_SLASH) {
            refStart.rollbackTo();
            SyntaxTreeBuilder.Marker containerRef = this.builder.mark();
            SyntaxTreeBuilder.Marker moduleRef = this.builder.mark();
            this.builder.advanceLexer();
            moduleRef.done(JavaSyntaxElementType.MODULE_REFERENCE);
            this.builder.advanceLexer();
            return containerRef;
        }
        refStart.rollbackTo();
        return null;
    }

    private final void parseFragmentRef(SyntaxTreeBuilder.Marker mark) {
        this.builder.advanceLexer();
        SyntaxTreeBuilder.Marker fragmentName = this.builder.mark();
        if (this.getTokenType() != JavaDocSyntaxTokenType.DOC_TAG_VALUE_TOKEN) {
            fragmentName.drop();
            mark.done(JavaDocSyntaxElementType.DOC_FRAGMENT_REF);
        } else {
            this.builder.advanceLexer();
            fragmentName.done(JavaDocSyntaxElementType.DOC_FRAGMENT_NAME);
            mark.done(JavaDocSyntaxElementType.DOC_FRAGMENT_REF);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void parseMethodRef(SyntaxTreeBuilder.Marker refStart) {
        if (this.getTokenType() == JavaDocSyntaxTokenType.DOC_TAG_VALUE_SHARP_TOKEN) {
            this.builder.advanceLexer();
        }
        if (this.getTokenType() != JavaDocSyntaxTokenType.DOC_TAG_VALUE_TOKEN) {
            refStart.done(JavaDocSyntaxElementType.DOC_METHOD_OR_FIELD_REF);
            return;
        }
        this.builder.advanceLexer();
        if (this.getTokenType() == JavaDocSyntaxTokenType.DOC_TAG_VALUE_LPAREN) {
            this.builder.advanceLexer();
            SyntaxTreeBuilder.Marker subValue = this.builder.mark();
            Object tokenType = null;
            block0: while (true) {
                void it;
                SyntaxElementType syntaxElementType;
                SyntaxElementType syntaxElementType2 = syntaxElementType = this.getTokenType();
                SyntaxElementTypeSet syntaxElementTypeSet = JavaDocParserKt.access$getTAG_VALUES_SET$p();
                boolean bl2 = false;
                tokenType = it;
                if (!syntaxElementTypeSet.containsNullable(syntaxElementType)) break;
                syntaxElementType = tokenType;
                if (Intrinsics.areEqual((Object)syntaxElementType, (Object)JavaDocSyntaxTokenType.DOC_TAG_VALUE_TOKEN)) {
                    this.builder.remapCurrentToken(JavaDocSyntaxElementType.DOC_TYPE_HOLDER);
                    this.builder.advanceLexer();
                    while (true) {
                        void it2;
                        SyntaxElementType bl2 = syntaxElementType2 = this.getTokenType();
                        syntaxElementTypeSet = JavaDocParserKt.access$getTAG_VALUES_SET$p();
                        boolean bl3 = false;
                        tokenType = it2;
                        if (!syntaxElementTypeSet.containsNullable(syntaxElementType2) || tokenType == JavaDocSyntaxTokenType.DOC_TAG_VALUE_COMMA || tokenType == JavaDocSyntaxTokenType.DOC_TAG_VALUE_RPAREN) continue block0;
                        this.builder.advanceLexer();
                    }
                }
                if (Intrinsics.areEqual((Object)syntaxElementType, (Object)JavaDocSyntaxTokenType.DOC_TAG_VALUE_RPAREN)) {
                    subValue.done(JavaDocSyntaxElementType.DOC_TAG_VALUE_ELEMENT);
                    this.builder.advanceLexer();
                    refStart.done(JavaDocSyntaxElementType.DOC_METHOD_OR_FIELD_REF);
                    return;
                }
                this.builder.advanceLexer();
            }
            subValue.done(JavaDocSyntaxElementType.DOC_TAG_VALUE_ELEMENT);
        }
        refStart.done(JavaDocSyntaxElementType.DOC_METHOD_OR_FIELD_REF);
    }

    private final void parseParameterRef() {
        SyntaxTreeBuilder.Marker tagValue = this.builder.mark();
        while (JavaDocParserKt.access$getTAG_VALUES_SET$p().containsNullable(this.getTokenType())) {
            this.builder.advanceLexer();
        }
        tagValue.done(JavaDocSyntaxElementType.DOC_PARAMETER_REF);
    }

    private final void parseSimpleTagValue() {
        SyntaxTreeBuilder.Marker tagData = this.builder.mark();
        while (true) {
            SyntaxElementType tokenType;
            if ((tokenType = this.getTokenType()) == JavaDocSyntaxTokenType.DOC_COMMENT_BAD_CHARACTER) {
                this.builder.remapCurrentToken(JavaDocSyntaxTokenType.DOC_TAG_VALUE_TOKEN);
            } else if (!JavaDocParserKt.access$getTAG_VALUES_SET$p().containsNullable(tokenType)) break;
            this.builder.advanceLexer();
        }
        tagData.done(JavaDocSyntaxElementType.DOC_TAG_VALUE_ELEMENT);
    }

    private final SyntaxElementType getTokenType() {
        return this.getTokenType(true);
    }

    private final SyntaxElementType getTokenType(boolean skipWhitespace) {
        SyntaxElementType tokenType = null;
        while (true) {
            SyntaxElementType syntaxElementType;
            SyntaxElementType it = syntaxElementType = this.builder.getTokenType();
            boolean bl = false;
            tokenType = it;
            if (syntaxElementType != JavaDocSyntaxTokenType.DOC_SPACE) break;
            this.builder.remapCurrentToken(SyntaxTokenTypes.getWHITE_SPACE());
            if (!skipWhitespace) continue;
            this.builder.advanceLexer();
        }
        return tokenType;
    }

    private final int getBraceScope() {
        return this.braceScope;
    }

    private final void setBraceScope(int braceScope) {
        this.braceScope = braceScope;
    }

    private final void remapAndAdvance() {
        if (JavaDocParserKt.access$getINLINE_TAG_BORDERS_SET$p().containsNullable(this.builder.getTokenType()) && this.getBraceScope() != 1) {
            this.builder.remapCurrentToken(JavaDocSyntaxTokenType.DOC_COMMENT_DATA);
        }
        this.builder.advanceLexer();
    }
}

