﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/bedrock-agent/model/ListFlowAliasesResult.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::BedrockAgent::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListFlowAliasesResult::ListFlowAliasesResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListFlowAliasesResult& ListFlowAliasesResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("flowAliasSummaries")) {
    Aws::Utils::Array<JsonView> flowAliasSummariesJsonList = jsonValue.GetArray("flowAliasSummaries");
    for (unsigned flowAliasSummariesIndex = 0; flowAliasSummariesIndex < flowAliasSummariesJsonList.GetLength();
         ++flowAliasSummariesIndex) {
      m_flowAliasSummaries.push_back(flowAliasSummariesJsonList[flowAliasSummariesIndex].AsObject());
    }
    m_flowAliasSummariesHasBeenSet = true;
  }
  if (jsonValue.ValueExists("nextToken")) {
    m_nextToken = jsonValue.GetString("nextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
